/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.field.WarehouseResourceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.selectable.WarehouseResourceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Warehouse Resource
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WarehouseResourceType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WarehouseResource extends VdmEntity<WarehouseResource>
{

    /**
     * Selector for all available fields of WarehouseResource.
     *
     */
    public final static WarehouseResourceSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @Key
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static WarehouseResourceField<String> WAREHOUSE = new WarehouseResourceField<String>("Warehouse");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseResource</b>
     * </p>
     *
     * @return Resource (Means of Transportation or User)
     */
    @Key
    @SerializedName( "WarehouseResource" )
    @JsonProperty( "WarehouseResource" )
    @Nullable
    @ODataField( odataName = "WarehouseResource" )
    private String warehouseResource;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseResource</b> field to query operations.
     *
     */
    public final static WarehouseResourceField<String> WAREHOUSE_RESOURCE =
        new WarehouseResourceField<String>("WarehouseResource");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>UserName</b>
     * </p>
     *
     * @return User Name in User Master Record
     */
    @SerializedName( "UserName" )
    @JsonProperty( "UserName" )
    @Nullable
    @ODataField( odataName = "UserName" )
    private String userName;
    /**
     * Use with available fluent helpers to apply the <b>UserName</b> field to query operations.
     *
     */
    public final static WarehouseResourceField<String> USER_NAME = new WarehouseResourceField<String>("UserName");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ResourceLogonDateTime</b>
     * </p>
     *
     * @return The resourceLogonDateTime contained in this entity.
     */
    @SerializedName( "ResourceLogonDateTime" )
    @JsonProperty( "ResourceLogonDateTime" )
    @Nullable
    @ODataField( odataName = "ResourceLogonDateTime" )
    private BigDecimal resourceLogonDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ResourceLogonDateTime</b> field to query operations.
     *
     */
    public final static WarehouseResourceField<BigDecimal> RESOURCE_LOGON_DATE_TIME =
        new WarehouseResourceField<BigDecimal>("ResourceLogonDateTime");

    @Nonnull
    @Override
    public Class<WarehouseResource> getType()
    {
        return WarehouseResource.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseResource</b>
     * </p>
     *
     * @param warehouseResource
     *            Resource (Means of Transportation or User)
     */
    public void setWarehouseResource( @Nullable final String warehouseResource )
    {
        rememberChangedField("WarehouseResource", this.warehouseResource);
        this.warehouseResource = warehouseResource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>UserName</b>
     * </p>
     *
     * @param userName
     *            User Name in User Master Record
     */
    public void setUserName( @Nullable final String userName )
    {
        rememberChangedField("UserName", this.userName);
        this.userName = userName;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ResourceLogonDateTime</b>
     * </p>
     *
     * @param resourceLogonDateTime
     *            The resourceLogonDateTime to set.
     */
    public void setResourceLogonDateTime( @Nullable final BigDecimal resourceLogonDateTime )
    {
        rememberChangedField("ResourceLogonDateTime", this.resourceLogonDateTime);
        this.resourceLogonDateTime = resourceLogonDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WarehouseResource";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Warehouse", getWarehouse());
        result.put("WarehouseResource", getWarehouseResource());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Warehouse", getWarehouse());
        values.put("WarehouseResource", getWarehouseResource());
        values.put("UserName", getUserName());
        values.put("ResourceLogonDateTime", getResourceLogonDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("WarehouseResource") ) {
                final Object value = values.remove("WarehouseResource");
                if( (value == null) || (!value.equals(getWarehouseResource())) ) {
                    setWarehouseResource(((String) value));
                }
            }
            if( values.containsKey("UserName") ) {
                final Object value = values.remove("UserName");
                if( (value == null) || (!value.equals(getUserName())) ) {
                    setUserName(((String) value));
                }
            }
            if( values.containsKey("ResourceLogonDateTime") ) {
                final Object value = values.remove("ResourceLogonDateTime");
                if( (value == null) || (!value.equals(getResourceLogonDateTime())) ) {
                    setResourceLogonDateTime(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WarehouseResourceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WarehouseResourceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WarehouseResourceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WarehouseResourceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseResourceService.DEFAULT_SERVICE_PATH);
    }

}
