/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link WarehouseResourceServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseResourceService WarehouseResourceService}, allowing
 * you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultWarehouseResourceServiceBatch
    extends
    BatchFluentHelperBasic<WarehouseResourceServiceBatch, WarehouseResourceServiceBatchChangeSet>
    implements
    WarehouseResourceServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseResourceService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultWarehouseResourceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWarehouseResourceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseResourceService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseResourceService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultWarehouseResourceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWarehouseResourceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseResourceService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultWarehouseResourceServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WarehouseResourceServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultWarehouseResourceServiceBatchChangeSet(this, service);
    }

}
