/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource;

/**
 * Implementation of the {@link WarehouseResourceServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseResourceService WarehouseResourceService}.
 *
 */
public class DefaultWarehouseResourceServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<WarehouseResourceServiceBatch, WarehouseResourceServiceBatchChangeSet>
    implements
    WarehouseResourceServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseResourceService service;

    @SuppressWarnings( "deprecation" )
    DefaultWarehouseResourceServiceBatchChangeSet(
        @Nonnull final DefaultWarehouseResourceServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseResourceService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultWarehouseResourceServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WarehouseResourceServiceBatchChangeSet createWarehouseResource(
        @Nonnull final WarehouseResource warehouseResource )
    {
        return addRequestCreate(service::createWarehouseResource, warehouseResource);
    }

    @Nonnull
    @Override
    public WarehouseResourceServiceBatchChangeSet deleteWarehouseResource(
        @Nonnull final WarehouseResource warehouseResource )
    {
        return addRequestDelete(service::deleteWarehouseResource, warehouseResource);
    }

}
