/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource WarehouseResource}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.field.WarehouseResourceField
 * WarehouseResourceField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.link.WarehouseResourceLink
 * WarehouseResourceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource#WAREHOUSE_RESOURCE
 * WAREHOUSE_RESOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource#USER_NAME
 * USER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehouseresource.WarehouseResource#RESOURCE_LOGON_DATE_TIME
 * RESOURCE_LOGON_DATE_TIME}</li>
 * </ul>
 *
 */
public interface WarehouseResourceSelectable extends EntitySelectable<WarehouseResource>
{

}
