/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.field.WarehouseStorageBinField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.selectable.WarehouseStorageBinSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Warehouse Storage Bin
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WarehouseStorageBinType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WarehouseStorageBin extends VdmEntity<WarehouseStorageBin>
{

    /**
     * Selector for all available fields of WarehouseStorageBin.
     *
     */
    public final static WarehouseStorageBinSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @Key
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> WAREHOUSE = new WarehouseStorageBinField<String>("Warehouse");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @return Storage Bin
     */
    @Key
    @SerializedName( "StorageBin" )
    @JsonProperty( "StorageBin" )
    @Nullable
    @ODataField( odataName = "StorageBin" )
    private String storageBin;
    /**
     * Use with available fluent helpers to apply the <b>StorageBin</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> STORAGE_BIN =
        new WarehouseStorageBinField<String>("StorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @return Storage Type
     */
    @SerializedName( "StorageType" )
    @JsonProperty( "StorageType" )
    @Nullable
    @ODataField( odataName = "StorageType" )
    private String storageType;
    /**
     * Use with available fluent helpers to apply the <b>StorageType</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> STORAGE_TYPE =
        new WarehouseStorageBinField<String>("StorageType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinIsEmpty</b>
     * </p>
     *
     * @return Empty Storage Bin
     */
    @SerializedName( "StorageBinIsEmpty" )
    @JsonProperty( "StorageBinIsEmpty" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "StorageBinIsEmpty" )
    private Boolean storageBinIsEmpty;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinIsEmpty</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<Boolean> STORAGE_BIN_IS_EMPTY =
        new WarehouseStorageBinField<Boolean>("StorageBinIsEmpty");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinIsFull</b>
     * </p>
     *
     * @return Indicator Whether Storage Bin is Full
     */
    @SerializedName( "StorageBinIsFull" )
    @JsonProperty( "StorageBinIsFull" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "StorageBinIsFull" )
    private Boolean storageBinIsFull;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinIsFull</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<Boolean> STORAGE_BIN_IS_FULL =
        new WarehouseStorageBinField<Boolean>("StorageBinIsFull");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinVerifiedByMobileID</b>
     * </p>
     *
     * @return Verification Field for Mobile Data Entry
     */
    @SerializedName( "StorageBinVerifiedByMobileID" )
    @JsonProperty( "StorageBinVerifiedByMobileID" )
    @Nullable
    @ODataField( odataName = "StorageBinVerifiedByMobileID" )
    private String storageBinVerifiedByMobileID;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinVerifiedByMobileID</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> STORAGE_BIN_VERIFIED_BY_MOBILE_ID =
        new WarehouseStorageBinField<String>("StorageBinVerifiedByMobileID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinIsBlockedForRemoval</b>
     * </p>
     *
     * @return Block Indicator: For Stock Removals
     */
    @SerializedName( "StorageBinIsBlockedForRemoval" )
    @JsonProperty( "StorageBinIsBlockedForRemoval" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "StorageBinIsBlockedForRemoval" )
    private Boolean storageBinIsBlockedForRemoval;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinIsBlockedForRemoval</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<Boolean> STORAGE_BIN_IS_BLOCKED_FOR_REMOVAL =
        new WarehouseStorageBinField<Boolean>("StorageBinIsBlockedForRemoval");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinIsBlockedForPutaway</b>
     * </p>
     *
     * @return Block Indicator: For Putaways
     */
    @SerializedName( "StorageBinIsBlockedForPutaway" )
    @JsonProperty( "StorageBinIsBlockedForPutaway" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "StorageBinIsBlockedForPutaway" )
    private Boolean storageBinIsBlockedForPutaway;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinIsBlockedForPutaway</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<Boolean> STORAGE_BIN_IS_BLOCKED_FOR_PUTAWAY =
        new WarehouseStorageBinField<Boolean>("StorageBinIsBlockedForPutaway");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinIsBlockedDueToPInv</b>
     * </p>
     *
     * @return Storage Bin Blocked Because of Physical Inventory
     */
    @SerializedName( "StorageBinIsBlockedDueToPInv" )
    @JsonProperty( "StorageBinIsBlockedDueToPInv" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "StorageBinIsBlockedDueToPInv" )
    private Boolean storageBinIsBlockedDueToPInv;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinIsBlockedDueToPInv</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<Boolean> STORAGE_BIN_IS_BLOCKED_DUE_TO_P_INV =
        new WarehouseStorageBinField<Boolean>("StorageBinIsBlockedDueToPInv");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinFreeDefinedAisleText</b>
     * </p>
     *
     * @return Storage Bin Aisle
     */
    @SerializedName( "StorageBinFreeDefinedAisleText" )
    @JsonProperty( "StorageBinFreeDefinedAisleText" )
    @Nullable
    @ODataField( odataName = "StorageBinFreeDefinedAisleText" )
    private String storageBinFreeDefinedAisleText;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinFreeDefinedAisleText</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> STORAGE_BIN_FREE_DEFINED_AISLE_TEXT =
        new WarehouseStorageBinField<String>("StorageBinFreeDefinedAisleText");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinFreeDefinedStackText</b>
     * </p>
     *
     * @return Storage Bin Stack
     */
    @SerializedName( "StorageBinFreeDefinedStackText" )
    @JsonProperty( "StorageBinFreeDefinedStackText" )
    @Nullable
    @ODataField( odataName = "StorageBinFreeDefinedStackText" )
    private String storageBinFreeDefinedStackText;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinFreeDefinedStackText</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> STORAGE_BIN_FREE_DEFINED_STACK_TEXT =
        new WarehouseStorageBinField<String>("StorageBinFreeDefinedStackText");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinFreeDefinedLevelText</b>
     * </p>
     *
     * @return Storage Bin Level
     */
    @SerializedName( "StorageBinFreeDefinedLevelText" )
    @JsonProperty( "StorageBinFreeDefinedLevelText" )
    @Nullable
    @ODataField( odataName = "StorageBinFreeDefinedLevelText" )
    private String storageBinFreeDefinedLevelText;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinFreeDefinedLevelText</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> STORAGE_BIN_FREE_DEFINED_LEVEL_TEXT =
        new WarehouseStorageBinField<String>("StorageBinFreeDefinedLevelText");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     *
     * @return Weight Unit
     */
    @SerializedName( "WeightUnit" )
    @JsonProperty( "WeightUnit" )
    @Nullable
    @ODataField( odataName = "WeightUnit" )
    private String weightUnit;
    /**
     * Use with available fluent helpers to apply the <b>WeightUnit</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> WEIGHT_UNIT =
        new WarehouseStorageBinField<String>("WeightUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LoadCapacityOfStorageBin</b>
     * </p>
     *
     * @return Maximum Weight of Storage Bin
     */
    @SerializedName( "LoadCapacityOfStorageBin" )
    @JsonProperty( "LoadCapacityOfStorageBin" )
    @Nullable
    @ODataField( odataName = "LoadCapacityOfStorageBin" )
    private BigDecimal loadCapacityOfStorageBin;
    /**
     * Use with available fluent helpers to apply the <b>LoadCapacityOfStorageBin</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<BigDecimal> LOAD_CAPACITY_OF_STORAGE_BIN =
        new WarehouseStorageBinField<BigDecimal>("LoadCapacityOfStorageBin");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightOfMaterialsInStorageBin</b>
     * </p>
     *
     * @return Weight of Materials in Storage Bin
     */
    @SerializedName( "WeightOfMaterialsInStorageBin" )
    @JsonProperty( "WeightOfMaterialsInStorageBin" )
    @Nullable
    @ODataField( odataName = "WeightOfMaterialsInStorageBin" )
    private BigDecimal weightOfMaterialsInStorageBin;
    /**
     * Use with available fluent helpers to apply the <b>WeightOfMaterialsInStorageBin</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<BigDecimal> WEIGHT_OF_MATERIALS_IN_STORAGE_BIN =
        new WarehouseStorageBinField<BigDecimal>("WeightOfMaterialsInStorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "VolumeUnit" )
    @JsonProperty( "VolumeUnit" )
    @Nullable
    @ODataField( odataName = "VolumeUnit" )
    private String volumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>VolumeUnit</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> VOLUME_UNIT =
        new WarehouseStorageBinField<String>("VolumeUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinMaxVolume</b>
     * </p>
     *
     * @return Maximum Volume
     */
    @SerializedName( "StorageBinMaxVolume" )
    @JsonProperty( "StorageBinMaxVolume" )
    @Nullable
    @ODataField( odataName = "StorageBinMaxVolume" )
    private BigDecimal storageBinMaxVolume;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinMaxVolume</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<BigDecimal> STORAGE_BIN_MAX_VOLUME =
        new WarehouseStorageBinField<BigDecimal>("StorageBinMaxVolume");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinOccupiedVolume</b>
     * </p>
     *
     * @return Loading or Net Volume
     */
    @SerializedName( "StorageBinOccupiedVolume" )
    @JsonProperty( "StorageBinOccupiedVolume" )
    @Nullable
    @ODataField( odataName = "StorageBinOccupiedVolume" )
    private BigDecimal storageBinOccupiedVolume;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinOccupiedVolume</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<BigDecimal> STORAGE_BIN_OCCUPIED_VOLUME =
        new WarehouseStorageBinField<BigDecimal>("StorageBinOccupiedVolume");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinRowPositionInWhse</b>
     * </p>
     *
     * @return X Coordinate
     */
    @SerializedName( "StorageBinRowPositionInWhse" )
    @JsonProperty( "StorageBinRowPositionInWhse" )
    @Nullable
    @ODataField( odataName = "StorageBinRowPositionInWhse" )
    private BigDecimal storageBinRowPositionInWhse;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinRowPositionInWhse</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<BigDecimal> STORAGE_BIN_ROW_POSITION_IN_WHSE =
        new WarehouseStorageBinField<BigDecimal>("StorageBinRowPositionInWhse");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinStackPositionInWhse</b>
     * </p>
     *
     * @return Y Coordinate
     */
    @SerializedName( "StorageBinStackPositionInWhse" )
    @JsonProperty( "StorageBinStackPositionInWhse" )
    @Nullable
    @ODataField( odataName = "StorageBinStackPositionInWhse" )
    private BigDecimal storageBinStackPositionInWhse;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinStackPositionInWhse</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<BigDecimal> STORAGE_BIN_STACK_POSITION_IN_WHSE =
        new WarehouseStorageBinField<BigDecimal>("StorageBinStackPositionInWhse");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinLevelPositionInWhse</b>
     * </p>
     *
     * @return Z Coordinate
     */
    @SerializedName( "StorageBinLevelPositionInWhse" )
    @JsonProperty( "StorageBinLevelPositionInWhse" )
    @Nullable
    @ODataField( odataName = "StorageBinLevelPositionInWhse" )
    private BigDecimal storageBinLevelPositionInWhse;
    /**
     * Use with available fluent helpers to apply the <b>StorageBinLevelPositionInWhse</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<BigDecimal> STORAGE_BIN_LEVEL_POSITION_IN_WHSE =
        new WarehouseStorageBinField<BigDecimal>("StorageBinLevelPositionInWhse");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EWMPhysicalInventoryType</b>
     * </p>
     *
     * @return Physical Inventory Type
     */
    @SerializedName( "EWMPhysicalInventoryType" )
    @JsonProperty( "EWMPhysicalInventoryType" )
    @Nullable
    @ODataField( odataName = "EWMPhysicalInventoryType" )
    private String eWMPhysicalInventoryType;
    /**
     * Use with available fluent helpers to apply the <b>EWMPhysicalInventoryType</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> EWM_PHYSICAL_INVENTORY_TYPE =
        new WarehouseStorageBinField<String>("EWMPhysicalInventoryType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocNumber</b>
     * </p>
     *
     * @return Physical Inventory Document Number
     */
    @SerializedName( "PhysicalInventoryDocNumber" )
    @JsonProperty( "PhysicalInventoryDocNumber" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryDocNumber" )
    private String physicalInventoryDocNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryDocNumber</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> PHYSICAL_INVENTORY_DOC_NUMBER =
        new WarehouseStorageBinField<String>("PhysicalInventoryDocNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemNumber</b>
     * </p>
     *
     * @return Item
     */
    @SerializedName( "PhysicalInventoryItemNumber" )
    @JsonProperty( "PhysicalInventoryItemNumber" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryItemNumber" )
    private String physicalInventoryItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryItemNumber</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> PHYSICAL_INVENTORY_ITEM_NUMBER =
        new WarehouseStorageBinField<String>("PhysicalInventoryItemNumber");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PInvCountedUTCDateTime</b>
     * </p>
     *
     * @return Entered Date of Physical Inventory Count (Time Stamp)
     */
    @SerializedName( "PInvCountedUTCDateTime" )
    @JsonProperty( "PInvCountedUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "PInvCountedUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime pInvCountedUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>PInvCountedUTCDateTime</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<ZonedDateTime> P_INV_COUNTED_UTC_DATE_TIME =
        new WarehouseStorageBinField<ZonedDateTime>("PInvCountedUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinLastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By
     */
    @SerializedName( "EWMStorageBinLastChangedByUser" )
    @JsonProperty( "EWMStorageBinLastChangedByUser" )
    @Nullable
    @ODataField( odataName = "EWMStorageBinLastChangedByUser" )
    private String eWMStorageBinLastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>EWMStorageBinLastChangedByUser</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> EWM_STORAGE_BIN_LAST_CHANGED_BY_USER =
        new WarehouseStorageBinField<String>("EWMStorageBinLastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinLastChgDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "EWMStorageBinLastChgDateTime" )
    @JsonProperty( "EWMStorageBinLastChgDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "EWMStorageBinLastChgDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime eWMStorageBinLastChgDateTime;
    /**
     * Use with available fluent helpers to apply the <b>EWMStorageBinLastChgDateTime</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<ZonedDateTime> EWM_STORAGE_BIN_LAST_CHG_DATE_TIME =
        new WarehouseStorageBinField<ZonedDateTime>("EWMStorageBinLastChgDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinLastWarehouseTask</b>
     * </p>
     *
     * @return Warehouse Task
     */
    @SerializedName( "EWMStorageBinLastWarehouseTask" )
    @JsonProperty( "EWMStorageBinLastWarehouseTask" )
    @Nullable
    @ODataField( odataName = "EWMStorageBinLastWarehouseTask" )
    private String eWMStorageBinLastWarehouseTask;
    /**
     * Use with available fluent helpers to apply the <b>EWMStorageBinLastWarehouseTask</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> EWM_STORAGE_BIN_LAST_WAREHOUSE_TASK =
        new WarehouseStorageBinField<String>("EWMStorageBinLastWarehouseTask");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinFirstPutawayDate</b>
     * </p>
     *
     * @return Date of First Putaway
     */
    @SerializedName( "EWMStorageBinFirstPutawayDate" )
    @JsonProperty( "EWMStorageBinFirstPutawayDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EWMStorageBinFirstPutawayDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime eWMStorageBinFirstPutawayDate;
    /**
     * Use with available fluent helpers to apply the <b>EWMStorageBinFirstPutawayDate</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<LocalDateTime> EWM_STORAGE_BIN_FIRST_PUTAWAY_DATE =
        new WarehouseStorageBinField<LocalDateTime>("EWMStorageBinFirstPutawayDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinLastMvtDateTime</b>
     * </p>
     *
     * @return Last Movement to Bin
     */
    @SerializedName( "EWMStorageBinLastMvtDateTime" )
    @JsonProperty( "EWMStorageBinLastMvtDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "EWMStorageBinLastMvtDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime eWMStorageBinLastMvtDateTime;
    /**
     * Use with available fluent helpers to apply the <b>EWMStorageBinLastMvtDateTime</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<ZonedDateTime> EWM_STORAGE_BIN_LAST_MVT_DATE_TIME =
        new WarehouseStorageBinField<ZonedDateTime>("EWMStorageBinLastMvtDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinLastClrgDateTime</b>
     * </p>
     *
     * @return Last Bin Clearing
     */
    @SerializedName( "EWMStorageBinLastClrgDateTime" )
    @JsonProperty( "EWMStorageBinLastClrgDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "EWMStorageBinLastClrgDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime eWMStorageBinLastClrgDateTime;
    /**
     * Use with available fluent helpers to apply the <b>EWMStorageBinLastClrgDateTime</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<ZonedDateTime> EWM_STORAGE_BIN_LAST_CLRG_DATE_TIME =
        new WarehouseStorageBinField<ZonedDateTime>("EWMStorageBinLastClrgDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinFixedBinType</b>
     * </p>
     *
     * @return Fixed Storage Bin Type
     */
    @SerializedName( "EWMStorageBinFixedBinType" )
    @JsonProperty( "EWMStorageBinFixedBinType" )
    @Nullable
    @ODataField( odataName = "EWMStorageBinFixedBinType" )
    private String eWMStorageBinFixedBinType;
    /**
     * Use with available fluent helpers to apply the <b>EWMStorageBinFixedBinType</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> EWM_STORAGE_BIN_FIXED_BIN_TYPE =
        new WarehouseStorageBinField<String>("EWMStorageBinFixedBinType");
    /**
     * Constraints: Not nullable, Precision: 4, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinAngleValue</b>
     * </p>
     *
     * @return Angle for Alignment of a Storage Bin (Degrees)
     */
    @SerializedName( "EWMStorageBinAngleValue" )
    @JsonProperty( "EWMStorageBinAngleValue" )
    @Nullable
    @ODataField( odataName = "EWMStorageBinAngleValue" )
    private BigDecimal eWMStorageBinAngleValue;
    /**
     * Use with available fluent helpers to apply the <b>EWMStorageBinAngleValue</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<BigDecimal> EWM_STORAGE_BIN_ANGLE_VALUE =
        new WarehouseStorageBinField<BigDecimal>("EWMStorageBinAngleValue");
    /**
     * Constraints: Not nullable, Precision: 6, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorBinNumberOfHndlgUnits</b>
     * </p>
     *
     * @return Number of Handling Units in Storage Bin
     */
    @SerializedName( "EWMStorBinNumberOfHndlgUnits" )
    @JsonProperty( "EWMStorBinNumberOfHndlgUnits" )
    @Nullable
    @ODataField( odataName = "EWMStorBinNumberOfHndlgUnits" )
    private BigDecimal eWMStorBinNumberOfHndlgUnits;
    /**
     * Use with available fluent helpers to apply the <b>EWMStorBinNumberOfHndlgUnits</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<BigDecimal> EWM_STOR_BIN_NUMBER_OF_HNDLG_UNITS =
        new WarehouseStorageBinField<BigDecimal>("EWMStorBinNumberOfHndlgUnits");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorBinMaxNmbrOfHndlgUnits</b>
     * </p>
     *
     * @return Maximum Number of Handling Units in Storage Bin
     */
    @SerializedName( "EWMStorBinMaxNmbrOfHndlgUnits" )
    @JsonProperty( "EWMStorBinMaxNmbrOfHndlgUnits" )
    @Nullable
    @ODataField( odataName = "EWMStorBinMaxNmbrOfHndlgUnits" )
    private String eWMStorBinMaxNmbrOfHndlgUnits;
    /**
     * Use with available fluent helpers to apply the <b>EWMStorBinMaxNmbrOfHndlgUnits</b> field to query operations.
     *
     */
    public final static WarehouseStorageBinField<String> EWM_STOR_BIN_MAX_NMBR_OF_HNDLG_UNITS =
        new WarehouseStorageBinField<String>("EWMStorBinMaxNmbrOfHndlgUnits");

    @Nonnull
    @Override
    public Class<WarehouseStorageBin> getType()
    {
        return WarehouseStorageBin.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBin</b>
     * </p>
     *
     * @param storageBin
     *            Storage Bin
     */
    public void setStorageBin( @Nullable final String storageBin )
    {
        rememberChangedField("StorageBin", this.storageBin);
        this.storageBin = storageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageType</b>
     * </p>
     *
     * @param storageType
     *            Storage Type
     */
    public void setStorageType( @Nullable final String storageType )
    {
        rememberChangedField("StorageType", this.storageType);
        this.storageType = storageType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinIsEmpty</b>
     * </p>
     *
     * @param storageBinIsEmpty
     *            Empty Storage Bin
     */
    public void setStorageBinIsEmpty( @Nullable final Boolean storageBinIsEmpty )
    {
        rememberChangedField("StorageBinIsEmpty", this.storageBinIsEmpty);
        this.storageBinIsEmpty = storageBinIsEmpty;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinIsFull</b>
     * </p>
     *
     * @param storageBinIsFull
     *            Indicator Whether Storage Bin is Full
     */
    public void setStorageBinIsFull( @Nullable final Boolean storageBinIsFull )
    {
        rememberChangedField("StorageBinIsFull", this.storageBinIsFull);
        this.storageBinIsFull = storageBinIsFull;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinVerifiedByMobileID</b>
     * </p>
     *
     * @param storageBinVerifiedByMobileID
     *            Verification Field for Mobile Data Entry
     */
    public void setStorageBinVerifiedByMobileID( @Nullable final String storageBinVerifiedByMobileID )
    {
        rememberChangedField("StorageBinVerifiedByMobileID", this.storageBinVerifiedByMobileID);
        this.storageBinVerifiedByMobileID = storageBinVerifiedByMobileID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinIsBlockedForRemoval</b>
     * </p>
     *
     * @param storageBinIsBlockedForRemoval
     *            Block Indicator: For Stock Removals
     */
    public void setStorageBinIsBlockedForRemoval( @Nullable final Boolean storageBinIsBlockedForRemoval )
    {
        rememberChangedField("StorageBinIsBlockedForRemoval", this.storageBinIsBlockedForRemoval);
        this.storageBinIsBlockedForRemoval = storageBinIsBlockedForRemoval;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinIsBlockedForPutaway</b>
     * </p>
     *
     * @param storageBinIsBlockedForPutaway
     *            Block Indicator: For Putaways
     */
    public void setStorageBinIsBlockedForPutaway( @Nullable final Boolean storageBinIsBlockedForPutaway )
    {
        rememberChangedField("StorageBinIsBlockedForPutaway", this.storageBinIsBlockedForPutaway);
        this.storageBinIsBlockedForPutaway = storageBinIsBlockedForPutaway;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinIsBlockedDueToPInv</b>
     * </p>
     *
     * @param storageBinIsBlockedDueToPInv
     *            Storage Bin Blocked Because of Physical Inventory
     */
    public void setStorageBinIsBlockedDueToPInv( @Nullable final Boolean storageBinIsBlockedDueToPInv )
    {
        rememberChangedField("StorageBinIsBlockedDueToPInv", this.storageBinIsBlockedDueToPInv);
        this.storageBinIsBlockedDueToPInv = storageBinIsBlockedDueToPInv;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinFreeDefinedAisleText</b>
     * </p>
     *
     * @param storageBinFreeDefinedAisleText
     *            Storage Bin Aisle
     */
    public void setStorageBinFreeDefinedAisleText( @Nullable final String storageBinFreeDefinedAisleText )
    {
        rememberChangedField("StorageBinFreeDefinedAisleText", this.storageBinFreeDefinedAisleText);
        this.storageBinFreeDefinedAisleText = storageBinFreeDefinedAisleText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinFreeDefinedStackText</b>
     * </p>
     *
     * @param storageBinFreeDefinedStackText
     *            Storage Bin Stack
     */
    public void setStorageBinFreeDefinedStackText( @Nullable final String storageBinFreeDefinedStackText )
    {
        rememberChangedField("StorageBinFreeDefinedStackText", this.storageBinFreeDefinedStackText);
        this.storageBinFreeDefinedStackText = storageBinFreeDefinedStackText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinFreeDefinedLevelText</b>
     * </p>
     *
     * @param storageBinFreeDefinedLevelText
     *            Storage Bin Level
     */
    public void setStorageBinFreeDefinedLevelText( @Nullable final String storageBinFreeDefinedLevelText )
    {
        rememberChangedField("StorageBinFreeDefinedLevelText", this.storageBinFreeDefinedLevelText);
        this.storageBinFreeDefinedLevelText = storageBinFreeDefinedLevelText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightUnit</b>
     * </p>
     *
     * @param weightUnit
     *            Weight Unit
     */
    public void setWeightUnit( @Nullable final String weightUnit )
    {
        rememberChangedField("WeightUnit", this.weightUnit);
        this.weightUnit = weightUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>LoadCapacityOfStorageBin</b>
     * </p>
     *
     * @param loadCapacityOfStorageBin
     *            Maximum Weight of Storage Bin
     */
    public void setLoadCapacityOfStorageBin( @Nullable final BigDecimal loadCapacityOfStorageBin )
    {
        rememberChangedField("LoadCapacityOfStorageBin", this.loadCapacityOfStorageBin);
        this.loadCapacityOfStorageBin = loadCapacityOfStorageBin;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WeightOfMaterialsInStorageBin</b>
     * </p>
     *
     * @param weightOfMaterialsInStorageBin
     *            Weight of Materials in Storage Bin
     */
    public void setWeightOfMaterialsInStorageBin( @Nullable final BigDecimal weightOfMaterialsInStorageBin )
    {
        rememberChangedField("WeightOfMaterialsInStorageBin", this.weightOfMaterialsInStorageBin);
        this.weightOfMaterialsInStorageBin = weightOfMaterialsInStorageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VolumeUnit</b>
     * </p>
     *
     * @param volumeUnit
     *            Volume Unit
     */
    public void setVolumeUnit( @Nullable final String volumeUnit )
    {
        rememberChangedField("VolumeUnit", this.volumeUnit);
        this.volumeUnit = volumeUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinMaxVolume</b>
     * </p>
     *
     * @param storageBinMaxVolume
     *            Maximum Volume
     */
    public void setStorageBinMaxVolume( @Nullable final BigDecimal storageBinMaxVolume )
    {
        rememberChangedField("StorageBinMaxVolume", this.storageBinMaxVolume);
        this.storageBinMaxVolume = storageBinMaxVolume;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinOccupiedVolume</b>
     * </p>
     *
     * @param storageBinOccupiedVolume
     *            Loading or Net Volume
     */
    public void setStorageBinOccupiedVolume( @Nullable final BigDecimal storageBinOccupiedVolume )
    {
        rememberChangedField("StorageBinOccupiedVolume", this.storageBinOccupiedVolume);
        this.storageBinOccupiedVolume = storageBinOccupiedVolume;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinRowPositionInWhse</b>
     * </p>
     *
     * @param storageBinRowPositionInWhse
     *            X Coordinate
     */
    public void setStorageBinRowPositionInWhse( @Nullable final BigDecimal storageBinRowPositionInWhse )
    {
        rememberChangedField("StorageBinRowPositionInWhse", this.storageBinRowPositionInWhse);
        this.storageBinRowPositionInWhse = storageBinRowPositionInWhse;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinStackPositionInWhse</b>
     * </p>
     *
     * @param storageBinStackPositionInWhse
     *            Y Coordinate
     */
    public void setStorageBinStackPositionInWhse( @Nullable final BigDecimal storageBinStackPositionInWhse )
    {
        rememberChangedField("StorageBinStackPositionInWhse", this.storageBinStackPositionInWhse);
        this.storageBinStackPositionInWhse = storageBinStackPositionInWhse;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>StorageBinLevelPositionInWhse</b>
     * </p>
     *
     * @param storageBinLevelPositionInWhse
     *            Z Coordinate
     */
    public void setStorageBinLevelPositionInWhse( @Nullable final BigDecimal storageBinLevelPositionInWhse )
    {
        rememberChangedField("StorageBinLevelPositionInWhse", this.storageBinLevelPositionInWhse);
        this.storageBinLevelPositionInWhse = storageBinLevelPositionInWhse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EWMPhysicalInventoryType</b>
     * </p>
     *
     * @param eWMPhysicalInventoryType
     *            Physical Inventory Type
     */
    public void setEWMPhysicalInventoryType( @Nullable final String eWMPhysicalInventoryType )
    {
        rememberChangedField("EWMPhysicalInventoryType", this.eWMPhysicalInventoryType);
        this.eWMPhysicalInventoryType = eWMPhysicalInventoryType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryDocNumber</b>
     * </p>
     *
     * @param physicalInventoryDocNumber
     *            Physical Inventory Document Number
     */
    public void setPhysicalInventoryDocNumber( @Nullable final String physicalInventoryDocNumber )
    {
        rememberChangedField("PhysicalInventoryDocNumber", this.physicalInventoryDocNumber);
        this.physicalInventoryDocNumber = physicalInventoryDocNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryItemNumber</b>
     * </p>
     *
     * @param physicalInventoryItemNumber
     *            Item
     */
    public void setPhysicalInventoryItemNumber( @Nullable final String physicalInventoryItemNumber )
    {
        rememberChangedField("PhysicalInventoryItemNumber", this.physicalInventoryItemNumber);
        this.physicalInventoryItemNumber = physicalInventoryItemNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>PInvCountedUTCDateTime</b>
     * </p>
     *
     * @param pInvCountedUTCDateTime
     *            Entered Date of Physical Inventory Count (Time Stamp)
     */
    public void setPInvCountedUTCDateTime( @Nullable final ZonedDateTime pInvCountedUTCDateTime )
    {
        rememberChangedField("PInvCountedUTCDateTime", this.pInvCountedUTCDateTime);
        this.pInvCountedUTCDateTime = pInvCountedUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinLastChangedByUser</b>
     * </p>
     *
     * @param eWMStorageBinLastChangedByUser
     *            Last Changed By
     */
    public void setEWMStorageBinLastChangedByUser( @Nullable final String eWMStorageBinLastChangedByUser )
    {
        rememberChangedField("EWMStorageBinLastChangedByUser", this.eWMStorageBinLastChangedByUser);
        this.eWMStorageBinLastChangedByUser = eWMStorageBinLastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinLastChgDateTime</b>
     * </p>
     *
     * @param eWMStorageBinLastChgDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setEWMStorageBinLastChgDateTime( @Nullable final ZonedDateTime eWMStorageBinLastChgDateTime )
    {
        rememberChangedField("EWMStorageBinLastChgDateTime", this.eWMStorageBinLastChgDateTime);
        this.eWMStorageBinLastChgDateTime = eWMStorageBinLastChgDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinLastWarehouseTask</b>
     * </p>
     *
     * @param eWMStorageBinLastWarehouseTask
     *            Warehouse Task
     */
    public void setEWMStorageBinLastWarehouseTask( @Nullable final String eWMStorageBinLastWarehouseTask )
    {
        rememberChangedField("EWMStorageBinLastWarehouseTask", this.eWMStorageBinLastWarehouseTask);
        this.eWMStorageBinLastWarehouseTask = eWMStorageBinLastWarehouseTask;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinFirstPutawayDate</b>
     * </p>
     *
     * @param eWMStorageBinFirstPutawayDate
     *            Date of First Putaway
     */
    public void setEWMStorageBinFirstPutawayDate( @Nullable final LocalDateTime eWMStorageBinFirstPutawayDate )
    {
        rememberChangedField("EWMStorageBinFirstPutawayDate", this.eWMStorageBinFirstPutawayDate);
        this.eWMStorageBinFirstPutawayDate = eWMStorageBinFirstPutawayDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinLastMvtDateTime</b>
     * </p>
     *
     * @param eWMStorageBinLastMvtDateTime
     *            Last Movement to Bin
     */
    public void setEWMStorageBinLastMvtDateTime( @Nullable final ZonedDateTime eWMStorageBinLastMvtDateTime )
    {
        rememberChangedField("EWMStorageBinLastMvtDateTime", this.eWMStorageBinLastMvtDateTime);
        this.eWMStorageBinLastMvtDateTime = eWMStorageBinLastMvtDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinLastClrgDateTime</b>
     * </p>
     *
     * @param eWMStorageBinLastClrgDateTime
     *            Last Bin Clearing
     */
    public void setEWMStorageBinLastClrgDateTime( @Nullable final ZonedDateTime eWMStorageBinLastClrgDateTime )
    {
        rememberChangedField("EWMStorageBinLastClrgDateTime", this.eWMStorageBinLastClrgDateTime);
        this.eWMStorageBinLastClrgDateTime = eWMStorageBinLastClrgDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinFixedBinType</b>
     * </p>
     *
     * @param eWMStorageBinFixedBinType
     *            Fixed Storage Bin Type
     */
    public void setEWMStorageBinFixedBinType( @Nullable final String eWMStorageBinFixedBinType )
    {
        rememberChangedField("EWMStorageBinFixedBinType", this.eWMStorageBinFixedBinType);
        this.eWMStorageBinFixedBinType = eWMStorageBinFixedBinType;
    }

    /**
     * Constraints: Not nullable, Precision: 4, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorageBinAngleValue</b>
     * </p>
     *
     * @param eWMStorageBinAngleValue
     *            Angle for Alignment of a Storage Bin (Degrees)
     */
    public void setEWMStorageBinAngleValue( @Nullable final BigDecimal eWMStorageBinAngleValue )
    {
        rememberChangedField("EWMStorageBinAngleValue", this.eWMStorageBinAngleValue);
        this.eWMStorageBinAngleValue = eWMStorageBinAngleValue;
    }

    /**
     * Constraints: Not nullable, Precision: 6, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorBinNumberOfHndlgUnits</b>
     * </p>
     *
     * @param eWMStorBinNumberOfHndlgUnits
     *            Number of Handling Units in Storage Bin
     */
    public void setEWMStorBinNumberOfHndlgUnits( @Nullable final BigDecimal eWMStorBinNumberOfHndlgUnits )
    {
        rememberChangedField("EWMStorBinNumberOfHndlgUnits", this.eWMStorBinNumberOfHndlgUnits);
        this.eWMStorBinNumberOfHndlgUnits = eWMStorBinNumberOfHndlgUnits;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>EWMStorBinMaxNmbrOfHndlgUnits</b>
     * </p>
     *
     * @param eWMStorBinMaxNmbrOfHndlgUnits
     *            Maximum Number of Handling Units in Storage Bin
     */
    public void setEWMStorBinMaxNmbrOfHndlgUnits( @Nullable final String eWMStorBinMaxNmbrOfHndlgUnits )
    {
        rememberChangedField("EWMStorBinMaxNmbrOfHndlgUnits", this.eWMStorBinMaxNmbrOfHndlgUnits);
        this.eWMStorBinMaxNmbrOfHndlgUnits = eWMStorBinMaxNmbrOfHndlgUnits;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WarehouseStorageBin";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Warehouse", getWarehouse());
        result.put("StorageBin", getStorageBin());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Warehouse", getWarehouse());
        values.put("StorageBin", getStorageBin());
        values.put("StorageType", getStorageType());
        values.put("StorageBinIsEmpty", getStorageBinIsEmpty());
        values.put("StorageBinIsFull", getStorageBinIsFull());
        values.put("StorageBinVerifiedByMobileID", getStorageBinVerifiedByMobileID());
        values.put("StorageBinIsBlockedForRemoval", getStorageBinIsBlockedForRemoval());
        values.put("StorageBinIsBlockedForPutaway", getStorageBinIsBlockedForPutaway());
        values.put("StorageBinIsBlockedDueToPInv", getStorageBinIsBlockedDueToPInv());
        values.put("StorageBinFreeDefinedAisleText", getStorageBinFreeDefinedAisleText());
        values.put("StorageBinFreeDefinedStackText", getStorageBinFreeDefinedStackText());
        values.put("StorageBinFreeDefinedLevelText", getStorageBinFreeDefinedLevelText());
        values.put("WeightUnit", getWeightUnit());
        values.put("LoadCapacityOfStorageBin", getLoadCapacityOfStorageBin());
        values.put("WeightOfMaterialsInStorageBin", getWeightOfMaterialsInStorageBin());
        values.put("VolumeUnit", getVolumeUnit());
        values.put("StorageBinMaxVolume", getStorageBinMaxVolume());
        values.put("StorageBinOccupiedVolume", getStorageBinOccupiedVolume());
        values.put("StorageBinRowPositionInWhse", getStorageBinRowPositionInWhse());
        values.put("StorageBinStackPositionInWhse", getStorageBinStackPositionInWhse());
        values.put("StorageBinLevelPositionInWhse", getStorageBinLevelPositionInWhse());
        values.put("EWMPhysicalInventoryType", getEWMPhysicalInventoryType());
        values.put("PhysicalInventoryDocNumber", getPhysicalInventoryDocNumber());
        values.put("PhysicalInventoryItemNumber", getPhysicalInventoryItemNumber());
        values.put("PInvCountedUTCDateTime", getPInvCountedUTCDateTime());
        values.put("EWMStorageBinLastChangedByUser", getEWMStorageBinLastChangedByUser());
        values.put("EWMStorageBinLastChgDateTime", getEWMStorageBinLastChgDateTime());
        values.put("EWMStorageBinLastWarehouseTask", getEWMStorageBinLastWarehouseTask());
        values.put("EWMStorageBinFirstPutawayDate", getEWMStorageBinFirstPutawayDate());
        values.put("EWMStorageBinLastMvtDateTime", getEWMStorageBinLastMvtDateTime());
        values.put("EWMStorageBinLastClrgDateTime", getEWMStorageBinLastClrgDateTime());
        values.put("EWMStorageBinFixedBinType", getEWMStorageBinFixedBinType());
        values.put("EWMStorageBinAngleValue", getEWMStorageBinAngleValue());
        values.put("EWMStorBinNumberOfHndlgUnits", getEWMStorBinNumberOfHndlgUnits());
        values.put("EWMStorBinMaxNmbrOfHndlgUnits", getEWMStorBinMaxNmbrOfHndlgUnits());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("StorageBin") ) {
                final Object value = values.remove("StorageBin");
                if( (value == null) || (!value.equals(getStorageBin())) ) {
                    setStorageBin(((String) value));
                }
            }
            if( values.containsKey("StorageType") ) {
                final Object value = values.remove("StorageType");
                if( (value == null) || (!value.equals(getStorageType())) ) {
                    setStorageType(((String) value));
                }
            }
            if( values.containsKey("StorageBinIsEmpty") ) {
                final Object value = values.remove("StorageBinIsEmpty");
                if( (value == null) || (!value.equals(getStorageBinIsEmpty())) ) {
                    setStorageBinIsEmpty(((Boolean) value));
                }
            }
            if( values.containsKey("StorageBinIsFull") ) {
                final Object value = values.remove("StorageBinIsFull");
                if( (value == null) || (!value.equals(getStorageBinIsFull())) ) {
                    setStorageBinIsFull(((Boolean) value));
                }
            }
            if( values.containsKey("StorageBinVerifiedByMobileID") ) {
                final Object value = values.remove("StorageBinVerifiedByMobileID");
                if( (value == null) || (!value.equals(getStorageBinVerifiedByMobileID())) ) {
                    setStorageBinVerifiedByMobileID(((String) value));
                }
            }
            if( values.containsKey("StorageBinIsBlockedForRemoval") ) {
                final Object value = values.remove("StorageBinIsBlockedForRemoval");
                if( (value == null) || (!value.equals(getStorageBinIsBlockedForRemoval())) ) {
                    setStorageBinIsBlockedForRemoval(((Boolean) value));
                }
            }
            if( values.containsKey("StorageBinIsBlockedForPutaway") ) {
                final Object value = values.remove("StorageBinIsBlockedForPutaway");
                if( (value == null) || (!value.equals(getStorageBinIsBlockedForPutaway())) ) {
                    setStorageBinIsBlockedForPutaway(((Boolean) value));
                }
            }
            if( values.containsKey("StorageBinIsBlockedDueToPInv") ) {
                final Object value = values.remove("StorageBinIsBlockedDueToPInv");
                if( (value == null) || (!value.equals(getStorageBinIsBlockedDueToPInv())) ) {
                    setStorageBinIsBlockedDueToPInv(((Boolean) value));
                }
            }
            if( values.containsKey("StorageBinFreeDefinedAisleText") ) {
                final Object value = values.remove("StorageBinFreeDefinedAisleText");
                if( (value == null) || (!value.equals(getStorageBinFreeDefinedAisleText())) ) {
                    setStorageBinFreeDefinedAisleText(((String) value));
                }
            }
            if( values.containsKey("StorageBinFreeDefinedStackText") ) {
                final Object value = values.remove("StorageBinFreeDefinedStackText");
                if( (value == null) || (!value.equals(getStorageBinFreeDefinedStackText())) ) {
                    setStorageBinFreeDefinedStackText(((String) value));
                }
            }
            if( values.containsKey("StorageBinFreeDefinedLevelText") ) {
                final Object value = values.remove("StorageBinFreeDefinedLevelText");
                if( (value == null) || (!value.equals(getStorageBinFreeDefinedLevelText())) ) {
                    setStorageBinFreeDefinedLevelText(((String) value));
                }
            }
            if( values.containsKey("WeightUnit") ) {
                final Object value = values.remove("WeightUnit");
                if( (value == null) || (!value.equals(getWeightUnit())) ) {
                    setWeightUnit(((String) value));
                }
            }
            if( values.containsKey("LoadCapacityOfStorageBin") ) {
                final Object value = values.remove("LoadCapacityOfStorageBin");
                if( (value == null) || (!value.equals(getLoadCapacityOfStorageBin())) ) {
                    setLoadCapacityOfStorageBin(((BigDecimal) value));
                }
            }
            if( values.containsKey("WeightOfMaterialsInStorageBin") ) {
                final Object value = values.remove("WeightOfMaterialsInStorageBin");
                if( (value == null) || (!value.equals(getWeightOfMaterialsInStorageBin())) ) {
                    setWeightOfMaterialsInStorageBin(((BigDecimal) value));
                }
            }
            if( values.containsKey("VolumeUnit") ) {
                final Object value = values.remove("VolumeUnit");
                if( (value == null) || (!value.equals(getVolumeUnit())) ) {
                    setVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("StorageBinMaxVolume") ) {
                final Object value = values.remove("StorageBinMaxVolume");
                if( (value == null) || (!value.equals(getStorageBinMaxVolume())) ) {
                    setStorageBinMaxVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("StorageBinOccupiedVolume") ) {
                final Object value = values.remove("StorageBinOccupiedVolume");
                if( (value == null) || (!value.equals(getStorageBinOccupiedVolume())) ) {
                    setStorageBinOccupiedVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("StorageBinRowPositionInWhse") ) {
                final Object value = values.remove("StorageBinRowPositionInWhse");
                if( (value == null) || (!value.equals(getStorageBinRowPositionInWhse())) ) {
                    setStorageBinRowPositionInWhse(((BigDecimal) value));
                }
            }
            if( values.containsKey("StorageBinStackPositionInWhse") ) {
                final Object value = values.remove("StorageBinStackPositionInWhse");
                if( (value == null) || (!value.equals(getStorageBinStackPositionInWhse())) ) {
                    setStorageBinStackPositionInWhse(((BigDecimal) value));
                }
            }
            if( values.containsKey("StorageBinLevelPositionInWhse") ) {
                final Object value = values.remove("StorageBinLevelPositionInWhse");
                if( (value == null) || (!value.equals(getStorageBinLevelPositionInWhse())) ) {
                    setStorageBinLevelPositionInWhse(((BigDecimal) value));
                }
            }
            if( values.containsKey("EWMPhysicalInventoryType") ) {
                final Object value = values.remove("EWMPhysicalInventoryType");
                if( (value == null) || (!value.equals(getEWMPhysicalInventoryType())) ) {
                    setEWMPhysicalInventoryType(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryDocNumber") ) {
                final Object value = values.remove("PhysicalInventoryDocNumber");
                if( (value == null) || (!value.equals(getPhysicalInventoryDocNumber())) ) {
                    setPhysicalInventoryDocNumber(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryItemNumber") ) {
                final Object value = values.remove("PhysicalInventoryItemNumber");
                if( (value == null) || (!value.equals(getPhysicalInventoryItemNumber())) ) {
                    setPhysicalInventoryItemNumber(((String) value));
                }
            }
            if( values.containsKey("PInvCountedUTCDateTime") ) {
                final Object value = values.remove("PInvCountedUTCDateTime");
                if( (value == null) || (!value.equals(getPInvCountedUTCDateTime())) ) {
                    setPInvCountedUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("EWMStorageBinLastChangedByUser") ) {
                final Object value = values.remove("EWMStorageBinLastChangedByUser");
                if( (value == null) || (!value.equals(getEWMStorageBinLastChangedByUser())) ) {
                    setEWMStorageBinLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("EWMStorageBinLastChgDateTime") ) {
                final Object value = values.remove("EWMStorageBinLastChgDateTime");
                if( (value == null) || (!value.equals(getEWMStorageBinLastChgDateTime())) ) {
                    setEWMStorageBinLastChgDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("EWMStorageBinLastWarehouseTask") ) {
                final Object value = values.remove("EWMStorageBinLastWarehouseTask");
                if( (value == null) || (!value.equals(getEWMStorageBinLastWarehouseTask())) ) {
                    setEWMStorageBinLastWarehouseTask(((String) value));
                }
            }
            if( values.containsKey("EWMStorageBinFirstPutawayDate") ) {
                final Object value = values.remove("EWMStorageBinFirstPutawayDate");
                if( (value == null) || (!value.equals(getEWMStorageBinFirstPutawayDate())) ) {
                    setEWMStorageBinFirstPutawayDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EWMStorageBinLastMvtDateTime") ) {
                final Object value = values.remove("EWMStorageBinLastMvtDateTime");
                if( (value == null) || (!value.equals(getEWMStorageBinLastMvtDateTime())) ) {
                    setEWMStorageBinLastMvtDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("EWMStorageBinLastClrgDateTime") ) {
                final Object value = values.remove("EWMStorageBinLastClrgDateTime");
                if( (value == null) || (!value.equals(getEWMStorageBinLastClrgDateTime())) ) {
                    setEWMStorageBinLastClrgDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("EWMStorageBinFixedBinType") ) {
                final Object value = values.remove("EWMStorageBinFixedBinType");
                if( (value == null) || (!value.equals(getEWMStorageBinFixedBinType())) ) {
                    setEWMStorageBinFixedBinType(((String) value));
                }
            }
            if( values.containsKey("EWMStorageBinAngleValue") ) {
                final Object value = values.remove("EWMStorageBinAngleValue");
                if( (value == null) || (!value.equals(getEWMStorageBinAngleValue())) ) {
                    setEWMStorageBinAngleValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("EWMStorBinNumberOfHndlgUnits") ) {
                final Object value = values.remove("EWMStorBinNumberOfHndlgUnits");
                if( (value == null) || (!value.equals(getEWMStorBinNumberOfHndlgUnits())) ) {
                    setEWMStorBinNumberOfHndlgUnits(((BigDecimal) value));
                }
            }
            if( values.containsKey("EWMStorBinMaxNmbrOfHndlgUnits") ) {
                final Object value = values.remove("EWMStorBinMaxNmbrOfHndlgUnits");
                if( (value == null) || (!value.equals(getEWMStorBinMaxNmbrOfHndlgUnits())) ) {
                    setEWMStorBinMaxNmbrOfHndlgUnits(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WarehouseStorageBinField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WarehouseStorageBinField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WarehouseStorageBinField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WarehouseStorageBinField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseStorageBinService.DEFAULT_SERVICE_PATH);
    }

}
