/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.selectable.WarehouseStorageBinSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin
 * WarehouseStorageBin} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class WarehouseStorageBinByKeyFluentHelper
    extends
    FluentHelperByKey<WarehouseStorageBinByKeyFluentHelper, WarehouseStorageBin, WarehouseStorageBinSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin
     * WarehouseStorageBin} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WarehouseStorageBin}
     * @param storageBin
     *            Storage Bin
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code WarehouseStorageBin}
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public WarehouseStorageBinByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String warehouse,
        final String storageBin )
    {
        super(servicePath, entityCollection);
        this.key.put("Warehouse", warehouse);
        this.key.put("StorageBin", storageBin);
    }

    @Override
    @Nonnull
    protected Class<WarehouseStorageBin> getEntityClass()
    {
        return WarehouseStorageBin.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
