/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link WarehouseStorageBinServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseStorageBinService WarehouseStorageBinService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultWarehouseStorageBinServiceBatch
    extends
    BatchFluentHelperBasic<WarehouseStorageBinServiceBatch, WarehouseStorageBinServiceBatchChangeSet>
    implements
    WarehouseStorageBinServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseStorageBinService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultWarehouseStorageBinServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWarehouseStorageBinServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseStorageBinService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseStorageBinService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultWarehouseStorageBinServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWarehouseStorageBinServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseStorageBinService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultWarehouseStorageBinServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WarehouseStorageBinServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultWarehouseStorageBinServiceBatchChangeSet(this, service);
    }

}
