/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link WarehouseStorageBinServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseStorageBinService WarehouseStorageBinService}.
 *
 */
public class DefaultWarehouseStorageBinServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<WarehouseStorageBinServiceBatch, WarehouseStorageBinServiceBatchChangeSet>
    implements
    WarehouseStorageBinServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseStorageBinService service;

    @SuppressWarnings( "deprecation" )
    DefaultWarehouseStorageBinServiceBatchChangeSet(
        @Nonnull final DefaultWarehouseStorageBinServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseStorageBinService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultWarehouseStorageBinServiceBatchChangeSet getThis()
    {
        return this;
    }

}
