/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin
 * WarehouseStorageBin}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.field.WarehouseStorageBinField
 * WarehouseStorageBinField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.link.WarehouseStorageBinLink
 * WarehouseStorageBinLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN
 * STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_TYPE
 * STORAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_IS_EMPTY
 * STORAGE_BIN_IS_EMPTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_IS_FULL
 * STORAGE_BIN_IS_FULL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_VERIFIED_BY_MOBILE_ID
 * STORAGE_BIN_VERIFIED_BY_MOBILE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_IS_BLOCKED_FOR_REMOVAL
 * STORAGE_BIN_IS_BLOCKED_FOR_REMOVAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_IS_BLOCKED_FOR_PUTAWAY
 * STORAGE_BIN_IS_BLOCKED_FOR_PUTAWAY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_IS_BLOCKED_DUE_TO_P_INV
 * STORAGE_BIN_IS_BLOCKED_DUE_TO_P_INV}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_FREE_DEFINED_AISLE_TEXT
 * STORAGE_BIN_FREE_DEFINED_AISLE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_FREE_DEFINED_STACK_TEXT
 * STORAGE_BIN_FREE_DEFINED_STACK_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_FREE_DEFINED_LEVEL_TEXT
 * STORAGE_BIN_FREE_DEFINED_LEVEL_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#WEIGHT_UNIT
 * WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#LOAD_CAPACITY_OF_STORAGE_BIN
 * LOAD_CAPACITY_OF_STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#WEIGHT_OF_MATERIALS_IN_STORAGE_BIN
 * WEIGHT_OF_MATERIALS_IN_STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#VOLUME_UNIT
 * VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_MAX_VOLUME
 * STORAGE_BIN_MAX_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_OCCUPIED_VOLUME
 * STORAGE_BIN_OCCUPIED_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_ROW_POSITION_IN_WHSE
 * STORAGE_BIN_ROW_POSITION_IN_WHSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_STACK_POSITION_IN_WHSE
 * STORAGE_BIN_STACK_POSITION_IN_WHSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#STORAGE_BIN_LEVEL_POSITION_IN_WHSE
 * STORAGE_BIN_LEVEL_POSITION_IN_WHSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#EWM_PHYSICAL_INVENTORY_TYPE
 * EWM_PHYSICAL_INVENTORY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#PHYSICAL_INVENTORY_DOC_NUMBER
 * PHYSICAL_INVENTORY_DOC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#PHYSICAL_INVENTORY_ITEM_NUMBER
 * PHYSICAL_INVENTORY_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#P_INV_COUNTED_UTC_DATE_TIME
 * P_INV_COUNTED_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#EWM_STORAGE_BIN_LAST_CHANGED_BY_USER
 * EWM_STORAGE_BIN_LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#EWM_STORAGE_BIN_LAST_CHG_DATE_TIME
 * EWM_STORAGE_BIN_LAST_CHG_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#EWM_STORAGE_BIN_LAST_WAREHOUSE_TASK
 * EWM_STORAGE_BIN_LAST_WAREHOUSE_TASK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#EWM_STORAGE_BIN_FIRST_PUTAWAY_DATE
 * EWM_STORAGE_BIN_FIRST_PUTAWAY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#EWM_STORAGE_BIN_LAST_MVT_DATE_TIME
 * EWM_STORAGE_BIN_LAST_MVT_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#EWM_STORAGE_BIN_LAST_CLRG_DATE_TIME
 * EWM_STORAGE_BIN_LAST_CLRG_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#EWM_STORAGE_BIN_FIXED_BIN_TYPE
 * EWM_STORAGE_BIN_FIXED_BIN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#EWM_STORAGE_BIN_ANGLE_VALUE
 * EWM_STORAGE_BIN_ANGLE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#EWM_STOR_BIN_NUMBER_OF_HNDLG_UNITS
 * EWM_STOR_BIN_NUMBER_OF_HNDLG_UNITS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousestoragebin.WarehouseStorageBin#EWM_STOR_BIN_MAX_NMBR_OF_HNDLG_UNITS
 * EWM_STOR_BIN_MAX_NMBR_OF_HNDLG_UNITS}</li>
 * </ul>
 *
 */
public interface WarehouseStorageBinSelectable extends EntitySelectable<WarehouseStorageBin>
{

}
