/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>DummyFunctionImportResult</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DummyFunctionImportResult extends VdmComplex<DummyFunctionImportResult>
{

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsInvalid</b>
     * </p>
     *
     * @param isInvalid
     *
     * @return TRUE
     */
    @SerializedName( "IsInvalid" )
    @JsonProperty( "IsInvalid" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsInvalid" )
    private Boolean isInvalid;

    @Nonnull
    @Override
    public Class<DummyFunctionImportResult> getType()
    {
        return DummyFunctionImportResult.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("IsInvalid", getIsInvalid());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("IsInvalid") ) {
                final Object value = values.remove("IsInvalid");
                if( (value == null) || (!value.equals(getIsInvalid())) ) {
                    setIsInvalid(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsInvalid</b>
     * </p>
     *
     * @param isInvalid
     *            TRUE
     */
    public void setIsInvalid( @Nullable final Boolean isInvalid )
    {
        rememberChangedField("IsInvalid", this.isInvalid);
        this.isInvalid = isInvalid;
    }

}
