/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.field.WarehouseOrderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.link.WarehouseOrderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.selectable.WarehouseOrderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Warehouse Order
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WarehouseOrderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WarehouseOrder extends VdmEntity<WarehouseOrder>
{

    /**
     * Selector for all available fields of WarehouseOrder.
     *
     */
    public final static WarehouseOrderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @Key
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static WarehouseOrderField<String> WAREHOUSE = new WarehouseOrderField<String>("Warehouse");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseOrder</b>
     * </p>
     *
     * @return Warehouse Order Number
     */
    @Key
    @SerializedName( "WarehouseOrder" )
    @JsonProperty( "WarehouseOrder" )
    @Nullable
    @ODataField( odataName = "WarehouseOrder" )
    private String warehouseOrder;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseOrder</b> field to query operations.
     *
     */
    public final static WarehouseOrderField<String> WAREHOUSE_ORDER = new WarehouseOrderField<String>("WarehouseOrder");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseOrderStatus</b>
     * </p>
     *
     * @return Warehouse Order Status
     */
    @SerializedName( "WarehouseOrderStatus" )
    @JsonProperty( "WarehouseOrderStatus" )
    @Nullable
    @ODataField( odataName = "WarehouseOrderStatus" )
    private String warehouseOrderStatus;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseOrderStatus</b> field to query operations.
     *
     */
    public final static WarehouseOrderField<String> WAREHOUSE_ORDER_STATUS =
        new WarehouseOrderField<String>("WarehouseOrderStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseOrderStatusName</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "WarehouseOrderStatusName" )
    @JsonProperty( "WarehouseOrderStatusName" )
    @Nullable
    @ODataField( odataName = "WarehouseOrderStatusName" )
    private String warehouseOrderStatusName;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseOrderStatusName</b> field to query operations.
     *
     */
    public final static WarehouseOrderField<String> WAREHOUSE_ORDER_STATUS_NAME =
        new WarehouseOrderField<String>("WarehouseOrderStatusName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Creation Time
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static WarehouseOrderField<ZonedDateTime> CREATION_DATE_TIME =
        new WarehouseOrderField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseOrderStartDateTime</b>
     * </p>
     *
     * @return Start Time
     */
    @SerializedName( "WarehouseOrderStartDateTime" )
    @JsonProperty( "WarehouseOrderStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "WarehouseOrderStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime warehouseOrderStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseOrderStartDateTime</b> field to query operations.
     *
     */
    public final static WarehouseOrderField<ZonedDateTime> WAREHOUSE_ORDER_START_DATE_TIME =
        new WarehouseOrderField<ZonedDateTime>("WarehouseOrderStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WhseOrderConfirmedDateTime</b>
     * </p>
     *
     * @return Time of Confirmation
     */
    @SerializedName( "WhseOrderConfirmedDateTime" )
    @JsonProperty( "WhseOrderConfirmedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "WhseOrderConfirmedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime whseOrderConfirmedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>WhseOrderConfirmedDateTime</b> field to query operations.
     *
     */
    public final static WarehouseOrderField<ZonedDateTime> WHSE_ORDER_CONFIRMED_DATE_TIME =
        new WarehouseOrderField<ZonedDateTime>("WhseOrderConfirmedDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Time of Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static WarehouseOrderField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new WarehouseOrderField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WhseOrderLatestStartDateTime</b>
     * </p>
     *
     * @return Latest Starting Date (LSD)
     */
    @SerializedName( "WhseOrderLatestStartDateTime" )
    @JsonProperty( "WhseOrderLatestStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "WhseOrderLatestStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime whseOrderLatestStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>WhseOrderLatestStartDateTime</b> field to query operations.
     *
     */
    public final static WarehouseOrderField<ZonedDateTime> WHSE_ORDER_LATEST_START_DATE_TIME =
        new WarehouseOrderField<ZonedDateTime>("WhseOrderLatestStartDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ExecutingResource</b>
     * </p>
     *
     * @return Resource (Means of Transportation or User)
     */
    @SerializedName( "ExecutingResource" )
    @JsonProperty( "ExecutingResource" )
    @Nullable
    @ODataField( odataName = "ExecutingResource" )
    private String executingResource;
    /**
     * Use with available fluent helpers to apply the <b>ExecutingResource</b> field to query operations.
     *
     */
    public final static WarehouseOrderField<String> EXECUTING_RESOURCE =
        new WarehouseOrderField<String>("ExecutingResource");
    /**
     * Navigation property <b>to_WarehouseTask</b> for <b>WarehouseOrder</b> to multiple <b>WarehouseTask</b>.
     *
     */
    @SerializedName( "to_WarehouseTask" )
    @JsonProperty( "to_WarehouseTask" )
    @ODataField( odataName = "to_WarehouseTask" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WarehouseTask> toWarehouseTask;
    /**
     * Use with available fluent helpers to apply the <b>to_WarehouseTask</b> navigation property to query operations.
     *
     */
    public final static WarehouseOrderLink<WarehouseTask> TO_WAREHOUSE_TASK =
        new WarehouseOrderLink<WarehouseTask>("to_WarehouseTask");

    @Nonnull
    @Override
    public Class<WarehouseOrder> getType()
    {
        return WarehouseOrder.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseOrder</b>
     * </p>
     *
     * @param warehouseOrder
     *            Warehouse Order Number
     */
    public void setWarehouseOrder( @Nullable final String warehouseOrder )
    {
        rememberChangedField("WarehouseOrder", this.warehouseOrder);
        this.warehouseOrder = warehouseOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseOrderStatus</b>
     * </p>
     *
     * @param warehouseOrderStatus
     *            Warehouse Order Status
     */
    public void setWarehouseOrderStatus( @Nullable final String warehouseOrderStatus )
    {
        rememberChangedField("WarehouseOrderStatus", this.warehouseOrderStatus);
        this.warehouseOrderStatus = warehouseOrderStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseOrderStatusName</b>
     * </p>
     *
     * @param warehouseOrderStatusName
     *            Short Text for Fixed Values
     */
    public void setWarehouseOrderStatusName( @Nullable final String warehouseOrderStatusName )
    {
        rememberChangedField("WarehouseOrderStatusName", this.warehouseOrderStatusName);
        this.warehouseOrderStatusName = warehouseOrderStatusName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Creation Time
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseOrderStartDateTime</b>
     * </p>
     *
     * @param warehouseOrderStartDateTime
     *            Start Time
     */
    public void setWarehouseOrderStartDateTime( @Nullable final ZonedDateTime warehouseOrderStartDateTime )
    {
        rememberChangedField("WarehouseOrderStartDateTime", this.warehouseOrderStartDateTime);
        this.warehouseOrderStartDateTime = warehouseOrderStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WhseOrderConfirmedDateTime</b>
     * </p>
     *
     * @param whseOrderConfirmedDateTime
     *            Time of Confirmation
     */
    public void setWhseOrderConfirmedDateTime( @Nullable final ZonedDateTime whseOrderConfirmedDateTime )
    {
        rememberChangedField("WhseOrderConfirmedDateTime", this.whseOrderConfirmedDateTime);
        this.whseOrderConfirmedDateTime = whseOrderConfirmedDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Time of Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WhseOrderLatestStartDateTime</b>
     * </p>
     *
     * @param whseOrderLatestStartDateTime
     *            Latest Starting Date (LSD)
     */
    public void setWhseOrderLatestStartDateTime( @Nullable final ZonedDateTime whseOrderLatestStartDateTime )
    {
        rememberChangedField("WhseOrderLatestStartDateTime", this.whseOrderLatestStartDateTime);
        this.whseOrderLatestStartDateTime = whseOrderLatestStartDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ExecutingResource</b>
     * </p>
     *
     * @param executingResource
     *            Resource (Means of Transportation or User)
     */
    public void setExecutingResource( @Nullable final String executingResource )
    {
        rememberChangedField("ExecutingResource", this.executingResource);
        this.executingResource = executingResource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WarehouseOrder";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Warehouse", getWarehouse());
        result.put("WarehouseOrder", getWarehouseOrder());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Warehouse", getWarehouse());
        values.put("WarehouseOrder", getWarehouseOrder());
        values.put("WarehouseOrderStatus", getWarehouseOrderStatus());
        values.put("WarehouseOrderStatusName", getWarehouseOrderStatusName());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("WarehouseOrderStartDateTime", getWarehouseOrderStartDateTime());
        values.put("WhseOrderConfirmedDateTime", getWhseOrderConfirmedDateTime());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("WhseOrderLatestStartDateTime", getWhseOrderLatestStartDateTime());
        values.put("ExecutingResource", getExecutingResource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("WarehouseOrder") ) {
                final Object value = values.remove("WarehouseOrder");
                if( (value == null) || (!value.equals(getWarehouseOrder())) ) {
                    setWarehouseOrder(((String) value));
                }
            }
            if( values.containsKey("WarehouseOrderStatus") ) {
                final Object value = values.remove("WarehouseOrderStatus");
                if( (value == null) || (!value.equals(getWarehouseOrderStatus())) ) {
                    setWarehouseOrderStatus(((String) value));
                }
            }
            if( values.containsKey("WarehouseOrderStatusName") ) {
                final Object value = values.remove("WarehouseOrderStatusName");
                if( (value == null) || (!value.equals(getWarehouseOrderStatusName())) ) {
                    setWarehouseOrderStatusName(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("WarehouseOrderStartDateTime") ) {
                final Object value = values.remove("WarehouseOrderStartDateTime");
                if( (value == null) || (!value.equals(getWarehouseOrderStartDateTime())) ) {
                    setWarehouseOrderStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("WhseOrderConfirmedDateTime") ) {
                final Object value = values.remove("WhseOrderConfirmedDateTime");
                if( (value == null) || (!value.equals(getWhseOrderConfirmedDateTime())) ) {
                    setWhseOrderConfirmedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("WhseOrderLatestStartDateTime") ) {
                final Object value = values.remove("WhseOrderLatestStartDateTime");
                if( (value == null) || (!value.equals(getWhseOrderLatestStartDateTime())) ) {
                    setWhseOrderLatestStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ExecutingResource") ) {
                final Object value = values.remove("ExecutingResource");
                if( (value == null) || (!value.equals(getExecutingResource())) ) {
                    setExecutingResource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WarehouseTask") ) {
                final Object value = (values).remove("to_WarehouseTask");
                if( value instanceof Iterable ) {
                    if( toWarehouseTask == null ) {
                        toWarehouseTask = Lists.newArrayList();
                    } else {
                        toWarehouseTask = Lists.newArrayList(toWarehouseTask);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WarehouseTask entity;
                        if( toWarehouseTask.size() > i ) {
                            entity = toWarehouseTask.get(i);
                        } else {
                            entity = new WarehouseTask();
                            toWarehouseTask.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WarehouseOrderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WarehouseOrderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WarehouseOrderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WarehouseOrderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseTaskService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWarehouseTask != null ) {
            (values).put("to_WarehouseTask", toWarehouseTask);
        }
        return values;
    }

    /**
     * Fetches the <b>WarehouseTask</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_WarehouseTask</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WarehouseTask</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WarehouseTask> fetchWarehouseTask()
    {
        return fetchFieldAsList("to_WarehouseTask", WarehouseTask.class);
    }

    /**
     * Retrieval of associated <b>WarehouseTask</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_WarehouseTask</b>.
     * <p>
     * If the navigation property <b>to_WarehouseTask</b> of a queried <b>WarehouseOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WarehouseTask</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WarehouseTask> getWarehouseTaskOrFetch()
    {
        if( toWarehouseTask == null ) {
            toWarehouseTask = fetchWarehouseTask();
        }
        return toWarehouseTask;
    }

    /**
     * Retrieval of associated <b>WarehouseTask</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_WarehouseTask</b>.
     * <p>
     * If the navigation property for an entity <b>WarehouseOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WarehouseTask</b> is already loaded, the result will
     *         contain the <b>WarehouseTask</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WarehouseTask>> getWarehouseTaskIfPresent()
    {
        return Option.of(toWarehouseTask);
    }

    /**
     * Overwrites the list of associated <b>WarehouseTask</b> entities for the loaded navigation property
     * <b>to_WarehouseTask</b>.
     * <p>
     * If the navigation property <b>to_WarehouseTask</b> of a queried <b>WarehouseOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WarehouseTask</b> entities.
     */
    public void setWarehouseTask( @Nonnull final List<WarehouseTask> value )
    {
        if( toWarehouseTask == null ) {
            toWarehouseTask = Lists.newArrayList();
        }
        toWarehouseTask.clear();
        toWarehouseTask.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WarehouseTask</b> entities. This corresponds to the OData navigation
     * property <b>to_WarehouseTask</b>.
     * <p>
     * If the navigation property <b>to_WarehouseTask</b> of a queried <b>WarehouseOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WarehouseTask</b> entities.
     */
    public void addWarehouseTask( WarehouseTask... entity )
    {
        if( toWarehouseTask == null ) {
            toWarehouseTask = Lists.newArrayList();
        }
        toWarehouseTask.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WarehouseOrder instances.
     *
     */
    public final static class WarehouseOrderBuilder
    {

        private List<WarehouseTask> toWarehouseTask = Lists.newArrayList();

        private WarehouseOrder.WarehouseOrderBuilder toWarehouseTask( final List<WarehouseTask> value )
        {
            toWarehouseTask.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WarehouseTask</b> for <b>WarehouseOrder</b> to multiple <b>WarehouseTask</b>.
         *
         * @param value
         *            The WarehouseTasks to build this WarehouseOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WarehouseOrder.WarehouseOrderBuilder warehouseTask( WarehouseTask... value )
        {
            return toWarehouseTask(Lists.newArrayList(value));
        }

    }

}
