/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.field.WarehouseTaskField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.link.WarehouseTaskLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.link.WarehouseTaskOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.selectable.WarehouseTaskSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Warehouse Task
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WarehouseTaskType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WarehouseTask extends VdmEntity<WarehouseTask>
{

    /**
     * Selector for all available fields of WarehouseTask.
     *
     */
    public final static WarehouseTaskSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @Key
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> WAREHOUSE = new WarehouseTaskField<String>("Warehouse");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTask</b>
     * </p>
     *
     * @return Warehouse Task
     */
    @Key
    @SerializedName( "WarehouseTask" )
    @JsonProperty( "WarehouseTask" )
    @Nullable
    @ODataField( odataName = "WarehouseTask" )
    private String warehouseTask;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseTask</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> WAREHOUSE_TASK = new WarehouseTaskField<String>("WarehouseTask");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTaskItem</b>
     * </p>
     *
     * @return Warehouse Task Item
     */
    @Key
    @SerializedName( "WarehouseTaskItem" )
    @JsonProperty( "WarehouseTaskItem" )
    @Nullable
    @ODataField( odataName = "WarehouseTaskItem" )
    private String warehouseTaskItem;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseTaskItem</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> WAREHOUSE_TASK_ITEM =
        new WarehouseTaskField<String>("WarehouseTaskItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseOrder</b>
     * </p>
     *
     * @return Warehouse Order Number
     */
    @SerializedName( "WarehouseOrder" )
    @JsonProperty( "WarehouseOrder" )
    @Nullable
    @ODataField( odataName = "WarehouseOrder" )
    private String warehouseOrder;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseOrder</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> WAREHOUSE_ORDER = new WarehouseTaskField<String>("WarehouseOrder");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Creation Time
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<ZonedDateTime> CREATION_DATE_TIME =
        new WarehouseTaskField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Time of Change
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new WarehouseTaskField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationUTCDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "ConfirmationUTCDateTime" )
    @JsonProperty( "ConfirmationUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmationUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime confirmationUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmationUTCDateTime</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<ZonedDateTime> CONFIRMATION_UTC_DATE_TIME =
        new WarehouseTaskField<ZonedDateTime>("ConfirmationUTCDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WhseTaskPlannedClosingDateTime</b>
     * </p>
     *
     * @return Planned Closing Date/Time
     */
    @SerializedName( "WhseTaskPlannedClosingDateTime" )
    @JsonProperty( "WhseTaskPlannedClosingDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "WhseTaskPlannedClosingDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime whseTaskPlannedClosingDateTime;
    /**
     * Use with available fluent helpers to apply the <b>WhseTaskPlannedClosingDateTime</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<ZonedDateTime> WHSE_TASK_PLANNED_CLOSING_DATE_TIME =
        new WarehouseTaskField<ZonedDateTime>("WhseTaskPlannedClosingDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WhseTaskGoodsReceiptDateTime</b>
     * </p>
     *
     * @return Date and Time of Goods Receipt
     */
    @SerializedName( "WhseTaskGoodsReceiptDateTime" )
    @JsonProperty( "WhseTaskGoodsReceiptDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "WhseTaskGoodsReceiptDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime whseTaskGoodsReceiptDateTime;
    /**
     * Use with available fluent helpers to apply the <b>WhseTaskGoodsReceiptDateTime</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<ZonedDateTime> WHSE_TASK_GOODS_RECEIPT_DATE_TIME =
        new WarehouseTaskField<ZonedDateTime>("WhseTaskGoodsReceiptDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTaskStatus</b>
     * </p>
     *
     * @return Warehouse Task Status
     */
    @SerializedName( "WarehouseTaskStatus" )
    @JsonProperty( "WarehouseTaskStatus" )
    @Nullable
    @ODataField( odataName = "WarehouseTaskStatus" )
    private String warehouseTaskStatus;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseTaskStatus</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> WAREHOUSE_TASK_STATUS =
        new WarehouseTaskField<String>("WarehouseTaskStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTaskStatusName</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "WarehouseTaskStatusName" )
    @JsonProperty( "WarehouseTaskStatusName" )
    @Nullable
    @ODataField( odataName = "WarehouseTaskStatusName" )
    private String warehouseTaskStatusName;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseTaskStatusName</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> WAREHOUSE_TASK_STATUS_NAME =
        new WarehouseTaskField<String>("WarehouseTaskStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseProcessType</b>
     * </p>
     *
     * @return Warehouse Process Type
     */
    @SerializedName( "WarehouseProcessType" )
    @JsonProperty( "WarehouseProcessType" )
    @Nullable
    @ODataField( odataName = "WarehouseProcessType" )
    private String warehouseProcessType;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseProcessType</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> WAREHOUSE_PROCESS_TYPE =
        new WarehouseTaskField<String>("WarehouseProcessType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseProcessTypeName</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "WarehouseProcessTypeName" )
    @JsonProperty( "WarehouseProcessTypeName" )
    @Nullable
    @ODataField( odataName = "WarehouseProcessTypeName" )
    private String warehouseProcessTypeName;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseProcessTypeName</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> WAREHOUSE_PROCESS_TYPE_NAME =
        new WarehouseTaskField<String>("WarehouseProcessTypeName");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsHandlingUnitWarehouseTask</b>
     * </p>
     *
     * @return Handling Unit Warehouse Task
     */
    @SerializedName( "IsHandlingUnitWarehouseTask" )
    @JsonProperty( "IsHandlingUnitWarehouseTask" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsHandlingUnitWarehouseTask" )
    private Boolean isHandlingUnitWarehouseTask;
    /**
     * Use with available fluent helpers to apply the <b>IsHandlingUnitWarehouseTask</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<Boolean> IS_HANDLING_UNIT_WAREHOUSE_TASK =
        new WarehouseTaskField<Boolean>("IsHandlingUnitWarehouseTask");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductName</b>
     * </p>
     *
     * @return Product Number
     */
    @SerializedName( "ProductName" )
    @JsonProperty( "ProductName" )
    @Nullable
    @ODataField( odataName = "ProductName" )
    private String productName;
    /**
     * Use with available fluent helpers to apply the <b>ProductName</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> PRODUCT_NAME = new WarehouseTaskField<String>("ProductName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductDescription</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "ProductDescription" )
    @JsonProperty( "ProductDescription" )
    @Nullable
    @ODataField( odataName = "ProductDescription" )
    private String productDescription;
    /**
     * Use with available fluent helpers to apply the <b>ProductDescription</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> PRODUCT_DESCRIPTION =
        new WarehouseTaskField<String>("ProductDescription");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> BATCH = new WarehouseTaskField<String>("Batch");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BatchChangeIsNotAllowed</b>
     * </p>
     *
     * @return Changing the Batch is not Allowed
     */
    @SerializedName( "BatchChangeIsNotAllowed" )
    @JsonProperty( "BatchChangeIsNotAllowed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BatchChangeIsNotAllowed" )
    private Boolean batchChangeIsNotAllowed;
    /**
     * Use with available fluent helpers to apply the <b>BatchChangeIsNotAllowed</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<Boolean> BATCH_CHANGE_IS_NOT_ALLOWED =
        new WarehouseTaskField<Boolean>("BatchChangeIsNotAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @return Stock Type
     */
    @SerializedName( "StockType" )
    @JsonProperty( "StockType" )
    @Nullable
    @ODataField( odataName = "StockType" )
    private String stockType;
    /**
     * Use with available fluent helpers to apply the <b>StockType</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> STOCK_TYPE = new WarehouseTaskField<String>("StockType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>StockTypeName</b>
     * </p>
     *
     * @return Description of Stock Type
     */
    @SerializedName( "StockTypeName" )
    @JsonProperty( "StockTypeName" )
    @Nullable
    @ODataField( odataName = "StockTypeName" )
    private String stockTypeName;
    /**
     * Use with available fluent helpers to apply the <b>StockTypeName</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> STOCK_TYPE_NAME = new WarehouseTaskField<String>("StockTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockOwner</b>
     * </p>
     *
     * @return The stockOwner contained in this entity.
     */
    @SerializedName( "StockOwner" )
    @JsonProperty( "StockOwner" )
    @Nullable
    @ODataField( odataName = "StockOwner" )
    private String stockOwner;
    /**
     * Use with available fluent helpers to apply the <b>StockOwner</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> STOCK_OWNER = new WarehouseTaskField<String>("StockOwner");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EntitledToDisposeParty</b>
     * </p>
     *
     * @return Party Entitled to Dispose
     */
    @SerializedName( "EntitledToDisposeParty" )
    @JsonProperty( "EntitledToDisposeParty" )
    @Nullable
    @ODataField( odataName = "EntitledToDisposeParty" )
    private String entitledToDisposeParty;
    /**
     * Use with available fluent helpers to apply the <b>EntitledToDisposeParty</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> ENTITLED_TO_DISPOSE_PARTY =
        new WarehouseTaskField<String>("EntitledToDisposeParty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentCategory</b>
     * </p>
     *
     * @return Special Reference Stock Type
     */
    @SerializedName( "StockDocumentCategory" )
    @JsonProperty( "StockDocumentCategory" )
    @Nullable
    @ODataField( odataName = "StockDocumentCategory" )
    private String stockDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>StockDocumentCategory</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> STOCK_DOCUMENT_CATEGORY =
        new WarehouseTaskField<String>("StockDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentNumber</b>
     * </p>
     *
     * @return Reference Document for Special Reference Stock
     */
    @SerializedName( "StockDocumentNumber" )
    @JsonProperty( "StockDocumentNumber" )
    @Nullable
    @ODataField( odataName = "StockDocumentNumber" )
    private String stockDocumentNumber;
    /**
     * Use with available fluent helpers to apply the <b>StockDocumentNumber</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> STOCK_DOCUMENT_NUMBER =
        new WarehouseTaskField<String>("StockDocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockItemNumber</b>
     * </p>
     *
     * @return Sales Order Item for Sales Order Stock
     */
    @SerializedName( "StockItemNumber" )
    @JsonProperty( "StockItemNumber" )
    @Nullable
    @ODataField( odataName = "StockItemNumber" )
    private String stockItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>StockItemNumber</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> STOCK_ITEM_NUMBER =
        new WarehouseTaskField<String>("StockItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> WBS_ELEMENT_INTERNAL_ID =
        new WarehouseTaskField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> WBS_ELEMENT_EXTERNAL_ID =
        new WarehouseTaskField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrder</b>
     * </p>
     *
     * @return The specialStockIdfgSalesOrder contained in this entity.
     */
    @SerializedName( "SpecialStockIdfgSalesOrder" )
    @JsonProperty( "SpecialStockIdfgSalesOrder" )
    @Nullable
    @ODataField( odataName = "SpecialStockIdfgSalesOrder" )
    private String specialStockIdfgSalesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SpecialStockIdfgSalesOrder</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> SPECIAL_STOCK_IDFG_SALES_ORDER =
        new WarehouseTaskField<String>("SpecialStockIdfgSalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrderItem</b>
     * </p>
     *
     * @return The specialStockIdfgSalesOrderItem contained in this entity.
     */
    @SerializedName( "SpecialStockIdfgSalesOrderItem" )
    @JsonProperty( "SpecialStockIdfgSalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SpecialStockIdfgSalesOrderItem" )
    private String specialStockIdfgSalesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SpecialStockIdfgSalesOrderItem</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> SPECIAL_STOCK_IDFG_SALES_ORDER_ITEM =
        new WarehouseTaskField<String>("SpecialStockIdfgSalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ExecutingResource</b>
     * </p>
     *
     * @return Executing Resource (Means of Transport or User)
     */
    @SerializedName( "ExecutingResource" )
    @JsonProperty( "ExecutingResource" )
    @Nullable
    @ODataField( odataName = "ExecutingResource" )
    private String executingResource;
    /**
     * Use with available fluent helpers to apply the <b>ExecutingResource</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> EXECUTING_RESOURCE =
        new WarehouseTaskField<String>("ExecutingResource");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProductionOrder</b>
     * </p>
     *
     * @return Manufacturing Order
     */
    @SerializedName( "ProductionOrder" )
    @JsonProperty( "ProductionOrder" )
    @Nullable
    @ODataField( odataName = "ProductionOrder" )
    private String productionOrder;
    /**
     * Use with available fluent helpers to apply the <b>ProductionOrder</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> PRODUCTION_ORDER = new WarehouseTaskField<String>("ProductionOrder");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @return Production Supply Area
     */
    @SerializedName( "ProductionSupplyArea" )
    @JsonProperty( "ProductionSupplyArea" )
    @Nullable
    @ODataField( odataName = "ProductionSupplyArea" )
    private String productionSupplyArea;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupplyArea</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> PRODUCTION_SUPPLY_AREA =
        new WarehouseTaskField<String>("ProductionSupplyArea");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Delivery</b>
     * </p>
     *
     * @return Document Number
     */
    @SerializedName( "Delivery" )
    @JsonProperty( "Delivery" )
    @Nullable
    @ODataField( odataName = "Delivery" )
    private String delivery;
    /**
     * Use with available fluent helpers to apply the <b>Delivery</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> DELIVERY = new WarehouseTaskField<String>("Delivery");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryItem</b>
     * </p>
     *
     * @return Item Number
     */
    @SerializedName( "DeliveryItem" )
    @JsonProperty( "DeliveryItem" )
    @Nullable
    @ODataField( odataName = "DeliveryItem" )
    private String deliveryItem;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryItem</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> DELIVERY_ITEM = new WarehouseTaskField<String>("DeliveryItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @SerializedName( "PurchasingDocument" )
    @JsonProperty( "PurchasingDocument" )
    @Nullable
    @ODataField( odataName = "PurchasingDocument" )
    private String purchasingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocument</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> PURCHASING_DOCUMENT =
        new WarehouseTaskField<String>("PurchasingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @SerializedName( "PurchasingDocumentItem" )
    @JsonProperty( "PurchasingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PurchasingDocumentItem" )
    private String purchasingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDocumentItem</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> PURCHASING_DOCUMENT_ITEM =
        new WarehouseTaskField<String>("PurchasingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @SerializedName( "SalesDocument" )
    @JsonProperty( "SalesDocument" )
    @Nullable
    @ODataField( odataName = "SalesDocument" )
    private String salesDocument;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocument</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> SALES_DOCUMENT = new WarehouseTaskField<String>("SalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesDocumentItem" )
    @JsonProperty( "SalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItem" )
    private String salesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItem</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> SALES_DOCUMENT_ITEM =
        new WarehouseTaskField<String>("SalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> BASE_UNIT = new WarehouseTaskField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EWMBaseUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "EWMBaseUnitISOCode" )
    @JsonProperty( "EWMBaseUnitISOCode" )
    @Nullable
    @ODataField( odataName = "EWMBaseUnitISOCode" )
    private String eWMBaseUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>EWMBaseUnitISOCode</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> EWM_BASE_UNIT_ISO_CODE =
        new WarehouseTaskField<String>("EWMBaseUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeUnit</b>
     * </p>
     *
     * @return Alternative Unit of Measure for Stockkeeping Unit
     */
    @SerializedName( "AlternativeUnit" )
    @JsonProperty( "AlternativeUnit" )
    @Nullable
    @ODataField( odataName = "AlternativeUnit" )
    private String alternativeUnit;
    /**
     * Use with available fluent helpers to apply the <b>AlternativeUnit</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> ALTERNATIVE_UNIT = new WarehouseTaskField<String>("AlternativeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EWMAlternativeUnitISOCode</b>
     * </p>
     *
     * @return ISO Code for Unit of Measurement
     */
    @SerializedName( "EWMAlternativeUnitISOCode" )
    @JsonProperty( "EWMAlternativeUnitISOCode" )
    @Nullable
    @ODataField( odataName = "EWMAlternativeUnitISOCode" )
    private String eWMAlternativeUnitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>EWMAlternativeUnitISOCode</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> EWM_ALTERNATIVE_UNIT_ISO_CODE =
        new WarehouseTaskField<String>("EWMAlternativeUnitISOCode");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantityInBaseUnit</b>
     * </p>
     *
     * @return Target Quantity in Base Unit of Measure
     */
    @SerializedName( "TargetQuantityInBaseUnit" )
    @JsonProperty( "TargetQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "TargetQuantityInBaseUnit" )
    private BigDecimal targetQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>TargetQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<BigDecimal> TARGET_QUANTITY_IN_BASE_UNIT =
        new WarehouseTaskField<BigDecimal>("TargetQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantityInAltvUnit</b>
     * </p>
     *
     * @return Target Quantity in Alternative Unit of Measure
     */
    @SerializedName( "TargetQuantityInAltvUnit" )
    @JsonProperty( "TargetQuantityInAltvUnit" )
    @Nullable
    @ODataField( odataName = "TargetQuantityInAltvUnit" )
    private BigDecimal targetQuantityInAltvUnit;
    /**
     * Use with available fluent helpers to apply the <b>TargetQuantityInAltvUnit</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<BigDecimal> TARGET_QUANTITY_IN_ALTV_UNIT =
        new WarehouseTaskField<BigDecimal>("TargetQuantityInAltvUnit");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>ActualQuantityInBaseUnit</b>
     * </p>
     *
     * @return The actualQuantityInBaseUnit contained in this entity.
     */
    @SerializedName( "ActualQuantityInBaseUnit" )
    @JsonProperty( "ActualQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "ActualQuantityInBaseUnit" )
    private BigDecimal actualQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>ActualQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<BigDecimal> ACTUAL_QUANTITY_IN_BASE_UNIT =
        new WarehouseTaskField<BigDecimal>("ActualQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>ActualQuantityInAltvUnit</b>
     * </p>
     *
     * @return The actualQuantityInAltvUnit contained in this entity.
     */
    @SerializedName( "ActualQuantityInAltvUnit" )
    @JsonProperty( "ActualQuantityInAltvUnit" )
    @Nullable
    @ODataField( odataName = "ActualQuantityInAltvUnit" )
    private BigDecimal actualQuantityInAltvUnit;
    /**
     * Use with available fluent helpers to apply the <b>ActualQuantityInAltvUnit</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<BigDecimal> ACTUAL_QUANTITY_IN_ALTV_UNIT =
        new WarehouseTaskField<BigDecimal>("ActualQuantityInAltvUnit");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>DifferenceQuantityInBaseUnit</b>
     * </p>
     *
     * @return The differenceQuantityInBaseUnit contained in this entity.
     */
    @SerializedName( "DifferenceQuantityInBaseUnit" )
    @JsonProperty( "DifferenceQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "DifferenceQuantityInBaseUnit" )
    private BigDecimal differenceQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>DifferenceQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<BigDecimal> DIFFERENCE_QUANTITY_IN_BASE_UNIT =
        new WarehouseTaskField<BigDecimal>("DifferenceQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>DifferenceQuantityInAltvUnit</b>
     * </p>
     *
     * @return The differenceQuantityInAltvUnit contained in this entity.
     */
    @SerializedName( "DifferenceQuantityInAltvUnit" )
    @JsonProperty( "DifferenceQuantityInAltvUnit" )
    @Nullable
    @ODataField( odataName = "DifferenceQuantityInAltvUnit" )
    private BigDecimal differenceQuantityInAltvUnit;
    /**
     * Use with available fluent helpers to apply the <b>DifferenceQuantityInAltvUnit</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<BigDecimal> DIFFERENCE_QUANTITY_IN_ALTV_UNIT =
        new WarehouseTaskField<BigDecimal>("DifferenceQuantityInAltvUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WhseTaskNetWeightUnitOfMeasure</b>
     * </p>
     *
     * @return Weight Unit
     */
    @SerializedName( "WhseTaskNetWeightUnitOfMeasure" )
    @JsonProperty( "WhseTaskNetWeightUnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "WhseTaskNetWeightUnitOfMeasure" )
    private String whseTaskNetWeightUnitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>WhseTaskNetWeightUnitOfMeasure</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> WHSE_TASK_NET_WEIGHT_UNIT_OF_MEASURE =
        new WarehouseTaskField<String>("WhseTaskNetWeightUnitOfMeasure");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetWeight</b>
     * </p>
     *
     * @return Loading or Net Weight
     */
    @SerializedName( "NetWeight" )
    @JsonProperty( "NetWeight" )
    @Nullable
    @ODataField( odataName = "NetWeight" )
    private BigDecimal netWeight;
    /**
     * Use with available fluent helpers to apply the <b>NetWeight</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<BigDecimal> NET_WEIGHT = new WarehouseTaskField<BigDecimal>("NetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WhseTaskNetVolumeUnitOfMeasure</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "WhseTaskNetVolumeUnitOfMeasure" )
    @JsonProperty( "WhseTaskNetVolumeUnitOfMeasure" )
    @Nullable
    @ODataField( odataName = "WhseTaskNetVolumeUnitOfMeasure" )
    private String whseTaskNetVolumeUnitOfMeasure;
    /**
     * Use with available fluent helpers to apply the <b>WhseTaskNetVolumeUnitOfMeasure</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> WHSE_TASK_NET_VOLUME_UNIT_OF_MEASURE =
        new WarehouseTaskField<String>("WhseTaskNetVolumeUnitOfMeasure");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WhseTaskNetVolume</b>
     * </p>
     *
     * @return Loading or Net Volume
     */
    @SerializedName( "WhseTaskNetVolume" )
    @JsonProperty( "WhseTaskNetVolume" )
    @Nullable
    @ODataField( odataName = "WhseTaskNetVolume" )
    private BigDecimal whseTaskNetVolume;
    /**
     * Use with available fluent helpers to apply the <b>WhseTaskNetVolume</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<BigDecimal> WHSE_TASK_NET_VOLUME =
        new WarehouseTaskField<BigDecimal>("WhseTaskNetVolume");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SourceStorageType</b>
     * </p>
     *
     * @return Source Storage Type
     */
    @SerializedName( "SourceStorageType" )
    @JsonProperty( "SourceStorageType" )
    @Nullable
    @ODataField( odataName = "SourceStorageType" )
    private String sourceStorageType;
    /**
     * Use with available fluent helpers to apply the <b>SourceStorageType</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> SOURCE_STORAGE_TYPE =
        new WarehouseTaskField<String>("SourceStorageType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SourceStorageTypeName</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "SourceStorageTypeName" )
    @JsonProperty( "SourceStorageTypeName" )
    @Nullable
    @ODataField( odataName = "SourceStorageTypeName" )
    private String sourceStorageTypeName;
    /**
     * Use with available fluent helpers to apply the <b>SourceStorageTypeName</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> SOURCE_STORAGE_TYPE_NAME =
        new WarehouseTaskField<String>("SourceStorageTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SourceStorageSection</b>
     * </p>
     *
     * @return Source Storage Section
     */
    @SerializedName( "SourceStorageSection" )
    @JsonProperty( "SourceStorageSection" )
    @Nullable
    @ODataField( odataName = "SourceStorageSection" )
    private String sourceStorageSection;
    /**
     * Use with available fluent helpers to apply the <b>SourceStorageSection</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> SOURCE_STORAGE_SECTION =
        new WarehouseTaskField<String>("SourceStorageSection");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SourceStorageBin</b>
     * </p>
     *
     * @return Source Storage Bin
     */
    @SerializedName( "SourceStorageBin" )
    @JsonProperty( "SourceStorageBin" )
    @Nullable
    @ODataField( odataName = "SourceStorageBin" )
    private String sourceStorageBin;
    /**
     * Use with available fluent helpers to apply the <b>SourceStorageBin</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> SOURCE_STORAGE_BIN =
        new WarehouseTaskField<String>("SourceStorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DestinationStorageType</b>
     * </p>
     *
     * @return Destination Storage Type
     */
    @SerializedName( "DestinationStorageType" )
    @JsonProperty( "DestinationStorageType" )
    @Nullable
    @ODataField( odataName = "DestinationStorageType" )
    private String destinationStorageType;
    /**
     * Use with available fluent helpers to apply the <b>DestinationStorageType</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> DESTINATION_STORAGE_TYPE =
        new WarehouseTaskField<String>("DestinationStorageType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DestinationStorageTypeName</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "DestinationStorageTypeName" )
    @JsonProperty( "DestinationStorageTypeName" )
    @Nullable
    @ODataField( odataName = "DestinationStorageTypeName" )
    private String destinationStorageTypeName;
    /**
     * Use with available fluent helpers to apply the <b>DestinationStorageTypeName</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> DESTINATION_STORAGE_TYPE_NAME =
        new WarehouseTaskField<String>("DestinationStorageTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DestinationStorageSection</b>
     * </p>
     *
     * @return Destination Storage Section
     */
    @SerializedName( "DestinationStorageSection" )
    @JsonProperty( "DestinationStorageSection" )
    @Nullable
    @ODataField( odataName = "DestinationStorageSection" )
    private String destinationStorageSection;
    /**
     * Use with available fluent helpers to apply the <b>DestinationStorageSection</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> DESTINATION_STORAGE_SECTION =
        new WarehouseTaskField<String>("DestinationStorageSection");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>DestinationStorageBin</b>
     * </p>
     *
     * @return Destination Storage Bin
     */
    @SerializedName( "DestinationStorageBin" )
    @JsonProperty( "DestinationStorageBin" )
    @Nullable
    @ODataField( odataName = "DestinationStorageBin" )
    private String destinationStorageBin;
    /**
     * Use with available fluent helpers to apply the <b>DestinationStorageBin</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> DESTINATION_STORAGE_BIN =
        new WarehouseTaskField<String>("DestinationStorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>DestinationResource</b>
     * </p>
     *
     * @return Destination Resource (Means of Transport or User)
     */
    @SerializedName( "DestinationResource" )
    @JsonProperty( "DestinationResource" )
    @Nullable
    @ODataField( odataName = "DestinationResource" )
    private String destinationResource;
    /**
     * Use with available fluent helpers to apply the <b>DestinationResource</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> DESTINATION_RESOURCE =
        new WarehouseTaskField<String>("DestinationResource");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ActivityArea</b>
     * </p>
     *
     * @return Activity Area
     */
    @SerializedName( "ActivityArea" )
    @JsonProperty( "ActivityArea" )
    @Nullable
    @ODataField( odataName = "ActivityArea" )
    private String activityArea;
    /**
     * Use with available fluent helpers to apply the <b>ActivityArea</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> ACTIVITY_AREA = new WarehouseTaskField<String>("ActivityArea");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ActivityAreaName</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "ActivityAreaName" )
    @JsonProperty( "ActivityAreaName" )
    @Nullable
    @ODataField( odataName = "ActivityAreaName" )
    private String activityAreaName;
    /**
     * Use with available fluent helpers to apply the <b>ActivityAreaName</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> ACTIVITY_AREA_NAME =
        new WarehouseTaskField<String>("ActivityAreaName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SourceHandlingUnit</b>
     * </p>
     *
     * @return Source Handling Unit
     */
    @SerializedName( "SourceHandlingUnit" )
    @JsonProperty( "SourceHandlingUnit" )
    @Nullable
    @ODataField( odataName = "SourceHandlingUnit" )
    private String sourceHandlingUnit;
    /**
     * Use with available fluent helpers to apply the <b>SourceHandlingUnit</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> SOURCE_HANDLING_UNIT =
        new WarehouseTaskField<String>("SourceHandlingUnit");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>DestinationHandlingUnit</b>
     * </p>
     *
     * @return Destination Handling Unit
     */
    @SerializedName( "DestinationHandlingUnit" )
    @JsonProperty( "DestinationHandlingUnit" )
    @Nullable
    @ODataField( odataName = "DestinationHandlingUnit" )
    private String destinationHandlingUnit;
    /**
     * Use with available fluent helpers to apply the <b>DestinationHandlingUnit</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> DESTINATION_HANDLING_UNIT =
        new WarehouseTaskField<String>("DestinationHandlingUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTaskExceptionCode</b>
     * </p>
     *
     * @return The warehouseTaskExceptionCode contained in this entity.
     */
    @SerializedName( "WarehouseTaskExceptionCode" )
    @JsonProperty( "WarehouseTaskExceptionCode" )
    @Nullable
    @ODataField( odataName = "WarehouseTaskExceptionCode" )
    private String warehouseTaskExceptionCode;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseTaskExceptionCode</b> field to query operations.
     *
     */
    public final static WarehouseTaskField<String> WAREHOUSE_TASK_EXCEPTION_CODE =
        new WarehouseTaskField<String>("WarehouseTaskExceptionCode");
    /**
     * Navigation property <b>to_WarehouseOrder</b> for <b>WarehouseTask</b> to single <b>WarehouseOrder</b>.
     *
     */
    @SerializedName( "to_WarehouseOrder" )
    @JsonProperty( "to_WarehouseOrder" )
    @ODataField( odataName = "to_WarehouseOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WarehouseOrder toWarehouseOrder;
    /**
     * Navigation property <b>to_WarehouseTaskExceptionCode</b> for <b>WarehouseTask</b> to multiple
     * <b>WarehouseTaskExceptionCode</b>.
     *
     */
    @SerializedName( "to_WarehouseTaskExceptionCode" )
    @JsonProperty( "to_WarehouseTaskExceptionCode" )
    @ODataField( odataName = "to_WarehouseTaskExceptionCode" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WarehouseTaskExceptionCode> toWarehouseTaskExceptionCode;
    /**
     * Use with available fluent helpers to apply the <b>to_WarehouseOrder</b> navigation property to query operations.
     *
     */
    public final static WarehouseTaskOneToOneLink<WarehouseOrder> TO_WAREHOUSE_ORDER =
        new WarehouseTaskOneToOneLink<WarehouseOrder>("to_WarehouseOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_WarehouseTaskExceptionCode</b> navigation property to query
     * operations.
     *
     */
    public final static WarehouseTaskLink<WarehouseTaskExceptionCode> TO_WAREHOUSE_TASK_EXCEPTION_CODE =
        new WarehouseTaskLink<WarehouseTaskExceptionCode>("to_WarehouseTaskExceptionCode");

    @Nonnull
    @Override
    public Class<WarehouseTask> getType()
    {
        return WarehouseTask.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTask</b>
     * </p>
     *
     * @param warehouseTask
     *            Warehouse Task
     */
    public void setWarehouseTask( @Nullable final String warehouseTask )
    {
        rememberChangedField("WarehouseTask", this.warehouseTask);
        this.warehouseTask = warehouseTask;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTaskItem</b>
     * </p>
     *
     * @param warehouseTaskItem
     *            Warehouse Task Item
     */
    public void setWarehouseTaskItem( @Nullable final String warehouseTaskItem )
    {
        rememberChangedField("WarehouseTaskItem", this.warehouseTaskItem);
        this.warehouseTaskItem = warehouseTaskItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseOrder</b>
     * </p>
     *
     * @param warehouseOrder
     *            Warehouse Order Number
     */
    public void setWarehouseOrder( @Nullable final String warehouseOrder )
    {
        rememberChangedField("WarehouseOrder", this.warehouseOrder);
        this.warehouseOrder = warehouseOrder;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Creation Time
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Time of Change
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmationUTCDateTime</b>
     * </p>
     *
     * @param confirmationUTCDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setConfirmationUTCDateTime( @Nullable final ZonedDateTime confirmationUTCDateTime )
    {
        rememberChangedField("ConfirmationUTCDateTime", this.confirmationUTCDateTime);
        this.confirmationUTCDateTime = confirmationUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WhseTaskPlannedClosingDateTime</b>
     * </p>
     *
     * @param whseTaskPlannedClosingDateTime
     *            Planned Closing Date/Time
     */
    public void setWhseTaskPlannedClosingDateTime( @Nullable final ZonedDateTime whseTaskPlannedClosingDateTime )
    {
        rememberChangedField("WhseTaskPlannedClosingDateTime", this.whseTaskPlannedClosingDateTime);
        this.whseTaskPlannedClosingDateTime = whseTaskPlannedClosingDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>WhseTaskGoodsReceiptDateTime</b>
     * </p>
     *
     * @param whseTaskGoodsReceiptDateTime
     *            Date and Time of Goods Receipt
     */
    public void setWhseTaskGoodsReceiptDateTime( @Nullable final ZonedDateTime whseTaskGoodsReceiptDateTime )
    {
        rememberChangedField("WhseTaskGoodsReceiptDateTime", this.whseTaskGoodsReceiptDateTime);
        this.whseTaskGoodsReceiptDateTime = whseTaskGoodsReceiptDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTaskStatus</b>
     * </p>
     *
     * @param warehouseTaskStatus
     *            Warehouse Task Status
     */
    public void setWarehouseTaskStatus( @Nullable final String warehouseTaskStatus )
    {
        rememberChangedField("WarehouseTaskStatus", this.warehouseTaskStatus);
        this.warehouseTaskStatus = warehouseTaskStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTaskStatusName</b>
     * </p>
     *
     * @param warehouseTaskStatusName
     *            Short Text for Fixed Values
     */
    public void setWarehouseTaskStatusName( @Nullable final String warehouseTaskStatusName )
    {
        rememberChangedField("WarehouseTaskStatusName", this.warehouseTaskStatusName);
        this.warehouseTaskStatusName = warehouseTaskStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseProcessType</b>
     * </p>
     *
     * @param warehouseProcessType
     *            Warehouse Process Type
     */
    public void setWarehouseProcessType( @Nullable final String warehouseProcessType )
    {
        rememberChangedField("WarehouseProcessType", this.warehouseProcessType);
        this.warehouseProcessType = warehouseProcessType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseProcessTypeName</b>
     * </p>
     *
     * @param warehouseProcessTypeName
     *            Description
     */
    public void setWarehouseProcessTypeName( @Nullable final String warehouseProcessTypeName )
    {
        rememberChangedField("WarehouseProcessTypeName", this.warehouseProcessTypeName);
        this.warehouseProcessTypeName = warehouseProcessTypeName;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsHandlingUnitWarehouseTask</b>
     * </p>
     *
     * @param isHandlingUnitWarehouseTask
     *            Handling Unit Warehouse Task
     */
    public void setIsHandlingUnitWarehouseTask( @Nullable final Boolean isHandlingUnitWarehouseTask )
    {
        rememberChangedField("IsHandlingUnitWarehouseTask", this.isHandlingUnitWarehouseTask);
        this.isHandlingUnitWarehouseTask = isHandlingUnitWarehouseTask;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductName</b>
     * </p>
     *
     * @param productName
     *            Product Number
     */
    public void setProductName( @Nullable final String productName )
    {
        rememberChangedField("ProductName", this.productName);
        this.productName = productName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProductDescription</b>
     * </p>
     *
     * @param productDescription
     *            Product Description
     */
    public void setProductDescription( @Nullable final String productDescription )
    {
        rememberChangedField("ProductDescription", this.productDescription);
        this.productDescription = productDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BatchChangeIsNotAllowed</b>
     * </p>
     *
     * @param batchChangeIsNotAllowed
     *            Changing the Batch is not Allowed
     */
    public void setBatchChangeIsNotAllowed( @Nullable final Boolean batchChangeIsNotAllowed )
    {
        rememberChangedField("BatchChangeIsNotAllowed", this.batchChangeIsNotAllowed);
        this.batchChangeIsNotAllowed = batchChangeIsNotAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>StockType</b>
     * </p>
     *
     * @param stockType
     *            Stock Type
     */
    public void setStockType( @Nullable final String stockType )
    {
        rememberChangedField("StockType", this.stockType);
        this.stockType = stockType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>StockTypeName</b>
     * </p>
     *
     * @param stockTypeName
     *            Description of Stock Type
     */
    public void setStockTypeName( @Nullable final String stockTypeName )
    {
        rememberChangedField("StockTypeName", this.stockTypeName);
        this.stockTypeName = stockTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockOwner</b>
     * </p>
     *
     * @param stockOwner
     *            The stockOwner to set.
     */
    public void setStockOwner( @Nullable final String stockOwner )
    {
        rememberChangedField("StockOwner", this.stockOwner);
        this.stockOwner = stockOwner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EntitledToDisposeParty</b>
     * </p>
     *
     * @param entitledToDisposeParty
     *            Party Entitled to Dispose
     */
    public void setEntitledToDisposeParty( @Nullable final String entitledToDisposeParty )
    {
        rememberChangedField("EntitledToDisposeParty", this.entitledToDisposeParty);
        this.entitledToDisposeParty = entitledToDisposeParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentCategory</b>
     * </p>
     *
     * @param stockDocumentCategory
     *            Special Reference Stock Type
     */
    public void setStockDocumentCategory( @Nullable final String stockDocumentCategory )
    {
        rememberChangedField("StockDocumentCategory", this.stockDocumentCategory);
        this.stockDocumentCategory = stockDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StockDocumentNumber</b>
     * </p>
     *
     * @param stockDocumentNumber
     *            Reference Document for Special Reference Stock
     */
    public void setStockDocumentNumber( @Nullable final String stockDocumentNumber )
    {
        rememberChangedField("StockDocumentNumber", this.stockDocumentNumber);
        this.stockDocumentNumber = stockDocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>StockItemNumber</b>
     * </p>
     *
     * @param stockItemNumber
     *            Sales Order Item for Sales Order Stock
     */
    public void setStockItemNumber( @Nullable final String stockItemNumber )
    {
        rememberChangedField("StockItemNumber", this.stockItemNumber);
        this.stockItemNumber = stockItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Element
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrder</b>
     * </p>
     *
     * @param specialStockIdfgSalesOrder
     *            The specialStockIdfgSalesOrder to set.
     */
    public void setSpecialStockIdfgSalesOrder( @Nullable final String specialStockIdfgSalesOrder )
    {
        rememberChangedField("SpecialStockIdfgSalesOrder", this.specialStockIdfgSalesOrder);
        this.specialStockIdfgSalesOrder = specialStockIdfgSalesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecialStockIdfgSalesOrderItem</b>
     * </p>
     *
     * @param specialStockIdfgSalesOrderItem
     *            The specialStockIdfgSalesOrderItem to set.
     */
    public void setSpecialStockIdfgSalesOrderItem( @Nullable final String specialStockIdfgSalesOrderItem )
    {
        rememberChangedField("SpecialStockIdfgSalesOrderItem", this.specialStockIdfgSalesOrderItem);
        this.specialStockIdfgSalesOrderItem = specialStockIdfgSalesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ExecutingResource</b>
     * </p>
     *
     * @param executingResource
     *            Executing Resource (Means of Transport or User)
     */
    public void setExecutingResource( @Nullable final String executingResource )
    {
        rememberChangedField("ExecutingResource", this.executingResource);
        this.executingResource = executingResource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProductionOrder</b>
     * </p>
     *
     * @param productionOrder
     *            Manufacturing Order
     */
    public void setProductionOrder( @Nullable final String productionOrder )
    {
        rememberChangedField("ProductionOrder", this.productionOrder);
        this.productionOrder = productionOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupplyArea</b>
     * </p>
     *
     * @param productionSupplyArea
     *            Production Supply Area
     */
    public void setProductionSupplyArea( @Nullable final String productionSupplyArea )
    {
        rememberChangedField("ProductionSupplyArea", this.productionSupplyArea);
        this.productionSupplyArea = productionSupplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Delivery</b>
     * </p>
     *
     * @param delivery
     *            Document Number
     */
    public void setDelivery( @Nullable final String delivery )
    {
        rememberChangedField("Delivery", this.delivery);
        this.delivery = delivery;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryItem</b>
     * </p>
     *
     * @param deliveryItem
     *            Item Number
     */
    public void setDeliveryItem( @Nullable final String deliveryItem )
    {
        rememberChangedField("DeliveryItem", this.deliveryItem);
        this.deliveryItem = deliveryItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocument</b>
     * </p>
     *
     * @param purchasingDocument
     *            Purchasing Document Number
     */
    public void setPurchasingDocument( @Nullable final String purchasingDocument )
    {
        rememberChangedField("PurchasingDocument", this.purchasingDocument);
        this.purchasingDocument = purchasingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDocumentItem</b>
     * </p>
     *
     * @param purchasingDocumentItem
     *            Item Number of Purchasing Document
     */
    public void setPurchasingDocumentItem( @Nullable final String purchasingDocumentItem )
    {
        rememberChangedField("PurchasingDocumentItem", this.purchasingDocumentItem);
        this.purchasingDocumentItem = purchasingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @param salesDocument
     *            Sales and Distribution Document Number
     */
    public void setSalesDocument( @Nullable final String salesDocument )
    {
        rememberChangedField("SalesDocument", this.salesDocument);
        this.salesDocument = salesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @param salesDocumentItem
     *            Sales Document Item
     */
    public void setSalesDocumentItem( @Nullable final String salesDocumentItem )
    {
        rememberChangedField("SalesDocumentItem", this.salesDocumentItem);
        this.salesDocumentItem = salesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EWMBaseUnitISOCode</b>
     * </p>
     *
     * @param eWMBaseUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setEWMBaseUnitISOCode( @Nullable final String eWMBaseUnitISOCode )
    {
        rememberChangedField("EWMBaseUnitISOCode", this.eWMBaseUnitISOCode);
        this.eWMBaseUnitISOCode = eWMBaseUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AlternativeUnit</b>
     * </p>
     *
     * @param alternativeUnit
     *            Alternative Unit of Measure for Stockkeeping Unit
     */
    public void setAlternativeUnit( @Nullable final String alternativeUnit )
    {
        rememberChangedField("AlternativeUnit", this.alternativeUnit);
        this.alternativeUnit = alternativeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EWMAlternativeUnitISOCode</b>
     * </p>
     *
     * @param eWMAlternativeUnitISOCode
     *            ISO Code for Unit of Measurement
     */
    public void setEWMAlternativeUnitISOCode( @Nullable final String eWMAlternativeUnitISOCode )
    {
        rememberChangedField("EWMAlternativeUnitISOCode", this.eWMAlternativeUnitISOCode);
        this.eWMAlternativeUnitISOCode = eWMAlternativeUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantityInBaseUnit</b>
     * </p>
     *
     * @param targetQuantityInBaseUnit
     *            Target Quantity in Base Unit of Measure
     */
    public void setTargetQuantityInBaseUnit( @Nullable final BigDecimal targetQuantityInBaseUnit )
    {
        rememberChangedField("TargetQuantityInBaseUnit", this.targetQuantityInBaseUnit);
        this.targetQuantityInBaseUnit = targetQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>TargetQuantityInAltvUnit</b>
     * </p>
     *
     * @param targetQuantityInAltvUnit
     *            Target Quantity in Alternative Unit of Measure
     */
    public void setTargetQuantityInAltvUnit( @Nullable final BigDecimal targetQuantityInAltvUnit )
    {
        rememberChangedField("TargetQuantityInAltvUnit", this.targetQuantityInAltvUnit);
        this.targetQuantityInAltvUnit = targetQuantityInAltvUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>ActualQuantityInBaseUnit</b>
     * </p>
     *
     * @param actualQuantityInBaseUnit
     *            The actualQuantityInBaseUnit to set.
     */
    public void setActualQuantityInBaseUnit( @Nullable final BigDecimal actualQuantityInBaseUnit )
    {
        rememberChangedField("ActualQuantityInBaseUnit", this.actualQuantityInBaseUnit);
        this.actualQuantityInBaseUnit = actualQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>ActualQuantityInAltvUnit</b>
     * </p>
     *
     * @param actualQuantityInAltvUnit
     *            The actualQuantityInAltvUnit to set.
     */
    public void setActualQuantityInAltvUnit( @Nullable final BigDecimal actualQuantityInAltvUnit )
    {
        rememberChangedField("ActualQuantityInAltvUnit", this.actualQuantityInAltvUnit);
        this.actualQuantityInAltvUnit = actualQuantityInAltvUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>DifferenceQuantityInBaseUnit</b>
     * </p>
     *
     * @param differenceQuantityInBaseUnit
     *            The differenceQuantityInBaseUnit to set.
     */
    public void setDifferenceQuantityInBaseUnit( @Nullable final BigDecimal differenceQuantityInBaseUnit )
    {
        rememberChangedField("DifferenceQuantityInBaseUnit", this.differenceQuantityInBaseUnit);
        this.differenceQuantityInBaseUnit = differenceQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>DifferenceQuantityInAltvUnit</b>
     * </p>
     *
     * @param differenceQuantityInAltvUnit
     *            The differenceQuantityInAltvUnit to set.
     */
    public void setDifferenceQuantityInAltvUnit( @Nullable final BigDecimal differenceQuantityInAltvUnit )
    {
        rememberChangedField("DifferenceQuantityInAltvUnit", this.differenceQuantityInAltvUnit);
        this.differenceQuantityInAltvUnit = differenceQuantityInAltvUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WhseTaskNetWeightUnitOfMeasure</b>
     * </p>
     *
     * @param whseTaskNetWeightUnitOfMeasure
     *            Weight Unit
     */
    public void setWhseTaskNetWeightUnitOfMeasure( @Nullable final String whseTaskNetWeightUnitOfMeasure )
    {
        rememberChangedField("WhseTaskNetWeightUnitOfMeasure", this.whseTaskNetWeightUnitOfMeasure);
        this.whseTaskNetWeightUnitOfMeasure = whseTaskNetWeightUnitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetWeight</b>
     * </p>
     *
     * @param netWeight
     *            Loading or Net Weight
     */
    public void setNetWeight( @Nullable final BigDecimal netWeight )
    {
        rememberChangedField("NetWeight", this.netWeight);
        this.netWeight = netWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WhseTaskNetVolumeUnitOfMeasure</b>
     * </p>
     *
     * @param whseTaskNetVolumeUnitOfMeasure
     *            Volume Unit
     */
    public void setWhseTaskNetVolumeUnitOfMeasure( @Nullable final String whseTaskNetVolumeUnitOfMeasure )
    {
        rememberChangedField("WhseTaskNetVolumeUnitOfMeasure", this.whseTaskNetVolumeUnitOfMeasure);
        this.whseTaskNetVolumeUnitOfMeasure = whseTaskNetVolumeUnitOfMeasure;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WhseTaskNetVolume</b>
     * </p>
     *
     * @param whseTaskNetVolume
     *            Loading or Net Volume
     */
    public void setWhseTaskNetVolume( @Nullable final BigDecimal whseTaskNetVolume )
    {
        rememberChangedField("WhseTaskNetVolume", this.whseTaskNetVolume);
        this.whseTaskNetVolume = whseTaskNetVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SourceStorageType</b>
     * </p>
     *
     * @param sourceStorageType
     *            Source Storage Type
     */
    public void setSourceStorageType( @Nullable final String sourceStorageType )
    {
        rememberChangedField("SourceStorageType", this.sourceStorageType);
        this.sourceStorageType = sourceStorageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SourceStorageTypeName</b>
     * </p>
     *
     * @param sourceStorageTypeName
     *            Description
     */
    public void setSourceStorageTypeName( @Nullable final String sourceStorageTypeName )
    {
        rememberChangedField("SourceStorageTypeName", this.sourceStorageTypeName);
        this.sourceStorageTypeName = sourceStorageTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SourceStorageSection</b>
     * </p>
     *
     * @param sourceStorageSection
     *            Source Storage Section
     */
    public void setSourceStorageSection( @Nullable final String sourceStorageSection )
    {
        rememberChangedField("SourceStorageSection", this.sourceStorageSection);
        this.sourceStorageSection = sourceStorageSection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SourceStorageBin</b>
     * </p>
     *
     * @param sourceStorageBin
     *            Source Storage Bin
     */
    public void setSourceStorageBin( @Nullable final String sourceStorageBin )
    {
        rememberChangedField("SourceStorageBin", this.sourceStorageBin);
        this.sourceStorageBin = sourceStorageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DestinationStorageType</b>
     * </p>
     *
     * @param destinationStorageType
     *            Destination Storage Type
     */
    public void setDestinationStorageType( @Nullable final String destinationStorageType )
    {
        rememberChangedField("DestinationStorageType", this.destinationStorageType);
        this.destinationStorageType = destinationStorageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DestinationStorageTypeName</b>
     * </p>
     *
     * @param destinationStorageTypeName
     *            Description
     */
    public void setDestinationStorageTypeName( @Nullable final String destinationStorageTypeName )
    {
        rememberChangedField("DestinationStorageTypeName", this.destinationStorageTypeName);
        this.destinationStorageTypeName = destinationStorageTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DestinationStorageSection</b>
     * </p>
     *
     * @param destinationStorageSection
     *            Destination Storage Section
     */
    public void setDestinationStorageSection( @Nullable final String destinationStorageSection )
    {
        rememberChangedField("DestinationStorageSection", this.destinationStorageSection);
        this.destinationStorageSection = destinationStorageSection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>DestinationStorageBin</b>
     * </p>
     *
     * @param destinationStorageBin
     *            Destination Storage Bin
     */
    public void setDestinationStorageBin( @Nullable final String destinationStorageBin )
    {
        rememberChangedField("DestinationStorageBin", this.destinationStorageBin);
        this.destinationStorageBin = destinationStorageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>DestinationResource</b>
     * </p>
     *
     * @param destinationResource
     *            Destination Resource (Means of Transport or User)
     */
    public void setDestinationResource( @Nullable final String destinationResource )
    {
        rememberChangedField("DestinationResource", this.destinationResource);
        this.destinationResource = destinationResource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ActivityArea</b>
     * </p>
     *
     * @param activityArea
     *            Activity Area
     */
    public void setActivityArea( @Nullable final String activityArea )
    {
        rememberChangedField("ActivityArea", this.activityArea);
        this.activityArea = activityArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ActivityAreaName</b>
     * </p>
     *
     * @param activityAreaName
     *            Description
     */
    public void setActivityAreaName( @Nullable final String activityAreaName )
    {
        rememberChangedField("ActivityAreaName", this.activityAreaName);
        this.activityAreaName = activityAreaName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SourceHandlingUnit</b>
     * </p>
     *
     * @param sourceHandlingUnit
     *            Source Handling Unit
     */
    public void setSourceHandlingUnit( @Nullable final String sourceHandlingUnit )
    {
        rememberChangedField("SourceHandlingUnit", this.sourceHandlingUnit);
        this.sourceHandlingUnit = sourceHandlingUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>DestinationHandlingUnit</b>
     * </p>
     *
     * @param destinationHandlingUnit
     *            Destination Handling Unit
     */
    public void setDestinationHandlingUnit( @Nullable final String destinationHandlingUnit )
    {
        rememberChangedField("DestinationHandlingUnit", this.destinationHandlingUnit);
        this.destinationHandlingUnit = destinationHandlingUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTaskExceptionCode</b>
     * </p>
     *
     * @param warehouseTaskExceptionCode
     *            The warehouseTaskExceptionCode to set.
     */
    public void setWarehouseTaskExceptionCode( @Nullable final String warehouseTaskExceptionCode )
    {
        rememberChangedField("WarehouseTaskExceptionCode", this.warehouseTaskExceptionCode);
        this.warehouseTaskExceptionCode = warehouseTaskExceptionCode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WarehouseTask";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Warehouse", getWarehouse());
        result.put("WarehouseTask", getWarehouseTask());
        result.put("WarehouseTaskItem", getWarehouseTaskItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Warehouse", getWarehouse());
        values.put("WarehouseTask", getWarehouseTask());
        values.put("WarehouseTaskItem", getWarehouseTaskItem());
        values.put("WarehouseOrder", getWarehouseOrder());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("ConfirmationUTCDateTime", getConfirmationUTCDateTime());
        values.put("WhseTaskPlannedClosingDateTime", getWhseTaskPlannedClosingDateTime());
        values.put("WhseTaskGoodsReceiptDateTime", getWhseTaskGoodsReceiptDateTime());
        values.put("WarehouseTaskStatus", getWarehouseTaskStatus());
        values.put("WarehouseTaskStatusName", getWarehouseTaskStatusName());
        values.put("WarehouseProcessType", getWarehouseProcessType());
        values.put("WarehouseProcessTypeName", getWarehouseProcessTypeName());
        values.put("IsHandlingUnitWarehouseTask", getIsHandlingUnitWarehouseTask());
        values.put("ProductName", getProductName());
        values.put("ProductDescription", getProductDescription());
        values.put("Batch", getBatch());
        values.put("BatchChangeIsNotAllowed", getBatchChangeIsNotAllowed());
        values.put("StockType", getStockType());
        values.put("StockTypeName", getStockTypeName());
        values.put("StockOwner", getStockOwner());
        values.put("EntitledToDisposeParty", getEntitledToDisposeParty());
        values.put("StockDocumentCategory", getStockDocumentCategory());
        values.put("StockDocumentNumber", getStockDocumentNumber());
        values.put("StockItemNumber", getStockItemNumber());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("SpecialStockIdfgSalesOrder", getSpecialStockIdfgSalesOrder());
        values.put("SpecialStockIdfgSalesOrderItem", getSpecialStockIdfgSalesOrderItem());
        values.put("ExecutingResource", getExecutingResource());
        values.put("ProductionOrder", getProductionOrder());
        values.put("ProductionSupplyArea", getProductionSupplyArea());
        values.put("Delivery", getDelivery());
        values.put("DeliveryItem", getDeliveryItem());
        values.put("PurchasingDocument", getPurchasingDocument());
        values.put("PurchasingDocumentItem", getPurchasingDocumentItem());
        values.put("SalesDocument", getSalesDocument());
        values.put("SalesDocumentItem", getSalesDocumentItem());
        values.put("BaseUnit", getBaseUnit());
        values.put("EWMBaseUnitISOCode", getEWMBaseUnitISOCode());
        values.put("AlternativeUnit", getAlternativeUnit());
        values.put("EWMAlternativeUnitISOCode", getEWMAlternativeUnitISOCode());
        values.put("TargetQuantityInBaseUnit", getTargetQuantityInBaseUnit());
        values.put("TargetQuantityInAltvUnit", getTargetQuantityInAltvUnit());
        values.put("ActualQuantityInBaseUnit", getActualQuantityInBaseUnit());
        values.put("ActualQuantityInAltvUnit", getActualQuantityInAltvUnit());
        values.put("DifferenceQuantityInBaseUnit", getDifferenceQuantityInBaseUnit());
        values.put("DifferenceQuantityInAltvUnit", getDifferenceQuantityInAltvUnit());
        values.put("WhseTaskNetWeightUnitOfMeasure", getWhseTaskNetWeightUnitOfMeasure());
        values.put("NetWeight", getNetWeight());
        values.put("WhseTaskNetVolumeUnitOfMeasure", getWhseTaskNetVolumeUnitOfMeasure());
        values.put("WhseTaskNetVolume", getWhseTaskNetVolume());
        values.put("SourceStorageType", getSourceStorageType());
        values.put("SourceStorageTypeName", getSourceStorageTypeName());
        values.put("SourceStorageSection", getSourceStorageSection());
        values.put("SourceStorageBin", getSourceStorageBin());
        values.put("DestinationStorageType", getDestinationStorageType());
        values.put("DestinationStorageTypeName", getDestinationStorageTypeName());
        values.put("DestinationStorageSection", getDestinationStorageSection());
        values.put("DestinationStorageBin", getDestinationStorageBin());
        values.put("DestinationResource", getDestinationResource());
        values.put("ActivityArea", getActivityArea());
        values.put("ActivityAreaName", getActivityAreaName());
        values.put("SourceHandlingUnit", getSourceHandlingUnit());
        values.put("DestinationHandlingUnit", getDestinationHandlingUnit());
        values.put("WarehouseTaskExceptionCode", getWarehouseTaskExceptionCode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("WarehouseTask") ) {
                final Object value = values.remove("WarehouseTask");
                if( (value == null) || (!value.equals(getWarehouseTask())) ) {
                    setWarehouseTask(((String) value));
                }
            }
            if( values.containsKey("WarehouseTaskItem") ) {
                final Object value = values.remove("WarehouseTaskItem");
                if( (value == null) || (!value.equals(getWarehouseTaskItem())) ) {
                    setWarehouseTaskItem(((String) value));
                }
            }
            if( values.containsKey("WarehouseOrder") ) {
                final Object value = values.remove("WarehouseOrder");
                if( (value == null) || (!value.equals(getWarehouseOrder())) ) {
                    setWarehouseOrder(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ConfirmationUTCDateTime") ) {
                final Object value = values.remove("ConfirmationUTCDateTime");
                if( (value == null) || (!value.equals(getConfirmationUTCDateTime())) ) {
                    setConfirmationUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("WhseTaskPlannedClosingDateTime") ) {
                final Object value = values.remove("WhseTaskPlannedClosingDateTime");
                if( (value == null) || (!value.equals(getWhseTaskPlannedClosingDateTime())) ) {
                    setWhseTaskPlannedClosingDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("WhseTaskGoodsReceiptDateTime") ) {
                final Object value = values.remove("WhseTaskGoodsReceiptDateTime");
                if( (value == null) || (!value.equals(getWhseTaskGoodsReceiptDateTime())) ) {
                    setWhseTaskGoodsReceiptDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("WarehouseTaskStatus") ) {
                final Object value = values.remove("WarehouseTaskStatus");
                if( (value == null) || (!value.equals(getWarehouseTaskStatus())) ) {
                    setWarehouseTaskStatus(((String) value));
                }
            }
            if( values.containsKey("WarehouseTaskStatusName") ) {
                final Object value = values.remove("WarehouseTaskStatusName");
                if( (value == null) || (!value.equals(getWarehouseTaskStatusName())) ) {
                    setWarehouseTaskStatusName(((String) value));
                }
            }
            if( values.containsKey("WarehouseProcessType") ) {
                final Object value = values.remove("WarehouseProcessType");
                if( (value == null) || (!value.equals(getWarehouseProcessType())) ) {
                    setWarehouseProcessType(((String) value));
                }
            }
            if( values.containsKey("WarehouseProcessTypeName") ) {
                final Object value = values.remove("WarehouseProcessTypeName");
                if( (value == null) || (!value.equals(getWarehouseProcessTypeName())) ) {
                    setWarehouseProcessTypeName(((String) value));
                }
            }
            if( values.containsKey("IsHandlingUnitWarehouseTask") ) {
                final Object value = values.remove("IsHandlingUnitWarehouseTask");
                if( (value == null) || (!value.equals(getIsHandlingUnitWarehouseTask())) ) {
                    setIsHandlingUnitWarehouseTask(((Boolean) value));
                }
            }
            if( values.containsKey("ProductName") ) {
                final Object value = values.remove("ProductName");
                if( (value == null) || (!value.equals(getProductName())) ) {
                    setProductName(((String) value));
                }
            }
            if( values.containsKey("ProductDescription") ) {
                final Object value = values.remove("ProductDescription");
                if( (value == null) || (!value.equals(getProductDescription())) ) {
                    setProductDescription(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("BatchChangeIsNotAllowed") ) {
                final Object value = values.remove("BatchChangeIsNotAllowed");
                if( (value == null) || (!value.equals(getBatchChangeIsNotAllowed())) ) {
                    setBatchChangeIsNotAllowed(((Boolean) value));
                }
            }
            if( values.containsKey("StockType") ) {
                final Object value = values.remove("StockType");
                if( (value == null) || (!value.equals(getStockType())) ) {
                    setStockType(((String) value));
                }
            }
            if( values.containsKey("StockTypeName") ) {
                final Object value = values.remove("StockTypeName");
                if( (value == null) || (!value.equals(getStockTypeName())) ) {
                    setStockTypeName(((String) value));
                }
            }
            if( values.containsKey("StockOwner") ) {
                final Object value = values.remove("StockOwner");
                if( (value == null) || (!value.equals(getStockOwner())) ) {
                    setStockOwner(((String) value));
                }
            }
            if( values.containsKey("EntitledToDisposeParty") ) {
                final Object value = values.remove("EntitledToDisposeParty");
                if( (value == null) || (!value.equals(getEntitledToDisposeParty())) ) {
                    setEntitledToDisposeParty(((String) value));
                }
            }
            if( values.containsKey("StockDocumentCategory") ) {
                final Object value = values.remove("StockDocumentCategory");
                if( (value == null) || (!value.equals(getStockDocumentCategory())) ) {
                    setStockDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("StockDocumentNumber") ) {
                final Object value = values.remove("StockDocumentNumber");
                if( (value == null) || (!value.equals(getStockDocumentNumber())) ) {
                    setStockDocumentNumber(((String) value));
                }
            }
            if( values.containsKey("StockItemNumber") ) {
                final Object value = values.remove("StockItemNumber");
                if( (value == null) || (!value.equals(getStockItemNumber())) ) {
                    setStockItemNumber(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("SpecialStockIdfgSalesOrder") ) {
                final Object value = values.remove("SpecialStockIdfgSalesOrder");
                if( (value == null) || (!value.equals(getSpecialStockIdfgSalesOrder())) ) {
                    setSpecialStockIdfgSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SpecialStockIdfgSalesOrderItem") ) {
                final Object value = values.remove("SpecialStockIdfgSalesOrderItem");
                if( (value == null) || (!value.equals(getSpecialStockIdfgSalesOrderItem())) ) {
                    setSpecialStockIdfgSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("ExecutingResource") ) {
                final Object value = values.remove("ExecutingResource");
                if( (value == null) || (!value.equals(getExecutingResource())) ) {
                    setExecutingResource(((String) value));
                }
            }
            if( values.containsKey("ProductionOrder") ) {
                final Object value = values.remove("ProductionOrder");
                if( (value == null) || (!value.equals(getProductionOrder())) ) {
                    setProductionOrder(((String) value));
                }
            }
            if( values.containsKey("ProductionSupplyArea") ) {
                final Object value = values.remove("ProductionSupplyArea");
                if( (value == null) || (!value.equals(getProductionSupplyArea())) ) {
                    setProductionSupplyArea(((String) value));
                }
            }
            if( values.containsKey("Delivery") ) {
                final Object value = values.remove("Delivery");
                if( (value == null) || (!value.equals(getDelivery())) ) {
                    setDelivery(((String) value));
                }
            }
            if( values.containsKey("DeliveryItem") ) {
                final Object value = values.remove("DeliveryItem");
                if( (value == null) || (!value.equals(getDeliveryItem())) ) {
                    setDeliveryItem(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocument") ) {
                final Object value = values.remove("PurchasingDocument");
                if( (value == null) || (!value.equals(getPurchasingDocument())) ) {
                    setPurchasingDocument(((String) value));
                }
            }
            if( values.containsKey("PurchasingDocumentItem") ) {
                final Object value = values.remove("PurchasingDocumentItem");
                if( (value == null) || (!value.equals(getPurchasingDocumentItem())) ) {
                    setPurchasingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SalesDocument") ) {
                final Object value = values.remove("SalesDocument");
                if( (value == null) || (!value.equals(getSalesDocument())) ) {
                    setSalesDocument(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItem") ) {
                final Object value = values.remove("SalesDocumentItem");
                if( (value == null) || (!value.equals(getSalesDocumentItem())) ) {
                    setSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("EWMBaseUnitISOCode") ) {
                final Object value = values.remove("EWMBaseUnitISOCode");
                if( (value == null) || (!value.equals(getEWMBaseUnitISOCode())) ) {
                    setEWMBaseUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("AlternativeUnit") ) {
                final Object value = values.remove("AlternativeUnit");
                if( (value == null) || (!value.equals(getAlternativeUnit())) ) {
                    setAlternativeUnit(((String) value));
                }
            }
            if( values.containsKey("EWMAlternativeUnitISOCode") ) {
                final Object value = values.remove("EWMAlternativeUnitISOCode");
                if( (value == null) || (!value.equals(getEWMAlternativeUnitISOCode())) ) {
                    setEWMAlternativeUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("TargetQuantityInBaseUnit") ) {
                final Object value = values.remove("TargetQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getTargetQuantityInBaseUnit())) ) {
                    setTargetQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("TargetQuantityInAltvUnit") ) {
                final Object value = values.remove("TargetQuantityInAltvUnit");
                if( (value == null) || (!value.equals(getTargetQuantityInAltvUnit())) ) {
                    setTargetQuantityInAltvUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActualQuantityInBaseUnit") ) {
                final Object value = values.remove("ActualQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getActualQuantityInBaseUnit())) ) {
                    setActualQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActualQuantityInAltvUnit") ) {
                final Object value = values.remove("ActualQuantityInAltvUnit");
                if( (value == null) || (!value.equals(getActualQuantityInAltvUnit())) ) {
                    setActualQuantityInAltvUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("DifferenceQuantityInBaseUnit") ) {
                final Object value = values.remove("DifferenceQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getDifferenceQuantityInBaseUnit())) ) {
                    setDifferenceQuantityInBaseUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("DifferenceQuantityInAltvUnit") ) {
                final Object value = values.remove("DifferenceQuantityInAltvUnit");
                if( (value == null) || (!value.equals(getDifferenceQuantityInAltvUnit())) ) {
                    setDifferenceQuantityInAltvUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("WhseTaskNetWeightUnitOfMeasure") ) {
                final Object value = values.remove("WhseTaskNetWeightUnitOfMeasure");
                if( (value == null) || (!value.equals(getWhseTaskNetWeightUnitOfMeasure())) ) {
                    setWhseTaskNetWeightUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("NetWeight") ) {
                final Object value = values.remove("NetWeight");
                if( (value == null) || (!value.equals(getNetWeight())) ) {
                    setNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("WhseTaskNetVolumeUnitOfMeasure") ) {
                final Object value = values.remove("WhseTaskNetVolumeUnitOfMeasure");
                if( (value == null) || (!value.equals(getWhseTaskNetVolumeUnitOfMeasure())) ) {
                    setWhseTaskNetVolumeUnitOfMeasure(((String) value));
                }
            }
            if( values.containsKey("WhseTaskNetVolume") ) {
                final Object value = values.remove("WhseTaskNetVolume");
                if( (value == null) || (!value.equals(getWhseTaskNetVolume())) ) {
                    setWhseTaskNetVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("SourceStorageType") ) {
                final Object value = values.remove("SourceStorageType");
                if( (value == null) || (!value.equals(getSourceStorageType())) ) {
                    setSourceStorageType(((String) value));
                }
            }
            if( values.containsKey("SourceStorageTypeName") ) {
                final Object value = values.remove("SourceStorageTypeName");
                if( (value == null) || (!value.equals(getSourceStorageTypeName())) ) {
                    setSourceStorageTypeName(((String) value));
                }
            }
            if( values.containsKey("SourceStorageSection") ) {
                final Object value = values.remove("SourceStorageSection");
                if( (value == null) || (!value.equals(getSourceStorageSection())) ) {
                    setSourceStorageSection(((String) value));
                }
            }
            if( values.containsKey("SourceStorageBin") ) {
                final Object value = values.remove("SourceStorageBin");
                if( (value == null) || (!value.equals(getSourceStorageBin())) ) {
                    setSourceStorageBin(((String) value));
                }
            }
            if( values.containsKey("DestinationStorageType") ) {
                final Object value = values.remove("DestinationStorageType");
                if( (value == null) || (!value.equals(getDestinationStorageType())) ) {
                    setDestinationStorageType(((String) value));
                }
            }
            if( values.containsKey("DestinationStorageTypeName") ) {
                final Object value = values.remove("DestinationStorageTypeName");
                if( (value == null) || (!value.equals(getDestinationStorageTypeName())) ) {
                    setDestinationStorageTypeName(((String) value));
                }
            }
            if( values.containsKey("DestinationStorageSection") ) {
                final Object value = values.remove("DestinationStorageSection");
                if( (value == null) || (!value.equals(getDestinationStorageSection())) ) {
                    setDestinationStorageSection(((String) value));
                }
            }
            if( values.containsKey("DestinationStorageBin") ) {
                final Object value = values.remove("DestinationStorageBin");
                if( (value == null) || (!value.equals(getDestinationStorageBin())) ) {
                    setDestinationStorageBin(((String) value));
                }
            }
            if( values.containsKey("DestinationResource") ) {
                final Object value = values.remove("DestinationResource");
                if( (value == null) || (!value.equals(getDestinationResource())) ) {
                    setDestinationResource(((String) value));
                }
            }
            if( values.containsKey("ActivityArea") ) {
                final Object value = values.remove("ActivityArea");
                if( (value == null) || (!value.equals(getActivityArea())) ) {
                    setActivityArea(((String) value));
                }
            }
            if( values.containsKey("ActivityAreaName") ) {
                final Object value = values.remove("ActivityAreaName");
                if( (value == null) || (!value.equals(getActivityAreaName())) ) {
                    setActivityAreaName(((String) value));
                }
            }
            if( values.containsKey("SourceHandlingUnit") ) {
                final Object value = values.remove("SourceHandlingUnit");
                if( (value == null) || (!value.equals(getSourceHandlingUnit())) ) {
                    setSourceHandlingUnit(((String) value));
                }
            }
            if( values.containsKey("DestinationHandlingUnit") ) {
                final Object value = values.remove("DestinationHandlingUnit");
                if( (value == null) || (!value.equals(getDestinationHandlingUnit())) ) {
                    setDestinationHandlingUnit(((String) value));
                }
            }
            if( values.containsKey("WarehouseTaskExceptionCode") ) {
                final Object value = values.remove("WarehouseTaskExceptionCode");
                if( (value == null) || (!value.equals(getWarehouseTaskExceptionCode())) ) {
                    setWarehouseTaskExceptionCode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WarehouseOrder") ) {
                final Object value = (values).remove("to_WarehouseOrder");
                if( value instanceof Map ) {
                    if( toWarehouseOrder == null ) {
                        toWarehouseOrder = new WarehouseOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toWarehouseOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_WarehouseTaskExceptionCode") ) {
                final Object value = (values).remove("to_WarehouseTaskExceptionCode");
                if( value instanceof Iterable ) {
                    if( toWarehouseTaskExceptionCode == null ) {
                        toWarehouseTaskExceptionCode = Lists.newArrayList();
                    } else {
                        toWarehouseTaskExceptionCode = Lists.newArrayList(toWarehouseTaskExceptionCode);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WarehouseTaskExceptionCode entity;
                        if( toWarehouseTaskExceptionCode.size() > i ) {
                            entity = toWarehouseTaskExceptionCode.get(i);
                        } else {
                            entity = new WarehouseTaskExceptionCode();
                            toWarehouseTaskExceptionCode.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WarehouseTaskField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WarehouseTaskField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WarehouseTaskField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WarehouseTaskField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseTaskService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWarehouseOrder != null ) {
            (values).put("to_WarehouseOrder", toWarehouseOrder);
        }
        if( toWarehouseTaskExceptionCode != null ) {
            (values).put("to_WarehouseTaskExceptionCode", toWarehouseTaskExceptionCode);
        }
        return values;
    }

    /**
     * Fetches the <b>WarehouseOrder</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_WarehouseOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WarehouseOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WarehouseOrder fetchWarehouseOrder()
    {
        return fetchFieldAsSingle("to_WarehouseOrder", WarehouseOrder.class);
    }

    /**
     * Retrieval of associated <b>WarehouseOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_WarehouseOrder</b>.
     * <p>
     * If the navigation property <b>to_WarehouseOrder</b> of a queried <b>WarehouseTask</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WarehouseOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WarehouseOrder getWarehouseOrderOrFetch()
    {
        if( toWarehouseOrder == null ) {
            toWarehouseOrder = fetchWarehouseOrder();
        }
        return toWarehouseOrder;
    }

    /**
     * Retrieval of associated <b>WarehouseOrder</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_WarehouseOrder</b>.
     * <p>
     * If the navigation property for an entity <b>WarehouseTask</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WarehouseOrder</b> is already loaded, the result will
     *         contain the <b>WarehouseOrder</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<WarehouseOrder> getWarehouseOrderIfPresent()
    {
        return Option.of(toWarehouseOrder);
    }

    /**
     * Overwrites the associated <b>WarehouseOrder</b> entity for the loaded navigation property
     * <b>to_WarehouseOrder</b>.
     *
     * @param value
     *            New <b>WarehouseOrder</b> entity.
     */
    public void setWarehouseOrder( final WarehouseOrder value )
    {
        toWarehouseOrder = value;
    }

    /**
     * Fetches the <b>WarehouseTaskExceptionCode</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_WarehouseTaskExceptionCode</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WarehouseTaskExceptionCode</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WarehouseTaskExceptionCode> fetchWarehouseTaskExceptionCode()
    {
        return fetchFieldAsList("to_WarehouseTaskExceptionCode", WarehouseTaskExceptionCode.class);
    }

    /**
     * Retrieval of associated <b>WarehouseTaskExceptionCode</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WarehouseTaskExceptionCode</b>.
     * <p>
     * If the navigation property <b>to_WarehouseTaskExceptionCode</b> of a queried <b>WarehouseTask</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WarehouseTaskExceptionCode</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WarehouseTaskExceptionCode> getWarehouseTaskExceptionCodeOrFetch()
    {
        if( toWarehouseTaskExceptionCode == null ) {
            toWarehouseTaskExceptionCode = fetchWarehouseTaskExceptionCode();
        }
        return toWarehouseTaskExceptionCode;
    }

    /**
     * Retrieval of associated <b>WarehouseTaskExceptionCode</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WarehouseTaskExceptionCode</b>.
     * <p>
     * If the navigation property for an entity <b>WarehouseTask</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WarehouseTaskExceptionCode</b> is already loaded, the
     *         result will contain the <b>WarehouseTaskExceptionCode</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WarehouseTaskExceptionCode>> getWarehouseTaskExceptionCodeIfPresent()
    {
        return Option.of(toWarehouseTaskExceptionCode);
    }

    /**
     * Overwrites the list of associated <b>WarehouseTaskExceptionCode</b> entities for the loaded navigation property
     * <b>to_WarehouseTaskExceptionCode</b>.
     * <p>
     * If the navigation property <b>to_WarehouseTaskExceptionCode</b> of a queried <b>WarehouseTask</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WarehouseTaskExceptionCode</b> entities.
     */
    public void setWarehouseTaskExceptionCode( @Nonnull final List<WarehouseTaskExceptionCode> value )
    {
        if( toWarehouseTaskExceptionCode == null ) {
            toWarehouseTaskExceptionCode = Lists.newArrayList();
        }
        toWarehouseTaskExceptionCode.clear();
        toWarehouseTaskExceptionCode.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WarehouseTaskExceptionCode</b> entities. This corresponds to the OData
     * navigation property <b>to_WarehouseTaskExceptionCode</b>.
     * <p>
     * If the navigation property <b>to_WarehouseTaskExceptionCode</b> of a queried <b>WarehouseTask</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WarehouseTaskExceptionCode</b> entities.
     */
    public void addWarehouseTaskExceptionCode( WarehouseTaskExceptionCode... entity )
    {
        if( toWarehouseTaskExceptionCode == null ) {
            toWarehouseTaskExceptionCode = Lists.newArrayList();
        }
        toWarehouseTaskExceptionCode.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WarehouseTask instances.
     *
     */
    public final static class WarehouseTaskBuilder
    {

        private WarehouseOrder toWarehouseOrder;
        private String warehouseOrder = null;
        private List<WarehouseTaskExceptionCode> toWarehouseTaskExceptionCode = Lists.newArrayList();
        private String warehouseTaskExceptionCode = null;

        private WarehouseTask.WarehouseTaskBuilder toWarehouseOrder( final WarehouseOrder value )
        {
            toWarehouseOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_WarehouseOrder</b> for <b>WarehouseTask</b> to single <b>WarehouseOrder</b>.
         *
         * @param value
         *            The WarehouseOrder to build this WarehouseTask with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WarehouseTask.WarehouseTaskBuilder warehouseOrder( final WarehouseOrder value )
        {
            return toWarehouseOrder(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>WarehouseOrder</b>
         * </p>
         *
         * @param value
         *            The warehouseOrder to build this WarehouseTask with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WarehouseTask.WarehouseTaskBuilder warehouseOrder( final String value )
        {
            warehouseOrder = value;
            return this;
        }

        private WarehouseTask.WarehouseTaskBuilder toWarehouseTaskExceptionCode(
            final List<WarehouseTaskExceptionCode> value )
        {
            toWarehouseTaskExceptionCode.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WarehouseTaskExceptionCode</b> for <b>WarehouseTask</b> to multiple
         * <b>WarehouseTaskExceptionCode</b>.
         *
         * @param value
         *            The WarehouseTaskExceptionCodes to build this WarehouseTask with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WarehouseTask.WarehouseTaskBuilder warehouseTaskExceptionCode( WarehouseTaskExceptionCode... value )
        {
            return toWarehouseTaskExceptionCode(Lists.newArrayList(value));
        }

        /**
         * Constraints: Not nullable, Maximum length: 1
         * <p>
         * Original property name from the Odata EDM: <b>WarehouseTaskExceptionCode</b>
         * </p>
         *
         * @param value
         *            The warehouseTaskExceptionCode to build this WarehouseTask with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WarehouseTask.WarehouseTaskBuilder warehouseTaskExceptionCode( final String value )
        {
            warehouseTaskExceptionCode = value;
            return this;
        }

    }

}
