/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.field.WarehouseTaskExceptionCodeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.link.WarehouseTaskExceptionCodeOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.selectable.WarehouseTaskExceptionCodeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Warehouse Task Exception Code
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WarehouseTaskExceptionCodeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WarehouseTaskExceptionCode extends VdmEntity<WarehouseTaskExceptionCode>
{

    /**
     * Selector for all available fields of WarehouseTaskExceptionCode.
     *
     */
    public final static WarehouseTaskExceptionCodeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @return Warehouse Number/Warehouse Complex
     */
    @Key
    @SerializedName( "Warehouse" )
    @JsonProperty( "Warehouse" )
    @Nullable
    @ODataField( odataName = "Warehouse" )
    private String warehouse;
    /**
     * Use with available fluent helpers to apply the <b>Warehouse</b> field to query operations.
     *
     */
    public final static WarehouseTaskExceptionCodeField<String> WAREHOUSE =
        new WarehouseTaskExceptionCodeField<String>("Warehouse");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTask</b>
     * </p>
     *
     * @return Warehouse Task
     */
    @Key
    @SerializedName( "WarehouseTask" )
    @JsonProperty( "WarehouseTask" )
    @Nullable
    @ODataField( odataName = "WarehouseTask" )
    private String warehouseTask;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseTask</b> field to query operations.
     *
     */
    public final static WarehouseTaskExceptionCodeField<String> WAREHOUSE_TASK =
        new WarehouseTaskExceptionCodeField<String>("WarehouseTask");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTaskItem</b>
     * </p>
     *
     * @return Warehouse Task Item
     */
    @Key
    @SerializedName( "WarehouseTaskItem" )
    @JsonProperty( "WarehouseTaskItem" )
    @Nullable
    @ODataField( odataName = "WarehouseTaskItem" )
    private String warehouseTaskItem;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseTaskItem</b> field to query operations.
     *
     */
    public final static WarehouseTaskExceptionCodeField<String> WAREHOUSE_TASK_ITEM =
        new WarehouseTaskExceptionCodeField<String>("WarehouseTaskItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTaskExceptionCode</b>
     * </p>
     *
     * @return Exception Code
     */
    @Key
    @SerializedName( "WarehouseTaskExceptionCode" )
    @JsonProperty( "WarehouseTaskExceptionCode" )
    @Nullable
    @ODataField( odataName = "WarehouseTaskExceptionCode" )
    private String warehouseTaskExceptionCode;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseTaskExceptionCode</b> field to query operations.
     *
     */
    public final static WarehouseTaskExceptionCodeField<String> WAREHOUSE_TASK_EXCEPTION_CODE =
        new WarehouseTaskExceptionCodeField<String>("WarehouseTaskExceptionCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessContext</b>
     * </p>
     *
     * @return Business Context
     */
    @Key
    @SerializedName( "BusinessContext" )
    @JsonProperty( "BusinessContext" )
    @Nullable
    @ODataField( odataName = "BusinessContext" )
    private String businessContext;
    /**
     * Use with available fluent helpers to apply the <b>BusinessContext</b> field to query operations.
     *
     */
    public final static WarehouseTaskExceptionCodeField<String> BUSINESS_CONTEXT =
        new WarehouseTaskExceptionCodeField<String>("BusinessContext");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusinessContextExecutionStep</b>
     * </p>
     *
     * @return Execution Step in Business Context
     */
    @Key
    @SerializedName( "BusinessContextExecutionStep" )
    @JsonProperty( "BusinessContextExecutionStep" )
    @Nullable
    @ODataField( odataName = "BusinessContextExecutionStep" )
    private String businessContextExecutionStep;
    /**
     * Use with available fluent helpers to apply the <b>BusinessContextExecutionStep</b> field to query operations.
     *
     */
    public final static WarehouseTaskExceptionCodeField<String> BUSINESS_CONTEXT_EXECUTION_STEP =
        new WarehouseTaskExceptionCodeField<String>("BusinessContextExecutionStep");
    /**
     * Navigation property <b>to_WarehouseTask</b> for <b>WarehouseTaskExceptionCode</b> to single <b>WarehouseTask</b>.
     *
     */
    @SerializedName( "to_WarehouseTask" )
    @JsonProperty( "to_WarehouseTask" )
    @ODataField( odataName = "to_WarehouseTask" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WarehouseTask toWarehouseTask;
    /**
     * Use with available fluent helpers to apply the <b>to_WarehouseTask</b> navigation property to query operations.
     *
     */
    public final static WarehouseTaskExceptionCodeOneToOneLink<WarehouseTask> TO_WAREHOUSE_TASK =
        new WarehouseTaskExceptionCodeOneToOneLink<WarehouseTask>("to_WarehouseTask");

    @Nonnull
    @Override
    public Class<WarehouseTaskExceptionCode> getType()
    {
        return WarehouseTaskExceptionCode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Warehouse</b>
     * </p>
     *
     * @param warehouse
     *            Warehouse Number/Warehouse Complex
     */
    public void setWarehouse( @Nullable final String warehouse )
    {
        rememberChangedField("Warehouse", this.warehouse);
        this.warehouse = warehouse;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTask</b>
     * </p>
     *
     * @param warehouseTask
     *            Warehouse Task
     */
    public void setWarehouseTask( @Nullable final String warehouseTask )
    {
        rememberChangedField("WarehouseTask", this.warehouseTask);
        this.warehouseTask = warehouseTask;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTaskItem</b>
     * </p>
     *
     * @param warehouseTaskItem
     *            Warehouse Task Item
     */
    public void setWarehouseTaskItem( @Nullable final String warehouseTaskItem )
    {
        rememberChangedField("WarehouseTaskItem", this.warehouseTaskItem);
        this.warehouseTaskItem = warehouseTaskItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseTaskExceptionCode</b>
     * </p>
     *
     * @param warehouseTaskExceptionCode
     *            Exception Code
     */
    public void setWarehouseTaskExceptionCode( @Nullable final String warehouseTaskExceptionCode )
    {
        rememberChangedField("WarehouseTaskExceptionCode", this.warehouseTaskExceptionCode);
        this.warehouseTaskExceptionCode = warehouseTaskExceptionCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessContext</b>
     * </p>
     *
     * @param businessContext
     *            Business Context
     */
    public void setBusinessContext( @Nullable final String businessContext )
    {
        rememberChangedField("BusinessContext", this.businessContext);
        this.businessContext = businessContext;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusinessContextExecutionStep</b>
     * </p>
     *
     * @param businessContextExecutionStep
     *            Execution Step in Business Context
     */
    public void setBusinessContextExecutionStep( @Nullable final String businessContextExecutionStep )
    {
        rememberChangedField("BusinessContextExecutionStep", this.businessContextExecutionStep);
        this.businessContextExecutionStep = businessContextExecutionStep;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WarehouseTaskExceptionCode";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Warehouse", getWarehouse());
        result.put("WarehouseTask", getWarehouseTask());
        result.put("WarehouseTaskItem", getWarehouseTaskItem());
        result.put("WarehouseTaskExceptionCode", getWarehouseTaskExceptionCode());
        result.put("BusinessContext", getBusinessContext());
        result.put("BusinessContextExecutionStep", getBusinessContextExecutionStep());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Warehouse", getWarehouse());
        values.put("WarehouseTask", getWarehouseTask());
        values.put("WarehouseTaskItem", getWarehouseTaskItem());
        values.put("WarehouseTaskExceptionCode", getWarehouseTaskExceptionCode());
        values.put("BusinessContext", getBusinessContext());
        values.put("BusinessContextExecutionStep", getBusinessContextExecutionStep());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Warehouse") ) {
                final Object value = values.remove("Warehouse");
                if( (value == null) || (!value.equals(getWarehouse())) ) {
                    setWarehouse(((String) value));
                }
            }
            if( values.containsKey("WarehouseTask") ) {
                final Object value = values.remove("WarehouseTask");
                if( (value == null) || (!value.equals(getWarehouseTask())) ) {
                    setWarehouseTask(((String) value));
                }
            }
            if( values.containsKey("WarehouseTaskItem") ) {
                final Object value = values.remove("WarehouseTaskItem");
                if( (value == null) || (!value.equals(getWarehouseTaskItem())) ) {
                    setWarehouseTaskItem(((String) value));
                }
            }
            if( values.containsKey("WarehouseTaskExceptionCode") ) {
                final Object value = values.remove("WarehouseTaskExceptionCode");
                if( (value == null) || (!value.equals(getWarehouseTaskExceptionCode())) ) {
                    setWarehouseTaskExceptionCode(((String) value));
                }
            }
            if( values.containsKey("BusinessContext") ) {
                final Object value = values.remove("BusinessContext");
                if( (value == null) || (!value.equals(getBusinessContext())) ) {
                    setBusinessContext(((String) value));
                }
            }
            if( values.containsKey("BusinessContextExecutionStep") ) {
                final Object value = values.remove("BusinessContextExecutionStep");
                if( (value == null) || (!value.equals(getBusinessContextExecutionStep())) ) {
                    setBusinessContextExecutionStep(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WarehouseTask") ) {
                final Object value = (values).remove("to_WarehouseTask");
                if( value instanceof Map ) {
                    if( toWarehouseTask == null ) {
                        toWarehouseTask = new WarehouseTask();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toWarehouseTask.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WarehouseTaskExceptionCodeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new WarehouseTaskExceptionCodeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WarehouseTaskExceptionCodeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WarehouseTaskExceptionCodeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseTaskService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWarehouseTask != null ) {
            (values).put("to_WarehouseTask", toWarehouseTask);
        }
        return values;
    }

    /**
     * Fetches the <b>WarehouseTask</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_WarehouseTask</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WarehouseTask</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WarehouseTask fetchWarehouseTask()
    {
        return fetchFieldAsSingle("to_WarehouseTask", WarehouseTask.class);
    }

    /**
     * Retrieval of associated <b>WarehouseTask</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_WarehouseTask</b>.
     * <p>
     * If the navigation property <b>to_WarehouseTask</b> of a queried <b>WarehouseTaskExceptionCode</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WarehouseTask</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WarehouseTask getWarehouseTaskOrFetch()
    {
        if( toWarehouseTask == null ) {
            toWarehouseTask = fetchWarehouseTask();
        }
        return toWarehouseTask;
    }

    /**
     * Retrieval of associated <b>WarehouseTask</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_WarehouseTask</b>.
     * <p>
     * If the navigation property for an entity <b>WarehouseTaskExceptionCode</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WarehouseTask</b> is already loaded, the result will
     *         contain the <b>WarehouseTask</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<WarehouseTask> getWarehouseTaskIfPresent()
    {
        return Option.of(toWarehouseTask);
    }

    /**
     * Overwrites the associated <b>WarehouseTask</b> entity for the loaded navigation property <b>to_WarehouseTask</b>.
     *
     * @param value
     *            New <b>WarehouseTask</b> entity.
     */
    public void setWarehouseTask( final WarehouseTask value )
    {
        toWarehouseTask = value;
    }

    /**
     * Helper class to allow for fluent creation of WarehouseTaskExceptionCode instances.
     *
     */
    public final static class WarehouseTaskExceptionCodeBuilder
    {

        private WarehouseTask toWarehouseTask;
        private String warehouseTask = null;

        private WarehouseTaskExceptionCode.WarehouseTaskExceptionCodeBuilder toWarehouseTask(
            final WarehouseTask value )
        {
            toWarehouseTask = value;
            return this;
        }

        /**
         * Navigation property <b>to_WarehouseTask</b> for <b>WarehouseTaskExceptionCode</b> to single
         * <b>WarehouseTask</b>.
         *
         * @param value
         *            The WarehouseTask to build this WarehouseTaskExceptionCode with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WarehouseTaskExceptionCode.WarehouseTaskExceptionCodeBuilder warehouseTask( final WarehouseTask value )
        {
            return toWarehouseTask(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 12
         * <p>
         * Original property name from the Odata EDM: <b>WarehouseTask</b>
         * </p>
         *
         * @param value
         *            The warehouseTask to build this WarehouseTaskExceptionCode with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WarehouseTaskExceptionCode.WarehouseTaskExceptionCodeBuilder warehouseTask( final String value )
        {
            warehouseTask = value;
            return this;
        }

    }

}
