/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link WarehouseTaskServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseTaskService WarehouseTaskService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultWarehouseTaskServiceBatch
    extends
    BatchFluentHelperBasic<WarehouseTaskServiceBatch, WarehouseTaskServiceBatchChangeSet>
    implements
    WarehouseTaskServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseTaskService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultWarehouseTaskServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWarehouseTaskServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseTaskService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseTaskService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultWarehouseTaskServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultWarehouseTaskServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseTaskService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultWarehouseTaskServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WarehouseTaskServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultWarehouseTaskServiceBatchChangeSet(this, service);
    }

}
