/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask;

/**
 * Implementation of the {@link WarehouseTaskServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseTaskService WarehouseTaskService}.
 *
 */
public class DefaultWarehouseTaskServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<WarehouseTaskServiceBatch, WarehouseTaskServiceBatchChangeSet>
    implements
    WarehouseTaskServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseTaskService service;

    @SuppressWarnings( "deprecation" )
    DefaultWarehouseTaskServiceBatchChangeSet(
        @Nonnull final DefaultWarehouseTaskServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseTaskService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultWarehouseTaskServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WarehouseTaskServiceBatchChangeSet createWarehouseOrder( @Nonnull final WarehouseOrder warehouseOrder )
    {
        return addRequestCreate(service::createWarehouseOrder, warehouseOrder);
    }

    @Nonnull
    @Override
    public WarehouseTaskServiceBatchChangeSet createWarehouseTask( @Nonnull final WarehouseTask warehouseTask )
    {
        return addRequestCreate(service::createWarehouseTask, warehouseTask);
    }

}
