/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WarehouseTaskService WarehouseTaskService}.
 *
 */
public interface WarehouseTaskServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<WarehouseTaskServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<WarehouseTaskServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder
     * WarehouseOrder} entity and save it to the S/4HANA system.
     *
     * @param warehouseOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder
     *            WarehouseOrder} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WarehouseTaskServiceBatchChangeSet createWarehouseOrder( @Nonnull final WarehouseOrder warehouseOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask
     * WarehouseTask} entity and save it to the S/4HANA system.
     *
     * @param warehouseTask
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask WarehouseTask}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WarehouseTaskServiceBatchChangeSet createWarehouseTask( @Nonnull final WarehouseTask warehouseTask );

}
