/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder WarehouseOrder}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.field.WarehouseOrderField
 * WarehouseOrderField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.link.WarehouseOrderLink WarehouseOrderLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder#WAREHOUSE WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder#WAREHOUSE_ORDER
 * WAREHOUSE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder#WAREHOUSE_ORDER_STATUS
 * WAREHOUSE_ORDER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder#WAREHOUSE_ORDER_STATUS_NAME
 * WAREHOUSE_ORDER_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder#WAREHOUSE_ORDER_START_DATE_TIME
 * WAREHOUSE_ORDER_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder#WHSE_ORDER_CONFIRMED_DATE_TIME
 * WHSE_ORDER_CONFIRMED_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder#WHSE_ORDER_LATEST_START_DATE_TIME
 * WHSE_ORDER_LATEST_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder#EXECUTING_RESOURCE
 * EXECUTING_RESOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseOrder#TO_WAREHOUSE_TASK
 * TO_WAREHOUSE_TASK}</li>
 * </ul>
 *
 */
public interface WarehouseOrderSelectable extends EntitySelectable<WarehouseOrder>
{

}
