/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCode;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCode
 * WarehouseTaskExceptionCode}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.field.WarehouseTaskExceptionCodeField
 * WarehouseTaskExceptionCodeField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.link.WarehouseTaskExceptionCodeLink
 * WarehouseTaskExceptionCodeLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCode#WAREHOUSE
 * WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCode#WAREHOUSE_TASK
 * WAREHOUSE_TASK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCode#WAREHOUSE_TASK_ITEM
 * WAREHOUSE_TASK_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCode#WAREHOUSE_TASK_EXCEPTION_CODE
 * WAREHOUSE_TASK_EXCEPTION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCode#BUSINESS_CONTEXT
 * BUSINESS_CONTEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCode#BUSINESS_CONTEXT_EXECUTION_STEP
 * BUSINESS_CONTEXT_EXECUTION_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTaskExceptionCode#TO_WAREHOUSE_TASK
 * TO_WAREHOUSE_TASK}</li>
 * </ul>
 *
 */
public interface WarehouseTaskExceptionCodeSelectable extends EntitySelectable<WarehouseTaskExceptionCode>
{

}
