/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask WarehouseTask}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.field.WarehouseTaskField
 * WarehouseTaskField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.link.WarehouseTaskLink WarehouseTaskLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WAREHOUSE WAREHOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WAREHOUSE_TASK
 * WAREHOUSE_TASK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WAREHOUSE_TASK_ITEM
 * WAREHOUSE_TASK_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WAREHOUSE_ORDER
 * WAREHOUSE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#CREATION_DATE_TIME
 * CREATION_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#CONFIRMATION_UTC_DATE_TIME
 * CONFIRMATION_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WHSE_TASK_PLANNED_CLOSING_DATE_TIME
 * WHSE_TASK_PLANNED_CLOSING_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WHSE_TASK_GOODS_RECEIPT_DATE_TIME
 * WHSE_TASK_GOODS_RECEIPT_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WAREHOUSE_TASK_STATUS
 * WAREHOUSE_TASK_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WAREHOUSE_TASK_STATUS_NAME
 * WAREHOUSE_TASK_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WAREHOUSE_PROCESS_TYPE
 * WAREHOUSE_PROCESS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WAREHOUSE_PROCESS_TYPE_NAME
 * WAREHOUSE_PROCESS_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#IS_HANDLING_UNIT_WAREHOUSE_TASK
 * IS_HANDLING_UNIT_WAREHOUSE_TASK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#PRODUCT_NAME
 * PRODUCT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#PRODUCT_DESCRIPTION
 * PRODUCT_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#BATCH BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#BATCH_CHANGE_IS_NOT_ALLOWED
 * BATCH_CHANGE_IS_NOT_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#STOCK_TYPE
 * STOCK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#STOCK_TYPE_NAME
 * STOCK_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#STOCK_OWNER
 * STOCK_OWNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#ENTITLED_TO_DISPOSE_PARTY
 * ENTITLED_TO_DISPOSE_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#STOCK_DOCUMENT_CATEGORY
 * STOCK_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#STOCK_DOCUMENT_NUMBER
 * STOCK_DOCUMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#STOCK_ITEM_NUMBER
 * STOCK_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WBS_ELEMENT_INTERNAL_ID
 * WBS_ELEMENT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#SPECIAL_STOCK_IDFG_SALES_ORDER
 * SPECIAL_STOCK_IDFG_SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#SPECIAL_STOCK_IDFG_SALES_ORDER_ITEM
 * SPECIAL_STOCK_IDFG_SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#EXECUTING_RESOURCE
 * EXECUTING_RESOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#PRODUCTION_ORDER
 * PRODUCTION_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#PRODUCTION_SUPPLY_AREA
 * PRODUCTION_SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#DELIVERY DELIVERY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#DELIVERY_ITEM
 * DELIVERY_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#PURCHASING_DOCUMENT
 * PURCHASING_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#PURCHASING_DOCUMENT_ITEM
 * PURCHASING_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#SALES_DOCUMENT
 * SALES_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#SALES_DOCUMENT_ITEM
 * SALES_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#BASE_UNIT BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#EWM_BASE_UNIT_ISO_CODE
 * EWM_BASE_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#ALTERNATIVE_UNIT
 * ALTERNATIVE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#EWM_ALTERNATIVE_UNIT_ISO_CODE
 * EWM_ALTERNATIVE_UNIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#TARGET_QUANTITY_IN_BASE_UNIT
 * TARGET_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#TARGET_QUANTITY_IN_ALTV_UNIT
 * TARGET_QUANTITY_IN_ALTV_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#ACTUAL_QUANTITY_IN_BASE_UNIT
 * ACTUAL_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#ACTUAL_QUANTITY_IN_ALTV_UNIT
 * ACTUAL_QUANTITY_IN_ALTV_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#DIFFERENCE_QUANTITY_IN_BASE_UNIT
 * DIFFERENCE_QUANTITY_IN_BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#DIFFERENCE_QUANTITY_IN_ALTV_UNIT
 * DIFFERENCE_QUANTITY_IN_ALTV_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WHSE_TASK_NET_WEIGHT_UNIT_OF_MEASURE
 * WHSE_TASK_NET_WEIGHT_UNIT_OF_MEASURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#NET_WEIGHT
 * NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WHSE_TASK_NET_VOLUME_UNIT_OF_MEASURE
 * WHSE_TASK_NET_VOLUME_UNIT_OF_MEASURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WHSE_TASK_NET_VOLUME
 * WHSE_TASK_NET_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#SOURCE_STORAGE_TYPE
 * SOURCE_STORAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#SOURCE_STORAGE_TYPE_NAME
 * SOURCE_STORAGE_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#SOURCE_STORAGE_SECTION
 * SOURCE_STORAGE_SECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#SOURCE_STORAGE_BIN
 * SOURCE_STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#DESTINATION_STORAGE_TYPE
 * DESTINATION_STORAGE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#DESTINATION_STORAGE_TYPE_NAME
 * DESTINATION_STORAGE_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#DESTINATION_STORAGE_SECTION
 * DESTINATION_STORAGE_SECTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#DESTINATION_STORAGE_BIN
 * DESTINATION_STORAGE_BIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#DESTINATION_RESOURCE
 * DESTINATION_RESOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#ACTIVITY_AREA
 * ACTIVITY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#ACTIVITY_AREA_NAME
 * ACTIVITY_AREA_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#SOURCE_HANDLING_UNIT
 * SOURCE_HANDLING_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#DESTINATION_HANDLING_UNIT
 * DESTINATION_HANDLING_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#WAREHOUSE_TASK_EXCEPTION_CODE
 * WAREHOUSE_TASK_EXCEPTION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#TO_WAREHOUSE_ORDER
 * TO_WAREHOUSE_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.warehousetask.WarehouseTask#TO_WAREHOUSE_TASK_EXCEPTION_CODE
 * TO_WAREHOUSE_TASK_EXCEPTION_CODE}</li>
 * </ul>
 *
 */
public interface WarehouseTaskSelectable extends EntitySelectable<WarehouseTask>
{

}
