/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterAllCapacityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterAllCapacityLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterAllCapacitySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Capacity Assignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCenterAllCapacityType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenterAllCapacity extends VdmEntity<WorkCenterAllCapacity>
{

    /**
     * Selector for all available fields of WorkCenterAllCapacity.
     *
     */
    public final static WorkCenterAllCapacitySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the resource
     */
    @Key
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacityField<String> WORK_CENTER_INTERNAL_ID =
        new WorkCenterAllCapacityField<String>("WorkCenterInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @Key
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacityField<String> WORK_CENTER_TYPE_CODE =
        new WorkCenterAllCapacityField<String>("WorkCenterTypeCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @return Capacity ID
     */
    @Key
    @SerializedName( "CapacityInternalID" )
    @JsonProperty( "CapacityInternalID" )
    @Nullable
    @ODataField( odataName = "CapacityInternalID" )
    private String capacityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CapacityInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacityField<String> CAPACITY_INTERNAL_ID =
        new WorkCenterAllCapacityField<String>("CapacityInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryAllocation</b>
     * </p>
     *
     * @return Capacity Category Allocation
     */
    @Key
    @SerializedName( "CapacityCategoryAllocation" )
    @JsonProperty( "CapacityCategoryAllocation" )
    @Nullable
    @ODataField( odataName = "CapacityCategoryAllocation" )
    private String capacityCategoryAllocation;
    /**
     * Use with available fluent helpers to apply the <b>CapacityCategoryAllocation</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacityField<String> CAPACITY_CATEGORY_ALLOCATION =
        new WorkCenterAllCapacityField<String>("CapacityCategoryAllocation");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacityField<String> WORK_CENTER =
        new WorkCenterAllCapacityField<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterDesc</b>
     * </p>
     *
     * @return Work Center Text
     */
    @SerializedName( "WorkCenterDesc" )
    @JsonProperty( "WorkCenterDesc" )
    @Nullable
    @ODataField( odataName = "WorkCenterDesc" )
    private String workCenterDesc;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterDesc</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacityField<String> WORK_CENTER_DESC =
        new WorkCenterAllCapacityField<String>("WorkCenterDesc");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacityField<String> PLANT = new WorkCenterAllCapacityField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCategoryCode</b>
     * </p>
     *
     * @return Work Center Category
     */
    @SerializedName( "WorkCenterCategoryCode" )
    @JsonProperty( "WorkCenterCategoryCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterCategoryCode" )
    private String workCenterCategoryCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterCategoryCode</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacityField<String> WORK_CENTER_CATEGORY_CODE =
        new WorkCenterAllCapacityField<String>("WorkCenterCategoryCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsible</b>
     * </p>
     *
     * @return Person Responsible for the Work Center
     */
    @SerializedName( "WorkCenterResponsible" )
    @JsonProperty( "WorkCenterResponsible" )
    @Nullable
    @ODataField( odataName = "WorkCenterResponsible" )
    private String workCenterResponsible;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterResponsible</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacityField<String> WORK_CENTER_RESPONSIBLE =
        new WorkCenterAllCapacityField<String>("WorkCenterResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyArea</b>
     * </p>
     *
     * @return Production Supply Area
     */
    @SerializedName( "SupplyArea" )
    @JsonProperty( "SupplyArea" )
    @Nullable
    @ODataField( odataName = "SupplyArea" )
    private String supplyArea;
    /**
     * Use with available fluent helpers to apply the <b>SupplyArea</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacityField<String> SUPPLY_AREA =
        new WorkCenterAllCapacityField<String>("SupplyArea");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterUsage</b>
     * </p>
     *
     * @return Work Center Usage in Bill of Operations
     */
    @SerializedName( "WorkCenterUsage" )
    @JsonProperty( "WorkCenterUsage" )
    @Nullable
    @ODataField( odataName = "WorkCenterUsage" )
    private String workCenterUsage;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterUsage</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacityField<String> WORK_CENTER_USAGE =
        new WorkCenterAllCapacityField<String>("WorkCenterUsage");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsibleName</b>
     * </p>
     *
     * @return Work Center Responsible Name
     */
    @SerializedName( "WorkCenterResponsibleName" )
    @JsonProperty( "WorkCenterResponsibleName" )
    @Nullable
    @ODataField( odataName = "WorkCenterResponsibleName" )
    private String workCenterResponsibleName;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterResponsibleName</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacityField<String> WORK_CENTER_RESPONSIBLE_NAME =
        new WorkCenterAllCapacityField<String>("WorkCenterResponsibleName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryCode</b>
     * </p>
     *
     * @return Capacity Category
     */
    @SerializedName( "CapacityCategoryCode" )
    @JsonProperty( "CapacityCategoryCode" )
    @Nullable
    @ODataField( odataName = "CapacityCategoryCode" )
    private String capacityCategoryCode;
    /**
     * Use with available fluent helpers to apply the <b>CapacityCategoryCode</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacityField<String> CAPACITY_CATEGORY_CODE =
        new WorkCenterAllCapacityField<String>("CapacityCategoryCode");
    /**
     * Navigation property <b>to_WorkCenterInterval</b> for <b>WorkCenterAllCapacity</b> to multiple
     * <b>WorkCenterCapacityInterval</b>.
     *
     */
    @SerializedName( "to_WorkCenterInterval" )
    @JsonProperty( "to_WorkCenterInterval" )
    @ODataField( odataName = "to_WorkCenterInterval" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterCapacityInterval> toWorkCenterInterval;
    /**
     * Navigation property <b>to_WorkCenterQueuingOp</b> for <b>WorkCenterAllCapacity</b> to multiple
     * <b>WorkCenterCapPplineOp</b>.
     *
     */
    @SerializedName( "to_WorkCenterQueuingOp" )
    @JsonProperty( "to_WorkCenterQueuingOp" )
    @ODataField( odataName = "to_WorkCenterQueuingOp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterCapPplineOp> toWorkCenterQueuingOp;
    /**
     * Navigation property <b>to_WorkCenterTodayOp</b> for <b>WorkCenterAllCapacity</b> to multiple
     * <b>WorkCenterCapDayOp</b>.
     *
     */
    @SerializedName( "to_WorkCenterTodayOp" )
    @JsonProperty( "to_WorkCenterTodayOp" )
    @ODataField( odataName = "to_WorkCenterTodayOp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterCapDayOp> toWorkCenterTodayOp;
    /**
     * Use with available fluent helpers to apply the <b>to_WorkCenterInterval</b> navigation property to query
     * operations.
     *
     */
    public final static WorkCenterAllCapacityLink<WorkCenterCapacityInterval> TO_WORK_CENTER_INTERVAL =
        new WorkCenterAllCapacityLink<WorkCenterCapacityInterval>("to_WorkCenterInterval");
    /**
     * Use with available fluent helpers to apply the <b>to_WorkCenterQueuingOp</b> navigation property to query
     * operations.
     *
     */
    public final static WorkCenterAllCapacityLink<WorkCenterCapPplineOp> TO_WORK_CENTER_QUEUING_OP =
        new WorkCenterAllCapacityLink<WorkCenterCapPplineOp>("to_WorkCenterQueuingOp");
    /**
     * Use with available fluent helpers to apply the <b>to_WorkCenterTodayOp</b> navigation property to query
     * operations.
     *
     */
    public final static WorkCenterAllCapacityLink<WorkCenterCapDayOp> TO_WORK_CENTER_TODAY_OP =
        new WorkCenterAllCapacityLink<WorkCenterCapDayOp>("to_WorkCenterTodayOp");

    @Nonnull
    @Override
    public Class<WorkCenterAllCapacity> getType()
    {
        return WorkCenterAllCapacity.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID of the resource
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @param capacityInternalID
     *            Capacity ID
     */
    public void setCapacityInternalID( @Nullable final String capacityInternalID )
    {
        rememberChangedField("CapacityInternalID", this.capacityInternalID);
        this.capacityInternalID = capacityInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryAllocation</b>
     * </p>
     *
     * @param capacityCategoryAllocation
     *            Capacity Category Allocation
     */
    public void setCapacityCategoryAllocation( @Nullable final String capacityCategoryAllocation )
    {
        rememberChangedField("CapacityCategoryAllocation", this.capacityCategoryAllocation);
        this.capacityCategoryAllocation = capacityCategoryAllocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterDesc</b>
     * </p>
     *
     * @param workCenterDesc
     *            Work Center Text
     */
    public void setWorkCenterDesc( @Nullable final String workCenterDesc )
    {
        rememberChangedField("WorkCenterDesc", this.workCenterDesc);
        this.workCenterDesc = workCenterDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCategoryCode</b>
     * </p>
     *
     * @param workCenterCategoryCode
     *            Work Center Category
     */
    public void setWorkCenterCategoryCode( @Nullable final String workCenterCategoryCode )
    {
        rememberChangedField("WorkCenterCategoryCode", this.workCenterCategoryCode);
        this.workCenterCategoryCode = workCenterCategoryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsible</b>
     * </p>
     *
     * @param workCenterResponsible
     *            Person Responsible for the Work Center
     */
    public void setWorkCenterResponsible( @Nullable final String workCenterResponsible )
    {
        rememberChangedField("WorkCenterResponsible", this.workCenterResponsible);
        this.workCenterResponsible = workCenterResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyArea</b>
     * </p>
     *
     * @param supplyArea
     *            Production Supply Area
     */
    public void setSupplyArea( @Nullable final String supplyArea )
    {
        rememberChangedField("SupplyArea", this.supplyArea);
        this.supplyArea = supplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterUsage</b>
     * </p>
     *
     * @param workCenterUsage
     *            Work Center Usage in Bill of Operations
     */
    public void setWorkCenterUsage( @Nullable final String workCenterUsage )
    {
        rememberChangedField("WorkCenterUsage", this.workCenterUsage);
        this.workCenterUsage = workCenterUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsibleName</b>
     * </p>
     *
     * @param workCenterResponsibleName
     *            Work Center Responsible Name
     */
    public void setWorkCenterResponsibleName( @Nullable final String workCenterResponsibleName )
    {
        rememberChangedField("WorkCenterResponsibleName", this.workCenterResponsibleName);
        this.workCenterResponsibleName = workCenterResponsibleName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryCode</b>
     * </p>
     *
     * @param capacityCategoryCode
     *            Capacity Category
     */
    public void setCapacityCategoryCode( @Nullable final String capacityCategoryCode )
    {
        rememberChangedField("CapacityCategoryCode", this.capacityCategoryCode);
        this.capacityCategoryCode = capacityCategoryCode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenterAllCapacity";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WorkCenterInternalID", getWorkCenterInternalID());
        result.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        result.put("CapacityInternalID", getCapacityInternalID());
        result.put("CapacityCategoryAllocation", getCapacityCategoryAllocation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("CapacityInternalID", getCapacityInternalID());
        values.put("CapacityCategoryAllocation", getCapacityCategoryAllocation());
        values.put("WorkCenter", getWorkCenter());
        values.put("WorkCenterDesc", getWorkCenterDesc());
        values.put("Plant", getPlant());
        values.put("WorkCenterCategoryCode", getWorkCenterCategoryCode());
        values.put("WorkCenterResponsible", getWorkCenterResponsible());
        values.put("SupplyArea", getSupplyArea());
        values.put("WorkCenterUsage", getWorkCenterUsage());
        values.put("WorkCenterResponsibleName", getWorkCenterResponsibleName());
        values.put("CapacityCategoryCode", getCapacityCategoryCode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("CapacityInternalID") ) {
                final Object value = values.remove("CapacityInternalID");
                if( (value == null) || (!value.equals(getCapacityInternalID())) ) {
                    setCapacityInternalID(((String) value));
                }
            }
            if( values.containsKey("CapacityCategoryAllocation") ) {
                final Object value = values.remove("CapacityCategoryAllocation");
                if( (value == null) || (!value.equals(getCapacityCategoryAllocation())) ) {
                    setCapacityCategoryAllocation(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("WorkCenterDesc") ) {
                final Object value = values.remove("WorkCenterDesc");
                if( (value == null) || (!value.equals(getWorkCenterDesc())) ) {
                    setWorkCenterDesc(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("WorkCenterCategoryCode") ) {
                final Object value = values.remove("WorkCenterCategoryCode");
                if( (value == null) || (!value.equals(getWorkCenterCategoryCode())) ) {
                    setWorkCenterCategoryCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenterResponsible") ) {
                final Object value = values.remove("WorkCenterResponsible");
                if( (value == null) || (!value.equals(getWorkCenterResponsible())) ) {
                    setWorkCenterResponsible(((String) value));
                }
            }
            if( values.containsKey("SupplyArea") ) {
                final Object value = values.remove("SupplyArea");
                if( (value == null) || (!value.equals(getSupplyArea())) ) {
                    setSupplyArea(((String) value));
                }
            }
            if( values.containsKey("WorkCenterUsage") ) {
                final Object value = values.remove("WorkCenterUsage");
                if( (value == null) || (!value.equals(getWorkCenterUsage())) ) {
                    setWorkCenterUsage(((String) value));
                }
            }
            if( values.containsKey("WorkCenterResponsibleName") ) {
                final Object value = values.remove("WorkCenterResponsibleName");
                if( (value == null) || (!value.equals(getWorkCenterResponsibleName())) ) {
                    setWorkCenterResponsibleName(((String) value));
                }
            }
            if( values.containsKey("CapacityCategoryCode") ) {
                final Object value = values.remove("CapacityCategoryCode");
                if( (value == null) || (!value.equals(getCapacityCategoryCode())) ) {
                    setCapacityCategoryCode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WorkCenterInterval") ) {
                final Object value = (values).remove("to_WorkCenterInterval");
                if( value instanceof Iterable ) {
                    if( toWorkCenterInterval == null ) {
                        toWorkCenterInterval = Lists.newArrayList();
                    } else {
                        toWorkCenterInterval = Lists.newArrayList(toWorkCenterInterval);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterCapacityInterval entity;
                        if( toWorkCenterInterval.size() > i ) {
                            entity = toWorkCenterInterval.get(i);
                        } else {
                            entity = new WorkCenterCapacityInterval();
                            toWorkCenterInterval.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_WorkCenterQueuingOp") ) {
                final Object value = (values).remove("to_WorkCenterQueuingOp");
                if( value instanceof Iterable ) {
                    if( toWorkCenterQueuingOp == null ) {
                        toWorkCenterQueuingOp = Lists.newArrayList();
                    } else {
                        toWorkCenterQueuingOp = Lists.newArrayList(toWorkCenterQueuingOp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterCapPplineOp entity;
                        if( toWorkCenterQueuingOp.size() > i ) {
                            entity = toWorkCenterQueuingOp.get(i);
                        } else {
                            entity = new WorkCenterCapPplineOp();
                            toWorkCenterQueuingOp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_WorkCenterTodayOp") ) {
                final Object value = (values).remove("to_WorkCenterTodayOp");
                if( value instanceof Iterable ) {
                    if( toWorkCenterTodayOp == null ) {
                        toWorkCenterTodayOp = Lists.newArrayList();
                    } else {
                        toWorkCenterTodayOp = Lists.newArrayList(toWorkCenterTodayOp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterCapDayOp entity;
                        if( toWorkCenterTodayOp.size() > i ) {
                            entity = toWorkCenterTodayOp.get(i);
                        } else {
                            entity = new WorkCenterCapDayOp();
                            toWorkCenterTodayOp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WorkCenterAllCapacityField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkCenterAllCapacityField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCenterAllCapacityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCenterAllCapacityField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWorkCenterInterval != null ) {
            (values).put("to_WorkCenterInterval", toWorkCenterInterval);
        }
        if( toWorkCenterQueuingOp != null ) {
            (values).put("to_WorkCenterQueuingOp", toWorkCenterQueuingOp);
        }
        if( toWorkCenterTodayOp != null ) {
            (values).put("to_WorkCenterTodayOp", toWorkCenterTodayOp);
        }
        return values;
    }

    /**
     * Fetches the <b>WorkCenterCapacityInterval</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_WorkCenterInterval</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterCapacityInterval</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapacityInterval> fetchWorkCenterInterval()
    {
        return fetchFieldAsList("to_WorkCenterInterval", WorkCenterCapacityInterval.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacityInterval</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterInterval</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterInterval</b> of a queried <b>WorkCenterAllCapacity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapacityInterval</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapacityInterval> getWorkCenterIntervalOrFetch()
    {
        if( toWorkCenterInterval == null ) {
            toWorkCenterInterval = fetchWorkCenterInterval();
        }
        return toWorkCenterInterval;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacityInterval</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterInterval</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenterAllCapacity</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WorkCenterInterval</b> is already loaded, the result
     *         will contain the <b>WorkCenterCapacityInterval</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterCapacityInterval>> getWorkCenterIntervalIfPresent()
    {
        return Option.of(toWorkCenterInterval);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterCapacityInterval</b> entities for the loaded navigation property
     * <b>to_WorkCenterInterval</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterInterval</b> of a queried <b>WorkCenterAllCapacity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterCapacityInterval</b> entities.
     */
    public void setWorkCenterInterval( @Nonnull final List<WorkCenterCapacityInterval> value )
    {
        if( toWorkCenterInterval == null ) {
            toWorkCenterInterval = Lists.newArrayList();
        }
        toWorkCenterInterval.clear();
        toWorkCenterInterval.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterCapacityInterval</b> entities. This corresponds to the OData
     * navigation property <b>to_WorkCenterInterval</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterInterval</b> of a queried <b>WorkCenterAllCapacity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterCapacityInterval</b> entities.
     */
    public void addWorkCenterInterval( WorkCenterCapacityInterval... entity )
    {
        if( toWorkCenterInterval == null ) {
            toWorkCenterInterval = Lists.newArrayList();
        }
        toWorkCenterInterval.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WorkCenterCapPplineOp</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterCapPplineOp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapPplineOp> fetchWorkCenterQueuingOp()
    {
        return fetchFieldAsList("to_WorkCenterQueuingOp", WorkCenterCapPplineOp.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapPplineOp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterQueuingOp</b> of a queried <b>WorkCenterAllCapacity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapPplineOp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapPplineOp> getWorkCenterQueuingOpOrFetch()
    {
        if( toWorkCenterQueuingOp == null ) {
            toWorkCenterQueuingOp = fetchWorkCenterQueuingOp();
        }
        return toWorkCenterQueuingOp;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapPplineOp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenterAllCapacity</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WorkCenterQueuingOp</b> is already loaded, the result
     *         will contain the <b>WorkCenterCapPplineOp</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterCapPplineOp>> getWorkCenterQueuingOpIfPresent()
    {
        return Option.of(toWorkCenterQueuingOp);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterCapPplineOp</b> entities for the loaded navigation property
     * <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterQueuingOp</b> of a queried <b>WorkCenterAllCapacity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterCapPplineOp</b> entities.
     */
    public void setWorkCenterQueuingOp( @Nonnull final List<WorkCenterCapPplineOp> value )
    {
        if( toWorkCenterQueuingOp == null ) {
            toWorkCenterQueuingOp = Lists.newArrayList();
        }
        toWorkCenterQueuingOp.clear();
        toWorkCenterQueuingOp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterCapPplineOp</b> entities. This corresponds to the OData
     * navigation property <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterQueuingOp</b> of a queried <b>WorkCenterAllCapacity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterCapPplineOp</b> entities.
     */
    public void addWorkCenterQueuingOp( WorkCenterCapPplineOp... entity )
    {
        if( toWorkCenterQueuingOp == null ) {
            toWorkCenterQueuingOp = Lists.newArrayList();
        }
        toWorkCenterQueuingOp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WorkCenterCapDayOp</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_WorkCenterTodayOp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterCapDayOp</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapDayOp> fetchWorkCenterTodayOp()
    {
        return fetchFieldAsList("to_WorkCenterTodayOp", WorkCenterCapDayOp.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapDayOp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterTodayOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterTodayOp</b> of a queried <b>WorkCenterAllCapacity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapDayOp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapDayOp> getWorkCenterTodayOpOrFetch()
    {
        if( toWorkCenterTodayOp == null ) {
            toWorkCenterTodayOp = fetchWorkCenterTodayOp();
        }
        return toWorkCenterTodayOp;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapDayOp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterTodayOp</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenterAllCapacity</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WorkCenterTodayOp</b> is already loaded, the result will
     *         contain the <b>WorkCenterCapDayOp</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterCapDayOp>> getWorkCenterTodayOpIfPresent()
    {
        return Option.of(toWorkCenterTodayOp);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterCapDayOp</b> entities for the loaded navigation property
     * <b>to_WorkCenterTodayOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterTodayOp</b> of a queried <b>WorkCenterAllCapacity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterCapDayOp</b> entities.
     */
    public void setWorkCenterTodayOp( @Nonnull final List<WorkCenterCapDayOp> value )
    {
        if( toWorkCenterTodayOp == null ) {
            toWorkCenterTodayOp = Lists.newArrayList();
        }
        toWorkCenterTodayOp.clear();
        toWorkCenterTodayOp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterCapDayOp</b> entities. This corresponds to the OData
     * navigation property <b>to_WorkCenterTodayOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterTodayOp</b> of a queried <b>WorkCenterAllCapacity</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterCapDayOp</b> entities.
     */
    public void addWorkCenterTodayOp( WorkCenterCapDayOp... entity )
    {
        if( toWorkCenterTodayOp == null ) {
            toWorkCenterTodayOp = Lists.newArrayList();
        }
        toWorkCenterTodayOp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WorkCenterAllCapacity instances.
     *
     */
    public final static class WorkCenterAllCapacityBuilder
    {

        private List<WorkCenterCapacityInterval> toWorkCenterInterval = Lists.newArrayList();
        private List<WorkCenterCapPplineOp> toWorkCenterQueuingOp = Lists.newArrayList();
        private List<WorkCenterCapDayOp> toWorkCenterTodayOp = Lists.newArrayList();

        private WorkCenterAllCapacity.WorkCenterAllCapacityBuilder toWorkCenterInterval(
            final List<WorkCenterCapacityInterval> value )
        {
            toWorkCenterInterval.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WorkCenterInterval</b> for <b>WorkCenterAllCapacity</b> to multiple
         * <b>WorkCenterCapacityInterval</b>.
         *
         * @param value
         *            The WorkCenterCapacityIntervals to build this WorkCenterAllCapacity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenterAllCapacity.WorkCenterAllCapacityBuilder workCenterInterval(
            WorkCenterCapacityInterval... value )
        {
            return toWorkCenterInterval(Lists.newArrayList(value));
        }

        private WorkCenterAllCapacity.WorkCenterAllCapacityBuilder toWorkCenterQueuingOp(
            final List<WorkCenterCapPplineOp> value )
        {
            toWorkCenterQueuingOp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WorkCenterQueuingOp</b> for <b>WorkCenterAllCapacity</b> to multiple
         * <b>WorkCenterCapPplineOp</b>.
         *
         * @param value
         *            The WorkCenterCapPplineOps to build this WorkCenterAllCapacity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenterAllCapacity.WorkCenterAllCapacityBuilder workCenterQueuingOp( WorkCenterCapPplineOp... value )
        {
            return toWorkCenterQueuingOp(Lists.newArrayList(value));
        }

        private WorkCenterAllCapacity.WorkCenterAllCapacityBuilder toWorkCenterTodayOp(
            final List<WorkCenterCapDayOp> value )
        {
            toWorkCenterTodayOp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WorkCenterTodayOp</b> for <b>WorkCenterAllCapacity</b> to multiple
         * <b>WorkCenterCapDayOp</b>.
         *
         * @param value
         *            The WorkCenterCapDayOps to build this WorkCenterAllCapacity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenterAllCapacity.WorkCenterAllCapacityBuilder workCenterTodayOp( WorkCenterCapDayOp... value )
        {
            return toWorkCenterTodayOp(Lists.newArrayList(value));
        }

    }

}
