/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterAllCapacity_2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterAllCapacity_2Link;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterAllCapacity_2OneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterAllCapacity_2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Capacity Assignment Version 2
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCenterAllCapacity_2Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenterAllCapacity_2 extends VdmEntity<WorkCenterAllCapacity_2>
{

    /**
     * Selector for all available fields of WorkCenterAllCapacity_2.
     *
     */
    public final static WorkCenterAllCapacity_2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the resource
     */
    @Key
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacity_2Field<String> WORK_CENTER_INTERNAL_ID =
        new WorkCenterAllCapacity_2Field<String>("WorkCenterInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @Key
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacity_2Field<String> WORK_CENTER_TYPE_CODE =
        new WorkCenterAllCapacity_2Field<String>("WorkCenterTypeCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryAllocation</b>
     * </p>
     *
     * @return Capacity Category Allocation
     */
    @Key
    @SerializedName( "CapacityCategoryAllocation" )
    @JsonProperty( "CapacityCategoryAllocation" )
    @Nullable
    @ODataField( odataName = "CapacityCategoryAllocation" )
    private String capacityCategoryAllocation;
    /**
     * Use with available fluent helpers to apply the <b>CapacityCategoryAllocation</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacity_2Field<String> CAPACITY_CATEGORY_ALLOCATION =
        new WorkCenterAllCapacity_2Field<String>("CapacityCategoryAllocation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacity_2Field<String> PLANT = new WorkCenterAllCapacity_2Field<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCategoryCode</b>
     * </p>
     *
     * @return Work Center Category
     */
    @SerializedName( "WorkCenterCategoryCode" )
    @JsonProperty( "WorkCenterCategoryCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterCategoryCode" )
    private String workCenterCategoryCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterCategoryCode</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacity_2Field<String> WORK_CENTER_CATEGORY_CODE =
        new WorkCenterAllCapacity_2Field<String>("WorkCenterCategoryCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacity_2Field<String> WORK_CENTER =
        new WorkCenterAllCapacity_2Field<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @return Capacity ID
     */
    @SerializedName( "CapacityInternalID" )
    @JsonProperty( "CapacityInternalID" )
    @Nullable
    @ODataField( odataName = "CapacityInternalID" )
    private String capacityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CapacityInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacity_2Field<String> CAPACITY_INTERNAL_ID =
        new WorkCenterAllCapacity_2Field<String>("CapacityInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SetupCapRequirementFormula</b>
     * </p>
     *
     * @return Formula for Setup Capacity Requirements
     */
    @SerializedName( "SetupCapRequirementFormula" )
    @JsonProperty( "SetupCapRequirementFormula" )
    @Nullable
    @ODataField( odataName = "SetupCapRequirementFormula" )
    private String setupCapRequirementFormula;
    /**
     * Use with available fluent helpers to apply the <b>SetupCapRequirementFormula</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacity_2Field<String> SETUP_CAP_REQUIREMENT_FORMULA =
        new WorkCenterAllCapacity_2Field<String>("SetupCapRequirementFormula");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProcgCapRequirementFormula</b>
     * </p>
     *
     * @return Formula for Processing Capacity Requirements
     */
    @SerializedName( "ProcgCapRequirementFormula" )
    @JsonProperty( "ProcgCapRequirementFormula" )
    @Nullable
    @ODataField( odataName = "ProcgCapRequirementFormula" )
    private String procgCapRequirementFormula;
    /**
     * Use with available fluent helpers to apply the <b>ProcgCapRequirementFormula</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacity_2Field<String> PROCG_CAP_REQUIREMENT_FORMULA =
        new WorkCenterAllCapacity_2Field<String>("ProcgCapRequirementFormula");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TeardownCapRequirementFormula</b>
     * </p>
     *
     * @return Formula for Teardown Capacity Requirements
     */
    @SerializedName( "TeardownCapRequirementFormula" )
    @JsonProperty( "TeardownCapRequirementFormula" )
    @Nullable
    @ODataField( odataName = "TeardownCapRequirementFormula" )
    private String teardownCapRequirementFormula;
    /**
     * Use with available fluent helpers to apply the <b>TeardownCapRequirementFormula</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacity_2Field<String> TEARDOWN_CAP_REQUIREMENT_FORMULA =
        new WorkCenterAllCapacity_2Field<String>("TeardownCapRequirementFormula");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OtherCapRequirementFormula</b>
     * </p>
     *
     * @return Formula for Other Capacity Requirements
     */
    @SerializedName( "OtherCapRequirementFormula" )
    @JsonProperty( "OtherCapRequirementFormula" )
    @Nullable
    @ODataField( odataName = "OtherCapRequirementFormula" )
    private String otherCapRequirementFormula;
    /**
     * Use with available fluent helpers to apply the <b>OtherCapRequirementFormula</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacity_2Field<String> OTHER_CAP_REQUIREMENT_FORMULA =
        new WorkCenterAllCapacity_2Field<String>("OtherCapRequirementFormula");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterLastChangeDateTime</b>
     * </p>
     *
     * @return Date and Time of Last Change
     */
    @SerializedName( "WorkCenterLastChangeDateTime" )
    @JsonProperty( "WorkCenterLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "WorkCenterLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime workCenterLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterLastChangeDateTime</b> field to query operations.
     *
     */
    public final static WorkCenterAllCapacity_2Field<ZonedDateTime> WORK_CENTER_LAST_CHANGE_DATE_TIME =
        new WorkCenterAllCapacity_2Field<ZonedDateTime>("WorkCenterLastChangeDateTime");
    /**
     * Navigation property <b>to_Capacity</b> for <b>WorkCenterAllCapacity_2</b> to single <b>WorkCenterCapacity</b>.
     *
     */
    @SerializedName( "to_Capacity" )
    @JsonProperty( "to_Capacity" )
    @ODataField( odataName = "to_Capacity" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WorkCenterCapacity toCapacity;
    /**
     * Navigation property <b>to_WorkCenterQueuingOp</b> for <b>WorkCenterAllCapacity_2</b> to multiple
     * <b>WorkCenterCapPplineOp</b>.
     *
     */
    @SerializedName( "to_WorkCenterQueuingOp" )
    @JsonProperty( "to_WorkCenterQueuingOp" )
    @ODataField( odataName = "to_WorkCenterQueuingOp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterCapPplineOp> toWorkCenterQueuingOp;
    /**
     * Navigation property <b>to_WorkCenterTodayOp</b> for <b>WorkCenterAllCapacity_2</b> to multiple
     * <b>WorkCenterCapDayOp</b>.
     *
     */
    @SerializedName( "to_WorkCenterTodayOp" )
    @JsonProperty( "to_WorkCenterTodayOp" )
    @ODataField( odataName = "to_WorkCenterTodayOp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterCapDayOp> toWorkCenterTodayOp;
    /**
     * Use with available fluent helpers to apply the <b>to_Capacity</b> navigation property to query operations.
     *
     */
    public final static WorkCenterAllCapacity_2OneToOneLink<WorkCenterCapacity> TO_CAPACITY =
        new WorkCenterAllCapacity_2OneToOneLink<WorkCenterCapacity>("to_Capacity");
    /**
     * Use with available fluent helpers to apply the <b>to_WorkCenterQueuingOp</b> navigation property to query
     * operations.
     *
     */
    public final static WorkCenterAllCapacity_2Link<WorkCenterCapPplineOp> TO_WORK_CENTER_QUEUING_OP =
        new WorkCenterAllCapacity_2Link<WorkCenterCapPplineOp>("to_WorkCenterQueuingOp");
    /**
     * Use with available fluent helpers to apply the <b>to_WorkCenterTodayOp</b> navigation property to query
     * operations.
     *
     */
    public final static WorkCenterAllCapacity_2Link<WorkCenterCapDayOp> TO_WORK_CENTER_TODAY_OP =
        new WorkCenterAllCapacity_2Link<WorkCenterCapDayOp>("to_WorkCenterTodayOp");

    @Nonnull
    @Override
    public Class<WorkCenterAllCapacity_2> getType()
    {
        return WorkCenterAllCapacity_2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID of the resource
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryAllocation</b>
     * </p>
     *
     * @param capacityCategoryAllocation
     *            Capacity Category Allocation
     */
    public void setCapacityCategoryAllocation( @Nullable final String capacityCategoryAllocation )
    {
        rememberChangedField("CapacityCategoryAllocation", this.capacityCategoryAllocation);
        this.capacityCategoryAllocation = capacityCategoryAllocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCategoryCode</b>
     * </p>
     *
     * @param workCenterCategoryCode
     *            Work Center Category
     */
    public void setWorkCenterCategoryCode( @Nullable final String workCenterCategoryCode )
    {
        rememberChangedField("WorkCenterCategoryCode", this.workCenterCategoryCode);
        this.workCenterCategoryCode = workCenterCategoryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @param capacityInternalID
     *            Capacity ID
     */
    public void setCapacityInternalID( @Nullable final String capacityInternalID )
    {
        rememberChangedField("CapacityInternalID", this.capacityInternalID);
        this.capacityInternalID = capacityInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SetupCapRequirementFormula</b>
     * </p>
     *
     * @param setupCapRequirementFormula
     *            Formula for Setup Capacity Requirements
     */
    public void setSetupCapRequirementFormula( @Nullable final String setupCapRequirementFormula )
    {
        rememberChangedField("SetupCapRequirementFormula", this.setupCapRequirementFormula);
        this.setupCapRequirementFormula = setupCapRequirementFormula;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ProcgCapRequirementFormula</b>
     * </p>
     *
     * @param procgCapRequirementFormula
     *            Formula for Processing Capacity Requirements
     */
    public void setProcgCapRequirementFormula( @Nullable final String procgCapRequirementFormula )
    {
        rememberChangedField("ProcgCapRequirementFormula", this.procgCapRequirementFormula);
        this.procgCapRequirementFormula = procgCapRequirementFormula;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TeardownCapRequirementFormula</b>
     * </p>
     *
     * @param teardownCapRequirementFormula
     *            Formula for Teardown Capacity Requirements
     */
    public void setTeardownCapRequirementFormula( @Nullable final String teardownCapRequirementFormula )
    {
        rememberChangedField("TeardownCapRequirementFormula", this.teardownCapRequirementFormula);
        this.teardownCapRequirementFormula = teardownCapRequirementFormula;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OtherCapRequirementFormula</b>
     * </p>
     *
     * @param otherCapRequirementFormula
     *            Formula for Other Capacity Requirements
     */
    public void setOtherCapRequirementFormula( @Nullable final String otherCapRequirementFormula )
    {
        rememberChangedField("OtherCapRequirementFormula", this.otherCapRequirementFormula);
        this.otherCapRequirementFormula = otherCapRequirementFormula;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterLastChangeDateTime</b>
     * </p>
     *
     * @param workCenterLastChangeDateTime
     *            Date and Time of Last Change
     */
    public void setWorkCenterLastChangeDateTime( @Nullable final ZonedDateTime workCenterLastChangeDateTime )
    {
        rememberChangedField("WorkCenterLastChangeDateTime", this.workCenterLastChangeDateTime);
        this.workCenterLastChangeDateTime = workCenterLastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenterAllCapacity_2";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WorkCenterInternalID", getWorkCenterInternalID());
        result.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        result.put("CapacityCategoryAllocation", getCapacityCategoryAllocation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("CapacityCategoryAllocation", getCapacityCategoryAllocation());
        values.put("Plant", getPlant());
        values.put("WorkCenterCategoryCode", getWorkCenterCategoryCode());
        values.put("WorkCenter", getWorkCenter());
        values.put("CapacityInternalID", getCapacityInternalID());
        values.put("SetupCapRequirementFormula", getSetupCapRequirementFormula());
        values.put("ProcgCapRequirementFormula", getProcgCapRequirementFormula());
        values.put("TeardownCapRequirementFormula", getTeardownCapRequirementFormula());
        values.put("OtherCapRequirementFormula", getOtherCapRequirementFormula());
        values.put("WorkCenterLastChangeDateTime", getWorkCenterLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("CapacityCategoryAllocation") ) {
                final Object value = values.remove("CapacityCategoryAllocation");
                if( (value == null) || (!value.equals(getCapacityCategoryAllocation())) ) {
                    setCapacityCategoryAllocation(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("WorkCenterCategoryCode") ) {
                final Object value = values.remove("WorkCenterCategoryCode");
                if( (value == null) || (!value.equals(getWorkCenterCategoryCode())) ) {
                    setWorkCenterCategoryCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("CapacityInternalID") ) {
                final Object value = values.remove("CapacityInternalID");
                if( (value == null) || (!value.equals(getCapacityInternalID())) ) {
                    setCapacityInternalID(((String) value));
                }
            }
            if( values.containsKey("SetupCapRequirementFormula") ) {
                final Object value = values.remove("SetupCapRequirementFormula");
                if( (value == null) || (!value.equals(getSetupCapRequirementFormula())) ) {
                    setSetupCapRequirementFormula(((String) value));
                }
            }
            if( values.containsKey("ProcgCapRequirementFormula") ) {
                final Object value = values.remove("ProcgCapRequirementFormula");
                if( (value == null) || (!value.equals(getProcgCapRequirementFormula())) ) {
                    setProcgCapRequirementFormula(((String) value));
                }
            }
            if( values.containsKey("TeardownCapRequirementFormula") ) {
                final Object value = values.remove("TeardownCapRequirementFormula");
                if( (value == null) || (!value.equals(getTeardownCapRequirementFormula())) ) {
                    setTeardownCapRequirementFormula(((String) value));
                }
            }
            if( values.containsKey("OtherCapRequirementFormula") ) {
                final Object value = values.remove("OtherCapRequirementFormula");
                if( (value == null) || (!value.equals(getOtherCapRequirementFormula())) ) {
                    setOtherCapRequirementFormula(((String) value));
                }
            }
            if( values.containsKey("WorkCenterLastChangeDateTime") ) {
                final Object value = values.remove("WorkCenterLastChangeDateTime");
                if( (value == null) || (!value.equals(getWorkCenterLastChangeDateTime())) ) {
                    setWorkCenterLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Capacity") ) {
                final Object value = (values).remove("to_Capacity");
                if( value instanceof Map ) {
                    if( toCapacity == null ) {
                        toCapacity = new WorkCenterCapacity();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCapacity.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_WorkCenterQueuingOp") ) {
                final Object value = (values).remove("to_WorkCenterQueuingOp");
                if( value instanceof Iterable ) {
                    if( toWorkCenterQueuingOp == null ) {
                        toWorkCenterQueuingOp = Lists.newArrayList();
                    } else {
                        toWorkCenterQueuingOp = Lists.newArrayList(toWorkCenterQueuingOp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterCapPplineOp entity;
                        if( toWorkCenterQueuingOp.size() > i ) {
                            entity = toWorkCenterQueuingOp.get(i);
                        } else {
                            entity = new WorkCenterCapPplineOp();
                            toWorkCenterQueuingOp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_WorkCenterTodayOp") ) {
                final Object value = (values).remove("to_WorkCenterTodayOp");
                if( value instanceof Iterable ) {
                    if( toWorkCenterTodayOp == null ) {
                        toWorkCenterTodayOp = Lists.newArrayList();
                    } else {
                        toWorkCenterTodayOp = Lists.newArrayList(toWorkCenterTodayOp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterCapDayOp entity;
                        if( toWorkCenterTodayOp.size() > i ) {
                            entity = toWorkCenterTodayOp.get(i);
                        } else {
                            entity = new WorkCenterCapDayOp();
                            toWorkCenterTodayOp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WorkCenterAllCapacity_2Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkCenterAllCapacity_2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCenterAllCapacity_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCenterAllCapacity_2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCapacity != null ) {
            (values).put("to_Capacity", toCapacity);
        }
        if( toWorkCenterQueuingOp != null ) {
            (values).put("to_WorkCenterQueuingOp", toWorkCenterQueuingOp);
        }
        if( toWorkCenterTodayOp != null ) {
            (values).put("to_WorkCenterTodayOp", toWorkCenterTodayOp);
        }
        return values;
    }

    /**
     * Fetches the <b>WorkCenterCapacity</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Capacity</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WorkCenterCapacity</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WorkCenterCapacity fetchCapacity()
    {
        return fetchFieldAsSingle("to_Capacity", WorkCenterCapacity.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacity</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Capacity</b>.
     * <p>
     * If the navigation property <b>to_Capacity</b> of a queried <b>WorkCenterAllCapacity_2</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapacity</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WorkCenterCapacity getCapacityOrFetch()
    {
        if( toCapacity == null ) {
            toCapacity = fetchCapacity();
        }
        return toCapacity;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacity</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Capacity</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenterAllCapacity_2</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Capacity</b> is already loaded, the result will contain
     *         the <b>WorkCenterCapacity</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<WorkCenterCapacity> getCapacityIfPresent()
    {
        return Option.of(toCapacity);
    }

    /**
     * Overwrites the associated <b>WorkCenterCapacity</b> entity for the loaded navigation property <b>to_Capacity</b>.
     *
     * @param value
     *            New <b>WorkCenterCapacity</b> entity.
     */
    public void setCapacity( final WorkCenterCapacity value )
    {
        toCapacity = value;
    }

    /**
     * Fetches the <b>WorkCenterCapPplineOp</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterCapPplineOp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapPplineOp> fetchWorkCenterQueuingOp()
    {
        return fetchFieldAsList("to_WorkCenterQueuingOp", WorkCenterCapPplineOp.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapPplineOp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterQueuingOp</b> of a queried <b>WorkCenterAllCapacity_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapPplineOp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapPplineOp> getWorkCenterQueuingOpOrFetch()
    {
        if( toWorkCenterQueuingOp == null ) {
            toWorkCenterQueuingOp = fetchWorkCenterQueuingOp();
        }
        return toWorkCenterQueuingOp;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapPplineOp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenterAllCapacity_2</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WorkCenterQueuingOp</b> is already loaded, the result
     *         will contain the <b>WorkCenterCapPplineOp</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterCapPplineOp>> getWorkCenterQueuingOpIfPresent()
    {
        return Option.of(toWorkCenterQueuingOp);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterCapPplineOp</b> entities for the loaded navigation property
     * <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterQueuingOp</b> of a queried <b>WorkCenterAllCapacity_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterCapPplineOp</b> entities.
     */
    public void setWorkCenterQueuingOp( @Nonnull final List<WorkCenterCapPplineOp> value )
    {
        if( toWorkCenterQueuingOp == null ) {
            toWorkCenterQueuingOp = Lists.newArrayList();
        }
        toWorkCenterQueuingOp.clear();
        toWorkCenterQueuingOp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterCapPplineOp</b> entities. This corresponds to the OData
     * navigation property <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterQueuingOp</b> of a queried <b>WorkCenterAllCapacity_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterCapPplineOp</b> entities.
     */
    public void addWorkCenterQueuingOp( WorkCenterCapPplineOp... entity )
    {
        if( toWorkCenterQueuingOp == null ) {
            toWorkCenterQueuingOp = Lists.newArrayList();
        }
        toWorkCenterQueuingOp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WorkCenterCapDayOp</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_WorkCenterTodayOp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterCapDayOp</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapDayOp> fetchWorkCenterTodayOp()
    {
        return fetchFieldAsList("to_WorkCenterTodayOp", WorkCenterCapDayOp.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapDayOp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterTodayOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterTodayOp</b> of a queried <b>WorkCenterAllCapacity_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapDayOp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapDayOp> getWorkCenterTodayOpOrFetch()
    {
        if( toWorkCenterTodayOp == null ) {
            toWorkCenterTodayOp = fetchWorkCenterTodayOp();
        }
        return toWorkCenterTodayOp;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapDayOp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterTodayOp</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenterAllCapacity_2</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WorkCenterTodayOp</b> is already loaded, the result will
     *         contain the <b>WorkCenterCapDayOp</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterCapDayOp>> getWorkCenterTodayOpIfPresent()
    {
        return Option.of(toWorkCenterTodayOp);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterCapDayOp</b> entities for the loaded navigation property
     * <b>to_WorkCenterTodayOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterTodayOp</b> of a queried <b>WorkCenterAllCapacity_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterCapDayOp</b> entities.
     */
    public void setWorkCenterTodayOp( @Nonnull final List<WorkCenterCapDayOp> value )
    {
        if( toWorkCenterTodayOp == null ) {
            toWorkCenterTodayOp = Lists.newArrayList();
        }
        toWorkCenterTodayOp.clear();
        toWorkCenterTodayOp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterCapDayOp</b> entities. This corresponds to the OData
     * navigation property <b>to_WorkCenterTodayOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterTodayOp</b> of a queried <b>WorkCenterAllCapacity_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterCapDayOp</b> entities.
     */
    public void addWorkCenterTodayOp( WorkCenterCapDayOp... entity )
    {
        if( toWorkCenterTodayOp == null ) {
            toWorkCenterTodayOp = Lists.newArrayList();
        }
        toWorkCenterTodayOp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WorkCenterAllCapacity_2 instances.
     *
     */
    public final static class WorkCenterAllCapacity_2Builder
    {

        private WorkCenterCapacity toCapacity;
        private List<WorkCenterCapPplineOp> toWorkCenterQueuingOp = Lists.newArrayList();
        private List<WorkCenterCapDayOp> toWorkCenterTodayOp = Lists.newArrayList();

        private WorkCenterAllCapacity_2.WorkCenterAllCapacity_2Builder toCapacity( final WorkCenterCapacity value )
        {
            toCapacity = value;
            return this;
        }

        /**
         * Navigation property <b>to_Capacity</b> for <b>WorkCenterAllCapacity_2</b> to single
         * <b>WorkCenterCapacity</b>.
         *
         * @param value
         *            The WorkCenterCapacity to build this WorkCenterAllCapacity_2 with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenterAllCapacity_2.WorkCenterAllCapacity_2Builder capacity( final WorkCenterCapacity value )
        {
            return toCapacity(value);
        }

        private WorkCenterAllCapacity_2.WorkCenterAllCapacity_2Builder toWorkCenterQueuingOp(
            final List<WorkCenterCapPplineOp> value )
        {
            toWorkCenterQueuingOp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WorkCenterQueuingOp</b> for <b>WorkCenterAllCapacity_2</b> to multiple
         * <b>WorkCenterCapPplineOp</b>.
         *
         * @param value
         *            The WorkCenterCapPplineOps to build this WorkCenterAllCapacity_2 with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenterAllCapacity_2.WorkCenterAllCapacity_2Builder workCenterQueuingOp(
            WorkCenterCapPplineOp... value )
        {
            return toWorkCenterQueuingOp(Lists.newArrayList(value));
        }

        private WorkCenterAllCapacity_2.WorkCenterAllCapacity_2Builder toWorkCenterTodayOp(
            final List<WorkCenterCapDayOp> value )
        {
            toWorkCenterTodayOp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WorkCenterTodayOp</b> for <b>WorkCenterAllCapacity_2</b> to multiple
         * <b>WorkCenterCapDayOp</b>.
         *
         * @param value
         *            The WorkCenterCapDayOps to build this WorkCenterAllCapacity_2 with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenterAllCapacity_2.WorkCenterAllCapacity_2Builder workCenterTodayOp( WorkCenterCapDayOp... value )
        {
            return toWorkCenterTodayOp(Lists.newArrayList(value));
        }

    }

}
