/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterAllCapacity_2Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
 * WorkCenterAllCapacity_2} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class WorkCenterAllCapacity_2ByKeyFluentHelper
    extends
    FluentHelperByKey<WorkCenterAllCapacity_2ByKeyFluentHelper, WorkCenterAllCapacity_2, WorkCenterAllCapacity_2Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     * WorkCenterAllCapacity_2} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WorkCenterAllCapacity_2}
     * @param capacityCategoryAllocation
     *            Capacity Category Allocation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code WorkCenterAllCapacity_2}
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param workCenterInternalID
     *            Object ID of the resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public WorkCenterAllCapacity_2ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String capacityCategoryAllocation )
    {
        super(servicePath, entityCollection);
        this.key.put("WorkCenterInternalID", workCenterInternalID);
        this.key.put("WorkCenterTypeCode", workCenterTypeCode);
        this.key.put("CapacityCategoryAllocation", capacityCategoryAllocation);
    }

    @Override
    @Nonnull
    protected Class<WorkCenterAllCapacity_2> getEntityClass()
    {
        return WorkCenterAllCapacity_2.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
