/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapDayOpField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapDayOpSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Daily Operations Capacity
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCenterCapDayOpType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenterCapDayOp extends VdmEntity<WorkCenterCapDayOp>
{

    /**
     * Selector for all available fields of WorkCenterCapDayOp.
     *
     */
    public final static WorkCenterCapDayOpSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> PLANT = new WorkCenterCapDayOpField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @return MRP Controller for Order
     */
    @Key
    @SerializedName( "MRPController" )
    @JsonProperty( "MRPController" )
    @Nullable
    @ODataField( odataName = "MRPController" )
    private String mRPController;
    /**
     * Use with available fluent helpers to apply the <b>MRPController</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> MRP_CONTROLLER =
        new WorkCenterCapDayOpField<String>("MRPController");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @Key
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> WORK_CENTER = new WorkCenterCapDayOpField<String>("WorkCenter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @return Capacity ID
     */
    @Key
    @SerializedName( "CapacityInternalID" )
    @JsonProperty( "CapacityInternalID" )
    @Nullable
    @ODataField( odataName = "CapacityInternalID" )
    private String capacityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CapacityInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> CAPACITY_INTERNAL_ID =
        new WorkCenterCapDayOpField<String>("CapacityInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirement</b>
     * </p>
     *
     * @return ID of the Capacity Requirements Record
     */
    @Key
    @SerializedName( "CapacityRequirement" )
    @JsonProperty( "CapacityRequirement" )
    @Nullable
    @ODataField( odataName = "CapacityRequirement" )
    private String capacityRequirement;
    /**
     * Use with available fluent helpers to apply the <b>CapacityRequirement</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> CAPACITY_REQUIREMENT =
        new WorkCenterCapDayOpField<String>("CapacityRequirement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number for Order
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> MATERIAL = new WorkCenterCapDayOpField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return The orderID contained in this entity.
     */
    @Key
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> ORDER_ID = new WorkCenterCapDayOpField<String>("OrderID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @return Operation/Activity Number
     */
    @Key
    @SerializedName( "Operation" )
    @JsonProperty( "Operation" )
    @Nullable
    @ODataField( odataName = "Operation" )
    private String operation;
    /**
     * Use with available fluent helpers to apply the <b>Operation</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> OPERATION = new WorkCenterCapDayOpField<String>("Operation");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterDesc</b>
     * </p>
     *
     * @return Work Center Text
     */
    @SerializedName( "WorkCenterDesc" )
    @JsonProperty( "WorkCenterDesc" )
    @Nullable
    @ODataField( odataName = "WorkCenterDesc" )
    private String workCenterDesc;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterDesc</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> WORK_CENTER_DESC =
        new WorkCenterCapDayOpField<String>("WorkCenterDesc");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsible</b>
     * </p>
     *
     * @return Person Responsible for the Work Center
     */
    @SerializedName( "WorkCenterResponsible" )
    @JsonProperty( "WorkCenterResponsible" )
    @Nullable
    @ODataField( odataName = "WorkCenterResponsible" )
    private String workCenterResponsible;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterResponsible</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> WORK_CENTER_RESPONSIBLE =
        new WorkCenterCapDayOpField<String>("WorkCenterResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCategoryCode</b>
     * </p>
     *
     * @return Work Center Category
     */
    @SerializedName( "WorkCenterCategoryCode" )
    @JsonProperty( "WorkCenterCategoryCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterCategoryCode" )
    private String workCenterCategoryCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterCategoryCode</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> WORK_CENTER_CATEGORY_CODE =
        new WorkCenterCapDayOpField<String>("WorkCenterCategoryCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the resource
     */
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> WORK_CENTER_INTERNAL_ID =
        new WorkCenterCapDayOpField<String>("WorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementOrigin</b>
     * </p>
     *
     * @return Capacity Requirement Origin
     */
    @SerializedName( "CapacityRequirementOrigin" )
    @JsonProperty( "CapacityRequirementOrigin" )
    @Nullable
    @ODataField( odataName = "CapacityRequirementOrigin" )
    private String capacityRequirementOrigin;
    /**
     * Use with available fluent helpers to apply the <b>CapacityRequirementOrigin</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> CAPACITY_REQUIREMENT_ORIGIN =
        new WorkCenterCapDayOpField<String>("CapacityRequirementOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementUnit</b>
     * </p>
     *
     * @return Unit of Measure for Capacity Requirements
     */
    @SerializedName( "CapacityRequirementUnit" )
    @JsonProperty( "CapacityRequirementUnit" )
    @Nullable
    @ODataField( odataName = "CapacityRequirementUnit" )
    private String capacityRequirementUnit;
    /**
     * Use with available fluent helpers to apply the <b>CapacityRequirementUnit</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> CAPACITY_REQUIREMENT_UNIT =
        new WorkCenterCapDayOpField<String>("CapacityRequirementUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @return Order Type
     */
    @SerializedName( "OrderType" )
    @JsonProperty( "OrderType" )
    @Nullable
    @ODataField( odataName = "OrderType" )
    private String orderType;
    /**
     * Use with available fluent helpers to apply the <b>OrderType</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> ORDER_TYPE = new WorkCenterCapDayOpField<String>("OrderType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OrderTypeName</b>
     * </p>
     *
     * @return Planned Order Type Name
     */
    @SerializedName( "OrderTypeName" )
    @JsonProperty( "OrderTypeName" )
    @Nullable
    @ODataField( odataName = "OrderTypeName" )
    private String orderTypeName;
    /**
     * Use with available fluent helpers to apply the <b>OrderTypeName</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> ORDER_TYPE_NAME =
        new WorkCenterCapDayOpField<String>("OrderTypeName");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPlannedTotalQty</b>
     * </p>
     *
     * @return Total Order Quantity
     */
    @SerializedName( "OrderPlannedTotalQty" )
    @JsonProperty( "OrderPlannedTotalQty" )
    @Nullable
    @ODataField( odataName = "OrderPlannedTotalQty" )
    private BigDecimal orderPlannedTotalQty;
    /**
     * Use with available fluent helpers to apply the <b>OrderPlannedTotalQty</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<BigDecimal> ORDER_PLANNED_TOTAL_QTY =
        new WorkCenterCapDayOpField<BigDecimal>("OrderPlannedTotalQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> BASE_UNIT = new WorkCenterCapDayOpField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @return Production Version
     */
    @SerializedName( "ProductionVersion" )
    @JsonProperty( "ProductionVersion" )
    @Nullable
    @ODataField( odataName = "ProductionVersion" )
    private String productionVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProductionVersion</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> PRODUCTION_VERSION =
        new WorkCenterCapDayOpField<String>("ProductionVersion");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OperationPlanningStatusText</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "OperationPlanningStatusText" )
    @JsonProperty( "OperationPlanningStatusText" )
    @Nullable
    @ODataField( odataName = "OperationPlanningStatusText" )
    private String operationPlanningStatusText;
    /**
     * Use with available fluent helpers to apply the <b>OperationPlanningStatusText</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> OPERATION_PLANNING_STATUS_TEXT =
        new WorkCenterCapDayOpField<String>("OperationPlanningStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationPlanningStatusCode</b>
     * </p>
     *
     * @return The operationPlanningStatusCode contained in this entity.
     */
    @SerializedName( "OperationPlanningStatusCode" )
    @JsonProperty( "OperationPlanningStatusCode" )
    @Nullable
    @ODataField( odataName = "OperationPlanningStatusCode" )
    private String operationPlanningStatusCode;
    /**
     * Use with available fluent helpers to apply the <b>OperationPlanningStatusCode</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> OPERATION_PLANNING_STATUS_CODE =
        new WorkCenterCapDayOpField<String>("OperationPlanningStatusCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestStartDate</b>
     * </p>
     *
     * @return Character field, 8 characters long
     */
    @SerializedName( "OperationLatestStartDate" )
    @JsonProperty( "OperationLatestStartDate" )
    @Nullable
    @ODataField( odataName = "OperationLatestStartDate" )
    private String operationLatestStartDate;
    /**
     * Use with available fluent helpers to apply the <b>OperationLatestStartDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> OPERATION_LATEST_START_DATE =
        new WorkCenterCapDayOpField<String>("OperationLatestStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestStartTime</b>
     * </p>
     *
     * @return Character field of length 6
     */
    @SerializedName( "OperationLatestStartTime" )
    @JsonProperty( "OperationLatestStartTime" )
    @Nullable
    @ODataField( odataName = "OperationLatestStartTime" )
    private String operationLatestStartTime;
    /**
     * Use with available fluent helpers to apply the <b>OperationLatestStartTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> OPERATION_LATEST_START_TIME =
        new WorkCenterCapDayOpField<String>("OperationLatestStartTime");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestEndDate</b>
     * </p>
     *
     * @return Character field, 8 characters long
     */
    @SerializedName( "OperationLatestEndDate" )
    @JsonProperty( "OperationLatestEndDate" )
    @Nullable
    @ODataField( odataName = "OperationLatestEndDate" )
    private String operationLatestEndDate;
    /**
     * Use with available fluent helpers to apply the <b>OperationLatestEndDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> OPERATION_LATEST_END_DATE =
        new WorkCenterCapDayOpField<String>("OperationLatestEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestEndTime</b>
     * </p>
     *
     * @return Character field of length 6
     */
    @SerializedName( "OperationLatestEndTime" )
    @JsonProperty( "OperationLatestEndTime" )
    @Nullable
    @ODataField( odataName = "OperationLatestEndTime" )
    private String operationLatestEndTime;
    /**
     * Use with available fluent helpers to apply the <b>OperationLatestEndTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> OPERATION_LATEST_END_TIME =
        new WorkCenterCapDayOpField<String>("OperationLatestEndTime");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>OrderStatusText</b>
     * </p>
     *
     * @return Individual Status of an Object
     */
    @SerializedName( "OrderStatusText" )
    @JsonProperty( "OrderStatusText" )
    @Nullable
    @ODataField( odataName = "OrderStatusText" )
    private String orderStatusText;
    /**
     * Use with available fluent helpers to apply the <b>OrderStatusText</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> ORDER_STATUS_TEXT =
        new WorkCenterCapDayOpField<String>("OrderStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OrderStatusCode</b>
     * </p>
     *
     * @return The orderStatusCode contained in this entity.
     */
    @SerializedName( "OrderStatusCode" )
    @JsonProperty( "OrderStatusCode" )
    @Nullable
    @ODataField( odataName = "OrderStatusCode" )
    private String orderStatusCode;
    /**
     * Use with available fluent helpers to apply the <b>OrderStatusCode</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> ORDER_STATUS_CODE =
        new WorkCenterCapDayOpField<String>("OrderStatusCode");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OrderFirmingStatusText</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "OrderFirmingStatusText" )
    @JsonProperty( "OrderFirmingStatusText" )
    @Nullable
    @ODataField( odataName = "OrderFirmingStatusText" )
    private String orderFirmingStatusText;
    /**
     * Use with available fluent helpers to apply the <b>OrderFirmingStatusText</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> ORDER_FIRMING_STATUS_TEXT =
        new WorkCenterCapDayOpField<String>("OrderFirmingStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldProcgStrtDte</b>
     * </p>
     *
     * @return Character field, 8 characters long
     */
    @SerializedName( "OpLtstSchedldProcgStrtDte" )
    @JsonProperty( "OpLtstSchedldProcgStrtDte" )
    @Nullable
    @ODataField( odataName = "OpLtstSchedldProcgStrtDte" )
    private String opLtstSchedldProcgStrtDte;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldProcgStrtDte</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> OP_LTST_SCHEDLD_PROCG_STRT_DTE =
        new WorkCenterCapDayOpField<String>("OpLtstSchedldProcgStrtDte");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldProcgStrtTme</b>
     * </p>
     *
     * @return Character field of length 6
     */
    @SerializedName( "OpLtstSchedldProcgStrtTme" )
    @JsonProperty( "OpLtstSchedldProcgStrtTme" )
    @Nullable
    @ODataField( odataName = "OpLtstSchedldProcgStrtTme" )
    private String opLtstSchedldProcgStrtTme;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldProcgStrtTme</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> OP_LTST_SCHEDLD_PROCG_STRT_TME =
        new WorkCenterCapDayOpField<String>("OpLtstSchedldProcgStrtTme");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldTrdwnStrtDte</b>
     * </p>
     *
     * @return Character field, 8 characters long
     */
    @SerializedName( "OpLtstSchedldTrdwnStrtDte" )
    @JsonProperty( "OpLtstSchedldTrdwnStrtDte" )
    @Nullable
    @ODataField( odataName = "OpLtstSchedldTrdwnStrtDte" )
    private String opLtstSchedldTrdwnStrtDte;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldTrdwnStrtDte</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> OP_LTST_SCHEDLD_TRDWN_STRT_DTE =
        new WorkCenterCapDayOpField<String>("OpLtstSchedldTrdwnStrtDte");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldTrdwnStrtTme</b>
     * </p>
     *
     * @return Character field of length 6
     */
    @SerializedName( "OpLtstSchedldTrdwnStrtTme" )
    @JsonProperty( "OpLtstSchedldTrdwnStrtTme" )
    @Nullable
    @ODataField( odataName = "OpLtstSchedldTrdwnStrtTme" )
    private String opLtstSchedldTrdwnStrtTme;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldTrdwnStrtTme</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> OP_LTST_SCHEDLD_TRDWN_STRT_TME =
        new WorkCenterCapDayOpField<String>("OpLtstSchedldTrdwnStrtTme");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegSetupDurn</b>
     * </p>
     *
     * @return The remainingCapReqOpSegSetupDurn contained in this entity.
     */
    @SerializedName( "RemainingCapReqOpSegSetupDurn" )
    @JsonProperty( "RemainingCapReqOpSegSetupDurn" )
    @Nullable
    @ODataField( odataName = "RemainingCapReqOpSegSetupDurn" )
    private BigDecimal remainingCapReqOpSegSetupDurn;
    /**
     * Use with available fluent helpers to apply the <b>RemainingCapReqOpSegSetupDurn</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<BigDecimal> REMAINING_CAP_REQ_OP_SEG_SETUP_DURN =
        new WorkCenterCapDayOpField<BigDecimal>("RemainingCapReqOpSegSetupDurn");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegProcgDurn</b>
     * </p>
     *
     * @return The remainingCapReqOpSegProcgDurn contained in this entity.
     */
    @SerializedName( "RemainingCapReqOpSegProcgDurn" )
    @JsonProperty( "RemainingCapReqOpSegProcgDurn" )
    @Nullable
    @ODataField( odataName = "RemainingCapReqOpSegProcgDurn" )
    private BigDecimal remainingCapReqOpSegProcgDurn;
    /**
     * Use with available fluent helpers to apply the <b>RemainingCapReqOpSegProcgDurn</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<BigDecimal> REMAINING_CAP_REQ_OP_SEG_PROCG_DURN =
        new WorkCenterCapDayOpField<BigDecimal>("RemainingCapReqOpSegProcgDurn");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegTrdwnDurn</b>
     * </p>
     *
     * @return The remainingCapReqOpSegTrdwnDurn contained in this entity.
     */
    @SerializedName( "RemainingCapReqOpSegTrdwnDurn" )
    @JsonProperty( "RemainingCapReqOpSegTrdwnDurn" )
    @Nullable
    @ODataField( odataName = "RemainingCapReqOpSegTrdwnDurn" )
    private BigDecimal remainingCapReqOpSegTrdwnDurn;
    /**
     * Use with available fluent helpers to apply the <b>RemainingCapReqOpSegTrdwnDurn</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<BigDecimal> REMAINING_CAP_REQ_OP_SEG_TRDWN_DURN =
        new WorkCenterCapDayOpField<BigDecimal>("RemainingCapReqOpSegTrdwnDurn");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementsAreDtmnd</b>
     * </p>
     *
     * @return The capacityRequirementsAreDtmnd contained in this entity.
     */
    @SerializedName( "CapacityRequirementsAreDtmnd" )
    @JsonProperty( "CapacityRequirementsAreDtmnd" )
    @Nullable
    @ODataField( odataName = "CapacityRequirementsAreDtmnd" )
    private BigDecimal capacityRequirementsAreDtmnd;
    /**
     * Use with available fluent helpers to apply the <b>CapacityRequirementsAreDtmnd</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<BigDecimal> CAPACITY_REQUIREMENTS_ARE_DTMND =
        new WorkCenterCapDayOpField<BigDecimal>("CapacityRequirementsAreDtmnd");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalID</b>
     * </p>
     *
     * @return Order Internal ID
     */
    @SerializedName( "OrderInternalID" )
    @JsonProperty( "OrderInternalID" )
    @Nullable
    @ODataField( odataName = "OrderInternalID" )
    private String orderInternalID;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapDayOpField<String> ORDER_INTERNAL_ID =
        new WorkCenterCapDayOpField<String>("OrderInternalID");

    @Nonnull
    @Override
    public Class<WorkCenterCapDayOp> getType()
    {
        return WorkCenterCapDayOp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @param mRPController
     *            MRP Controller for Order
     */
    public void setMRPController( @Nullable final String mRPController )
    {
        rememberChangedField("MRPController", this.mRPController);
        this.mRPController = mRPController;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @param capacityInternalID
     *            Capacity ID
     */
    public void setCapacityInternalID( @Nullable final String capacityInternalID )
    {
        rememberChangedField("CapacityInternalID", this.capacityInternalID);
        this.capacityInternalID = capacityInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirement</b>
     * </p>
     *
     * @param capacityRequirement
     *            ID of the Capacity Requirements Record
     */
    public void setCapacityRequirement( @Nullable final String capacityRequirement )
    {
        rememberChangedField("CapacityRequirement", this.capacityRequirement);
        this.capacityRequirement = capacityRequirement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number for Order
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            The orderID to set.
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @param operation
     *            Operation/Activity Number
     */
    public void setOperation( @Nullable final String operation )
    {
        rememberChangedField("Operation", this.operation);
        this.operation = operation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterDesc</b>
     * </p>
     *
     * @param workCenterDesc
     *            Work Center Text
     */
    public void setWorkCenterDesc( @Nullable final String workCenterDesc )
    {
        rememberChangedField("WorkCenterDesc", this.workCenterDesc);
        this.workCenterDesc = workCenterDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsible</b>
     * </p>
     *
     * @param workCenterResponsible
     *            Person Responsible for the Work Center
     */
    public void setWorkCenterResponsible( @Nullable final String workCenterResponsible )
    {
        rememberChangedField("WorkCenterResponsible", this.workCenterResponsible);
        this.workCenterResponsible = workCenterResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCategoryCode</b>
     * </p>
     *
     * @param workCenterCategoryCode
     *            Work Center Category
     */
    public void setWorkCenterCategoryCode( @Nullable final String workCenterCategoryCode )
    {
        rememberChangedField("WorkCenterCategoryCode", this.workCenterCategoryCode);
        this.workCenterCategoryCode = workCenterCategoryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID of the resource
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementOrigin</b>
     * </p>
     *
     * @param capacityRequirementOrigin
     *            Capacity Requirement Origin
     */
    public void setCapacityRequirementOrigin( @Nullable final String capacityRequirementOrigin )
    {
        rememberChangedField("CapacityRequirementOrigin", this.capacityRequirementOrigin);
        this.capacityRequirementOrigin = capacityRequirementOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementUnit</b>
     * </p>
     *
     * @param capacityRequirementUnit
     *            Unit of Measure for Capacity Requirements
     */
    public void setCapacityRequirementUnit( @Nullable final String capacityRequirementUnit )
    {
        rememberChangedField("CapacityRequirementUnit", this.capacityRequirementUnit);
        this.capacityRequirementUnit = capacityRequirementUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @param orderType
     *            Order Type
     */
    public void setOrderType( @Nullable final String orderType )
    {
        rememberChangedField("OrderType", this.orderType);
        this.orderType = orderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OrderTypeName</b>
     * </p>
     *
     * @param orderTypeName
     *            Planned Order Type Name
     */
    public void setOrderTypeName( @Nullable final String orderTypeName )
    {
        rememberChangedField("OrderTypeName", this.orderTypeName);
        this.orderTypeName = orderTypeName;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPlannedTotalQty</b>
     * </p>
     *
     * @param orderPlannedTotalQty
     *            Total Order Quantity
     */
    public void setOrderPlannedTotalQty( @Nullable final BigDecimal orderPlannedTotalQty )
    {
        rememberChangedField("OrderPlannedTotalQty", this.orderPlannedTotalQty);
        this.orderPlannedTotalQty = orderPlannedTotalQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @param productionVersion
     *            Production Version
     */
    public void setProductionVersion( @Nullable final String productionVersion )
    {
        rememberChangedField("ProductionVersion", this.productionVersion);
        this.productionVersion = productionVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OperationPlanningStatusText</b>
     * </p>
     *
     * @param operationPlanningStatusText
     *            Short Text for Fixed Values
     */
    public void setOperationPlanningStatusText( @Nullable final String operationPlanningStatusText )
    {
        rememberChangedField("OperationPlanningStatusText", this.operationPlanningStatusText);
        this.operationPlanningStatusText = operationPlanningStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationPlanningStatusCode</b>
     * </p>
     *
     * @param operationPlanningStatusCode
     *            The operationPlanningStatusCode to set.
     */
    public void setOperationPlanningStatusCode( @Nullable final String operationPlanningStatusCode )
    {
        rememberChangedField("OperationPlanningStatusCode", this.operationPlanningStatusCode);
        this.operationPlanningStatusCode = operationPlanningStatusCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestStartDate</b>
     * </p>
     *
     * @param operationLatestStartDate
     *            Character field, 8 characters long
     */
    public void setOperationLatestStartDate( @Nullable final String operationLatestStartDate )
    {
        rememberChangedField("OperationLatestStartDate", this.operationLatestStartDate);
        this.operationLatestStartDate = operationLatestStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestStartTime</b>
     * </p>
     *
     * @param operationLatestStartTime
     *            Character field of length 6
     */
    public void setOperationLatestStartTime( @Nullable final String operationLatestStartTime )
    {
        rememberChangedField("OperationLatestStartTime", this.operationLatestStartTime);
        this.operationLatestStartTime = operationLatestStartTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestEndDate</b>
     * </p>
     *
     * @param operationLatestEndDate
     *            Character field, 8 characters long
     */
    public void setOperationLatestEndDate( @Nullable final String operationLatestEndDate )
    {
        rememberChangedField("OperationLatestEndDate", this.operationLatestEndDate);
        this.operationLatestEndDate = operationLatestEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestEndTime</b>
     * </p>
     *
     * @param operationLatestEndTime
     *            Character field of length 6
     */
    public void setOperationLatestEndTime( @Nullable final String operationLatestEndTime )
    {
        rememberChangedField("OperationLatestEndTime", this.operationLatestEndTime);
        this.operationLatestEndTime = operationLatestEndTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>OrderStatusText</b>
     * </p>
     *
     * @param orderStatusText
     *            Individual Status of an Object
     */
    public void setOrderStatusText( @Nullable final String orderStatusText )
    {
        rememberChangedField("OrderStatusText", this.orderStatusText);
        this.orderStatusText = orderStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OrderStatusCode</b>
     * </p>
     *
     * @param orderStatusCode
     *            The orderStatusCode to set.
     */
    public void setOrderStatusCode( @Nullable final String orderStatusCode )
    {
        rememberChangedField("OrderStatusCode", this.orderStatusCode);
        this.orderStatusCode = orderStatusCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OrderFirmingStatusText</b>
     * </p>
     *
     * @param orderFirmingStatusText
     *            Short Text for Fixed Values
     */
    public void setOrderFirmingStatusText( @Nullable final String orderFirmingStatusText )
    {
        rememberChangedField("OrderFirmingStatusText", this.orderFirmingStatusText);
        this.orderFirmingStatusText = orderFirmingStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldProcgStrtDte</b>
     * </p>
     *
     * @param opLtstSchedldProcgStrtDte
     *            Character field, 8 characters long
     */
    public void setOpLtstSchedldProcgStrtDte( @Nullable final String opLtstSchedldProcgStrtDte )
    {
        rememberChangedField("OpLtstSchedldProcgStrtDte", this.opLtstSchedldProcgStrtDte);
        this.opLtstSchedldProcgStrtDte = opLtstSchedldProcgStrtDte;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldProcgStrtTme</b>
     * </p>
     *
     * @param opLtstSchedldProcgStrtTme
     *            Character field of length 6
     */
    public void setOpLtstSchedldProcgStrtTme( @Nullable final String opLtstSchedldProcgStrtTme )
    {
        rememberChangedField("OpLtstSchedldProcgStrtTme", this.opLtstSchedldProcgStrtTme);
        this.opLtstSchedldProcgStrtTme = opLtstSchedldProcgStrtTme;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldTrdwnStrtDte</b>
     * </p>
     *
     * @param opLtstSchedldTrdwnStrtDte
     *            Character field, 8 characters long
     */
    public void setOpLtstSchedldTrdwnStrtDte( @Nullable final String opLtstSchedldTrdwnStrtDte )
    {
        rememberChangedField("OpLtstSchedldTrdwnStrtDte", this.opLtstSchedldTrdwnStrtDte);
        this.opLtstSchedldTrdwnStrtDte = opLtstSchedldTrdwnStrtDte;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldTrdwnStrtTme</b>
     * </p>
     *
     * @param opLtstSchedldTrdwnStrtTme
     *            Character field of length 6
     */
    public void setOpLtstSchedldTrdwnStrtTme( @Nullable final String opLtstSchedldTrdwnStrtTme )
    {
        rememberChangedField("OpLtstSchedldTrdwnStrtTme", this.opLtstSchedldTrdwnStrtTme);
        this.opLtstSchedldTrdwnStrtTme = opLtstSchedldTrdwnStrtTme;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegSetupDurn</b>
     * </p>
     *
     * @param remainingCapReqOpSegSetupDurn
     *            The remainingCapReqOpSegSetupDurn to set.
     */
    public void setRemainingCapReqOpSegSetupDurn( @Nullable final BigDecimal remainingCapReqOpSegSetupDurn )
    {
        rememberChangedField("RemainingCapReqOpSegSetupDurn", this.remainingCapReqOpSegSetupDurn);
        this.remainingCapReqOpSegSetupDurn = remainingCapReqOpSegSetupDurn;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegProcgDurn</b>
     * </p>
     *
     * @param remainingCapReqOpSegProcgDurn
     *            The remainingCapReqOpSegProcgDurn to set.
     */
    public void setRemainingCapReqOpSegProcgDurn( @Nullable final BigDecimal remainingCapReqOpSegProcgDurn )
    {
        rememberChangedField("RemainingCapReqOpSegProcgDurn", this.remainingCapReqOpSegProcgDurn);
        this.remainingCapReqOpSegProcgDurn = remainingCapReqOpSegProcgDurn;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegTrdwnDurn</b>
     * </p>
     *
     * @param remainingCapReqOpSegTrdwnDurn
     *            The remainingCapReqOpSegTrdwnDurn to set.
     */
    public void setRemainingCapReqOpSegTrdwnDurn( @Nullable final BigDecimal remainingCapReqOpSegTrdwnDurn )
    {
        rememberChangedField("RemainingCapReqOpSegTrdwnDurn", this.remainingCapReqOpSegTrdwnDurn);
        this.remainingCapReqOpSegTrdwnDurn = remainingCapReqOpSegTrdwnDurn;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementsAreDtmnd</b>
     * </p>
     *
     * @param capacityRequirementsAreDtmnd
     *            The capacityRequirementsAreDtmnd to set.
     */
    public void setCapacityRequirementsAreDtmnd( @Nullable final BigDecimal capacityRequirementsAreDtmnd )
    {
        rememberChangedField("CapacityRequirementsAreDtmnd", this.capacityRequirementsAreDtmnd);
        this.capacityRequirementsAreDtmnd = capacityRequirementsAreDtmnd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalID</b>
     * </p>
     *
     * @param orderInternalID
     *            Order Internal ID
     */
    public void setOrderInternalID( @Nullable final String orderInternalID )
    {
        rememberChangedField("OrderInternalID", this.orderInternalID);
        this.orderInternalID = orderInternalID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenterCapDayOp";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Plant", getPlant());
        result.put("MRPController", getMRPController());
        result.put("WorkCenter", getWorkCenter());
        result.put("CapacityInternalID", getCapacityInternalID());
        result.put("CapacityRequirement", getCapacityRequirement());
        result.put("Material", getMaterial());
        result.put("OrderID", getOrderID());
        result.put("Operation", getOperation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Plant", getPlant());
        values.put("MRPController", getMRPController());
        values.put("WorkCenter", getWorkCenter());
        values.put("CapacityInternalID", getCapacityInternalID());
        values.put("CapacityRequirement", getCapacityRequirement());
        values.put("Material", getMaterial());
        values.put("OrderID", getOrderID());
        values.put("Operation", getOperation());
        values.put("WorkCenterDesc", getWorkCenterDesc());
        values.put("WorkCenterResponsible", getWorkCenterResponsible());
        values.put("WorkCenterCategoryCode", getWorkCenterCategoryCode());
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("CapacityRequirementOrigin", getCapacityRequirementOrigin());
        values.put("CapacityRequirementUnit", getCapacityRequirementUnit());
        values.put("OrderType", getOrderType());
        values.put("OrderTypeName", getOrderTypeName());
        values.put("OrderPlannedTotalQty", getOrderPlannedTotalQty());
        values.put("BaseUnit", getBaseUnit());
        values.put("ProductionVersion", getProductionVersion());
        values.put("OperationPlanningStatusText", getOperationPlanningStatusText());
        values.put("OperationPlanningStatusCode", getOperationPlanningStatusCode());
        values.put("OperationLatestStartDate", getOperationLatestStartDate());
        values.put("OperationLatestStartTime", getOperationLatestStartTime());
        values.put("OperationLatestEndDate", getOperationLatestEndDate());
        values.put("OperationLatestEndTime", getOperationLatestEndTime());
        values.put("OrderStatusText", getOrderStatusText());
        values.put("OrderStatusCode", getOrderStatusCode());
        values.put("OrderFirmingStatusText", getOrderFirmingStatusText());
        values.put("OpLtstSchedldProcgStrtDte", getOpLtstSchedldProcgStrtDte());
        values.put("OpLtstSchedldProcgStrtTme", getOpLtstSchedldProcgStrtTme());
        values.put("OpLtstSchedldTrdwnStrtDte", getOpLtstSchedldTrdwnStrtDte());
        values.put("OpLtstSchedldTrdwnStrtTme", getOpLtstSchedldTrdwnStrtTme());
        values.put("RemainingCapReqOpSegSetupDurn", getRemainingCapReqOpSegSetupDurn());
        values.put("RemainingCapReqOpSegProcgDurn", getRemainingCapReqOpSegProcgDurn());
        values.put("RemainingCapReqOpSegTrdwnDurn", getRemainingCapReqOpSegTrdwnDurn());
        values.put("CapacityRequirementsAreDtmnd", getCapacityRequirementsAreDtmnd());
        values.put("OrderInternalID", getOrderInternalID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MRPController") ) {
                final Object value = values.remove("MRPController");
                if( (value == null) || (!value.equals(getMRPController())) ) {
                    setMRPController(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("CapacityInternalID") ) {
                final Object value = values.remove("CapacityInternalID");
                if( (value == null) || (!value.equals(getCapacityInternalID())) ) {
                    setCapacityInternalID(((String) value));
                }
            }
            if( values.containsKey("CapacityRequirement") ) {
                final Object value = values.remove("CapacityRequirement");
                if( (value == null) || (!value.equals(getCapacityRequirement())) ) {
                    setCapacityRequirement(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("Operation") ) {
                final Object value = values.remove("Operation");
                if( (value == null) || (!value.equals(getOperation())) ) {
                    setOperation(((String) value));
                }
            }
            if( values.containsKey("WorkCenterDesc") ) {
                final Object value = values.remove("WorkCenterDesc");
                if( (value == null) || (!value.equals(getWorkCenterDesc())) ) {
                    setWorkCenterDesc(((String) value));
                }
            }
            if( values.containsKey("WorkCenterResponsible") ) {
                final Object value = values.remove("WorkCenterResponsible");
                if( (value == null) || (!value.equals(getWorkCenterResponsible())) ) {
                    setWorkCenterResponsible(((String) value));
                }
            }
            if( values.containsKey("WorkCenterCategoryCode") ) {
                final Object value = values.remove("WorkCenterCategoryCode");
                if( (value == null) || (!value.equals(getWorkCenterCategoryCode())) ) {
                    setWorkCenterCategoryCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("CapacityRequirementOrigin") ) {
                final Object value = values.remove("CapacityRequirementOrigin");
                if( (value == null) || (!value.equals(getCapacityRequirementOrigin())) ) {
                    setCapacityRequirementOrigin(((String) value));
                }
            }
            if( values.containsKey("CapacityRequirementUnit") ) {
                final Object value = values.remove("CapacityRequirementUnit");
                if( (value == null) || (!value.equals(getCapacityRequirementUnit())) ) {
                    setCapacityRequirementUnit(((String) value));
                }
            }
            if( values.containsKey("OrderType") ) {
                final Object value = values.remove("OrderType");
                if( (value == null) || (!value.equals(getOrderType())) ) {
                    setOrderType(((String) value));
                }
            }
            if( values.containsKey("OrderTypeName") ) {
                final Object value = values.remove("OrderTypeName");
                if( (value == null) || (!value.equals(getOrderTypeName())) ) {
                    setOrderTypeName(((String) value));
                }
            }
            if( values.containsKey("OrderPlannedTotalQty") ) {
                final Object value = values.remove("OrderPlannedTotalQty");
                if( (value == null) || (!value.equals(getOrderPlannedTotalQty())) ) {
                    setOrderPlannedTotalQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ProductionVersion") ) {
                final Object value = values.remove("ProductionVersion");
                if( (value == null) || (!value.equals(getProductionVersion())) ) {
                    setProductionVersion(((String) value));
                }
            }
            if( values.containsKey("OperationPlanningStatusText") ) {
                final Object value = values.remove("OperationPlanningStatusText");
                if( (value == null) || (!value.equals(getOperationPlanningStatusText())) ) {
                    setOperationPlanningStatusText(((String) value));
                }
            }
            if( values.containsKey("OperationPlanningStatusCode") ) {
                final Object value = values.remove("OperationPlanningStatusCode");
                if( (value == null) || (!value.equals(getOperationPlanningStatusCode())) ) {
                    setOperationPlanningStatusCode(((String) value));
                }
            }
            if( values.containsKey("OperationLatestStartDate") ) {
                final Object value = values.remove("OperationLatestStartDate");
                if( (value == null) || (!value.equals(getOperationLatestStartDate())) ) {
                    setOperationLatestStartDate(((String) value));
                }
            }
            if( values.containsKey("OperationLatestStartTime") ) {
                final Object value = values.remove("OperationLatestStartTime");
                if( (value == null) || (!value.equals(getOperationLatestStartTime())) ) {
                    setOperationLatestStartTime(((String) value));
                }
            }
            if( values.containsKey("OperationLatestEndDate") ) {
                final Object value = values.remove("OperationLatestEndDate");
                if( (value == null) || (!value.equals(getOperationLatestEndDate())) ) {
                    setOperationLatestEndDate(((String) value));
                }
            }
            if( values.containsKey("OperationLatestEndTime") ) {
                final Object value = values.remove("OperationLatestEndTime");
                if( (value == null) || (!value.equals(getOperationLatestEndTime())) ) {
                    setOperationLatestEndTime(((String) value));
                }
            }
            if( values.containsKey("OrderStatusText") ) {
                final Object value = values.remove("OrderStatusText");
                if( (value == null) || (!value.equals(getOrderStatusText())) ) {
                    setOrderStatusText(((String) value));
                }
            }
            if( values.containsKey("OrderStatusCode") ) {
                final Object value = values.remove("OrderStatusCode");
                if( (value == null) || (!value.equals(getOrderStatusCode())) ) {
                    setOrderStatusCode(((String) value));
                }
            }
            if( values.containsKey("OrderFirmingStatusText") ) {
                final Object value = values.remove("OrderFirmingStatusText");
                if( (value == null) || (!value.equals(getOrderFirmingStatusText())) ) {
                    setOrderFirmingStatusText(((String) value));
                }
            }
            if( values.containsKey("OpLtstSchedldProcgStrtDte") ) {
                final Object value = values.remove("OpLtstSchedldProcgStrtDte");
                if( (value == null) || (!value.equals(getOpLtstSchedldProcgStrtDte())) ) {
                    setOpLtstSchedldProcgStrtDte(((String) value));
                }
            }
            if( values.containsKey("OpLtstSchedldProcgStrtTme") ) {
                final Object value = values.remove("OpLtstSchedldProcgStrtTme");
                if( (value == null) || (!value.equals(getOpLtstSchedldProcgStrtTme())) ) {
                    setOpLtstSchedldProcgStrtTme(((String) value));
                }
            }
            if( values.containsKey("OpLtstSchedldTrdwnStrtDte") ) {
                final Object value = values.remove("OpLtstSchedldTrdwnStrtDte");
                if( (value == null) || (!value.equals(getOpLtstSchedldTrdwnStrtDte())) ) {
                    setOpLtstSchedldTrdwnStrtDte(((String) value));
                }
            }
            if( values.containsKey("OpLtstSchedldTrdwnStrtTme") ) {
                final Object value = values.remove("OpLtstSchedldTrdwnStrtTme");
                if( (value == null) || (!value.equals(getOpLtstSchedldTrdwnStrtTme())) ) {
                    setOpLtstSchedldTrdwnStrtTme(((String) value));
                }
            }
            if( values.containsKey("RemainingCapReqOpSegSetupDurn") ) {
                final Object value = values.remove("RemainingCapReqOpSegSetupDurn");
                if( (value == null) || (!value.equals(getRemainingCapReqOpSegSetupDurn())) ) {
                    setRemainingCapReqOpSegSetupDurn(((BigDecimal) value));
                }
            }
            if( values.containsKey("RemainingCapReqOpSegProcgDurn") ) {
                final Object value = values.remove("RemainingCapReqOpSegProcgDurn");
                if( (value == null) || (!value.equals(getRemainingCapReqOpSegProcgDurn())) ) {
                    setRemainingCapReqOpSegProcgDurn(((BigDecimal) value));
                }
            }
            if( values.containsKey("RemainingCapReqOpSegTrdwnDurn") ) {
                final Object value = values.remove("RemainingCapReqOpSegTrdwnDurn");
                if( (value == null) || (!value.equals(getRemainingCapReqOpSegTrdwnDurn())) ) {
                    setRemainingCapReqOpSegTrdwnDurn(((BigDecimal) value));
                }
            }
            if( values.containsKey("CapacityRequirementsAreDtmnd") ) {
                final Object value = values.remove("CapacityRequirementsAreDtmnd");
                if( (value == null) || (!value.equals(getCapacityRequirementsAreDtmnd())) ) {
                    setCapacityRequirementsAreDtmnd(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderInternalID") ) {
                final Object value = values.remove("OrderInternalID");
                if( (value == null) || (!value.equals(getOrderInternalID())) ) {
                    setOrderInternalID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WorkCenterCapDayOpField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkCenterCapDayOpField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCenterCapDayOpField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCenterCapDayOpField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

}
