/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapDayOpSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp WorkCenterCapDayOp}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class WorkCenterCapDayOpByKeyFluentHelper
    extends
    FluentHelperByKey<WorkCenterCapDayOpByKeyFluentHelper, WorkCenterCapDayOp, WorkCenterCapDayOpSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp WorkCenterCapDayOp}
     * entity with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest}
     * method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WorkCenterCapDayOp}
     * @param capacityInternalID
     *            Capacity ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param capacityRequirement
     *            ID of the Capacity Requirements Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param material
     *            Material Number for Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param orderID
     *
     * @param servicePath
     *            Service path to be used to fetch a single {@code WorkCenterCapDayOp}
     * @param plant
     *            Plant
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param operation
     *            Operation/Activity Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param workCenter
     *            Work Center
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param mRPController
     *            MRP Controller for Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     */
    public WorkCenterCapDayOpByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String plant,
        final String mRPController,
        final String workCenter,
        final String capacityInternalID,
        final String capacityRequirement,
        final String material,
        final String orderID,
        final String operation )
    {
        super(servicePath, entityCollection);
        this.key.put("Plant", plant);
        this.key.put("MRPController", mRPController);
        this.key.put("WorkCenter", workCenter);
        this.key.put("CapacityInternalID", capacityInternalID);
        this.key.put("CapacityRequirement", capacityRequirement);
        this.key.put("Material", material);
        this.key.put("OrderID", orderID);
        this.key.put("Operation", operation);
    }

    @Override
    @Nonnull
    protected Class<WorkCenterCapDayOp> getEntityClass()
    {
        return WorkCenterCapDayOp.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
