/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapOrderPerBucketField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapOrderPerBucketOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapOrderPerBucketSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Operation Load Distribution
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCenterCapOrderPerBucketType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenterCapOrderPerBucket extends VdmEntity<WorkCenterCapOrderPerBucket>
{

    /**
     * Selector for all available fields of WorkCenterCapOrderPerBucket.
     *
     */
    public final static WorkCenterCapOrderPerBucketSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalStartDate</b>
     * </p>
     *
     * @return Date
     */
    @Key
    @SerializedName( "P_CapEvalStartDate" )
    @JsonProperty( "P_CapEvalStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "P_CapEvalStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime p_CapEvalStartDate;
    /**
     * Use with available fluent helpers to apply the <b>P_CapEvalStartDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<LocalDateTime> P_CAP_EVAL_START_DATE =
        new WorkCenterCapOrderPerBucketField<LocalDateTime>("P_CapEvalStartDate");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalEndDate</b>
     * </p>
     *
     * @return Date
     */
    @Key
    @SerializedName( "P_CapEvalEndDate" )
    @JsonProperty( "P_CapEvalEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "P_CapEvalEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime p_CapEvalEndDate;
    /**
     * Use with available fluent helpers to apply the <b>P_CapEvalEndDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<LocalDateTime> P_CAP_EVAL_END_DATE =
        new WorkCenterCapOrderPerBucketField<LocalDateTime>("P_CapEvalEndDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalBucketType</b>
     * </p>
     *
     * @return Single-Character Flag
     */
    @Key
    @SerializedName( "P_CapEvalBucketType" )
    @JsonProperty( "P_CapEvalBucketType" )
    @Nullable
    @ODataField( odataName = "P_CapEvalBucketType" )
    private String p_CapEvalBucketType;
    /**
     * Use with available fluent helpers to apply the <b>P_CapEvalBucketType</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> P_CAP_EVAL_BUCKET_TYPE =
        new WorkCenterCapOrderPerBucketField<String>("P_CapEvalBucketType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> PLANT =
        new WorkCenterCapOrderPerBucketField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @return MRP Controller for Order
     */
    @Key
    @SerializedName( "MRPController" )
    @JsonProperty( "MRPController" )
    @Nullable
    @ODataField( odataName = "MRPController" )
    private String mRPController;
    /**
     * Use with available fluent helpers to apply the <b>MRPController</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> MRP_CONTROLLER =
        new WorkCenterCapOrderPerBucketField<String>("MRPController");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @Key
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> WORK_CENTER =
        new WorkCenterCapOrderPerBucketField<String>("WorkCenter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @Key
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> WORK_CENTER_TYPE_CODE =
        new WorkCenterCapOrderPerBucketField<String>("WorkCenterTypeCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryAllocation</b>
     * </p>
     *
     * @return Capacity Category Allocation
     */
    @Key
    @SerializedName( "CapacityCategoryAllocation" )
    @JsonProperty( "CapacityCategoryAllocation" )
    @Nullable
    @ODataField( odataName = "CapacityCategoryAllocation" )
    private String capacityCategoryAllocation;
    /**
     * Use with available fluent helpers to apply the <b>CapacityCategoryAllocation</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> CAPACITY_CATEGORY_ALLOCATION =
        new WorkCenterCapOrderPerBucketField<String>("CapacityCategoryAllocation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @return Capacity ID
     */
    @Key
    @SerializedName( "CapacityInternalID" )
    @JsonProperty( "CapacityInternalID" )
    @Nullable
    @ODataField( odataName = "CapacityInternalID" )
    private String capacityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CapacityInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> CAPACITY_INTERNAL_ID =
        new WorkCenterCapOrderPerBucketField<String>("CapacityInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> MATERIAL =
        new WorkCenterCapOrderPerBucketField<String>("Material");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return The orderID contained in this entity.
     */
    @Key
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> ORDER_ID =
        new WorkCenterCapOrderPerBucketField<String>("OrderID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @return Operation/Activity Number
     */
    @Key
    @SerializedName( "Operation" )
    @JsonProperty( "Operation" )
    @Nullable
    @ODataField( odataName = "Operation" )
    private String operation;
    /**
     * Use with available fluent helpers to apply the <b>Operation</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> OPERATION =
        new WorkCenterCapOrderPerBucketField<String>("Operation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEvaluationTimePeriod</b>
     * </p>
     *
     * @return The capacityEvaluationTimePeriod contained in this entity.
     */
    @Key
    @SerializedName( "CapacityEvaluationTimePeriod" )
    @JsonProperty( "CapacityEvaluationTimePeriod" )
    @Nullable
    @ODataField( odataName = "CapacityEvaluationTimePeriod" )
    private String capacityEvaluationTimePeriod;
    /**
     * Use with available fluent helpers to apply the <b>CapacityEvaluationTimePeriod</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> CAPACITY_EVALUATION_TIME_PERIOD =
        new WorkCenterCapOrderPerBucketField<String>("CapacityEvaluationTimePeriod");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftName</b>
     * </p>
     *
     * @return Shift Definition
     */
    @Key
    @SerializedName( "ShiftName" )
    @JsonProperty( "ShiftName" )
    @Nullable
    @ODataField( odataName = "ShiftName" )
    private String shiftName;
    /**
     * Use with available fluent helpers to apply the <b>ShiftName</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> SHIFT_NAME =
        new WorkCenterCapOrderPerBucketField<String>("ShiftName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CapEvalBucketType</b>
     * </p>
     *
     * @return The capEvalBucketType contained in this entity.
     */
    @SerializedName( "CapEvalBucketType" )
    @JsonProperty( "CapEvalBucketType" )
    @Nullable
    @ODataField( odataName = "CapEvalBucketType" )
    private String capEvalBucketType;
    /**
     * Use with available fluent helpers to apply the <b>CapEvalBucketType</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> CAP_EVAL_BUCKET_TYPE =
        new WorkCenterCapOrderPerBucketField<String>("CapEvalBucketType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEvaluationTimePerdText</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "CapacityEvaluationTimePerdText" )
    @JsonProperty( "CapacityEvaluationTimePerdText" )
    @Nullable
    @ODataField( odataName = "CapacityEvaluationTimePerdText" )
    private String capacityEvaluationTimePerdText;
    /**
     * Use with available fluent helpers to apply the <b>CapacityEvaluationTimePerdText</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> CAPACITY_EVALUATION_TIME_PERD_TEXT =
        new WorkCenterCapOrderPerBucketField<String>("CapacityEvaluationTimePerdText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @return Factory Calendar ID
     */
    @SerializedName( "FactoryCalendar" )
    @JsonProperty( "FactoryCalendar" )
    @Nullable
    @ODataField( odataName = "FactoryCalendar" )
    private String factoryCalendar;
    /**
     * Use with available fluent helpers to apply the <b>FactoryCalendar</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> FACTORY_CALENDAR =
        new WorkCenterCapOrderPerBucketField<String>("FactoryCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterDesc</b>
     * </p>
     *
     * @return Work Center Text
     */
    @SerializedName( "WorkCenterDesc" )
    @JsonProperty( "WorkCenterDesc" )
    @Nullable
    @ODataField( odataName = "WorkCenterDesc" )
    private String workCenterDesc;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterDesc</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> WORK_CENTER_DESC =
        new WorkCenterCapOrderPerBucketField<String>("WorkCenterDesc");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsible</b>
     * </p>
     *
     * @return Person Responsible for the Work Center
     */
    @SerializedName( "WorkCenterResponsible" )
    @JsonProperty( "WorkCenterResponsible" )
    @Nullable
    @ODataField( odataName = "WorkCenterResponsible" )
    private String workCenterResponsible;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterResponsible</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> WORK_CENTER_RESPONSIBLE =
        new WorkCenterCapOrderPerBucketField<String>("WorkCenterResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCategoryCode</b>
     * </p>
     *
     * @return Work Center Category
     */
    @SerializedName( "WorkCenterCategoryCode" )
    @JsonProperty( "WorkCenterCategoryCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterCategoryCode" )
    private String workCenterCategoryCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterCategoryCode</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> WORK_CENTER_CATEGORY_CODE =
        new WorkCenterCapOrderPerBucketField<String>("WorkCenterCategoryCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the resource
     */
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> WORK_CENTER_INTERNAL_ID =
        new WorkCenterCapOrderPerBucketField<String>("WorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementOrigin</b>
     * </p>
     *
     * @return Capacity Requirement Origin
     */
    @SerializedName( "CapacityRequirementOrigin" )
    @JsonProperty( "CapacityRequirementOrigin" )
    @Nullable
    @ODataField( odataName = "CapacityRequirementOrigin" )
    private String capacityRequirementOrigin;
    /**
     * Use with available fluent helpers to apply the <b>CapacityRequirementOrigin</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> CAPACITY_REQUIREMENT_ORIGIN =
        new WorkCenterCapOrderPerBucketField<String>("CapacityRequirementOrigin");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementUnit</b>
     * </p>
     *
     * @return Unit of Measure for Capacity Requirements
     */
    @SerializedName( "CapacityRequirementUnit" )
    @JsonProperty( "CapacityRequirementUnit" )
    @Nullable
    @ODataField( odataName = "CapacityRequirementUnit" )
    private String capacityRequirementUnit;
    /**
     * Use with available fluent helpers to apply the <b>CapacityRequirementUnit</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> CAPACITY_REQUIREMENT_UNIT =
        new WorkCenterCapOrderPerBucketField<String>("CapacityRequirementUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @return Order Type
     */
    @SerializedName( "OrderType" )
    @JsonProperty( "OrderType" )
    @Nullable
    @ODataField( odataName = "OrderType" )
    private String orderType;
    /**
     * Use with available fluent helpers to apply the <b>OrderType</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> ORDER_TYPE =
        new WorkCenterCapOrderPerBucketField<String>("OrderType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OrderTypeName</b>
     * </p>
     *
     * @return Planned Order Type Name
     */
    @SerializedName( "OrderTypeName" )
    @JsonProperty( "OrderTypeName" )
    @Nullable
    @ODataField( odataName = "OrderTypeName" )
    private String orderTypeName;
    /**
     * Use with available fluent helpers to apply the <b>OrderTypeName</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> ORDER_TYPE_NAME =
        new WorkCenterCapOrderPerBucketField<String>("OrderTypeName");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPlannedTotalQty</b>
     * </p>
     *
     * @return Total Order Quantity
     */
    @SerializedName( "OrderPlannedTotalQty" )
    @JsonProperty( "OrderPlannedTotalQty" )
    @Nullable
    @ODataField( odataName = "OrderPlannedTotalQty" )
    private BigDecimal orderPlannedTotalQty;
    /**
     * Use with available fluent helpers to apply the <b>OrderPlannedTotalQty</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<BigDecimal> ORDER_PLANNED_TOTAL_QTY =
        new WorkCenterCapOrderPerBucketField<BigDecimal>("OrderPlannedTotalQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> BASE_UNIT =
        new WorkCenterCapOrderPerBucketField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderCategory</b>
     * </p>
     *
     * @return Order Category
     */
    @SerializedName( "OrderCategory" )
    @JsonProperty( "OrderCategory" )
    @Nullable
    @ODataField( odataName = "OrderCategory" )
    private String orderCategory;
    /**
     * Use with available fluent helpers to apply the <b>OrderCategory</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> ORDER_CATEGORY =
        new WorkCenterCapOrderPerBucketField<String>("OrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OrderCategoryName</b>
     * </p>
     *
     * @return Planned Order Category Name
     */
    @SerializedName( "OrderCategoryName" )
    @JsonProperty( "OrderCategoryName" )
    @Nullable
    @ODataField( odataName = "OrderCategoryName" )
    private String orderCategoryName;
    /**
     * Use with available fluent helpers to apply the <b>OrderCategoryName</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> ORDER_CATEGORY_NAME =
        new WorkCenterCapOrderPerBucketField<String>("OrderCategoryName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @return Production Version
     */
    @SerializedName( "ProductionVersion" )
    @JsonProperty( "ProductionVersion" )
    @Nullable
    @ODataField( odataName = "ProductionVersion" )
    private String productionVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProductionVersion</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> PRODUCTION_VERSION =
        new WorkCenterCapOrderPerBucketField<String>("ProductionVersion");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OperationPlanningStatusText</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "OperationPlanningStatusText" )
    @JsonProperty( "OperationPlanningStatusText" )
    @Nullable
    @ODataField( odataName = "OperationPlanningStatusText" )
    private String operationPlanningStatusText;
    /**
     * Use with available fluent helpers to apply the <b>OperationPlanningStatusText</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> OPERATION_PLANNING_STATUS_TEXT =
        new WorkCenterCapOrderPerBucketField<String>("OperationPlanningStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationPlanningStatusCode</b>
     * </p>
     *
     * @return The operationPlanningStatusCode contained in this entity.
     */
    @SerializedName( "OperationPlanningStatusCode" )
    @JsonProperty( "OperationPlanningStatusCode" )
    @Nullable
    @ODataField( odataName = "OperationPlanningStatusCode" )
    private String operationPlanningStatusCode;
    /**
     * Use with available fluent helpers to apply the <b>OperationPlanningStatusCode</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> OPERATION_PLANNING_STATUS_CODE =
        new WorkCenterCapOrderPerBucketField<String>("OperationPlanningStatusCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestStartDate</b>
     * </p>
     *
     * @return Character field, 8 characters long
     */
    @SerializedName( "OperationLatestStartDate" )
    @JsonProperty( "OperationLatestStartDate" )
    @Nullable
    @ODataField( odataName = "OperationLatestStartDate" )
    private String operationLatestStartDate;
    /**
     * Use with available fluent helpers to apply the <b>OperationLatestStartDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> OPERATION_LATEST_START_DATE =
        new WorkCenterCapOrderPerBucketField<String>("OperationLatestStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestStartTime</b>
     * </p>
     *
     * @return Character field of length 6
     */
    @SerializedName( "OperationLatestStartTime" )
    @JsonProperty( "OperationLatestStartTime" )
    @Nullable
    @ODataField( odataName = "OperationLatestStartTime" )
    private String operationLatestStartTime;
    /**
     * Use with available fluent helpers to apply the <b>OperationLatestStartTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> OPERATION_LATEST_START_TIME =
        new WorkCenterCapOrderPerBucketField<String>("OperationLatestStartTime");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestEndDate</b>
     * </p>
     *
     * @return Character field, 8 characters long
     */
    @SerializedName( "OperationLatestEndDate" )
    @JsonProperty( "OperationLatestEndDate" )
    @Nullable
    @ODataField( odataName = "OperationLatestEndDate" )
    private String operationLatestEndDate;
    /**
     * Use with available fluent helpers to apply the <b>OperationLatestEndDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> OPERATION_LATEST_END_DATE =
        new WorkCenterCapOrderPerBucketField<String>("OperationLatestEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestEndTime</b>
     * </p>
     *
     * @return Character field of length 6
     */
    @SerializedName( "OperationLatestEndTime" )
    @JsonProperty( "OperationLatestEndTime" )
    @Nullable
    @ODataField( odataName = "OperationLatestEndTime" )
    private String operationLatestEndTime;
    /**
     * Use with available fluent helpers to apply the <b>OperationLatestEndTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> OPERATION_LATEST_END_TIME =
        new WorkCenterCapOrderPerBucketField<String>("OperationLatestEndTime");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>OrderStatusText</b>
     * </p>
     *
     * @return Individual Status of an Object
     */
    @SerializedName( "OrderStatusText" )
    @JsonProperty( "OrderStatusText" )
    @Nullable
    @ODataField( odataName = "OrderStatusText" )
    private String orderStatusText;
    /**
     * Use with available fluent helpers to apply the <b>OrderStatusText</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> ORDER_STATUS_TEXT =
        new WorkCenterCapOrderPerBucketField<String>("OrderStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OrderStatusCode</b>
     * </p>
     *
     * @return The orderStatusCode contained in this entity.
     */
    @SerializedName( "OrderStatusCode" )
    @JsonProperty( "OrderStatusCode" )
    @Nullable
    @ODataField( odataName = "OrderStatusCode" )
    private String orderStatusCode;
    /**
     * Use with available fluent helpers to apply the <b>OrderStatusCode</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> ORDER_STATUS_CODE =
        new WorkCenterCapOrderPerBucketField<String>("OrderStatusCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderFirmingStatusCode</b>
     * </p>
     *
     * @return Single-Character Flag
     */
    @SerializedName( "OrderFirmingStatusCode" )
    @JsonProperty( "OrderFirmingStatusCode" )
    @Nullable
    @ODataField( odataName = "OrderFirmingStatusCode" )
    private String orderFirmingStatusCode;
    /**
     * Use with available fluent helpers to apply the <b>OrderFirmingStatusCode</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> ORDER_FIRMING_STATUS_CODE =
        new WorkCenterCapOrderPerBucketField<String>("OrderFirmingStatusCode");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OrderFirmingStatusText</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "OrderFirmingStatusText" )
    @JsonProperty( "OrderFirmingStatusText" )
    @Nullable
    @ODataField( odataName = "OrderFirmingStatusText" )
    private String orderFirmingStatusText;
    /**
     * Use with available fluent helpers to apply the <b>OrderFirmingStatusText</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> ORDER_FIRMING_STATUS_TEXT =
        new WorkCenterCapOrderPerBucketField<String>("OrderFirmingStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldProcgStrtDte</b>
     * </p>
     *
     * @return Character field, 8 characters long
     */
    @SerializedName( "OpLtstSchedldProcgStrtDte" )
    @JsonProperty( "OpLtstSchedldProcgStrtDte" )
    @Nullable
    @ODataField( odataName = "OpLtstSchedldProcgStrtDte" )
    private String opLtstSchedldProcgStrtDte;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldProcgStrtDte</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> OP_LTST_SCHEDLD_PROCG_STRT_DTE =
        new WorkCenterCapOrderPerBucketField<String>("OpLtstSchedldProcgStrtDte");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldProcgStrtTme</b>
     * </p>
     *
     * @return Character field of length 6
     */
    @SerializedName( "OpLtstSchedldProcgStrtTme" )
    @JsonProperty( "OpLtstSchedldProcgStrtTme" )
    @Nullable
    @ODataField( odataName = "OpLtstSchedldProcgStrtTme" )
    private String opLtstSchedldProcgStrtTme;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldProcgStrtTme</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> OP_LTST_SCHEDLD_PROCG_STRT_TME =
        new WorkCenterCapOrderPerBucketField<String>("OpLtstSchedldProcgStrtTme");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldTrdwnStrtDte</b>
     * </p>
     *
     * @return Character field, 8 characters long
     */
    @SerializedName( "OpLtstSchedldTrdwnStrtDte" )
    @JsonProperty( "OpLtstSchedldTrdwnStrtDte" )
    @Nullable
    @ODataField( odataName = "OpLtstSchedldTrdwnStrtDte" )
    private String opLtstSchedldTrdwnStrtDte;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldTrdwnStrtDte</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> OP_LTST_SCHEDLD_TRDWN_STRT_DTE =
        new WorkCenterCapOrderPerBucketField<String>("OpLtstSchedldTrdwnStrtDte");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldTrdwnStrtTme</b>
     * </p>
     *
     * @return Character field of length 6
     */
    @SerializedName( "OpLtstSchedldTrdwnStrtTme" )
    @JsonProperty( "OpLtstSchedldTrdwnStrtTme" )
    @Nullable
    @ODataField( odataName = "OpLtstSchedldTrdwnStrtTme" )
    private String opLtstSchedldTrdwnStrtTme;
    /**
     * Use with available fluent helpers to apply the <b>OpLtstSchedldTrdwnStrtTme</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> OP_LTST_SCHEDLD_TRDWN_STRT_TME =
        new WorkCenterCapOrderPerBucketField<String>("OpLtstSchedldTrdwnStrtTme");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegSetupDurn</b>
     * </p>
     *
     * @return The remainingCapReqOpSegSetupDurn contained in this entity.
     */
    @SerializedName( "RemainingCapReqOpSegSetupDurn" )
    @JsonProperty( "RemainingCapReqOpSegSetupDurn" )
    @Nullable
    @ODataField( odataName = "RemainingCapReqOpSegSetupDurn" )
    private BigDecimal remainingCapReqOpSegSetupDurn;
    /**
     * Use with available fluent helpers to apply the <b>RemainingCapReqOpSegSetupDurn</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<BigDecimal> REMAINING_CAP_REQ_OP_SEG_SETUP_DURN =
        new WorkCenterCapOrderPerBucketField<BigDecimal>("RemainingCapReqOpSegSetupDurn");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegProcgDurn</b>
     * </p>
     *
     * @return The remainingCapReqOpSegProcgDurn contained in this entity.
     */
    @SerializedName( "RemainingCapReqOpSegProcgDurn" )
    @JsonProperty( "RemainingCapReqOpSegProcgDurn" )
    @Nullable
    @ODataField( odataName = "RemainingCapReqOpSegProcgDurn" )
    private BigDecimal remainingCapReqOpSegProcgDurn;
    /**
     * Use with available fluent helpers to apply the <b>RemainingCapReqOpSegProcgDurn</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<BigDecimal> REMAINING_CAP_REQ_OP_SEG_PROCG_DURN =
        new WorkCenterCapOrderPerBucketField<BigDecimal>("RemainingCapReqOpSegProcgDurn");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegTrdwnDurn</b>
     * </p>
     *
     * @return The remainingCapReqOpSegTrdwnDurn contained in this entity.
     */
    @SerializedName( "RemainingCapReqOpSegTrdwnDurn" )
    @JsonProperty( "RemainingCapReqOpSegTrdwnDurn" )
    @Nullable
    @ODataField( odataName = "RemainingCapReqOpSegTrdwnDurn" )
    private BigDecimal remainingCapReqOpSegTrdwnDurn;
    /**
     * Use with available fluent helpers to apply the <b>RemainingCapReqOpSegTrdwnDurn</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<BigDecimal> REMAINING_CAP_REQ_OP_SEG_TRDWN_DURN =
        new WorkCenterCapOrderPerBucketField<BigDecimal>("RemainingCapReqOpSegTrdwnDurn");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalID</b>
     * </p>
     *
     * @return Order Internal ID
     */
    @SerializedName( "OrderInternalID" )
    @JsonProperty( "OrderInternalID" )
    @Nullable
    @ODataField( odataName = "OrderInternalID" )
    private String orderInternalID;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> ORDER_INTERNAL_ID =
        new WorkCenterCapOrderPerBucketField<String>("OrderInternalID");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityStartTime</b>
     * </p>
     *
     * @return The capacityStartTime contained in this entity.
     */
    @SerializedName( "CapacityStartTime" )
    @JsonProperty( "CapacityStartTime" )
    @Nullable
    @ODataField( odataName = "CapacityStartTime" )
    private BigDecimal capacityStartTime;
    /**
     * Use with available fluent helpers to apply the <b>CapacityStartTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<BigDecimal> CAPACITY_START_TIME =
        new WorkCenterCapOrderPerBucketField<BigDecimal>("CapacityStartTime");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEndTime</b>
     * </p>
     *
     * @return The capacityEndTime contained in this entity.
     */
    @SerializedName( "CapacityEndTime" )
    @JsonProperty( "CapacityEndTime" )
    @Nullable
    @ODataField( odataName = "CapacityEndTime" )
    private BigDecimal capacityEndTime;
    /**
     * Use with available fluent helpers to apply the <b>CapacityEndTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<BigDecimal> CAPACITY_END_TIME =
        new WorkCenterCapOrderPerBucketField<BigDecimal>("CapacityEndTime");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterAvailableCapacity</b>
     * </p>
     *
     * @return The workCenterAvailableCapacity contained in this entity.
     */
    @SerializedName( "WorkCenterAvailableCapacity" )
    @JsonProperty( "WorkCenterAvailableCapacity" )
    @Nullable
    @ODataField( odataName = "WorkCenterAvailableCapacity" )
    private BigDecimal workCenterAvailableCapacity;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterAvailableCapacity</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<BigDecimal> WORK_CENTER_AVAILABLE_CAPACITY =
        new WorkCenterCapOrderPerBucketField<BigDecimal>("WorkCenterAvailableCapacity");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCapRqmtInCapUnit</b>
     * </p>
     *
     * @return The workCenterCapRqmtInCapUnit contained in this entity.
     */
    @SerializedName( "WorkCenterCapRqmtInCapUnit" )
    @JsonProperty( "WorkCenterCapRqmtInCapUnit" )
    @Nullable
    @ODataField( odataName = "WorkCenterCapRqmtInCapUnit" )
    private BigDecimal workCenterCapRqmtInCapUnit;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterCapRqmtInCapUnit</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<BigDecimal> WORK_CENTER_CAP_RQMT_IN_CAP_UNIT =
        new WorkCenterCapOrderPerBucketField<BigDecimal>("WorkCenterCapRqmtInCapUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCapacityUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "WorkCenterCapacityUnit" )
    @JsonProperty( "WorkCenterCapacityUnit" )
    @Nullable
    @ODataField( odataName = "WorkCenterCapacityUnit" )
    private String workCenterCapacityUnit;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterCapacityUnit</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> WORK_CENTER_CAPACITY_UNIT =
        new WorkCenterCapOrderPerBucketField<String>("WorkCenterCapacityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCapUnitText</b>
     * </p>
     *
     * @return Unit of Measurement Text (Maximum 10 Characters)
     */
    @SerializedName( "WorkCenterCapUnitText" )
    @JsonProperty( "WorkCenterCapUnitText" )
    @Nullable
    @ODataField( odataName = "WorkCenterCapUnitText" )
    private String workCenterCapUnitText;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterCapUnitText</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketField<String> WORK_CENTER_CAP_UNIT_TEXT =
        new WorkCenterCapOrderPerBucketField<String>("WorkCenterCapUnitText");
    /**
     * Navigation property <b>Parameters</b> for <b>WorkCenterCapOrderPerBucket</b> to single
     * <b>WorkCenterCapOrderPerBucketParameters</b>.
     *
     */
    @SerializedName( "Parameters" )
    @JsonProperty( "Parameters" )
    @ODataField( odataName = "Parameters" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WorkCenterCapOrderPerBucketParameters toParameters;
    /**
     * Use with available fluent helpers to apply the <b>Parameters</b> navigation property to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketOneToOneLink<WorkCenterCapOrderPerBucketParameters> TO_PARAMETERS =
        new WorkCenterCapOrderPerBucketOneToOneLink<WorkCenterCapOrderPerBucketParameters>("Parameters");

    @Nonnull
    @Override
    public Class<WorkCenterCapOrderPerBucket> getType()
    {
        return WorkCenterCapOrderPerBucket.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalStartDate</b>
     * </p>
     *
     * @param p_CapEvalStartDate
     *            Date
     */
    public void setP_CapEvalStartDate( @Nullable final LocalDateTime p_CapEvalStartDate )
    {
        rememberChangedField("P_CapEvalStartDate", this.p_CapEvalStartDate);
        this.p_CapEvalStartDate = p_CapEvalStartDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalEndDate</b>
     * </p>
     *
     * @param p_CapEvalEndDate
     *            Date
     */
    public void setP_CapEvalEndDate( @Nullable final LocalDateTime p_CapEvalEndDate )
    {
        rememberChangedField("P_CapEvalEndDate", this.p_CapEvalEndDate);
        this.p_CapEvalEndDate = p_CapEvalEndDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalBucketType</b>
     * </p>
     *
     * @param p_CapEvalBucketType
     *            Single-Character Flag
     */
    public void setP_CapEvalBucketType( @Nullable final String p_CapEvalBucketType )
    {
        rememberChangedField("P_CapEvalBucketType", this.p_CapEvalBucketType);
        this.p_CapEvalBucketType = p_CapEvalBucketType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @param mRPController
     *            MRP Controller for Order
     */
    public void setMRPController( @Nullable final String mRPController )
    {
        rememberChangedField("MRPController", this.mRPController);
        this.mRPController = mRPController;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryAllocation</b>
     * </p>
     *
     * @param capacityCategoryAllocation
     *            Capacity Category Allocation
     */
    public void setCapacityCategoryAllocation( @Nullable final String capacityCategoryAllocation )
    {
        rememberChangedField("CapacityCategoryAllocation", this.capacityCategoryAllocation);
        this.capacityCategoryAllocation = capacityCategoryAllocation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @param capacityInternalID
     *            Capacity ID
     */
    public void setCapacityInternalID( @Nullable final String capacityInternalID )
    {
        rememberChangedField("CapacityInternalID", this.capacityInternalID);
        this.capacityInternalID = capacityInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            The orderID to set.
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Operation</b>
     * </p>
     *
     * @param operation
     *            Operation/Activity Number
     */
    public void setOperation( @Nullable final String operation )
    {
        rememberChangedField("Operation", this.operation);
        this.operation = operation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEvaluationTimePeriod</b>
     * </p>
     *
     * @param capacityEvaluationTimePeriod
     *            The capacityEvaluationTimePeriod to set.
     */
    public void setCapacityEvaluationTimePeriod( @Nullable final String capacityEvaluationTimePeriod )
    {
        rememberChangedField("CapacityEvaluationTimePeriod", this.capacityEvaluationTimePeriod);
        this.capacityEvaluationTimePeriod = capacityEvaluationTimePeriod;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftName</b>
     * </p>
     *
     * @param shiftName
     *            Shift Definition
     */
    public void setShiftName( @Nullable final String shiftName )
    {
        rememberChangedField("ShiftName", this.shiftName);
        this.shiftName = shiftName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CapEvalBucketType</b>
     * </p>
     *
     * @param capEvalBucketType
     *            The capEvalBucketType to set.
     */
    public void setCapEvalBucketType( @Nullable final String capEvalBucketType )
    {
        rememberChangedField("CapEvalBucketType", this.capEvalBucketType);
        this.capEvalBucketType = capEvalBucketType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEvaluationTimePerdText</b>
     * </p>
     *
     * @param capacityEvaluationTimePerdText
     *            Short Text for Fixed Values
     */
    public void setCapacityEvaluationTimePerdText( @Nullable final String capacityEvaluationTimePerdText )
    {
        rememberChangedField("CapacityEvaluationTimePerdText", this.capacityEvaluationTimePerdText);
        this.capacityEvaluationTimePerdText = capacityEvaluationTimePerdText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @param factoryCalendar
     *            Factory Calendar ID
     */
    public void setFactoryCalendar( @Nullable final String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterDesc</b>
     * </p>
     *
     * @param workCenterDesc
     *            Work Center Text
     */
    public void setWorkCenterDesc( @Nullable final String workCenterDesc )
    {
        rememberChangedField("WorkCenterDesc", this.workCenterDesc);
        this.workCenterDesc = workCenterDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsible</b>
     * </p>
     *
     * @param workCenterResponsible
     *            Person Responsible for the Work Center
     */
    public void setWorkCenterResponsible( @Nullable final String workCenterResponsible )
    {
        rememberChangedField("WorkCenterResponsible", this.workCenterResponsible);
        this.workCenterResponsible = workCenterResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCategoryCode</b>
     * </p>
     *
     * @param workCenterCategoryCode
     *            Work Center Category
     */
    public void setWorkCenterCategoryCode( @Nullable final String workCenterCategoryCode )
    {
        rememberChangedField("WorkCenterCategoryCode", this.workCenterCategoryCode);
        this.workCenterCategoryCode = workCenterCategoryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID of the resource
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementOrigin</b>
     * </p>
     *
     * @param capacityRequirementOrigin
     *            Capacity Requirement Origin
     */
    public void setCapacityRequirementOrigin( @Nullable final String capacityRequirementOrigin )
    {
        rememberChangedField("CapacityRequirementOrigin", this.capacityRequirementOrigin);
        this.capacityRequirementOrigin = capacityRequirementOrigin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityRequirementUnit</b>
     * </p>
     *
     * @param capacityRequirementUnit
     *            Unit of Measure for Capacity Requirements
     */
    public void setCapacityRequirementUnit( @Nullable final String capacityRequirementUnit )
    {
        rememberChangedField("CapacityRequirementUnit", this.capacityRequirementUnit);
        this.capacityRequirementUnit = capacityRequirementUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @param orderType
     *            Order Type
     */
    public void setOrderType( @Nullable final String orderType )
    {
        rememberChangedField("OrderType", this.orderType);
        this.orderType = orderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OrderTypeName</b>
     * </p>
     *
     * @param orderTypeName
     *            Planned Order Type Name
     */
    public void setOrderTypeName( @Nullable final String orderTypeName )
    {
        rememberChangedField("OrderTypeName", this.orderTypeName);
        this.orderTypeName = orderTypeName;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderPlannedTotalQty</b>
     * </p>
     *
     * @param orderPlannedTotalQty
     *            Total Order Quantity
     */
    public void setOrderPlannedTotalQty( @Nullable final BigDecimal orderPlannedTotalQty )
    {
        rememberChangedField("OrderPlannedTotalQty", this.orderPlannedTotalQty);
        this.orderPlannedTotalQty = orderPlannedTotalQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrderCategory</b>
     * </p>
     *
     * @param orderCategory
     *            Order Category
     */
    public void setOrderCategory( @Nullable final String orderCategory )
    {
        rememberChangedField("OrderCategory", this.orderCategory);
        this.orderCategory = orderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OrderCategoryName</b>
     * </p>
     *
     * @param orderCategoryName
     *            Planned Order Category Name
     */
    public void setOrderCategoryName( @Nullable final String orderCategoryName )
    {
        rememberChangedField("OrderCategoryName", this.orderCategoryName);
        this.orderCategoryName = orderCategoryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @param productionVersion
     *            Production Version
     */
    public void setProductionVersion( @Nullable final String productionVersion )
    {
        rememberChangedField("ProductionVersion", this.productionVersion);
        this.productionVersion = productionVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OperationPlanningStatusText</b>
     * </p>
     *
     * @param operationPlanningStatusText
     *            Short Text for Fixed Values
     */
    public void setOperationPlanningStatusText( @Nullable final String operationPlanningStatusText )
    {
        rememberChangedField("OperationPlanningStatusText", this.operationPlanningStatusText);
        this.operationPlanningStatusText = operationPlanningStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationPlanningStatusCode</b>
     * </p>
     *
     * @param operationPlanningStatusCode
     *            The operationPlanningStatusCode to set.
     */
    public void setOperationPlanningStatusCode( @Nullable final String operationPlanningStatusCode )
    {
        rememberChangedField("OperationPlanningStatusCode", this.operationPlanningStatusCode);
        this.operationPlanningStatusCode = operationPlanningStatusCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestStartDate</b>
     * </p>
     *
     * @param operationLatestStartDate
     *            Character field, 8 characters long
     */
    public void setOperationLatestStartDate( @Nullable final String operationLatestStartDate )
    {
        rememberChangedField("OperationLatestStartDate", this.operationLatestStartDate);
        this.operationLatestStartDate = operationLatestStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestStartTime</b>
     * </p>
     *
     * @param operationLatestStartTime
     *            Character field of length 6
     */
    public void setOperationLatestStartTime( @Nullable final String operationLatestStartTime )
    {
        rememberChangedField("OperationLatestStartTime", this.operationLatestStartTime);
        this.operationLatestStartTime = operationLatestStartTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestEndDate</b>
     * </p>
     *
     * @param operationLatestEndDate
     *            Character field, 8 characters long
     */
    public void setOperationLatestEndDate( @Nullable final String operationLatestEndDate )
    {
        rememberChangedField("OperationLatestEndDate", this.operationLatestEndDate);
        this.operationLatestEndDate = operationLatestEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OperationLatestEndTime</b>
     * </p>
     *
     * @param operationLatestEndTime
     *            Character field of length 6
     */
    public void setOperationLatestEndTime( @Nullable final String operationLatestEndTime )
    {
        rememberChangedField("OperationLatestEndTime", this.operationLatestEndTime);
        this.operationLatestEndTime = operationLatestEndTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>OrderStatusText</b>
     * </p>
     *
     * @param orderStatusText
     *            Individual Status of an Object
     */
    public void setOrderStatusText( @Nullable final String orderStatusText )
    {
        rememberChangedField("OrderStatusText", this.orderStatusText);
        this.orderStatusText = orderStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>OrderStatusCode</b>
     * </p>
     *
     * @param orderStatusCode
     *            The orderStatusCode to set.
     */
    public void setOrderStatusCode( @Nullable final String orderStatusCode )
    {
        rememberChangedField("OrderStatusCode", this.orderStatusCode);
        this.orderStatusCode = orderStatusCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderFirmingStatusCode</b>
     * </p>
     *
     * @param orderFirmingStatusCode
     *            Single-Character Flag
     */
    public void setOrderFirmingStatusCode( @Nullable final String orderFirmingStatusCode )
    {
        rememberChangedField("OrderFirmingStatusCode", this.orderFirmingStatusCode);
        this.orderFirmingStatusCode = orderFirmingStatusCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>OrderFirmingStatusText</b>
     * </p>
     *
     * @param orderFirmingStatusText
     *            Short Text for Fixed Values
     */
    public void setOrderFirmingStatusText( @Nullable final String orderFirmingStatusText )
    {
        rememberChangedField("OrderFirmingStatusText", this.orderFirmingStatusText);
        this.orderFirmingStatusText = orderFirmingStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldProcgStrtDte</b>
     * </p>
     *
     * @param opLtstSchedldProcgStrtDte
     *            Character field, 8 characters long
     */
    public void setOpLtstSchedldProcgStrtDte( @Nullable final String opLtstSchedldProcgStrtDte )
    {
        rememberChangedField("OpLtstSchedldProcgStrtDte", this.opLtstSchedldProcgStrtDte);
        this.opLtstSchedldProcgStrtDte = opLtstSchedldProcgStrtDte;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldProcgStrtTme</b>
     * </p>
     *
     * @param opLtstSchedldProcgStrtTme
     *            Character field of length 6
     */
    public void setOpLtstSchedldProcgStrtTme( @Nullable final String opLtstSchedldProcgStrtTme )
    {
        rememberChangedField("OpLtstSchedldProcgStrtTme", this.opLtstSchedldProcgStrtTme);
        this.opLtstSchedldProcgStrtTme = opLtstSchedldProcgStrtTme;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldTrdwnStrtDte</b>
     * </p>
     *
     * @param opLtstSchedldTrdwnStrtDte
     *            Character field, 8 characters long
     */
    public void setOpLtstSchedldTrdwnStrtDte( @Nullable final String opLtstSchedldTrdwnStrtDte )
    {
        rememberChangedField("OpLtstSchedldTrdwnStrtDte", this.opLtstSchedldTrdwnStrtDte);
        this.opLtstSchedldTrdwnStrtDte = opLtstSchedldTrdwnStrtDte;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OpLtstSchedldTrdwnStrtTme</b>
     * </p>
     *
     * @param opLtstSchedldTrdwnStrtTme
     *            Character field of length 6
     */
    public void setOpLtstSchedldTrdwnStrtTme( @Nullable final String opLtstSchedldTrdwnStrtTme )
    {
        rememberChangedField("OpLtstSchedldTrdwnStrtTme", this.opLtstSchedldTrdwnStrtTme);
        this.opLtstSchedldTrdwnStrtTme = opLtstSchedldTrdwnStrtTme;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegSetupDurn</b>
     * </p>
     *
     * @param remainingCapReqOpSegSetupDurn
     *            The remainingCapReqOpSegSetupDurn to set.
     */
    public void setRemainingCapReqOpSegSetupDurn( @Nullable final BigDecimal remainingCapReqOpSegSetupDurn )
    {
        rememberChangedField("RemainingCapReqOpSegSetupDurn", this.remainingCapReqOpSegSetupDurn);
        this.remainingCapReqOpSegSetupDurn = remainingCapReqOpSegSetupDurn;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegProcgDurn</b>
     * </p>
     *
     * @param remainingCapReqOpSegProcgDurn
     *            The remainingCapReqOpSegProcgDurn to set.
     */
    public void setRemainingCapReqOpSegProcgDurn( @Nullable final BigDecimal remainingCapReqOpSegProcgDurn )
    {
        rememberChangedField("RemainingCapReqOpSegProcgDurn", this.remainingCapReqOpSegProcgDurn);
        this.remainingCapReqOpSegProcgDurn = remainingCapReqOpSegProcgDurn;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>RemainingCapReqOpSegTrdwnDurn</b>
     * </p>
     *
     * @param remainingCapReqOpSegTrdwnDurn
     *            The remainingCapReqOpSegTrdwnDurn to set.
     */
    public void setRemainingCapReqOpSegTrdwnDurn( @Nullable final BigDecimal remainingCapReqOpSegTrdwnDurn )
    {
        rememberChangedField("RemainingCapReqOpSegTrdwnDurn", this.remainingCapReqOpSegTrdwnDurn);
        this.remainingCapReqOpSegTrdwnDurn = remainingCapReqOpSegTrdwnDurn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalID</b>
     * </p>
     *
     * @param orderInternalID
     *            Order Internal ID
     */
    public void setOrderInternalID( @Nullable final String orderInternalID )
    {
        rememberChangedField("OrderInternalID", this.orderInternalID);
        this.orderInternalID = orderInternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityStartTime</b>
     * </p>
     *
     * @param capacityStartTime
     *            The capacityStartTime to set.
     */
    public void setCapacityStartTime( @Nullable final BigDecimal capacityStartTime )
    {
        rememberChangedField("CapacityStartTime", this.capacityStartTime);
        this.capacityStartTime = capacityStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEndTime</b>
     * </p>
     *
     * @param capacityEndTime
     *            The capacityEndTime to set.
     */
    public void setCapacityEndTime( @Nullable final BigDecimal capacityEndTime )
    {
        rememberChangedField("CapacityEndTime", this.capacityEndTime);
        this.capacityEndTime = capacityEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterAvailableCapacity</b>
     * </p>
     *
     * @param workCenterAvailableCapacity
     *            The workCenterAvailableCapacity to set.
     */
    public void setWorkCenterAvailableCapacity( @Nullable final BigDecimal workCenterAvailableCapacity )
    {
        rememberChangedField("WorkCenterAvailableCapacity", this.workCenterAvailableCapacity);
        this.workCenterAvailableCapacity = workCenterAvailableCapacity;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCapRqmtInCapUnit</b>
     * </p>
     *
     * @param workCenterCapRqmtInCapUnit
     *            The workCenterCapRqmtInCapUnit to set.
     */
    public void setWorkCenterCapRqmtInCapUnit( @Nullable final BigDecimal workCenterCapRqmtInCapUnit )
    {
        rememberChangedField("WorkCenterCapRqmtInCapUnit", this.workCenterCapRqmtInCapUnit);
        this.workCenterCapRqmtInCapUnit = workCenterCapRqmtInCapUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCapacityUnit</b>
     * </p>
     *
     * @param workCenterCapacityUnit
     *            Base Unit of Measure
     */
    public void setWorkCenterCapacityUnit( @Nullable final String workCenterCapacityUnit )
    {
        rememberChangedField("WorkCenterCapacityUnit", this.workCenterCapacityUnit);
        this.workCenterCapacityUnit = workCenterCapacityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCapUnitText</b>
     * </p>
     *
     * @param workCenterCapUnitText
     *            Unit of Measurement Text (Maximum 10 Characters)
     */
    public void setWorkCenterCapUnitText( @Nullable final String workCenterCapUnitText )
    {
        rememberChangedField("WorkCenterCapUnitText", this.workCenterCapUnitText);
        this.workCenterCapUnitText = workCenterCapUnitText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenterCapOrderPerBucketSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("P_CapEvalStartDate", getP_CapEvalStartDate());
        result.put("P_CapEvalEndDate", getP_CapEvalEndDate());
        result.put("P_CapEvalBucketType", getP_CapEvalBucketType());
        result.put("Plant", getPlant());
        result.put("MRPController", getMRPController());
        result.put("WorkCenter", getWorkCenter());
        result.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        result.put("CapacityCategoryAllocation", getCapacityCategoryAllocation());
        result.put("CapacityInternalID", getCapacityInternalID());
        result.put("Material", getMaterial());
        result.put("OrderID", getOrderID());
        result.put("Operation", getOperation());
        result.put("CapacityEvaluationTimePeriod", getCapacityEvaluationTimePeriod());
        result.put("ShiftName", getShiftName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("P_CapEvalStartDate", getP_CapEvalStartDate());
        values.put("P_CapEvalEndDate", getP_CapEvalEndDate());
        values.put("P_CapEvalBucketType", getP_CapEvalBucketType());
        values.put("Plant", getPlant());
        values.put("MRPController", getMRPController());
        values.put("WorkCenter", getWorkCenter());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("CapacityCategoryAllocation", getCapacityCategoryAllocation());
        values.put("CapacityInternalID", getCapacityInternalID());
        values.put("Material", getMaterial());
        values.put("OrderID", getOrderID());
        values.put("Operation", getOperation());
        values.put("CapacityEvaluationTimePeriod", getCapacityEvaluationTimePeriod());
        values.put("ShiftName", getShiftName());
        values.put("CapEvalBucketType", getCapEvalBucketType());
        values.put("CapacityEvaluationTimePerdText", getCapacityEvaluationTimePerdText());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("WorkCenterDesc", getWorkCenterDesc());
        values.put("WorkCenterResponsible", getWorkCenterResponsible());
        values.put("WorkCenterCategoryCode", getWorkCenterCategoryCode());
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("CapacityRequirementOrigin", getCapacityRequirementOrigin());
        values.put("CapacityRequirementUnit", getCapacityRequirementUnit());
        values.put("OrderType", getOrderType());
        values.put("OrderTypeName", getOrderTypeName());
        values.put("OrderPlannedTotalQty", getOrderPlannedTotalQty());
        values.put("BaseUnit", getBaseUnit());
        values.put("OrderCategory", getOrderCategory());
        values.put("OrderCategoryName", getOrderCategoryName());
        values.put("ProductionVersion", getProductionVersion());
        values.put("OperationPlanningStatusText", getOperationPlanningStatusText());
        values.put("OperationPlanningStatusCode", getOperationPlanningStatusCode());
        values.put("OperationLatestStartDate", getOperationLatestStartDate());
        values.put("OperationLatestStartTime", getOperationLatestStartTime());
        values.put("OperationLatestEndDate", getOperationLatestEndDate());
        values.put("OperationLatestEndTime", getOperationLatestEndTime());
        values.put("OrderStatusText", getOrderStatusText());
        values.put("OrderStatusCode", getOrderStatusCode());
        values.put("OrderFirmingStatusCode", getOrderFirmingStatusCode());
        values.put("OrderFirmingStatusText", getOrderFirmingStatusText());
        values.put("OpLtstSchedldProcgStrtDte", getOpLtstSchedldProcgStrtDte());
        values.put("OpLtstSchedldProcgStrtTme", getOpLtstSchedldProcgStrtTme());
        values.put("OpLtstSchedldTrdwnStrtDte", getOpLtstSchedldTrdwnStrtDte());
        values.put("OpLtstSchedldTrdwnStrtTme", getOpLtstSchedldTrdwnStrtTme());
        values.put("RemainingCapReqOpSegSetupDurn", getRemainingCapReqOpSegSetupDurn());
        values.put("RemainingCapReqOpSegProcgDurn", getRemainingCapReqOpSegProcgDurn());
        values.put("RemainingCapReqOpSegTrdwnDurn", getRemainingCapReqOpSegTrdwnDurn());
        values.put("OrderInternalID", getOrderInternalID());
        values.put("CapacityStartTime", getCapacityStartTime());
        values.put("CapacityEndTime", getCapacityEndTime());
        values.put("WorkCenterAvailableCapacity", getWorkCenterAvailableCapacity());
        values.put("WorkCenterCapRqmtInCapUnit", getWorkCenterCapRqmtInCapUnit());
        values.put("WorkCenterCapacityUnit", getWorkCenterCapacityUnit());
        values.put("WorkCenterCapUnitText", getWorkCenterCapUnitText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("P_CapEvalStartDate") ) {
                final Object value = values.remove("P_CapEvalStartDate");
                if( (value == null) || (!value.equals(getP_CapEvalStartDate())) ) {
                    setP_CapEvalStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("P_CapEvalEndDate") ) {
                final Object value = values.remove("P_CapEvalEndDate");
                if( (value == null) || (!value.equals(getP_CapEvalEndDate())) ) {
                    setP_CapEvalEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("P_CapEvalBucketType") ) {
                final Object value = values.remove("P_CapEvalBucketType");
                if( (value == null) || (!value.equals(getP_CapEvalBucketType())) ) {
                    setP_CapEvalBucketType(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MRPController") ) {
                final Object value = values.remove("MRPController");
                if( (value == null) || (!value.equals(getMRPController())) ) {
                    setMRPController(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("CapacityCategoryAllocation") ) {
                final Object value = values.remove("CapacityCategoryAllocation");
                if( (value == null) || (!value.equals(getCapacityCategoryAllocation())) ) {
                    setCapacityCategoryAllocation(((String) value));
                }
            }
            if( values.containsKey("CapacityInternalID") ) {
                final Object value = values.remove("CapacityInternalID");
                if( (value == null) || (!value.equals(getCapacityInternalID())) ) {
                    setCapacityInternalID(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("Operation") ) {
                final Object value = values.remove("Operation");
                if( (value == null) || (!value.equals(getOperation())) ) {
                    setOperation(((String) value));
                }
            }
            if( values.containsKey("CapacityEvaluationTimePeriod") ) {
                final Object value = values.remove("CapacityEvaluationTimePeriod");
                if( (value == null) || (!value.equals(getCapacityEvaluationTimePeriod())) ) {
                    setCapacityEvaluationTimePeriod(((String) value));
                }
            }
            if( values.containsKey("ShiftName") ) {
                final Object value = values.remove("ShiftName");
                if( (value == null) || (!value.equals(getShiftName())) ) {
                    setShiftName(((String) value));
                }
            }
            if( values.containsKey("CapEvalBucketType") ) {
                final Object value = values.remove("CapEvalBucketType");
                if( (value == null) || (!value.equals(getCapEvalBucketType())) ) {
                    setCapEvalBucketType(((String) value));
                }
            }
            if( values.containsKey("CapacityEvaluationTimePerdText") ) {
                final Object value = values.remove("CapacityEvaluationTimePerdText");
                if( (value == null) || (!value.equals(getCapacityEvaluationTimePerdText())) ) {
                    setCapacityEvaluationTimePerdText(((String) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((String) value));
                }
            }
            if( values.containsKey("WorkCenterDesc") ) {
                final Object value = values.remove("WorkCenterDesc");
                if( (value == null) || (!value.equals(getWorkCenterDesc())) ) {
                    setWorkCenterDesc(((String) value));
                }
            }
            if( values.containsKey("WorkCenterResponsible") ) {
                final Object value = values.remove("WorkCenterResponsible");
                if( (value == null) || (!value.equals(getWorkCenterResponsible())) ) {
                    setWorkCenterResponsible(((String) value));
                }
            }
            if( values.containsKey("WorkCenterCategoryCode") ) {
                final Object value = values.remove("WorkCenterCategoryCode");
                if( (value == null) || (!value.equals(getWorkCenterCategoryCode())) ) {
                    setWorkCenterCategoryCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("CapacityRequirementOrigin") ) {
                final Object value = values.remove("CapacityRequirementOrigin");
                if( (value == null) || (!value.equals(getCapacityRequirementOrigin())) ) {
                    setCapacityRequirementOrigin(((String) value));
                }
            }
            if( values.containsKey("CapacityRequirementUnit") ) {
                final Object value = values.remove("CapacityRequirementUnit");
                if( (value == null) || (!value.equals(getCapacityRequirementUnit())) ) {
                    setCapacityRequirementUnit(((String) value));
                }
            }
            if( values.containsKey("OrderType") ) {
                final Object value = values.remove("OrderType");
                if( (value == null) || (!value.equals(getOrderType())) ) {
                    setOrderType(((String) value));
                }
            }
            if( values.containsKey("OrderTypeName") ) {
                final Object value = values.remove("OrderTypeName");
                if( (value == null) || (!value.equals(getOrderTypeName())) ) {
                    setOrderTypeName(((String) value));
                }
            }
            if( values.containsKey("OrderPlannedTotalQty") ) {
                final Object value = values.remove("OrderPlannedTotalQty");
                if( (value == null) || (!value.equals(getOrderPlannedTotalQty())) ) {
                    setOrderPlannedTotalQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("OrderCategory") ) {
                final Object value = values.remove("OrderCategory");
                if( (value == null) || (!value.equals(getOrderCategory())) ) {
                    setOrderCategory(((String) value));
                }
            }
            if( values.containsKey("OrderCategoryName") ) {
                final Object value = values.remove("OrderCategoryName");
                if( (value == null) || (!value.equals(getOrderCategoryName())) ) {
                    setOrderCategoryName(((String) value));
                }
            }
            if( values.containsKey("ProductionVersion") ) {
                final Object value = values.remove("ProductionVersion");
                if( (value == null) || (!value.equals(getProductionVersion())) ) {
                    setProductionVersion(((String) value));
                }
            }
            if( values.containsKey("OperationPlanningStatusText") ) {
                final Object value = values.remove("OperationPlanningStatusText");
                if( (value == null) || (!value.equals(getOperationPlanningStatusText())) ) {
                    setOperationPlanningStatusText(((String) value));
                }
            }
            if( values.containsKey("OperationPlanningStatusCode") ) {
                final Object value = values.remove("OperationPlanningStatusCode");
                if( (value == null) || (!value.equals(getOperationPlanningStatusCode())) ) {
                    setOperationPlanningStatusCode(((String) value));
                }
            }
            if( values.containsKey("OperationLatestStartDate") ) {
                final Object value = values.remove("OperationLatestStartDate");
                if( (value == null) || (!value.equals(getOperationLatestStartDate())) ) {
                    setOperationLatestStartDate(((String) value));
                }
            }
            if( values.containsKey("OperationLatestStartTime") ) {
                final Object value = values.remove("OperationLatestStartTime");
                if( (value == null) || (!value.equals(getOperationLatestStartTime())) ) {
                    setOperationLatestStartTime(((String) value));
                }
            }
            if( values.containsKey("OperationLatestEndDate") ) {
                final Object value = values.remove("OperationLatestEndDate");
                if( (value == null) || (!value.equals(getOperationLatestEndDate())) ) {
                    setOperationLatestEndDate(((String) value));
                }
            }
            if( values.containsKey("OperationLatestEndTime") ) {
                final Object value = values.remove("OperationLatestEndTime");
                if( (value == null) || (!value.equals(getOperationLatestEndTime())) ) {
                    setOperationLatestEndTime(((String) value));
                }
            }
            if( values.containsKey("OrderStatusText") ) {
                final Object value = values.remove("OrderStatusText");
                if( (value == null) || (!value.equals(getOrderStatusText())) ) {
                    setOrderStatusText(((String) value));
                }
            }
            if( values.containsKey("OrderStatusCode") ) {
                final Object value = values.remove("OrderStatusCode");
                if( (value == null) || (!value.equals(getOrderStatusCode())) ) {
                    setOrderStatusCode(((String) value));
                }
            }
            if( values.containsKey("OrderFirmingStatusCode") ) {
                final Object value = values.remove("OrderFirmingStatusCode");
                if( (value == null) || (!value.equals(getOrderFirmingStatusCode())) ) {
                    setOrderFirmingStatusCode(((String) value));
                }
            }
            if( values.containsKey("OrderFirmingStatusText") ) {
                final Object value = values.remove("OrderFirmingStatusText");
                if( (value == null) || (!value.equals(getOrderFirmingStatusText())) ) {
                    setOrderFirmingStatusText(((String) value));
                }
            }
            if( values.containsKey("OpLtstSchedldProcgStrtDte") ) {
                final Object value = values.remove("OpLtstSchedldProcgStrtDte");
                if( (value == null) || (!value.equals(getOpLtstSchedldProcgStrtDte())) ) {
                    setOpLtstSchedldProcgStrtDte(((String) value));
                }
            }
            if( values.containsKey("OpLtstSchedldProcgStrtTme") ) {
                final Object value = values.remove("OpLtstSchedldProcgStrtTme");
                if( (value == null) || (!value.equals(getOpLtstSchedldProcgStrtTme())) ) {
                    setOpLtstSchedldProcgStrtTme(((String) value));
                }
            }
            if( values.containsKey("OpLtstSchedldTrdwnStrtDte") ) {
                final Object value = values.remove("OpLtstSchedldTrdwnStrtDte");
                if( (value == null) || (!value.equals(getOpLtstSchedldTrdwnStrtDte())) ) {
                    setOpLtstSchedldTrdwnStrtDte(((String) value));
                }
            }
            if( values.containsKey("OpLtstSchedldTrdwnStrtTme") ) {
                final Object value = values.remove("OpLtstSchedldTrdwnStrtTme");
                if( (value == null) || (!value.equals(getOpLtstSchedldTrdwnStrtTme())) ) {
                    setOpLtstSchedldTrdwnStrtTme(((String) value));
                }
            }
            if( values.containsKey("RemainingCapReqOpSegSetupDurn") ) {
                final Object value = values.remove("RemainingCapReqOpSegSetupDurn");
                if( (value == null) || (!value.equals(getRemainingCapReqOpSegSetupDurn())) ) {
                    setRemainingCapReqOpSegSetupDurn(((BigDecimal) value));
                }
            }
            if( values.containsKey("RemainingCapReqOpSegProcgDurn") ) {
                final Object value = values.remove("RemainingCapReqOpSegProcgDurn");
                if( (value == null) || (!value.equals(getRemainingCapReqOpSegProcgDurn())) ) {
                    setRemainingCapReqOpSegProcgDurn(((BigDecimal) value));
                }
            }
            if( values.containsKey("RemainingCapReqOpSegTrdwnDurn") ) {
                final Object value = values.remove("RemainingCapReqOpSegTrdwnDurn");
                if( (value == null) || (!value.equals(getRemainingCapReqOpSegTrdwnDurn())) ) {
                    setRemainingCapReqOpSegTrdwnDurn(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderInternalID") ) {
                final Object value = values.remove("OrderInternalID");
                if( (value == null) || (!value.equals(getOrderInternalID())) ) {
                    setOrderInternalID(((String) value));
                }
            }
            if( values.containsKey("CapacityStartTime") ) {
                final Object value = values.remove("CapacityStartTime");
                if( (value == null) || (!value.equals(getCapacityStartTime())) ) {
                    setCapacityStartTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("CapacityEndTime") ) {
                final Object value = values.remove("CapacityEndTime");
                if( (value == null) || (!value.equals(getCapacityEndTime())) ) {
                    setCapacityEndTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("WorkCenterAvailableCapacity") ) {
                final Object value = values.remove("WorkCenterAvailableCapacity");
                if( (value == null) || (!value.equals(getWorkCenterAvailableCapacity())) ) {
                    setWorkCenterAvailableCapacity(((BigDecimal) value));
                }
            }
            if( values.containsKey("WorkCenterCapRqmtInCapUnit") ) {
                final Object value = values.remove("WorkCenterCapRqmtInCapUnit");
                if( (value == null) || (!value.equals(getWorkCenterCapRqmtInCapUnit())) ) {
                    setWorkCenterCapRqmtInCapUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("WorkCenterCapacityUnit") ) {
                final Object value = values.remove("WorkCenterCapacityUnit");
                if( (value == null) || (!value.equals(getWorkCenterCapacityUnit())) ) {
                    setWorkCenterCapacityUnit(((String) value));
                }
            }
            if( values.containsKey("WorkCenterCapUnitText") ) {
                final Object value = values.remove("WorkCenterCapUnitText");
                if( (value == null) || (!value.equals(getWorkCenterCapUnitText())) ) {
                    setWorkCenterCapUnitText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Parameters") ) {
                final Object value = (values).remove("Parameters");
                if( value instanceof Map ) {
                    if( toParameters == null ) {
                        toParameters = new WorkCenterCapOrderPerBucketParameters();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toParameters.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WorkCenterCapOrderPerBucketField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new WorkCenterCapOrderPerBucketField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCenterCapOrderPerBucketField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCenterCapOrderPerBucketField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toParameters != null ) {
            (values).put("Parameters", toParameters);
        }
        return values;
    }

    /**
     * Fetches the <b>WorkCenterCapOrderPerBucketParameters</b> entity (one to one) associated with this entity. This
     * corresponds to the OData navigation property <b>Parameters</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WorkCenterCapOrderPerBucketParameters</b> entity, or {@code null} if an entity
     *         is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WorkCenterCapOrderPerBucketParameters fetchParameters()
    {
        return fetchFieldAsSingle("Parameters", WorkCenterCapOrderPerBucketParameters.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapOrderPerBucketParameters</b> entity (one to one). This corresponds to the
     * OData navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property <b>Parameters</b> of a queried <b>WorkCenterCapOrderPerBucket</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapOrderPerBucketParameters</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WorkCenterCapOrderPerBucketParameters getParametersOrFetch()
    {
        if( toParameters == null ) {
            toParameters = fetchParameters();
        }
        return toParameters;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapOrderPerBucketParameters</b> entity (one to one). This corresponds to the
     * OData navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenterCapOrderPerBucket</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>Parameters</b> is already loaded, the result will contain
     *         the <b>WorkCenterCapOrderPerBucketParameters</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<WorkCenterCapOrderPerBucketParameters> getParametersIfPresent()
    {
        return Option.of(toParameters);
    }

    /**
     * Overwrites the associated <b>WorkCenterCapOrderPerBucketParameters</b> entity for the loaded navigation property
     * <b>Parameters</b>.
     *
     * @param value
     *            New <b>WorkCenterCapOrderPerBucketParameters</b> entity.
     */
    public void setParameters( final WorkCenterCapOrderPerBucketParameters value )
    {
        toParameters = value;
    }

    /**
     * Helper class to allow for fluent creation of WorkCenterCapOrderPerBucket instances.
     *
     */
    public final static class WorkCenterCapOrderPerBucketBuilder
    {

        private WorkCenterCapOrderPerBucketParameters toParameters;

        private WorkCenterCapOrderPerBucket.WorkCenterCapOrderPerBucketBuilder toParameters(
            final WorkCenterCapOrderPerBucketParameters value )
        {
            toParameters = value;
            return this;
        }

        /**
         * Navigation property <b>Parameters</b> for <b>WorkCenterCapOrderPerBucket</b> to single
         * <b>WorkCenterCapOrderPerBucketParameters</b>.
         *
         * @param value
         *            The WorkCenterCapOrderPerBucketParameters to build this WorkCenterCapOrderPerBucket with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenterCapOrderPerBucket.WorkCenterCapOrderPerBucketBuilder parameters(
            final WorkCenterCapOrderPerBucketParameters value )
        {
            return toParameters(value);
        }

    }

}
