/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapOrderPerBucketParametersField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapOrderPerBucketParametersLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapOrderPerBucketParametersSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCenterCapOrderPerBucketParameters</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenterCapOrderPerBucketParameters extends VdmEntity<WorkCenterCapOrderPerBucketParameters>
{

    /**
     * Selector for all available fields of WorkCenterCapOrderPerBucketParameters.
     *
     */
    public final static WorkCenterCapOrderPerBucketParametersSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalStartDate</b>
     * </p>
     *
     * @return Date
     */
    @Key
    @SerializedName( "P_CapEvalStartDate" )
    @JsonProperty( "P_CapEvalStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "P_CapEvalStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime p_CapEvalStartDate;
    /**
     * Use with available fluent helpers to apply the <b>P_CapEvalStartDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketParametersField<LocalDateTime> P_CAP_EVAL_START_DATE =
        new WorkCenterCapOrderPerBucketParametersField<LocalDateTime>("P_CapEvalStartDate");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalEndDate</b>
     * </p>
     *
     * @return Date
     */
    @Key
    @SerializedName( "P_CapEvalEndDate" )
    @JsonProperty( "P_CapEvalEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "P_CapEvalEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime p_CapEvalEndDate;
    /**
     * Use with available fluent helpers to apply the <b>P_CapEvalEndDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketParametersField<LocalDateTime> P_CAP_EVAL_END_DATE =
        new WorkCenterCapOrderPerBucketParametersField<LocalDateTime>("P_CapEvalEndDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalBucketType</b>
     * </p>
     *
     * @return Single-Character Flag
     */
    @Key
    @SerializedName( "P_CapEvalBucketType" )
    @JsonProperty( "P_CapEvalBucketType" )
    @Nullable
    @ODataField( odataName = "P_CapEvalBucketType" )
    private String p_CapEvalBucketType;
    /**
     * Use with available fluent helpers to apply the <b>P_CapEvalBucketType</b> field to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketParametersField<String> P_CAP_EVAL_BUCKET_TYPE =
        new WorkCenterCapOrderPerBucketParametersField<String>("P_CapEvalBucketType");
    /**
     * Navigation property <b>Set</b> for <b>WorkCenterCapOrderPerBucketParameters</b> to multiple
     * <b>WorkCenterCapOrderPerBucket</b>.
     *
     */
    @SerializedName( "Set" )
    @JsonProperty( "Set" )
    @ODataField( odataName = "Set" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterCapOrderPerBucket> toSet;
    /**
     * Use with available fluent helpers to apply the <b>Set</b> navigation property to query operations.
     *
     */
    public final static WorkCenterCapOrderPerBucketParametersLink<WorkCenterCapOrderPerBucket> TO_SET =
        new WorkCenterCapOrderPerBucketParametersLink<WorkCenterCapOrderPerBucket>("Set");

    @Nonnull
    @Override
    public Class<WorkCenterCapOrderPerBucketParameters> getType()
    {
        return WorkCenterCapOrderPerBucketParameters.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalStartDate</b>
     * </p>
     *
     * @param p_CapEvalStartDate
     *            Date
     */
    public void setP_CapEvalStartDate( @Nullable final LocalDateTime p_CapEvalStartDate )
    {
        rememberChangedField("P_CapEvalStartDate", this.p_CapEvalStartDate);
        this.p_CapEvalStartDate = p_CapEvalStartDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalEndDate</b>
     * </p>
     *
     * @param p_CapEvalEndDate
     *            Date
     */
    public void setP_CapEvalEndDate( @Nullable final LocalDateTime p_CapEvalEndDate )
    {
        rememberChangedField("P_CapEvalEndDate", this.p_CapEvalEndDate);
        this.p_CapEvalEndDate = p_CapEvalEndDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalBucketType</b>
     * </p>
     *
     * @param p_CapEvalBucketType
     *            Single-Character Flag
     */
    public void setP_CapEvalBucketType( @Nullable final String p_CapEvalBucketType )
    {
        rememberChangedField("P_CapEvalBucketType", this.p_CapEvalBucketType);
        this.p_CapEvalBucketType = p_CapEvalBucketType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenterCapOrderPerBucket";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("P_CapEvalStartDate", getP_CapEvalStartDate());
        result.put("P_CapEvalEndDate", getP_CapEvalEndDate());
        result.put("P_CapEvalBucketType", getP_CapEvalBucketType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("P_CapEvalStartDate", getP_CapEvalStartDate());
        values.put("P_CapEvalEndDate", getP_CapEvalEndDate());
        values.put("P_CapEvalBucketType", getP_CapEvalBucketType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("P_CapEvalStartDate") ) {
                final Object value = values.remove("P_CapEvalStartDate");
                if( (value == null) || (!value.equals(getP_CapEvalStartDate())) ) {
                    setP_CapEvalStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("P_CapEvalEndDate") ) {
                final Object value = values.remove("P_CapEvalEndDate");
                if( (value == null) || (!value.equals(getP_CapEvalEndDate())) ) {
                    setP_CapEvalEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("P_CapEvalBucketType") ) {
                final Object value = values.remove("P_CapEvalBucketType");
                if( (value == null) || (!value.equals(getP_CapEvalBucketType())) ) {
                    setP_CapEvalBucketType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Set") ) {
                final Object value = (values).remove("Set");
                if( value instanceof Iterable ) {
                    if( toSet == null ) {
                        toSet = Lists.newArrayList();
                    } else {
                        toSet = Lists.newArrayList(toSet);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterCapOrderPerBucket entity;
                        if( toSet.size() > i ) {
                            entity = toSet.get(i);
                        } else {
                            entity = new WorkCenterCapOrderPerBucket();
                            toSet.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WorkCenterCapOrderPerBucketParametersField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new WorkCenterCapOrderPerBucketParametersField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCenterCapOrderPerBucketParametersField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCenterCapOrderPerBucketParametersField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSet != null ) {
            (values).put("Set", toSet);
        }
        return values;
    }

    /**
     * Fetches the <b>WorkCenterCapOrderPerBucket</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>Set</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterCapOrderPerBucket</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapOrderPerBucket> fetchSet()
    {
        return fetchFieldAsList("Set", WorkCenterCapOrderPerBucket.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapOrderPerBucket</b> entities (one to many). This corresponds to the OData
     * navigation property <b>Set</b>.
     * <p>
     * If the navigation property <b>Set</b> of a queried <b>WorkCenterCapOrderPerBucketParameters</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapOrderPerBucket</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapOrderPerBucket> getSetOrFetch()
    {
        if( toSet == null ) {
            toSet = fetchSet();
        }
        return toSet;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapOrderPerBucket</b> entities (one to many). This corresponds to the OData
     * navigation property <b>Set</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenterCapOrderPerBucketParameters</b> has not been resolved yet,
     * this method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>Set</b> is already loaded, the result will contain the
     *         <b>WorkCenterCapOrderPerBucket</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterCapOrderPerBucket>> getSetIfPresent()
    {
        return Option.of(toSet);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterCapOrderPerBucket</b> entities for the loaded navigation property
     * <b>Set</b>.
     * <p>
     * If the navigation property <b>Set</b> of a queried <b>WorkCenterCapOrderPerBucketParameters</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterCapOrderPerBucket</b> entities.
     */
    public void setSet( @Nonnull final List<WorkCenterCapOrderPerBucket> value )
    {
        if( toSet == null ) {
            toSet = Lists.newArrayList();
        }
        toSet.clear();
        toSet.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterCapOrderPerBucket</b> entities. This corresponds to the
     * OData navigation property <b>Set</b>.
     * <p>
     * If the navigation property <b>Set</b> of a queried <b>WorkCenterCapOrderPerBucketParameters</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterCapOrderPerBucket</b> entities.
     */
    public void addSet( WorkCenterCapOrderPerBucket... entity )
    {
        if( toSet == null ) {
            toSet = Lists.newArrayList();
        }
        toSet.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WorkCenterCapOrderPerBucketParameters instances.
     *
     */
    public final static class WorkCenterCapOrderPerBucketParametersBuilder
    {

        private List<WorkCenterCapOrderPerBucket> toSet = Lists.newArrayList();

        private WorkCenterCapOrderPerBucketParameters.WorkCenterCapOrderPerBucketParametersBuilder toSet(
            final List<WorkCenterCapOrderPerBucket> value )
        {
            toSet.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>Set</b> for <b>WorkCenterCapOrderPerBucketParameters</b> to multiple
         * <b>WorkCenterCapOrderPerBucket</b>.
         *
         * @param value
         *            The WorkCenterCapOrderPerBuckets to build this WorkCenterCapOrderPerBucketParameters with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenterCapOrderPerBucketParameters.WorkCenterCapOrderPerBucketParametersBuilder set(
            WorkCenterCapOrderPerBucket... value )
        {
            return toSet(Lists.newArrayList(value));
        }

    }

}
