/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapPerBucketField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapPerBucketOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapPerBucketSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Capacity Evaluation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCenterCapPerBucketType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenterCapPerBucket extends VdmEntity<WorkCenterCapPerBucket>
{

    /**
     * Selector for all available fields of WorkCenterCapPerBucket.
     *
     */
    public final static WorkCenterCapPerBucketSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalStartDate</b>
     * </p>
     *
     * @return Date
     */
    @Key
    @SerializedName( "P_CapEvalStartDate" )
    @JsonProperty( "P_CapEvalStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "P_CapEvalStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime p_CapEvalStartDate;
    /**
     * Use with available fluent helpers to apply the <b>P_CapEvalStartDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<LocalDateTime> P_CAP_EVAL_START_DATE =
        new WorkCenterCapPerBucketField<LocalDateTime>("P_CapEvalStartDate");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalEndDate</b>
     * </p>
     *
     * @return Date
     */
    @Key
    @SerializedName( "P_CapEvalEndDate" )
    @JsonProperty( "P_CapEvalEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "P_CapEvalEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime p_CapEvalEndDate;
    /**
     * Use with available fluent helpers to apply the <b>P_CapEvalEndDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<LocalDateTime> P_CAP_EVAL_END_DATE =
        new WorkCenterCapPerBucketField<LocalDateTime>("P_CapEvalEndDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalBucketType</b>
     * </p>
     *
     * @return Single-Character Flag
     */
    @Key
    @SerializedName( "P_CapEvalBucketType" )
    @JsonProperty( "P_CapEvalBucketType" )
    @Nullable
    @ODataField( odataName = "P_CapEvalBucketType" )
    private String p_CapEvalBucketType;
    /**
     * Use with available fluent helpers to apply the <b>P_CapEvalBucketType</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> P_CAP_EVAL_BUCKET_TYPE =
        new WorkCenterCapPerBucketField<String>("P_CapEvalBucketType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> PLANT = new WorkCenterCapPerBucketField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @Key
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> WORK_CENTER =
        new WorkCenterCapPerBucketField<String>("WorkCenter");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @return Capacity ID
     */
    @Key
    @SerializedName( "CapacityInternalID" )
    @JsonProperty( "CapacityInternalID" )
    @Nullable
    @ODataField( odataName = "CapacityInternalID" )
    private String capacityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CapacityInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> CAPACITY_INTERNAL_ID =
        new WorkCenterCapPerBucketField<String>("CapacityInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftName</b>
     * </p>
     *
     * @return Shift Definition
     */
    @Key
    @SerializedName( "ShiftName" )
    @JsonProperty( "ShiftName" )
    @Nullable
    @ODataField( odataName = "ShiftName" )
    private String shiftName;
    /**
     * Use with available fluent helpers to apply the <b>ShiftName</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> SHIFT_NAME =
        new WorkCenterCapPerBucketField<String>("ShiftName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEvaluationTimePeriod</b>
     * </p>
     *
     * @return The capacityEvaluationTimePeriod contained in this entity.
     */
    @Key
    @SerializedName( "CapacityEvaluationTimePeriod" )
    @JsonProperty( "CapacityEvaluationTimePeriod" )
    @Nullable
    @ODataField( odataName = "CapacityEvaluationTimePeriod" )
    private String capacityEvaluationTimePeriod;
    /**
     * Use with available fluent helpers to apply the <b>CapacityEvaluationTimePeriod</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> CAPACITY_EVALUATION_TIME_PERIOD =
        new WorkCenterCapPerBucketField<String>("CapacityEvaluationTimePeriod");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CapEvalBucketType</b>
     * </p>
     *
     * @return The capEvalBucketType contained in this entity.
     */
    @Key
    @SerializedName( "CapEvalBucketType" )
    @JsonProperty( "CapEvalBucketType" )
    @Nullable
    @ODataField( odataName = "CapEvalBucketType" )
    private String capEvalBucketType;
    /**
     * Use with available fluent helpers to apply the <b>CapEvalBucketType</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> CAP_EVAL_BUCKET_TYPE =
        new WorkCenterCapPerBucketField<String>("CapEvalBucketType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEvaluationTimePerdText</b>
     * </p>
     *
     * @return Short Text for Fixed Values
     */
    @SerializedName( "CapacityEvaluationTimePerdText" )
    @JsonProperty( "CapacityEvaluationTimePerdText" )
    @Nullable
    @ODataField( odataName = "CapacityEvaluationTimePerdText" )
    private String capacityEvaluationTimePerdText;
    /**
     * Use with available fluent helpers to apply the <b>CapacityEvaluationTimePerdText</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> CAPACITY_EVALUATION_TIME_PERD_TEXT =
        new WorkCenterCapPerBucketField<String>("CapacityEvaluationTimePerdText");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the resource
     */
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> WORK_CENTER_INTERNAL_ID =
        new WorkCenterCapPerBucketField<String>("WorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsible</b>
     * </p>
     *
     * @return Person Responsible for the Work Center
     */
    @SerializedName( "WorkCenterResponsible" )
    @JsonProperty( "WorkCenterResponsible" )
    @Nullable
    @ODataField( odataName = "WorkCenterResponsible" )
    private String workCenterResponsible;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterResponsible</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> WORK_CENTER_RESPONSIBLE =
        new WorkCenterCapPerBucketField<String>("WorkCenterResponsible");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityStartTime</b>
     * </p>
     *
     * @return Start time in seconds (internal)
     */
    @SerializedName( "CapacityStartTime" )
    @JsonProperty( "CapacityStartTime" )
    @Nullable
    @ODataField( odataName = "CapacityStartTime" )
    private Integer capacityStartTime;
    /**
     * Use with available fluent helpers to apply the <b>CapacityStartTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<Integer> CAPACITY_START_TIME =
        new WorkCenterCapPerBucketField<Integer>("CapacityStartTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEndTime</b>
     * </p>
     *
     * @return End Time in Seconds (internal)
     */
    @SerializedName( "CapacityEndTime" )
    @JsonProperty( "CapacityEndTime" )
    @Nullable
    @ODataField( odataName = "CapacityEndTime" )
    private Integer capacityEndTime;
    /**
     * Use with available fluent helpers to apply the <b>CapacityEndTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<Integer> CAPACITY_END_TIME =
        new WorkCenterCapPerBucketField<Integer>("CapacityEndTime");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterAvailableCapacity</b>
     * </p>
     *
     * @return The workCenterAvailableCapacity contained in this entity.
     */
    @SerializedName( "WorkCenterAvailableCapacity" )
    @JsonProperty( "WorkCenterAvailableCapacity" )
    @Nullable
    @ODataField( odataName = "WorkCenterAvailableCapacity" )
    private BigDecimal workCenterAvailableCapacity;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterAvailableCapacity</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<BigDecimal> WORK_CENTER_AVAILABLE_CAPACITY =
        new WorkCenterCapPerBucketField<BigDecimal>("WorkCenterAvailableCapacity");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCapRqmtInCapUnit</b>
     * </p>
     *
     * @return The workCenterCapRqmtInCapUnit contained in this entity.
     */
    @SerializedName( "WorkCenterCapRqmtInCapUnit" )
    @JsonProperty( "WorkCenterCapRqmtInCapUnit" )
    @Nullable
    @ODataField( odataName = "WorkCenterCapRqmtInCapUnit" )
    private BigDecimal workCenterCapRqmtInCapUnit;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterCapRqmtInCapUnit</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<BigDecimal> WORK_CENTER_CAP_RQMT_IN_CAP_UNIT =
        new WorkCenterCapPerBucketField<BigDecimal>("WorkCenterCapRqmtInCapUnit");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrRmngCapInCapUnit</b>
     * </p>
     *
     * @return The wrkCtrRmngCapInCapUnit contained in this entity.
     */
    @SerializedName( "WrkCtrRmngCapInCapUnit" )
    @JsonProperty( "WrkCtrRmngCapInCapUnit" )
    @Nullable
    @ODataField( odataName = "WrkCtrRmngCapInCapUnit" )
    private BigDecimal wrkCtrRmngCapInCapUnit;
    /**
     * Use with available fluent helpers to apply the <b>WrkCtrRmngCapInCapUnit</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<BigDecimal> WRK_CTR_RMNG_CAP_IN_CAP_UNIT =
        new WorkCenterCapPerBucketField<BigDecimal>("WrkCtrRmngCapInCapUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTotUtilznInTmePerd</b>
     * </p>
     *
     * @return The workCenterTotUtilznInTmePerd contained in this entity.
     */
    @SerializedName( "WorkCenterTotUtilznInTmePerd" )
    @JsonProperty( "WorkCenterTotUtilznInTmePerd" )
    @Nullable
    @ODataField( odataName = "WorkCenterTotUtilznInTmePerd" )
    private Double workCenterTotUtilznInTmePerd;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTotUtilznInTmePerd</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<Double> WORK_CENTER_TOT_UTILZN_IN_TME_PERD =
        new WorkCenterCapPerBucketField<Double>("WorkCenterTotUtilznInTmePerd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCapacityUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "WorkCenterCapacityUnit" )
    @JsonProperty( "WorkCenterCapacityUnit" )
    @Nullable
    @ODataField( odataName = "WorkCenterCapacityUnit" )
    private String workCenterCapacityUnit;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterCapacityUnit</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> WORK_CENTER_CAPACITY_UNIT =
        new WorkCenterCapPerBucketField<String>("WorkCenterCapacityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCapUnitText</b>
     * </p>
     *
     * @return Unit of Measurement Text (Maximum 10 Characters)
     */
    @SerializedName( "WorkCenterCapUnitText" )
    @JsonProperty( "WorkCenterCapUnitText" )
    @Nullable
    @ODataField( odataName = "WorkCenterCapUnitText" )
    private String workCenterCapUnitText;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterCapUnitText</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> WORK_CENTER_CAP_UNIT_TEXT =
        new WorkCenterCapPerBucketField<String>("WorkCenterCapUnitText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> WORK_CENTER_TYPE_CODE =
        new WorkCenterCapPerBucketField<String>("WorkCenterTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryAllocation</b>
     * </p>
     *
     * @return Capacity Category Allocation
     */
    @SerializedName( "CapacityCategoryAllocation" )
    @JsonProperty( "CapacityCategoryAllocation" )
    @Nullable
    @ODataField( odataName = "CapacityCategoryAllocation" )
    private String capacityCategoryAllocation;
    /**
     * Use with available fluent helpers to apply the <b>CapacityCategoryAllocation</b> field to query operations.
     *
     */
    public final static WorkCenterCapPerBucketField<String> CAPACITY_CATEGORY_ALLOCATION =
        new WorkCenterCapPerBucketField<String>("CapacityCategoryAllocation");
    /**
     * Navigation property <b>Parameters</b> for <b>WorkCenterCapPerBucket</b> to single
     * <b>WorkCenterCapPerBucketParameters</b>.
     *
     */
    @SerializedName( "Parameters" )
    @JsonProperty( "Parameters" )
    @ODataField( odataName = "Parameters" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WorkCenterCapPerBucketParameters toParameters;
    /**
     * Use with available fluent helpers to apply the <b>Parameters</b> navigation property to query operations.
     *
     */
    public final static WorkCenterCapPerBucketOneToOneLink<WorkCenterCapPerBucketParameters> TO_PARAMETERS =
        new WorkCenterCapPerBucketOneToOneLink<WorkCenterCapPerBucketParameters>("Parameters");

    @Nonnull
    @Override
    public Class<WorkCenterCapPerBucket> getType()
    {
        return WorkCenterCapPerBucket.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalStartDate</b>
     * </p>
     *
     * @param p_CapEvalStartDate
     *            Date
     */
    public void setP_CapEvalStartDate( @Nullable final LocalDateTime p_CapEvalStartDate )
    {
        rememberChangedField("P_CapEvalStartDate", this.p_CapEvalStartDate);
        this.p_CapEvalStartDate = p_CapEvalStartDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalEndDate</b>
     * </p>
     *
     * @param p_CapEvalEndDate
     *            Date
     */
    public void setP_CapEvalEndDate( @Nullable final LocalDateTime p_CapEvalEndDate )
    {
        rememberChangedField("P_CapEvalEndDate", this.p_CapEvalEndDate);
        this.p_CapEvalEndDate = p_CapEvalEndDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>P_CapEvalBucketType</b>
     * </p>
     *
     * @param p_CapEvalBucketType
     *            Single-Character Flag
     */
    public void setP_CapEvalBucketType( @Nullable final String p_CapEvalBucketType )
    {
        rememberChangedField("P_CapEvalBucketType", this.p_CapEvalBucketType);
        this.p_CapEvalBucketType = p_CapEvalBucketType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @param capacityInternalID
     *            Capacity ID
     */
    public void setCapacityInternalID( @Nullable final String capacityInternalID )
    {
        rememberChangedField("CapacityInternalID", this.capacityInternalID);
        this.capacityInternalID = capacityInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftName</b>
     * </p>
     *
     * @param shiftName
     *            Shift Definition
     */
    public void setShiftName( @Nullable final String shiftName )
    {
        rememberChangedField("ShiftName", this.shiftName);
        this.shiftName = shiftName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEvaluationTimePeriod</b>
     * </p>
     *
     * @param capacityEvaluationTimePeriod
     *            The capacityEvaluationTimePeriod to set.
     */
    public void setCapacityEvaluationTimePeriod( @Nullable final String capacityEvaluationTimePeriod )
    {
        rememberChangedField("CapacityEvaluationTimePeriod", this.capacityEvaluationTimePeriod);
        this.capacityEvaluationTimePeriod = capacityEvaluationTimePeriod;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CapEvalBucketType</b>
     * </p>
     *
     * @param capEvalBucketType
     *            The capEvalBucketType to set.
     */
    public void setCapEvalBucketType( @Nullable final String capEvalBucketType )
    {
        rememberChangedField("CapEvalBucketType", this.capEvalBucketType);
        this.capEvalBucketType = capEvalBucketType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEvaluationTimePerdText</b>
     * </p>
     *
     * @param capacityEvaluationTimePerdText
     *            Short Text for Fixed Values
     */
    public void setCapacityEvaluationTimePerdText( @Nullable final String capacityEvaluationTimePerdText )
    {
        rememberChangedField("CapacityEvaluationTimePerdText", this.capacityEvaluationTimePerdText);
        this.capacityEvaluationTimePerdText = capacityEvaluationTimePerdText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID of the resource
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsible</b>
     * </p>
     *
     * @param workCenterResponsible
     *            Person Responsible for the Work Center
     */
    public void setWorkCenterResponsible( @Nullable final String workCenterResponsible )
    {
        rememberChangedField("WorkCenterResponsible", this.workCenterResponsible);
        this.workCenterResponsible = workCenterResponsible;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityStartTime</b>
     * </p>
     *
     * @param capacityStartTime
     *            Start time in seconds (internal)
     */
    public void setCapacityStartTime( @Nullable final Integer capacityStartTime )
    {
        rememberChangedField("CapacityStartTime", this.capacityStartTime);
        this.capacityStartTime = capacityStartTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEndTime</b>
     * </p>
     *
     * @param capacityEndTime
     *            End Time in Seconds (internal)
     */
    public void setCapacityEndTime( @Nullable final Integer capacityEndTime )
    {
        rememberChangedField("CapacityEndTime", this.capacityEndTime);
        this.capacityEndTime = capacityEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterAvailableCapacity</b>
     * </p>
     *
     * @param workCenterAvailableCapacity
     *            The workCenterAvailableCapacity to set.
     */
    public void setWorkCenterAvailableCapacity( @Nullable final BigDecimal workCenterAvailableCapacity )
    {
        rememberChangedField("WorkCenterAvailableCapacity", this.workCenterAvailableCapacity);
        this.workCenterAvailableCapacity = workCenterAvailableCapacity;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCapRqmtInCapUnit</b>
     * </p>
     *
     * @param workCenterCapRqmtInCapUnit
     *            The workCenterCapRqmtInCapUnit to set.
     */
    public void setWorkCenterCapRqmtInCapUnit( @Nullable final BigDecimal workCenterCapRqmtInCapUnit )
    {
        rememberChangedField("WorkCenterCapRqmtInCapUnit", this.workCenterCapRqmtInCapUnit);
        this.workCenterCapRqmtInCapUnit = workCenterCapRqmtInCapUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrRmngCapInCapUnit</b>
     * </p>
     *
     * @param wrkCtrRmngCapInCapUnit
     *            The wrkCtrRmngCapInCapUnit to set.
     */
    public void setWrkCtrRmngCapInCapUnit( @Nullable final BigDecimal wrkCtrRmngCapInCapUnit )
    {
        rememberChangedField("WrkCtrRmngCapInCapUnit", this.wrkCtrRmngCapInCapUnit);
        this.wrkCtrRmngCapInCapUnit = wrkCtrRmngCapInCapUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTotUtilznInTmePerd</b>
     * </p>
     *
     * @param workCenterTotUtilznInTmePerd
     *            The workCenterTotUtilznInTmePerd to set.
     */
    public void setWorkCenterTotUtilznInTmePerd( @Nullable final Double workCenterTotUtilznInTmePerd )
    {
        rememberChangedField("WorkCenterTotUtilznInTmePerd", this.workCenterTotUtilznInTmePerd);
        this.workCenterTotUtilznInTmePerd = workCenterTotUtilznInTmePerd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCapacityUnit</b>
     * </p>
     *
     * @param workCenterCapacityUnit
     *            Base Unit of Measure
     */
    public void setWorkCenterCapacityUnit( @Nullable final String workCenterCapacityUnit )
    {
        rememberChangedField("WorkCenterCapacityUnit", this.workCenterCapacityUnit);
        this.workCenterCapacityUnit = workCenterCapacityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCapUnitText</b>
     * </p>
     *
     * @param workCenterCapUnitText
     *            Unit of Measurement Text (Maximum 10 Characters)
     */
    public void setWorkCenterCapUnitText( @Nullable final String workCenterCapUnitText )
    {
        rememberChangedField("WorkCenterCapUnitText", this.workCenterCapUnitText);
        this.workCenterCapUnitText = workCenterCapUnitText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryAllocation</b>
     * </p>
     *
     * @param capacityCategoryAllocation
     *            Capacity Category Allocation
     */
    public void setCapacityCategoryAllocation( @Nullable final String capacityCategoryAllocation )
    {
        rememberChangedField("CapacityCategoryAllocation", this.capacityCategoryAllocation);
        this.capacityCategoryAllocation = capacityCategoryAllocation;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenterCapPerBucketSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("P_CapEvalStartDate", getP_CapEvalStartDate());
        result.put("P_CapEvalEndDate", getP_CapEvalEndDate());
        result.put("P_CapEvalBucketType", getP_CapEvalBucketType());
        result.put("Plant", getPlant());
        result.put("WorkCenter", getWorkCenter());
        result.put("CapacityInternalID", getCapacityInternalID());
        result.put("ShiftName", getShiftName());
        result.put("CapacityEvaluationTimePeriod", getCapacityEvaluationTimePeriod());
        result.put("CapEvalBucketType", getCapEvalBucketType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("P_CapEvalStartDate", getP_CapEvalStartDate());
        values.put("P_CapEvalEndDate", getP_CapEvalEndDate());
        values.put("P_CapEvalBucketType", getP_CapEvalBucketType());
        values.put("Plant", getPlant());
        values.put("WorkCenter", getWorkCenter());
        values.put("CapacityInternalID", getCapacityInternalID());
        values.put("ShiftName", getShiftName());
        values.put("CapacityEvaluationTimePeriod", getCapacityEvaluationTimePeriod());
        values.put("CapEvalBucketType", getCapEvalBucketType());
        values.put("CapacityEvaluationTimePerdText", getCapacityEvaluationTimePerdText());
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("WorkCenterResponsible", getWorkCenterResponsible());
        values.put("CapacityStartTime", getCapacityStartTime());
        values.put("CapacityEndTime", getCapacityEndTime());
        values.put("WorkCenterAvailableCapacity", getWorkCenterAvailableCapacity());
        values.put("WorkCenterCapRqmtInCapUnit", getWorkCenterCapRqmtInCapUnit());
        values.put("WrkCtrRmngCapInCapUnit", getWrkCtrRmngCapInCapUnit());
        values.put("WorkCenterTotUtilznInTmePerd", getWorkCenterTotUtilznInTmePerd());
        values.put("WorkCenterCapacityUnit", getWorkCenterCapacityUnit());
        values.put("WorkCenterCapUnitText", getWorkCenterCapUnitText());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("CapacityCategoryAllocation", getCapacityCategoryAllocation());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("P_CapEvalStartDate") ) {
                final Object value = values.remove("P_CapEvalStartDate");
                if( (value == null) || (!value.equals(getP_CapEvalStartDate())) ) {
                    setP_CapEvalStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("P_CapEvalEndDate") ) {
                final Object value = values.remove("P_CapEvalEndDate");
                if( (value == null) || (!value.equals(getP_CapEvalEndDate())) ) {
                    setP_CapEvalEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("P_CapEvalBucketType") ) {
                final Object value = values.remove("P_CapEvalBucketType");
                if( (value == null) || (!value.equals(getP_CapEvalBucketType())) ) {
                    setP_CapEvalBucketType(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("CapacityInternalID") ) {
                final Object value = values.remove("CapacityInternalID");
                if( (value == null) || (!value.equals(getCapacityInternalID())) ) {
                    setCapacityInternalID(((String) value));
                }
            }
            if( values.containsKey("ShiftName") ) {
                final Object value = values.remove("ShiftName");
                if( (value == null) || (!value.equals(getShiftName())) ) {
                    setShiftName(((String) value));
                }
            }
            if( values.containsKey("CapacityEvaluationTimePeriod") ) {
                final Object value = values.remove("CapacityEvaluationTimePeriod");
                if( (value == null) || (!value.equals(getCapacityEvaluationTimePeriod())) ) {
                    setCapacityEvaluationTimePeriod(((String) value));
                }
            }
            if( values.containsKey("CapEvalBucketType") ) {
                final Object value = values.remove("CapEvalBucketType");
                if( (value == null) || (!value.equals(getCapEvalBucketType())) ) {
                    setCapEvalBucketType(((String) value));
                }
            }
            if( values.containsKey("CapacityEvaluationTimePerdText") ) {
                final Object value = values.remove("CapacityEvaluationTimePerdText");
                if( (value == null) || (!value.equals(getCapacityEvaluationTimePerdText())) ) {
                    setCapacityEvaluationTimePerdText(((String) value));
                }
            }
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenterResponsible") ) {
                final Object value = values.remove("WorkCenterResponsible");
                if( (value == null) || (!value.equals(getWorkCenterResponsible())) ) {
                    setWorkCenterResponsible(((String) value));
                }
            }
            if( values.containsKey("CapacityStartTime") ) {
                final Object value = values.remove("CapacityStartTime");
                if( (value == null) || (!value.equals(getCapacityStartTime())) ) {
                    setCapacityStartTime(((Integer) value));
                }
            }
            if( values.containsKey("CapacityEndTime") ) {
                final Object value = values.remove("CapacityEndTime");
                if( (value == null) || (!value.equals(getCapacityEndTime())) ) {
                    setCapacityEndTime(((Integer) value));
                }
            }
            if( values.containsKey("WorkCenterAvailableCapacity") ) {
                final Object value = values.remove("WorkCenterAvailableCapacity");
                if( (value == null) || (!value.equals(getWorkCenterAvailableCapacity())) ) {
                    setWorkCenterAvailableCapacity(((BigDecimal) value));
                }
            }
            if( values.containsKey("WorkCenterCapRqmtInCapUnit") ) {
                final Object value = values.remove("WorkCenterCapRqmtInCapUnit");
                if( (value == null) || (!value.equals(getWorkCenterCapRqmtInCapUnit())) ) {
                    setWorkCenterCapRqmtInCapUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("WrkCtrRmngCapInCapUnit") ) {
                final Object value = values.remove("WrkCtrRmngCapInCapUnit");
                if( (value == null) || (!value.equals(getWrkCtrRmngCapInCapUnit())) ) {
                    setWrkCtrRmngCapInCapUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("WorkCenterTotUtilznInTmePerd") ) {
                final Object value = values.remove("WorkCenterTotUtilznInTmePerd");
                if( (value == null) || (!value.equals(getWorkCenterTotUtilznInTmePerd())) ) {
                    setWorkCenterTotUtilznInTmePerd(((Double) value));
                }
            }
            if( values.containsKey("WorkCenterCapacityUnit") ) {
                final Object value = values.remove("WorkCenterCapacityUnit");
                if( (value == null) || (!value.equals(getWorkCenterCapacityUnit())) ) {
                    setWorkCenterCapacityUnit(((String) value));
                }
            }
            if( values.containsKey("WorkCenterCapUnitText") ) {
                final Object value = values.remove("WorkCenterCapUnitText");
                if( (value == null) || (!value.equals(getWorkCenterCapUnitText())) ) {
                    setWorkCenterCapUnitText(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("CapacityCategoryAllocation") ) {
                final Object value = values.remove("CapacityCategoryAllocation");
                if( (value == null) || (!value.equals(getCapacityCategoryAllocation())) ) {
                    setCapacityCategoryAllocation(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("Parameters") ) {
                final Object value = (values).remove("Parameters");
                if( value instanceof Map ) {
                    if( toParameters == null ) {
                        toParameters = new WorkCenterCapPerBucketParameters();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toParameters.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WorkCenterCapPerBucketField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkCenterCapPerBucketField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCenterCapPerBucketField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCenterCapPerBucketField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toParameters != null ) {
            (values).put("Parameters", toParameters);
        }
        return values;
    }

    /**
     * Fetches the <b>WorkCenterCapPerBucketParameters</b> entity (one to one) associated with this entity. This
     * corresponds to the OData navigation property <b>Parameters</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WorkCenterCapPerBucketParameters</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WorkCenterCapPerBucketParameters fetchParameters()
    {
        return fetchFieldAsSingle("Parameters", WorkCenterCapPerBucketParameters.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapPerBucketParameters</b> entity (one to one). This corresponds to the
     * OData navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property <b>Parameters</b> of a queried <b>WorkCenterCapPerBucket</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapPerBucketParameters</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WorkCenterCapPerBucketParameters getParametersOrFetch()
    {
        if( toParameters == null ) {
            toParameters = fetchParameters();
        }
        return toParameters;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapPerBucketParameters</b> entity (one to one). This corresponds to the
     * OData navigation property <b>Parameters</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenterCapPerBucket</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>Parameters</b> is already loaded, the result will contain
     *         the <b>WorkCenterCapPerBucketParameters</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<WorkCenterCapPerBucketParameters> getParametersIfPresent()
    {
        return Option.of(toParameters);
    }

    /**
     * Overwrites the associated <b>WorkCenterCapPerBucketParameters</b> entity for the loaded navigation property
     * <b>Parameters</b>.
     *
     * @param value
     *            New <b>WorkCenterCapPerBucketParameters</b> entity.
     */
    public void setParameters( final WorkCenterCapPerBucketParameters value )
    {
        toParameters = value;
    }

    /**
     * Helper class to allow for fluent creation of WorkCenterCapPerBucket instances.
     *
     */
    public final static class WorkCenterCapPerBucketBuilder
    {

        private WorkCenterCapPerBucketParameters toParameters;

        private WorkCenterCapPerBucket.WorkCenterCapPerBucketBuilder toParameters(
            final WorkCenterCapPerBucketParameters value )
        {
            toParameters = value;
            return this;
        }

        /**
         * Navigation property <b>Parameters</b> for <b>WorkCenterCapPerBucket</b> to single
         * <b>WorkCenterCapPerBucketParameters</b>.
         *
         * @param value
         *            The WorkCenterCapPerBucketParameters to build this WorkCenterCapPerBucket with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenterCapPerBucket.WorkCenterCapPerBucketBuilder parameters(
            final WorkCenterCapPerBucketParameters value )
        {
            return toParameters(value);
        }

    }

}
