/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapPerBucketParametersSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucketParameters
 * WorkCenterCapPerBucketParameters} entity using key fields. This fluent helper allows methods which modify the
 * underlying query to be called before executing the query itself.
 *
 */
public class WorkCenterCapPerBucketParametersByKeyFluentHelper
    extends
    FluentHelperByKey<WorkCenterCapPerBucketParametersByKeyFluentHelper, WorkCenterCapPerBucketParameters, WorkCenterCapPerBucketParametersSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucketParameters
     * WorkCenterCapPerBucketParameters} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WorkCenterCapPerBucketParameters}
     * @param p_CapEvalBucketType
     *            Single-Character Flag
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code WorkCenterCapPerBucketParameters}
     * @param p_CapEvalStartDate
     *            Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param p_CapEvalEndDate
     *            Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     */
    public WorkCenterCapPerBucketParametersByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final LocalDateTime p_CapEvalStartDate,
        final LocalDateTime p_CapEvalEndDate,
        final String p_CapEvalBucketType )
    {
        super(servicePath, entityCollection);
        this.key.put("P_CapEvalStartDate", p_CapEvalStartDate);
        this.key.put("P_CapEvalEndDate", p_CapEvalEndDate);
        this.key.put("P_CapEvalBucketType", p_CapEvalBucketType);
    }

    @Override
    @Nonnull
    protected Class<WorkCenterCapPerBucketParameters> getEntityClass()
    {
        return WorkCenterCapPerBucketParameters.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
