/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapacityField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapacityLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapacitySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Capacity Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCenterCapacityType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenterCapacity extends VdmEntity<WorkCenterCapacity>
{

    /**
     * Selector for all available fields of WorkCenterCapacity.
     *
     */
    public final static WorkCenterCapacitySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @return Capacity ID
     */
    @Key
    @SerializedName( "CapacityInternalID" )
    @JsonProperty( "CapacityInternalID" )
    @Nullable
    @ODataField( odataName = "CapacityInternalID" )
    private String capacityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CapacityInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> CAPACITY_INTERNAL_ID =
        new WorkCenterCapacityField<String>("CapacityInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Capacity</b>
     * </p>
     *
     * @return Capacity name
     */
    @SerializedName( "Capacity" )
    @JsonProperty( "Capacity" )
    @Nullable
    @ODataField( odataName = "Capacity" )
    private String capacity;
    /**
     * Use with available fluent helpers to apply the <b>Capacity</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> CAPACITY = new WorkCenterCapacityField<String>("Capacity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryCode</b>
     * </p>
     *
     * @return Capacity Category
     */
    @SerializedName( "CapacityCategoryCode" )
    @JsonProperty( "CapacityCategoryCode" )
    @Nullable
    @ODataField( odataName = "CapacityCategoryCode" )
    private String capacityCategoryCode;
    /**
     * Use with available fluent helpers to apply the <b>CapacityCategoryCode</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> CAPACITY_CATEGORY_CODE =
        new WorkCenterCapacityField<String>("CapacityCategoryCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityActiveVersion</b>
     * </p>
     *
     * @return Active Version of Available Capacity
     */
    @SerializedName( "CapacityActiveVersion" )
    @JsonProperty( "CapacityActiveVersion" )
    @Nullable
    @ODataField( odataName = "CapacityActiveVersion" )
    private String capacityActiveVersion;
    /**
     * Use with available fluent helpers to apply the <b>CapacityActiveVersion</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> CAPACITY_ACTIVE_VERSION =
        new WorkCenterCapacityField<String>("CapacityActiveVersion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityIsFinite</b>
     * </p>
     *
     * @return Indicator: Capacity Relevant to Finite Scheduling
     */
    @SerializedName( "CapacityIsFinite" )
    @JsonProperty( "CapacityIsFinite" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CapacityIsFinite" )
    private Boolean capacityIsFinite;
    /**
     * Use with available fluent helpers to apply the <b>CapacityIsFinite</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<Boolean> CAPACITY_IS_FINITE =
        new WorkCenterCapacityField<Boolean>("CapacityIsFinite");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityIsPooled</b>
     * </p>
     *
     * @return Pooled Capacity Indicator
     */
    @SerializedName( "CapacityIsPooled" )
    @JsonProperty( "CapacityIsPooled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CapacityIsPooled" )
    private Boolean capacityIsPooled;
    /**
     * Use with available fluent helpers to apply the <b>CapacityIsPooled</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<Boolean> CAPACITY_IS_POOLED =
        new WorkCenterCapacityField<Boolean>("CapacityIsPooled");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityHasIndivCapacities</b>
     * </p>
     *
     * @return Has Individual Capacities
     */
    @SerializedName( "CapacityHasIndivCapacities" )
    @JsonProperty( "CapacityHasIndivCapacities" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CapacityHasIndivCapacities" )
    private Boolean capacityHasIndivCapacities;
    /**
     * Use with available fluent helpers to apply the <b>CapacityHasIndivCapacities</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<Boolean> CAPACITY_HAS_INDIV_CAPACITIES =
        new WorkCenterCapacityField<Boolean>("CapacityHasIndivCapacities");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityIsExcldFrmLongTermPlng</b>
     * </p>
     *
     * @return Indicator: Capacity Excluded From Long-Term Planning
     */
    @SerializedName( "CapacityIsExcldFrmLongTermPlng" )
    @JsonProperty( "CapacityIsExcldFrmLongTermPlng" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CapacityIsExcldFrmLongTermPlng" )
    private Boolean capacityIsExcldFrmLongTermPlng;
    /**
     * Use with available fluent helpers to apply the <b>CapacityIsExcldFrmLongTermPlng</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<Boolean> CAPACITY_IS_EXCLD_FRM_LONG_TERM_PLNG =
        new WorkCenterCapacityField<Boolean>("CapacityIsExcldFrmLongTermPlng");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityNumberOfCapacities</b>
     * </p>
     *
     * @return Number of Individual Capacities
     */
    @SerializedName( "CapacityNumberOfCapacities" )
    @JsonProperty( "CapacityNumberOfCapacities" )
    @Nullable
    @ODataField( odataName = "CapacityNumberOfCapacities" )
    private Short capacityNumberOfCapacities;
    /**
     * Use with available fluent helpers to apply the <b>CapacityNumberOfCapacities</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<Short> CAPACITY_NUMBER_OF_CAPACITIES =
        new WorkCenterCapacityField<Short>("CapacityNumberOfCapacities");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityResponsiblePlanner</b>
     * </p>
     *
     * @return Capacity Responsible Planner Group
     */
    @SerializedName( "CapacityResponsiblePlanner" )
    @JsonProperty( "CapacityResponsiblePlanner" )
    @Nullable
    @ODataField( odataName = "CapacityResponsiblePlanner" )
    private String capacityResponsiblePlanner;
    /**
     * Use with available fluent helpers to apply the <b>CapacityResponsiblePlanner</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> CAPACITY_RESPONSIBLE_PLANNER =
        new WorkCenterCapacityField<String>("CapacityResponsiblePlanner");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityPlanUtilizationPercent</b>
     * </p>
     *
     * @return Capacity Utilization Ratio in Percent
     */
    @SerializedName( "CapacityPlanUtilizationPercent" )
    @JsonProperty( "CapacityPlanUtilizationPercent" )
    @Nullable
    @ODataField( odataName = "CapacityPlanUtilizationPercent" )
    private String capacityPlanUtilizationPercent;
    /**
     * Use with available fluent helpers to apply the <b>CapacityPlanUtilizationPercent</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> CAPACITY_PLAN_UTILIZATION_PERCENT =
        new WorkCenterCapacityField<String>("CapacityPlanUtilizationPercent");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityBreakDuration</b>
     * </p>
     *
     * @return Cumulative Break Duration in Seconds (internal)
     */
    @SerializedName( "CapacityBreakDuration" )
    @JsonProperty( "CapacityBreakDuration" )
    @Nullable
    @ODataField( odataName = "CapacityBreakDuration" )
    private Integer capacityBreakDuration;
    /**
     * Use with available fluent helpers to apply the <b>CapacityBreakDuration</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<Integer> CAPACITY_BREAK_DURATION =
        new WorkCenterCapacityField<Integer>("CapacityBreakDuration");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> PLANT = new WorkCenterCapacityField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @return Factory Calendar ID
     */
    @SerializedName( "FactoryCalendar" )
    @JsonProperty( "FactoryCalendar" )
    @Nullable
    @ODataField( odataName = "FactoryCalendar" )
    private String factoryCalendar;
    /**
     * Use with available fluent helpers to apply the <b>FactoryCalendar</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> FACTORY_CALENDAR =
        new WorkCenterCapacityField<String>("FactoryCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @return Authorization Group
     */
    @SerializedName( "AuthorizationGroup" )
    @JsonProperty( "AuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "AuthorizationGroup" )
    private String authorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationGroup</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> AUTHORIZATION_GROUP =
        new WorkCenterCapacityField<String>("AuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShiftGroup</b>
     * </p>
     *
     * @return Grouping for Shift Definitions and Shift Sequences
     */
    @SerializedName( "ShiftGroup" )
    @JsonProperty( "ShiftGroup" )
    @Nullable
    @ODataField( odataName = "ShiftGroup" )
    private String shiftGroup;
    /**
     * Use with available fluent helpers to apply the <b>ShiftGroup</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> SHIFT_GROUP = new WorkCenterCapacityField<String>("ShiftGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityStartTime</b>
     * </p>
     *
     * @return Start time in seconds (internal)
     */
    @SerializedName( "CapacityStartTime" )
    @JsonProperty( "CapacityStartTime" )
    @Nullable
    @ODataField( odataName = "CapacityStartTime" )
    private Integer capacityStartTime;
    /**
     * Use with available fluent helpers to apply the <b>CapacityStartTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<Integer> CAPACITY_START_TIME =
        new WorkCenterCapacityField<Integer>("CapacityStartTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEndTime</b>
     * </p>
     *
     * @return End Time in Seconds (internal)
     */
    @SerializedName( "CapacityEndTime" )
    @JsonProperty( "CapacityEndTime" )
    @Nullable
    @ODataField( odataName = "CapacityEndTime" )
    private Integer capacityEndTime;
    /**
     * Use with available fluent helpers to apply the <b>CapacityEndTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<Integer> CAPACITY_END_TIME =
        new WorkCenterCapacityField<Integer>("CapacityEndTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapIsUsedInMultiOperations</b>
     * </p>
     *
     * @return Indicator: Several Operations Can Use Capacity
     */
    @SerializedName( "CapIsUsedInMultiOperations" )
    @JsonProperty( "CapIsUsedInMultiOperations" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CapIsUsedInMultiOperations" )
    private Boolean capIsUsedInMultiOperations;
    /**
     * Use with available fluent helpers to apply the <b>CapIsUsedInMultiOperations</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<Boolean> CAP_IS_USED_IN_MULTI_OPERATIONS =
        new WorkCenterCapacityField<Boolean>("CapIsUsedInMultiOperations");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ReferencedCapacityInternalID</b>
     * </p>
     *
     * @return Referenced Capacity ID
     */
    @SerializedName( "ReferencedCapacityInternalID" )
    @JsonProperty( "ReferencedCapacityInternalID" )
    @Nullable
    @ODataField( odataName = "ReferencedCapacityInternalID" )
    private String referencedCapacityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ReferencedCapacityInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> REFERENCED_CAPACITY_INTERNAL_ID =
        new WorkCenterCapacityField<String>("ReferencedCapacityInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapOverloadThresholdInPercent</b>
     * </p>
     *
     * @return Overload
     */
    @SerializedName( "CapOverloadThresholdInPercent" )
    @JsonProperty( "CapOverloadThresholdInPercent" )
    @Nullable
    @ODataField( odataName = "CapOverloadThresholdInPercent" )
    private String capOverloadThresholdInPercent;
    /**
     * Use with available fluent helpers to apply the <b>CapOverloadThresholdInPercent</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> CAP_OVERLOAD_THRESHOLD_IN_PERCENT =
        new WorkCenterCapacityField<String>("CapOverloadThresholdInPercent");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityQuantityUnit</b>
     * </p>
     *
     * @return Capacity Unit of Measure
     */
    @SerializedName( "CapacityQuantityUnit" )
    @JsonProperty( "CapacityQuantityUnit" )
    @Nullable
    @ODataField( odataName = "CapacityQuantityUnit" )
    private String capacityQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>CapacityQuantityUnit</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> CAPACITY_QUANTITY_UNIT =
        new WorkCenterCapacityField<String>("CapacityQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityBaseQtyUnit</b>
     * </p>
     *
     * @return Capacity Base Unit of Measure
     */
    @SerializedName( "CapacityBaseQtyUnit" )
    @JsonProperty( "CapacityBaseQtyUnit" )
    @Nullable
    @ODataField( odataName = "CapacityBaseQtyUnit" )
    private String capacityBaseQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>CapacityBaseQtyUnit</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<String> CAPACITY_BASE_QTY_UNIT =
        new WorkCenterCapacityField<String>("CapacityBaseQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CapacityLastChangeDateTime</b>
     * </p>
     *
     * @return Capacity Last Change Date Time
     */
    @SerializedName( "CapacityLastChangeDateTime" )
    @JsonProperty( "CapacityLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CapacityLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime capacityLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CapacityLastChangeDateTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityField<ZonedDateTime> CAPACITY_LAST_CHANGE_DATE_TIME =
        new WorkCenterCapacityField<ZonedDateTime>("CapacityLastChangeDateTime");
    /**
     * Navigation property <b>to_CapacityInterval</b> for <b>WorkCenterCapacity</b> to multiple
     * <b>WorkCenterCapacityInterval_2</b>.
     *
     */
    @SerializedName( "to_CapacityInterval" )
    @JsonProperty( "to_CapacityInterval" )
    @ODataField( odataName = "to_CapacityInterval" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterCapacityInterval_2> toCapacityInterval;
    /**
     * Navigation property <b>to_CapacityText</b> for <b>WorkCenterCapacity</b> to multiple
     * <b>WorkCenterCapacityText</b>.
     *
     */
    @SerializedName( "to_CapacityText" )
    @JsonProperty( "to_CapacityText" )
    @ODataField( odataName = "to_CapacityText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterCapacityText> toCapacityText;
    /**
     * Use with available fluent helpers to apply the <b>to_CapacityInterval</b> navigation property to query
     * operations.
     *
     */
    public final static WorkCenterCapacityLink<WorkCenterCapacityInterval_2> TO_CAPACITY_INTERVAL =
        new WorkCenterCapacityLink<WorkCenterCapacityInterval_2>("to_CapacityInterval");
    /**
     * Use with available fluent helpers to apply the <b>to_CapacityText</b> navigation property to query operations.
     *
     */
    public final static WorkCenterCapacityLink<WorkCenterCapacityText> TO_CAPACITY_TEXT =
        new WorkCenterCapacityLink<WorkCenterCapacityText>("to_CapacityText");

    @Nonnull
    @Override
    public Class<WorkCenterCapacity> getType()
    {
        return WorkCenterCapacity.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @param capacityInternalID
     *            Capacity ID
     */
    public void setCapacityInternalID( @Nullable final String capacityInternalID )
    {
        rememberChangedField("CapacityInternalID", this.capacityInternalID);
        this.capacityInternalID = capacityInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Capacity</b>
     * </p>
     *
     * @param capacity
     *            Capacity name
     */
    public void setCapacity( @Nullable final String capacity )
    {
        rememberChangedField("Capacity", this.capacity);
        this.capacity = capacity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryCode</b>
     * </p>
     *
     * @param capacityCategoryCode
     *            Capacity Category
     */
    public void setCapacityCategoryCode( @Nullable final String capacityCategoryCode )
    {
        rememberChangedField("CapacityCategoryCode", this.capacityCategoryCode);
        this.capacityCategoryCode = capacityCategoryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityActiveVersion</b>
     * </p>
     *
     * @param capacityActiveVersion
     *            Active Version of Available Capacity
     */
    public void setCapacityActiveVersion( @Nullable final String capacityActiveVersion )
    {
        rememberChangedField("CapacityActiveVersion", this.capacityActiveVersion);
        this.capacityActiveVersion = capacityActiveVersion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityIsFinite</b>
     * </p>
     *
     * @param capacityIsFinite
     *            Indicator: Capacity Relevant to Finite Scheduling
     */
    public void setCapacityIsFinite( @Nullable final Boolean capacityIsFinite )
    {
        rememberChangedField("CapacityIsFinite", this.capacityIsFinite);
        this.capacityIsFinite = capacityIsFinite;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityIsPooled</b>
     * </p>
     *
     * @param capacityIsPooled
     *            Pooled Capacity Indicator
     */
    public void setCapacityIsPooled( @Nullable final Boolean capacityIsPooled )
    {
        rememberChangedField("CapacityIsPooled", this.capacityIsPooled);
        this.capacityIsPooled = capacityIsPooled;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityHasIndivCapacities</b>
     * </p>
     *
     * @param capacityHasIndivCapacities
     *            Has Individual Capacities
     */
    public void setCapacityHasIndivCapacities( @Nullable final Boolean capacityHasIndivCapacities )
    {
        rememberChangedField("CapacityHasIndivCapacities", this.capacityHasIndivCapacities);
        this.capacityHasIndivCapacities = capacityHasIndivCapacities;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityIsExcldFrmLongTermPlng</b>
     * </p>
     *
     * @param capacityIsExcldFrmLongTermPlng
     *            Indicator: Capacity Excluded From Long-Term Planning
     */
    public void setCapacityIsExcldFrmLongTermPlng( @Nullable final Boolean capacityIsExcldFrmLongTermPlng )
    {
        rememberChangedField("CapacityIsExcldFrmLongTermPlng", this.capacityIsExcldFrmLongTermPlng);
        this.capacityIsExcldFrmLongTermPlng = capacityIsExcldFrmLongTermPlng;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityNumberOfCapacities</b>
     * </p>
     *
     * @param capacityNumberOfCapacities
     *            Number of Individual Capacities
     */
    public void setCapacityNumberOfCapacities( @Nullable final Short capacityNumberOfCapacities )
    {
        rememberChangedField("CapacityNumberOfCapacities", this.capacityNumberOfCapacities);
        this.capacityNumberOfCapacities = capacityNumberOfCapacities;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityResponsiblePlanner</b>
     * </p>
     *
     * @param capacityResponsiblePlanner
     *            Capacity Responsible Planner Group
     */
    public void setCapacityResponsiblePlanner( @Nullable final String capacityResponsiblePlanner )
    {
        rememberChangedField("CapacityResponsiblePlanner", this.capacityResponsiblePlanner);
        this.capacityResponsiblePlanner = capacityResponsiblePlanner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityPlanUtilizationPercent</b>
     * </p>
     *
     * @param capacityPlanUtilizationPercent
     *            Capacity Utilization Ratio in Percent
     */
    public void setCapacityPlanUtilizationPercent( @Nullable final String capacityPlanUtilizationPercent )
    {
        rememberChangedField("CapacityPlanUtilizationPercent", this.capacityPlanUtilizationPercent);
        this.capacityPlanUtilizationPercent = capacityPlanUtilizationPercent;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityBreakDuration</b>
     * </p>
     *
     * @param capacityBreakDuration
     *            Cumulative Break Duration in Seconds (internal)
     */
    public void setCapacityBreakDuration( @Nullable final Integer capacityBreakDuration )
    {
        rememberChangedField("CapacityBreakDuration", this.capacityBreakDuration);
        this.capacityBreakDuration = capacityBreakDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @param factoryCalendar
     *            Factory Calendar ID
     */
    public void setFactoryCalendar( @Nullable final String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @param authorizationGroup
     *            Authorization Group
     */
    public void setAuthorizationGroup( @Nullable final String authorizationGroup )
    {
        rememberChangedField("AuthorizationGroup", this.authorizationGroup);
        this.authorizationGroup = authorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShiftGroup</b>
     * </p>
     *
     * @param shiftGroup
     *            Grouping for Shift Definitions and Shift Sequences
     */
    public void setShiftGroup( @Nullable final String shiftGroup )
    {
        rememberChangedField("ShiftGroup", this.shiftGroup);
        this.shiftGroup = shiftGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityStartTime</b>
     * </p>
     *
     * @param capacityStartTime
     *            Start time in seconds (internal)
     */
    public void setCapacityStartTime( @Nullable final Integer capacityStartTime )
    {
        rememberChangedField("CapacityStartTime", this.capacityStartTime);
        this.capacityStartTime = capacityStartTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityEndTime</b>
     * </p>
     *
     * @param capacityEndTime
     *            End Time in Seconds (internal)
     */
    public void setCapacityEndTime( @Nullable final Integer capacityEndTime )
    {
        rememberChangedField("CapacityEndTime", this.capacityEndTime);
        this.capacityEndTime = capacityEndTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapIsUsedInMultiOperations</b>
     * </p>
     *
     * @param capIsUsedInMultiOperations
     *            Indicator: Several Operations Can Use Capacity
     */
    public void setCapIsUsedInMultiOperations( @Nullable final Boolean capIsUsedInMultiOperations )
    {
        rememberChangedField("CapIsUsedInMultiOperations", this.capIsUsedInMultiOperations);
        this.capIsUsedInMultiOperations = capIsUsedInMultiOperations;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ReferencedCapacityInternalID</b>
     * </p>
     *
     * @param referencedCapacityInternalID
     *            Referenced Capacity ID
     */
    public void setReferencedCapacityInternalID( @Nullable final String referencedCapacityInternalID )
    {
        rememberChangedField("ReferencedCapacityInternalID", this.referencedCapacityInternalID);
        this.referencedCapacityInternalID = referencedCapacityInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapOverloadThresholdInPercent</b>
     * </p>
     *
     * @param capOverloadThresholdInPercent
     *            Overload
     */
    public void setCapOverloadThresholdInPercent( @Nullable final String capOverloadThresholdInPercent )
    {
        rememberChangedField("CapOverloadThresholdInPercent", this.capOverloadThresholdInPercent);
        this.capOverloadThresholdInPercent = capOverloadThresholdInPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityQuantityUnit</b>
     * </p>
     *
     * @param capacityQuantityUnit
     *            Capacity Unit of Measure
     */
    public void setCapacityQuantityUnit( @Nullable final String capacityQuantityUnit )
    {
        rememberChangedField("CapacityQuantityUnit", this.capacityQuantityUnit);
        this.capacityQuantityUnit = capacityQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityBaseQtyUnit</b>
     * </p>
     *
     * @param capacityBaseQtyUnit
     *            Capacity Base Unit of Measure
     */
    public void setCapacityBaseQtyUnit( @Nullable final String capacityBaseQtyUnit )
    {
        rememberChangedField("CapacityBaseQtyUnit", this.capacityBaseQtyUnit);
        this.capacityBaseQtyUnit = capacityBaseQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CapacityLastChangeDateTime</b>
     * </p>
     *
     * @param capacityLastChangeDateTime
     *            Capacity Last Change Date Time
     */
    public void setCapacityLastChangeDateTime( @Nullable final ZonedDateTime capacityLastChangeDateTime )
    {
        rememberChangedField("CapacityLastChangeDateTime", this.capacityLastChangeDateTime);
        this.capacityLastChangeDateTime = capacityLastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenterCapacity";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CapacityInternalID", getCapacityInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CapacityInternalID", getCapacityInternalID());
        values.put("Capacity", getCapacity());
        values.put("CapacityCategoryCode", getCapacityCategoryCode());
        values.put("CapacityActiveVersion", getCapacityActiveVersion());
        values.put("CapacityIsFinite", getCapacityIsFinite());
        values.put("CapacityIsPooled", getCapacityIsPooled());
        values.put("CapacityHasIndivCapacities", getCapacityHasIndivCapacities());
        values.put("CapacityIsExcldFrmLongTermPlng", getCapacityIsExcldFrmLongTermPlng());
        values.put("CapacityNumberOfCapacities", getCapacityNumberOfCapacities());
        values.put("CapacityResponsiblePlanner", getCapacityResponsiblePlanner());
        values.put("CapacityPlanUtilizationPercent", getCapacityPlanUtilizationPercent());
        values.put("CapacityBreakDuration", getCapacityBreakDuration());
        values.put("Plant", getPlant());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("AuthorizationGroup", getAuthorizationGroup());
        values.put("ShiftGroup", getShiftGroup());
        values.put("CapacityStartTime", getCapacityStartTime());
        values.put("CapacityEndTime", getCapacityEndTime());
        values.put("CapIsUsedInMultiOperations", getCapIsUsedInMultiOperations());
        values.put("ReferencedCapacityInternalID", getReferencedCapacityInternalID());
        values.put("CapOverloadThresholdInPercent", getCapOverloadThresholdInPercent());
        values.put("CapacityQuantityUnit", getCapacityQuantityUnit());
        values.put("CapacityBaseQtyUnit", getCapacityBaseQtyUnit());
        values.put("CapacityLastChangeDateTime", getCapacityLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CapacityInternalID") ) {
                final Object value = values.remove("CapacityInternalID");
                if( (value == null) || (!value.equals(getCapacityInternalID())) ) {
                    setCapacityInternalID(((String) value));
                }
            }
            if( values.containsKey("Capacity") ) {
                final Object value = values.remove("Capacity");
                if( (value == null) || (!value.equals(getCapacity())) ) {
                    setCapacity(((String) value));
                }
            }
            if( values.containsKey("CapacityCategoryCode") ) {
                final Object value = values.remove("CapacityCategoryCode");
                if( (value == null) || (!value.equals(getCapacityCategoryCode())) ) {
                    setCapacityCategoryCode(((String) value));
                }
            }
            if( values.containsKey("CapacityActiveVersion") ) {
                final Object value = values.remove("CapacityActiveVersion");
                if( (value == null) || (!value.equals(getCapacityActiveVersion())) ) {
                    setCapacityActiveVersion(((String) value));
                }
            }
            if( values.containsKey("CapacityIsFinite") ) {
                final Object value = values.remove("CapacityIsFinite");
                if( (value == null) || (!value.equals(getCapacityIsFinite())) ) {
                    setCapacityIsFinite(((Boolean) value));
                }
            }
            if( values.containsKey("CapacityIsPooled") ) {
                final Object value = values.remove("CapacityIsPooled");
                if( (value == null) || (!value.equals(getCapacityIsPooled())) ) {
                    setCapacityIsPooled(((Boolean) value));
                }
            }
            if( values.containsKey("CapacityHasIndivCapacities") ) {
                final Object value = values.remove("CapacityHasIndivCapacities");
                if( (value == null) || (!value.equals(getCapacityHasIndivCapacities())) ) {
                    setCapacityHasIndivCapacities(((Boolean) value));
                }
            }
            if( values.containsKey("CapacityIsExcldFrmLongTermPlng") ) {
                final Object value = values.remove("CapacityIsExcldFrmLongTermPlng");
                if( (value == null) || (!value.equals(getCapacityIsExcldFrmLongTermPlng())) ) {
                    setCapacityIsExcldFrmLongTermPlng(((Boolean) value));
                }
            }
            if( values.containsKey("CapacityNumberOfCapacities") ) {
                final Object value = values.remove("CapacityNumberOfCapacities");
                if( (value == null) || (!value.equals(getCapacityNumberOfCapacities())) ) {
                    setCapacityNumberOfCapacities(((Short) value));
                }
            }
            if( values.containsKey("CapacityResponsiblePlanner") ) {
                final Object value = values.remove("CapacityResponsiblePlanner");
                if( (value == null) || (!value.equals(getCapacityResponsiblePlanner())) ) {
                    setCapacityResponsiblePlanner(((String) value));
                }
            }
            if( values.containsKey("CapacityPlanUtilizationPercent") ) {
                final Object value = values.remove("CapacityPlanUtilizationPercent");
                if( (value == null) || (!value.equals(getCapacityPlanUtilizationPercent())) ) {
                    setCapacityPlanUtilizationPercent(((String) value));
                }
            }
            if( values.containsKey("CapacityBreakDuration") ) {
                final Object value = values.remove("CapacityBreakDuration");
                if( (value == null) || (!value.equals(getCapacityBreakDuration())) ) {
                    setCapacityBreakDuration(((Integer) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((String) value));
                }
            }
            if( values.containsKey("AuthorizationGroup") ) {
                final Object value = values.remove("AuthorizationGroup");
                if( (value == null) || (!value.equals(getAuthorizationGroup())) ) {
                    setAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("ShiftGroup") ) {
                final Object value = values.remove("ShiftGroup");
                if( (value == null) || (!value.equals(getShiftGroup())) ) {
                    setShiftGroup(((String) value));
                }
            }
            if( values.containsKey("CapacityStartTime") ) {
                final Object value = values.remove("CapacityStartTime");
                if( (value == null) || (!value.equals(getCapacityStartTime())) ) {
                    setCapacityStartTime(((Integer) value));
                }
            }
            if( values.containsKey("CapacityEndTime") ) {
                final Object value = values.remove("CapacityEndTime");
                if( (value == null) || (!value.equals(getCapacityEndTime())) ) {
                    setCapacityEndTime(((Integer) value));
                }
            }
            if( values.containsKey("CapIsUsedInMultiOperations") ) {
                final Object value = values.remove("CapIsUsedInMultiOperations");
                if( (value == null) || (!value.equals(getCapIsUsedInMultiOperations())) ) {
                    setCapIsUsedInMultiOperations(((Boolean) value));
                }
            }
            if( values.containsKey("ReferencedCapacityInternalID") ) {
                final Object value = values.remove("ReferencedCapacityInternalID");
                if( (value == null) || (!value.equals(getReferencedCapacityInternalID())) ) {
                    setReferencedCapacityInternalID(((String) value));
                }
            }
            if( values.containsKey("CapOverloadThresholdInPercent") ) {
                final Object value = values.remove("CapOverloadThresholdInPercent");
                if( (value == null) || (!value.equals(getCapOverloadThresholdInPercent())) ) {
                    setCapOverloadThresholdInPercent(((String) value));
                }
            }
            if( values.containsKey("CapacityQuantityUnit") ) {
                final Object value = values.remove("CapacityQuantityUnit");
                if( (value == null) || (!value.equals(getCapacityQuantityUnit())) ) {
                    setCapacityQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("CapacityBaseQtyUnit") ) {
                final Object value = values.remove("CapacityBaseQtyUnit");
                if( (value == null) || (!value.equals(getCapacityBaseQtyUnit())) ) {
                    setCapacityBaseQtyUnit(((String) value));
                }
            }
            if( values.containsKey("CapacityLastChangeDateTime") ) {
                final Object value = values.remove("CapacityLastChangeDateTime");
                if( (value == null) || (!value.equals(getCapacityLastChangeDateTime())) ) {
                    setCapacityLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CapacityInterval") ) {
                final Object value = (values).remove("to_CapacityInterval");
                if( value instanceof Iterable ) {
                    if( toCapacityInterval == null ) {
                        toCapacityInterval = Lists.newArrayList();
                    } else {
                        toCapacityInterval = Lists.newArrayList(toCapacityInterval);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterCapacityInterval_2 entity;
                        if( toCapacityInterval.size() > i ) {
                            entity = toCapacityInterval.get(i);
                        } else {
                            entity = new WorkCenterCapacityInterval_2();
                            toCapacityInterval.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CapacityText") ) {
                final Object value = (values).remove("to_CapacityText");
                if( value instanceof Iterable ) {
                    if( toCapacityText == null ) {
                        toCapacityText = Lists.newArrayList();
                    } else {
                        toCapacityText = Lists.newArrayList(toCapacityText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterCapacityText entity;
                        if( toCapacityText.size() > i ) {
                            entity = toCapacityText.get(i);
                        } else {
                            entity = new WorkCenterCapacityText();
                            toCapacityText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WorkCenterCapacityField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkCenterCapacityField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCenterCapacityField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCenterCapacityField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCapacityInterval != null ) {
            (values).put("to_CapacityInterval", toCapacityInterval);
        }
        if( toCapacityText != null ) {
            (values).put("to_CapacityText", toCapacityText);
        }
        return values;
    }

    /**
     * Fetches the <b>WorkCenterCapacityInterval_2</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_CapacityInterval</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterCapacityInterval_2</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapacityInterval_2> fetchCapacityInterval()
    {
        return fetchFieldAsList("to_CapacityInterval", WorkCenterCapacityInterval_2.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacityInterval_2</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CapacityInterval</b>.
     * <p>
     * If the navigation property <b>to_CapacityInterval</b> of a queried <b>WorkCenterCapacity</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapacityInterval_2</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapacityInterval_2> getCapacityIntervalOrFetch()
    {
        if( toCapacityInterval == null ) {
            toCapacityInterval = fetchCapacityInterval();
        }
        return toCapacityInterval;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacityInterval_2</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CapacityInterval</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenterCapacity</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CapacityInterval</b> is already loaded, the result will
     *         contain the <b>WorkCenterCapacityInterval_2</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterCapacityInterval_2>> getCapacityIntervalIfPresent()
    {
        return Option.of(toCapacityInterval);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterCapacityInterval_2</b> entities for the loaded navigation property
     * <b>to_CapacityInterval</b>.
     * <p>
     * If the navigation property <b>to_CapacityInterval</b> of a queried <b>WorkCenterCapacity</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterCapacityInterval_2</b> entities.
     */
    public void setCapacityInterval( @Nonnull final List<WorkCenterCapacityInterval_2> value )
    {
        if( toCapacityInterval == null ) {
            toCapacityInterval = Lists.newArrayList();
        }
        toCapacityInterval.clear();
        toCapacityInterval.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterCapacityInterval_2</b> entities. This corresponds to the
     * OData navigation property <b>to_CapacityInterval</b>.
     * <p>
     * If the navigation property <b>to_CapacityInterval</b> of a queried <b>WorkCenterCapacity</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterCapacityInterval_2</b> entities.
     */
    public void addCapacityInterval( WorkCenterCapacityInterval_2... entity )
    {
        if( toCapacityInterval == null ) {
            toCapacityInterval = Lists.newArrayList();
        }
        toCapacityInterval.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WorkCenterCapacityText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CapacityText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterCapacityText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapacityText> fetchCapacityText()
    {
        return fetchFieldAsList("to_CapacityText", WorkCenterCapacityText.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacityText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CapacityText</b>.
     * <p>
     * If the navigation property <b>to_CapacityText</b> of a queried <b>WorkCenterCapacity</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapacityText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapacityText> getCapacityTextOrFetch()
    {
        if( toCapacityText == null ) {
            toCapacityText = fetchCapacityText();
        }
        return toCapacityText;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacityText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CapacityText</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenterCapacity</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CapacityText</b> is already loaded, the result will
     *         contain the <b>WorkCenterCapacityText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterCapacityText>> getCapacityTextIfPresent()
    {
        return Option.of(toCapacityText);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterCapacityText</b> entities for the loaded navigation property
     * <b>to_CapacityText</b>.
     * <p>
     * If the navigation property <b>to_CapacityText</b> of a queried <b>WorkCenterCapacity</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterCapacityText</b> entities.
     */
    public void setCapacityText( @Nonnull final List<WorkCenterCapacityText> value )
    {
        if( toCapacityText == null ) {
            toCapacityText = Lists.newArrayList();
        }
        toCapacityText.clear();
        toCapacityText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterCapacityText</b> entities. This corresponds to the OData
     * navigation property <b>to_CapacityText</b>.
     * <p>
     * If the navigation property <b>to_CapacityText</b> of a queried <b>WorkCenterCapacity</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterCapacityText</b> entities.
     */
    public void addCapacityText( WorkCenterCapacityText... entity )
    {
        if( toCapacityText == null ) {
            toCapacityText = Lists.newArrayList();
        }
        toCapacityText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WorkCenterCapacity instances.
     *
     */
    public final static class WorkCenterCapacityBuilder
    {

        private List<WorkCenterCapacityInterval_2> toCapacityInterval = Lists.newArrayList();
        private List<WorkCenterCapacityText> toCapacityText = Lists.newArrayList();

        private WorkCenterCapacity.WorkCenterCapacityBuilder toCapacityInterval(
            final List<WorkCenterCapacityInterval_2> value )
        {
            toCapacityInterval.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CapacityInterval</b> for <b>WorkCenterCapacity</b> to multiple
         * <b>WorkCenterCapacityInterval_2</b>.
         *
         * @param value
         *            The WorkCenterCapacityInterval_2s to build this WorkCenterCapacity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenterCapacity.WorkCenterCapacityBuilder capacityInterval( WorkCenterCapacityInterval_2... value )
        {
            return toCapacityInterval(Lists.newArrayList(value));
        }

        private WorkCenterCapacity.WorkCenterCapacityBuilder toCapacityText( final List<WorkCenterCapacityText> value )
        {
            toCapacityText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CapacityText</b> for <b>WorkCenterCapacity</b> to multiple
         * <b>WorkCenterCapacityText</b>.
         *
         * @param value
         *            The WorkCenterCapacityTexts to build this WorkCenterCapacity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenterCapacity.WorkCenterCapacityBuilder capacityText( WorkCenterCapacityText... value )
        {
            return toCapacityText(Lists.newArrayList(value));
        }

    }

}
