/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapacityIntervalField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapacityIntervalLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapacityIntervalSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Capacity Interval
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCenterCapacityIntervalType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenterCapacityInterval extends VdmEntity<WorkCenterCapacityInterval>
{

    /**
     * Selector for all available fields of WorkCenterCapacityInterval.
     *
     */
    public final static WorkCenterCapacityIntervalSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the resource
     */
    @Key
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalField<String> WORK_CENTER_INTERNAL_ID =
        new WorkCenterCapacityIntervalField<String>("WorkCenterInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @Key
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalField<String> WORK_CENTER_TYPE_CODE =
        new WorkCenterCapacityIntervalField<String>("WorkCenterTypeCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryAllocation</b>
     * </p>
     *
     * @return Capacity Category Allocation
     */
    @Key
    @SerializedName( "CapacityCategoryAllocation" )
    @JsonProperty( "CapacityCategoryAllocation" )
    @Nullable
    @ODataField( odataName = "CapacityCategoryAllocation" )
    private String capacityCategoryAllocation;
    /**
     * Use with available fluent helpers to apply the <b>CapacityCategoryAllocation</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalField<String> CAPACITY_CATEGORY_ALLOCATION =
        new WorkCenterCapacityIntervalField<String>("CapacityCategoryAllocation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @return Capacity ID
     */
    @Key
    @SerializedName( "CapacityInternalID" )
    @JsonProperty( "CapacityInternalID" )
    @Nullable
    @ODataField( odataName = "CapacityInternalID" )
    private String capacityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CapacityInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalField<String> CAPACITY_INTERNAL_ID =
        new WorkCenterCapacityIntervalField<String>("CapacityInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityActiveVersion</b>
     * </p>
     *
     * @return The capacityActiveVersion contained in this entity.
     */
    @Key
    @SerializedName( "CapacityActiveVersion" )
    @JsonProperty( "CapacityActiveVersion" )
    @Nullable
    @ODataField( odataName = "CapacityActiveVersion" )
    private String capacityActiveVersion;
    /**
     * Use with available fluent helpers to apply the <b>CapacityActiveVersion</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalField<String> CAPACITY_ACTIVE_VERSION =
        new WorkCenterCapacityIntervalField<String>("CapacityActiveVersion");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalEndDate</b>
     * </p>
     *
     * @return The intervalEndDate contained in this entity.
     */
    @Key
    @SerializedName( "IntervalEndDate" )
    @JsonProperty( "IntervalEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "IntervalEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime intervalEndDate;
    /**
     * Use with available fluent helpers to apply the <b>IntervalEndDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalField<LocalDateTime> INTERVAL_END_DATE =
        new WorkCenterCapacityIntervalField<LocalDateTime>("IntervalEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalStartDate</b>
     * </p>
     *
     * @return The intervalStartDate contained in this entity.
     */
    @SerializedName( "IntervalStartDate" )
    @JsonProperty( "IntervalStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "IntervalStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime intervalStartDate;
    /**
     * Use with available fluent helpers to apply the <b>IntervalStartDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalField<LocalDateTime> INTERVAL_START_DATE =
        new WorkCenterCapacityIntervalField<LocalDateTime>("IntervalStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalField<String> WORK_CENTER =
        new WorkCenterCapacityIntervalField<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalField<String> PLANT =
        new WorkCenterCapacityIntervalField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkDayRule</b>
     * </p>
     *
     * @return The workDayRule contained in this entity.
     */
    @SerializedName( "WorkDayRule" )
    @JsonProperty( "WorkDayRule" )
    @Nullable
    @ODataField( odataName = "WorkDayRule" )
    private String workDayRule;
    /**
     * Use with available fluent helpers to apply the <b>WorkDayRule</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalField<String> WORK_DAY_RULE =
        new WorkCenterCapacityIntervalField<String>("WorkDayRule");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AvailableCapacityIntervalDurn</b>
     * </p>
     *
     * @return Duration of an Available Capacity Interval
     */
    @SerializedName( "AvailableCapacityIntervalDurn" )
    @JsonProperty( "AvailableCapacityIntervalDurn" )
    @Nullable
    @ODataField( odataName = "AvailableCapacityIntervalDurn" )
    private String availableCapacityIntervalDurn;
    /**
     * Use with available fluent helpers to apply the <b>AvailableCapacityIntervalDurn</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalField<String> AVAILABLE_CAPACITY_INTERVAL_DURN =
        new WorkCenterCapacityIntervalField<String>("AvailableCapacityIntervalDurn");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftSequence</b>
     * </p>
     *
     * @return The shiftSequence contained in this entity.
     */
    @SerializedName( "ShiftSequence" )
    @JsonProperty( "ShiftSequence" )
    @Nullable
    @ODataField( odataName = "ShiftSequence" )
    private String shiftSequence;
    /**
     * Use with available fluent helpers to apply the <b>ShiftSequence</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalField<String> SHIFT_SEQUENCE =
        new WorkCenterCapacityIntervalField<String>("ShiftSequence");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StdAvailableCapacityIsValid</b>
     * </p>
     *
     * @return Ind.: Standard Available Capacity is Valid for this Interval
     */
    @SerializedName( "StdAvailableCapacityIsValid" )
    @JsonProperty( "StdAvailableCapacityIsValid" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "StdAvailableCapacityIsValid" )
    private Boolean stdAvailableCapacityIsValid;
    /**
     * Use with available fluent helpers to apply the <b>StdAvailableCapacityIsValid</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalField<Boolean> STD_AVAILABLE_CAPACITY_IS_VALID =
        new WorkCenterCapacityIntervalField<Boolean>("StdAvailableCapacityIsValid");
    /**
     * Navigation property <b>to_WorkCenterShift</b> for <b>WorkCenterCapacityInterval</b> to multiple
     * <b>WorkCenterCapacityShift</b>.
     *
     */
    @SerializedName( "to_WorkCenterShift" )
    @JsonProperty( "to_WorkCenterShift" )
    @ODataField( odataName = "to_WorkCenterShift" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterCapacityShift> toWorkCenterShift;
    /**
     * Use with available fluent helpers to apply the <b>to_WorkCenterShift</b> navigation property to query operations.
     *
     */
    public final static WorkCenterCapacityIntervalLink<WorkCenterCapacityShift> TO_WORK_CENTER_SHIFT =
        new WorkCenterCapacityIntervalLink<WorkCenterCapacityShift>("to_WorkCenterShift");

    @Nonnull
    @Override
    public Class<WorkCenterCapacityInterval> getType()
    {
        return WorkCenterCapacityInterval.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID of the resource
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryAllocation</b>
     * </p>
     *
     * @param capacityCategoryAllocation
     *            Capacity Category Allocation
     */
    public void setCapacityCategoryAllocation( @Nullable final String capacityCategoryAllocation )
    {
        rememberChangedField("CapacityCategoryAllocation", this.capacityCategoryAllocation);
        this.capacityCategoryAllocation = capacityCategoryAllocation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @param capacityInternalID
     *            Capacity ID
     */
    public void setCapacityInternalID( @Nullable final String capacityInternalID )
    {
        rememberChangedField("CapacityInternalID", this.capacityInternalID);
        this.capacityInternalID = capacityInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityActiveVersion</b>
     * </p>
     *
     * @param capacityActiveVersion
     *            The capacityActiveVersion to set.
     */
    public void setCapacityActiveVersion( @Nullable final String capacityActiveVersion )
    {
        rememberChangedField("CapacityActiveVersion", this.capacityActiveVersion);
        this.capacityActiveVersion = capacityActiveVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalEndDate</b>
     * </p>
     *
     * @param intervalEndDate
     *            The intervalEndDate to set.
     */
    public void setIntervalEndDate( @Nullable final LocalDateTime intervalEndDate )
    {
        rememberChangedField("IntervalEndDate", this.intervalEndDate);
        this.intervalEndDate = intervalEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalStartDate</b>
     * </p>
     *
     * @param intervalStartDate
     *            The intervalStartDate to set.
     */
    public void setIntervalStartDate( @Nullable final LocalDateTime intervalStartDate )
    {
        rememberChangedField("IntervalStartDate", this.intervalStartDate);
        this.intervalStartDate = intervalStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkDayRule</b>
     * </p>
     *
     * @param workDayRule
     *            The workDayRule to set.
     */
    public void setWorkDayRule( @Nullable final String workDayRule )
    {
        rememberChangedField("WorkDayRule", this.workDayRule);
        this.workDayRule = workDayRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AvailableCapacityIntervalDurn</b>
     * </p>
     *
     * @param availableCapacityIntervalDurn
     *            Duration of an Available Capacity Interval
     */
    public void setAvailableCapacityIntervalDurn( @Nullable final String availableCapacityIntervalDurn )
    {
        rememberChangedField("AvailableCapacityIntervalDurn", this.availableCapacityIntervalDurn);
        this.availableCapacityIntervalDurn = availableCapacityIntervalDurn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftSequence</b>
     * </p>
     *
     * @param shiftSequence
     *            The shiftSequence to set.
     */
    public void setShiftSequence( @Nullable final String shiftSequence )
    {
        rememberChangedField("ShiftSequence", this.shiftSequence);
        this.shiftSequence = shiftSequence;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StdAvailableCapacityIsValid</b>
     * </p>
     *
     * @param stdAvailableCapacityIsValid
     *            Ind.: Standard Available Capacity is Valid for this Interval
     */
    public void setStdAvailableCapacityIsValid( @Nullable final Boolean stdAvailableCapacityIsValid )
    {
        rememberChangedField("StdAvailableCapacityIsValid", this.stdAvailableCapacityIsValid);
        this.stdAvailableCapacityIsValid = stdAvailableCapacityIsValid;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenterCapacityInterval";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WorkCenterInternalID", getWorkCenterInternalID());
        result.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        result.put("CapacityCategoryAllocation", getCapacityCategoryAllocation());
        result.put("CapacityInternalID", getCapacityInternalID());
        result.put("CapacityActiveVersion", getCapacityActiveVersion());
        result.put("IntervalEndDate", getIntervalEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("CapacityCategoryAllocation", getCapacityCategoryAllocation());
        values.put("CapacityInternalID", getCapacityInternalID());
        values.put("CapacityActiveVersion", getCapacityActiveVersion());
        values.put("IntervalEndDate", getIntervalEndDate());
        values.put("IntervalStartDate", getIntervalStartDate());
        values.put("WorkCenter", getWorkCenter());
        values.put("Plant", getPlant());
        values.put("WorkDayRule", getWorkDayRule());
        values.put("AvailableCapacityIntervalDurn", getAvailableCapacityIntervalDurn());
        values.put("ShiftSequence", getShiftSequence());
        values.put("StdAvailableCapacityIsValid", getStdAvailableCapacityIsValid());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("CapacityCategoryAllocation") ) {
                final Object value = values.remove("CapacityCategoryAllocation");
                if( (value == null) || (!value.equals(getCapacityCategoryAllocation())) ) {
                    setCapacityCategoryAllocation(((String) value));
                }
            }
            if( values.containsKey("CapacityInternalID") ) {
                final Object value = values.remove("CapacityInternalID");
                if( (value == null) || (!value.equals(getCapacityInternalID())) ) {
                    setCapacityInternalID(((String) value));
                }
            }
            if( values.containsKey("CapacityActiveVersion") ) {
                final Object value = values.remove("CapacityActiveVersion");
                if( (value == null) || (!value.equals(getCapacityActiveVersion())) ) {
                    setCapacityActiveVersion(((String) value));
                }
            }
            if( values.containsKey("IntervalEndDate") ) {
                final Object value = values.remove("IntervalEndDate");
                if( (value == null) || (!value.equals(getIntervalEndDate())) ) {
                    setIntervalEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("IntervalStartDate") ) {
                final Object value = values.remove("IntervalStartDate");
                if( (value == null) || (!value.equals(getIntervalStartDate())) ) {
                    setIntervalStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("WorkDayRule") ) {
                final Object value = values.remove("WorkDayRule");
                if( (value == null) || (!value.equals(getWorkDayRule())) ) {
                    setWorkDayRule(((String) value));
                }
            }
            if( values.containsKey("AvailableCapacityIntervalDurn") ) {
                final Object value = values.remove("AvailableCapacityIntervalDurn");
                if( (value == null) || (!value.equals(getAvailableCapacityIntervalDurn())) ) {
                    setAvailableCapacityIntervalDurn(((String) value));
                }
            }
            if( values.containsKey("ShiftSequence") ) {
                final Object value = values.remove("ShiftSequence");
                if( (value == null) || (!value.equals(getShiftSequence())) ) {
                    setShiftSequence(((String) value));
                }
            }
            if( values.containsKey("StdAvailableCapacityIsValid") ) {
                final Object value = values.remove("StdAvailableCapacityIsValid");
                if( (value == null) || (!value.equals(getStdAvailableCapacityIsValid())) ) {
                    setStdAvailableCapacityIsValid(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_WorkCenterShift") ) {
                final Object value = (values).remove("to_WorkCenterShift");
                if( value instanceof Iterable ) {
                    if( toWorkCenterShift == null ) {
                        toWorkCenterShift = Lists.newArrayList();
                    } else {
                        toWorkCenterShift = Lists.newArrayList(toWorkCenterShift);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterCapacityShift entity;
                        if( toWorkCenterShift.size() > i ) {
                            entity = toWorkCenterShift.get(i);
                        } else {
                            entity = new WorkCenterCapacityShift();
                            toWorkCenterShift.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WorkCenterCapacityIntervalField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new WorkCenterCapacityIntervalField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCenterCapacityIntervalField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCenterCapacityIntervalField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toWorkCenterShift != null ) {
            (values).put("to_WorkCenterShift", toWorkCenterShift);
        }
        return values;
    }

    /**
     * Fetches the <b>WorkCenterCapacityShift</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_WorkCenterShift</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterCapacityShift</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapacityShift> fetchWorkCenterShift()
    {
        return fetchFieldAsList("to_WorkCenterShift", WorkCenterCapacityShift.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacityShift</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterShift</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterShift</b> of a queried <b>WorkCenterCapacityInterval</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapacityShift</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapacityShift> getWorkCenterShiftOrFetch()
    {
        if( toWorkCenterShift == null ) {
            toWorkCenterShift = fetchWorkCenterShift();
        }
        return toWorkCenterShift;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacityShift</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterShift</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenterCapacityInterval</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WorkCenterShift</b> is already loaded, the result will
     *         contain the <b>WorkCenterCapacityShift</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterCapacityShift>> getWorkCenterShiftIfPresent()
    {
        return Option.of(toWorkCenterShift);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterCapacityShift</b> entities for the loaded navigation property
     * <b>to_WorkCenterShift</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterShift</b> of a queried <b>WorkCenterCapacityInterval</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterCapacityShift</b> entities.
     */
    public void setWorkCenterShift( @Nonnull final List<WorkCenterCapacityShift> value )
    {
        if( toWorkCenterShift == null ) {
            toWorkCenterShift = Lists.newArrayList();
        }
        toWorkCenterShift.clear();
        toWorkCenterShift.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterCapacityShift</b> entities. This corresponds to the OData
     * navigation property <b>to_WorkCenterShift</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterShift</b> of a queried <b>WorkCenterCapacityInterval</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterCapacityShift</b> entities.
     */
    public void addWorkCenterShift( WorkCenterCapacityShift... entity )
    {
        if( toWorkCenterShift == null ) {
            toWorkCenterShift = Lists.newArrayList();
        }
        toWorkCenterShift.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WorkCenterCapacityInterval instances.
     *
     */
    public final static class WorkCenterCapacityIntervalBuilder
    {

        private List<WorkCenterCapacityShift> toWorkCenterShift = Lists.newArrayList();

        private WorkCenterCapacityInterval.WorkCenterCapacityIntervalBuilder toWorkCenterShift(
            final List<WorkCenterCapacityShift> value )
        {
            toWorkCenterShift.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WorkCenterShift</b> for <b>WorkCenterCapacityInterval</b> to multiple
         * <b>WorkCenterCapacityShift</b>.
         *
         * @param value
         *            The WorkCenterCapacityShifts to build this WorkCenterCapacityInterval with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenterCapacityInterval.WorkCenterCapacityIntervalBuilder workCenterShift(
            WorkCenterCapacityShift... value )
        {
            return toWorkCenterShift(Lists.newArrayList(value));
        }

    }

}
