/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapacityIntervalSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
 * WorkCenterCapacityInterval} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class WorkCenterCapacityIntervalByKeyFluentHelper
    extends
    FluentHelperByKey<WorkCenterCapacityIntervalByKeyFluentHelper, WorkCenterCapacityInterval, WorkCenterCapacityIntervalSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     * WorkCenterCapacityInterval} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WorkCenterCapacityInterval}
     * @param capacityInternalID
     *            Capacity ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param capacityCategoryAllocation
     *            Capacity Category Allocation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code WorkCenterCapacityInterval}
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param intervalEndDate
     *
     * @param workCenterInternalID
     *            Object ID of the resource
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param capacityActiveVersion
     *
     */
    public WorkCenterCapacityIntervalByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String workCenterInternalID,
        final String workCenterTypeCode,
        final String capacityCategoryAllocation,
        final String capacityInternalID,
        final String capacityActiveVersion,
        final LocalDateTime intervalEndDate )
    {
        super(servicePath, entityCollection);
        this.key.put("WorkCenterInternalID", workCenterInternalID);
        this.key.put("WorkCenterTypeCode", workCenterTypeCode);
        this.key.put("CapacityCategoryAllocation", capacityCategoryAllocation);
        this.key.put("CapacityInternalID", capacityInternalID);
        this.key.put("CapacityActiveVersion", capacityActiveVersion);
        this.key.put("IntervalEndDate", intervalEndDate);
    }

    @Override
    @Nonnull
    protected Class<WorkCenterCapacityInterval> getEntityClass()
    {
        return WorkCenterCapacityInterval.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
