/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapacityInterval_2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapacityInterval_2Link;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapacityInterval_2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Capacity Interval Version 2
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCenterCapacityInterval_2Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenterCapacityInterval_2 extends VdmEntity<WorkCenterCapacityInterval_2>
{

    /**
     * Selector for all available fields of WorkCenterCapacityInterval_2.
     *
     */
    public final static WorkCenterCapacityInterval_2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @return Capacity ID
     */
    @Key
    @SerializedName( "CapacityInternalID" )
    @JsonProperty( "CapacityInternalID" )
    @Nullable
    @ODataField( odataName = "CapacityInternalID" )
    private String capacityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CapacityInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityInterval_2Field<String> CAPACITY_INTERNAL_ID =
        new WorkCenterCapacityInterval_2Field<String>("CapacityInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityActiveVersion</b>
     * </p>
     *
     * @return The capacityActiveVersion contained in this entity.
     */
    @Key
    @SerializedName( "CapacityActiveVersion" )
    @JsonProperty( "CapacityActiveVersion" )
    @Nullable
    @ODataField( odataName = "CapacityActiveVersion" )
    private String capacityActiveVersion;
    /**
     * Use with available fluent helpers to apply the <b>CapacityActiveVersion</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityInterval_2Field<String> CAPACITY_ACTIVE_VERSION =
        new WorkCenterCapacityInterval_2Field<String>("CapacityActiveVersion");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalEndDate</b>
     * </p>
     *
     * @return The intervalEndDate contained in this entity.
     */
    @Key
    @SerializedName( "IntervalEndDate" )
    @JsonProperty( "IntervalEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "IntervalEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime intervalEndDate;
    /**
     * Use with available fluent helpers to apply the <b>IntervalEndDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityInterval_2Field<LocalDateTime> INTERVAL_END_DATE =
        new WorkCenterCapacityInterval_2Field<LocalDateTime>("IntervalEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "IntervalStartDate" )
    @JsonProperty( "IntervalStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "IntervalStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime intervalStartDate;
    /**
     * Use with available fluent helpers to apply the <b>IntervalStartDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityInterval_2Field<LocalDateTime> INTERVAL_START_DATE =
        new WorkCenterCapacityInterval_2Field<LocalDateTime>("IntervalStartDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StdAvailableCapacityIsValid</b>
     * </p>
     *
     * @return Ind.: Standard Available Capacity is Valid for this Interval
     */
    @SerializedName( "StdAvailableCapacityIsValid" )
    @JsonProperty( "StdAvailableCapacityIsValid" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "StdAvailableCapacityIsValid" )
    private Boolean stdAvailableCapacityIsValid;
    /**
     * Use with available fluent helpers to apply the <b>StdAvailableCapacityIsValid</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityInterval_2Field<Boolean> STD_AVAILABLE_CAPACITY_IS_VALID =
        new WorkCenterCapacityInterval_2Field<Boolean>("StdAvailableCapacityIsValid");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AvailableCapacityIntervalDurn</b>
     * </p>
     *
     * @return Duration of an Available Capacity Interval
     */
    @SerializedName( "AvailableCapacityIntervalDurn" )
    @JsonProperty( "AvailableCapacityIntervalDurn" )
    @Nullable
    @ODataField( odataName = "AvailableCapacityIntervalDurn" )
    private String availableCapacityIntervalDurn;
    /**
     * Use with available fluent helpers to apply the <b>AvailableCapacityIntervalDurn</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityInterval_2Field<String> AVAILABLE_CAPACITY_INTERVAL_DURN =
        new WorkCenterCapacityInterval_2Field<String>("AvailableCapacityIntervalDurn");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftSequence</b>
     * </p>
     *
     * @return The shiftSequence contained in this entity.
     */
    @SerializedName( "ShiftSequence" )
    @JsonProperty( "ShiftSequence" )
    @Nullable
    @ODataField( odataName = "ShiftSequence" )
    private String shiftSequence;
    /**
     * Use with available fluent helpers to apply the <b>ShiftSequence</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityInterval_2Field<String> SHIFT_SEQUENCE =
        new WorkCenterCapacityInterval_2Field<String>("ShiftSequence");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkDayRule</b>
     * </p>
     *
     * @return The workDayRule contained in this entity.
     */
    @SerializedName( "WorkDayRule" )
    @JsonProperty( "WorkDayRule" )
    @Nullable
    @ODataField( odataName = "WorkDayRule" )
    private String workDayRule;
    /**
     * Use with available fluent helpers to apply the <b>WorkDayRule</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityInterval_2Field<String> WORK_DAY_RULE =
        new WorkCenterCapacityInterval_2Field<String>("WorkDayRule");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CapacityNumberOfShifts</b>
     * </p>
     *
     * @return The capacityNumberOfShifts contained in this entity.
     */
    @SerializedName( "CapacityNumberOfShifts" )
    @JsonProperty( "CapacityNumberOfShifts" )
    @Nullable
    @ODataField( odataName = "CapacityNumberOfShifts" )
    private String capacityNumberOfShifts;
    /**
     * Use with available fluent helpers to apply the <b>CapacityNumberOfShifts</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityInterval_2Field<String> CAPACITY_NUMBER_OF_SHIFTS =
        new WorkCenterCapacityInterval_2Field<String>("CapacityNumberOfShifts");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityNumberOfCapacities</b>
     * </p>
     *
     * @return Number of Individual Capacities
     */
    @SerializedName( "CapacityNumberOfCapacities" )
    @JsonProperty( "CapacityNumberOfCapacities" )
    @Nullable
    @ODataField( odataName = "CapacityNumberOfCapacities" )
    private Short capacityNumberOfCapacities;
    /**
     * Use with available fluent helpers to apply the <b>CapacityNumberOfCapacities</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityInterval_2Field<Short> CAPACITY_NUMBER_OF_CAPACITIES =
        new WorkCenterCapacityInterval_2Field<Short>("CapacityNumberOfCapacities");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityPlanUtilizationPercent</b>
     * </p>
     *
     * @return Capacity Utilization Ratio in Percent
     */
    @SerializedName( "CapacityPlanUtilizationPercent" )
    @JsonProperty( "CapacityPlanUtilizationPercent" )
    @Nullable
    @ODataField( odataName = "CapacityPlanUtilizationPercent" )
    private String capacityPlanUtilizationPercent;
    /**
     * Use with available fluent helpers to apply the <b>CapacityPlanUtilizationPercent</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityInterval_2Field<String> CAPACITY_PLAN_UTILIZATION_PERCENT =
        new WorkCenterCapacityInterval_2Field<String>("CapacityPlanUtilizationPercent");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CapacityLastChangeDateTime</b>
     * </p>
     *
     * @return Capacity Last Change Date Time
     */
    @SerializedName( "CapacityLastChangeDateTime" )
    @JsonProperty( "CapacityLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CapacityLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime capacityLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CapacityLastChangeDateTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityInterval_2Field<ZonedDateTime> CAPACITY_LAST_CHANGE_DATE_TIME =
        new WorkCenterCapacityInterval_2Field<ZonedDateTime>("CapacityLastChangeDateTime");
    /**
     * Navigation property <b>to_CapacityShift</b> for <b>WorkCenterCapacityInterval_2</b> to multiple
     * <b>WorkCenterCapacityShift_2</b>.
     *
     */
    @SerializedName( "to_CapacityShift" )
    @JsonProperty( "to_CapacityShift" )
    @ODataField( odataName = "to_CapacityShift" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterCapacityShift_2> toCapacityShift;
    /**
     * Use with available fluent helpers to apply the <b>to_CapacityShift</b> navigation property to query operations.
     *
     */
    public final static WorkCenterCapacityInterval_2Link<WorkCenterCapacityShift_2> TO_CAPACITY_SHIFT =
        new WorkCenterCapacityInterval_2Link<WorkCenterCapacityShift_2>("to_CapacityShift");

    @Nonnull
    @Override
    public Class<WorkCenterCapacityInterval_2> getType()
    {
        return WorkCenterCapacityInterval_2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @param capacityInternalID
     *            Capacity ID
     */
    public void setCapacityInternalID( @Nullable final String capacityInternalID )
    {
        rememberChangedField("CapacityInternalID", this.capacityInternalID);
        this.capacityInternalID = capacityInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityActiveVersion</b>
     * </p>
     *
     * @param capacityActiveVersion
     *            The capacityActiveVersion to set.
     */
    public void setCapacityActiveVersion( @Nullable final String capacityActiveVersion )
    {
        rememberChangedField("CapacityActiveVersion", this.capacityActiveVersion);
        this.capacityActiveVersion = capacityActiveVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalEndDate</b>
     * </p>
     *
     * @param intervalEndDate
     *            The intervalEndDate to set.
     */
    public void setIntervalEndDate( @Nullable final LocalDateTime intervalEndDate )
    {
        rememberChangedField("IntervalEndDate", this.intervalEndDate);
        this.intervalEndDate = intervalEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalStartDate</b>
     * </p>
     *
     * @param intervalStartDate
     *            Valid-From Date
     */
    public void setIntervalStartDate( @Nullable final LocalDateTime intervalStartDate )
    {
        rememberChangedField("IntervalStartDate", this.intervalStartDate);
        this.intervalStartDate = intervalStartDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>StdAvailableCapacityIsValid</b>
     * </p>
     *
     * @param stdAvailableCapacityIsValid
     *            Ind.: Standard Available Capacity is Valid for this Interval
     */
    public void setStdAvailableCapacityIsValid( @Nullable final Boolean stdAvailableCapacityIsValid )
    {
        rememberChangedField("StdAvailableCapacityIsValid", this.stdAvailableCapacityIsValid);
        this.stdAvailableCapacityIsValid = stdAvailableCapacityIsValid;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AvailableCapacityIntervalDurn</b>
     * </p>
     *
     * @param availableCapacityIntervalDurn
     *            Duration of an Available Capacity Interval
     */
    public void setAvailableCapacityIntervalDurn( @Nullable final String availableCapacityIntervalDurn )
    {
        rememberChangedField("AvailableCapacityIntervalDurn", this.availableCapacityIntervalDurn);
        this.availableCapacityIntervalDurn = availableCapacityIntervalDurn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftSequence</b>
     * </p>
     *
     * @param shiftSequence
     *            The shiftSequence to set.
     */
    public void setShiftSequence( @Nullable final String shiftSequence )
    {
        rememberChangedField("ShiftSequence", this.shiftSequence);
        this.shiftSequence = shiftSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkDayRule</b>
     * </p>
     *
     * @param workDayRule
     *            The workDayRule to set.
     */
    public void setWorkDayRule( @Nullable final String workDayRule )
    {
        rememberChangedField("WorkDayRule", this.workDayRule);
        this.workDayRule = workDayRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CapacityNumberOfShifts</b>
     * </p>
     *
     * @param capacityNumberOfShifts
     *            The capacityNumberOfShifts to set.
     */
    public void setCapacityNumberOfShifts( @Nullable final String capacityNumberOfShifts )
    {
        rememberChangedField("CapacityNumberOfShifts", this.capacityNumberOfShifts);
        this.capacityNumberOfShifts = capacityNumberOfShifts;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityNumberOfCapacities</b>
     * </p>
     *
     * @param capacityNumberOfCapacities
     *            Number of Individual Capacities
     */
    public void setCapacityNumberOfCapacities( @Nullable final Short capacityNumberOfCapacities )
    {
        rememberChangedField("CapacityNumberOfCapacities", this.capacityNumberOfCapacities);
        this.capacityNumberOfCapacities = capacityNumberOfCapacities;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityPlanUtilizationPercent</b>
     * </p>
     *
     * @param capacityPlanUtilizationPercent
     *            Capacity Utilization Ratio in Percent
     */
    public void setCapacityPlanUtilizationPercent( @Nullable final String capacityPlanUtilizationPercent )
    {
        rememberChangedField("CapacityPlanUtilizationPercent", this.capacityPlanUtilizationPercent);
        this.capacityPlanUtilizationPercent = capacityPlanUtilizationPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CapacityLastChangeDateTime</b>
     * </p>
     *
     * @param capacityLastChangeDateTime
     *            Capacity Last Change Date Time
     */
    public void setCapacityLastChangeDateTime( @Nullable final ZonedDateTime capacityLastChangeDateTime )
    {
        rememberChangedField("CapacityLastChangeDateTime", this.capacityLastChangeDateTime);
        this.capacityLastChangeDateTime = capacityLastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenterCapacityInterval_2";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CapacityInternalID", getCapacityInternalID());
        result.put("CapacityActiveVersion", getCapacityActiveVersion());
        result.put("IntervalEndDate", getIntervalEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CapacityInternalID", getCapacityInternalID());
        values.put("CapacityActiveVersion", getCapacityActiveVersion());
        values.put("IntervalEndDate", getIntervalEndDate());
        values.put("IntervalStartDate", getIntervalStartDate());
        values.put("StdAvailableCapacityIsValid", getStdAvailableCapacityIsValid());
        values.put("AvailableCapacityIntervalDurn", getAvailableCapacityIntervalDurn());
        values.put("ShiftSequence", getShiftSequence());
        values.put("WorkDayRule", getWorkDayRule());
        values.put("CapacityNumberOfShifts", getCapacityNumberOfShifts());
        values.put("CapacityNumberOfCapacities", getCapacityNumberOfCapacities());
        values.put("CapacityPlanUtilizationPercent", getCapacityPlanUtilizationPercent());
        values.put("CapacityLastChangeDateTime", getCapacityLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CapacityInternalID") ) {
                final Object value = values.remove("CapacityInternalID");
                if( (value == null) || (!value.equals(getCapacityInternalID())) ) {
                    setCapacityInternalID(((String) value));
                }
            }
            if( values.containsKey("CapacityActiveVersion") ) {
                final Object value = values.remove("CapacityActiveVersion");
                if( (value == null) || (!value.equals(getCapacityActiveVersion())) ) {
                    setCapacityActiveVersion(((String) value));
                }
            }
            if( values.containsKey("IntervalEndDate") ) {
                final Object value = values.remove("IntervalEndDate");
                if( (value == null) || (!value.equals(getIntervalEndDate())) ) {
                    setIntervalEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("IntervalStartDate") ) {
                final Object value = values.remove("IntervalStartDate");
                if( (value == null) || (!value.equals(getIntervalStartDate())) ) {
                    setIntervalStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("StdAvailableCapacityIsValid") ) {
                final Object value = values.remove("StdAvailableCapacityIsValid");
                if( (value == null) || (!value.equals(getStdAvailableCapacityIsValid())) ) {
                    setStdAvailableCapacityIsValid(((Boolean) value));
                }
            }
            if( values.containsKey("AvailableCapacityIntervalDurn") ) {
                final Object value = values.remove("AvailableCapacityIntervalDurn");
                if( (value == null) || (!value.equals(getAvailableCapacityIntervalDurn())) ) {
                    setAvailableCapacityIntervalDurn(((String) value));
                }
            }
            if( values.containsKey("ShiftSequence") ) {
                final Object value = values.remove("ShiftSequence");
                if( (value == null) || (!value.equals(getShiftSequence())) ) {
                    setShiftSequence(((String) value));
                }
            }
            if( values.containsKey("WorkDayRule") ) {
                final Object value = values.remove("WorkDayRule");
                if( (value == null) || (!value.equals(getWorkDayRule())) ) {
                    setWorkDayRule(((String) value));
                }
            }
            if( values.containsKey("CapacityNumberOfShifts") ) {
                final Object value = values.remove("CapacityNumberOfShifts");
                if( (value == null) || (!value.equals(getCapacityNumberOfShifts())) ) {
                    setCapacityNumberOfShifts(((String) value));
                }
            }
            if( values.containsKey("CapacityNumberOfCapacities") ) {
                final Object value = values.remove("CapacityNumberOfCapacities");
                if( (value == null) || (!value.equals(getCapacityNumberOfCapacities())) ) {
                    setCapacityNumberOfCapacities(((Short) value));
                }
            }
            if( values.containsKey("CapacityPlanUtilizationPercent") ) {
                final Object value = values.remove("CapacityPlanUtilizationPercent");
                if( (value == null) || (!value.equals(getCapacityPlanUtilizationPercent())) ) {
                    setCapacityPlanUtilizationPercent(((String) value));
                }
            }
            if( values.containsKey("CapacityLastChangeDateTime") ) {
                final Object value = values.remove("CapacityLastChangeDateTime");
                if( (value == null) || (!value.equals(getCapacityLastChangeDateTime())) ) {
                    setCapacityLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CapacityShift") ) {
                final Object value = (values).remove("to_CapacityShift");
                if( value instanceof Iterable ) {
                    if( toCapacityShift == null ) {
                        toCapacityShift = Lists.newArrayList();
                    } else {
                        toCapacityShift = Lists.newArrayList(toCapacityShift);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterCapacityShift_2 entity;
                        if( toCapacityShift.size() > i ) {
                            entity = toCapacityShift.get(i);
                        } else {
                            entity = new WorkCenterCapacityShift_2();
                            toCapacityShift.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WorkCenterCapacityInterval_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new WorkCenterCapacityInterval_2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCenterCapacityInterval_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCenterCapacityInterval_2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCapacityShift != null ) {
            (values).put("to_CapacityShift", toCapacityShift);
        }
        return values;
    }

    /**
     * Fetches the <b>WorkCenterCapacityShift_2</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CapacityShift</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterCapacityShift_2</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapacityShift_2> fetchCapacityShift()
    {
        return fetchFieldAsList("to_CapacityShift", WorkCenterCapacityShift_2.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacityShift_2</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CapacityShift</b>.
     * <p>
     * If the navigation property <b>to_CapacityShift</b> of a queried <b>WorkCenterCapacityInterval_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapacityShift_2</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCapacityShift_2> getCapacityShiftOrFetch()
    {
        if( toCapacityShift == null ) {
            toCapacityShift = fetchCapacityShift();
        }
        return toCapacityShift;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacityShift_2</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CapacityShift</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenterCapacityInterval_2</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CapacityShift</b> is already loaded, the result will
     *         contain the <b>WorkCenterCapacityShift_2</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterCapacityShift_2>> getCapacityShiftIfPresent()
    {
        return Option.of(toCapacityShift);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterCapacityShift_2</b> entities for the loaded navigation property
     * <b>to_CapacityShift</b>.
     * <p>
     * If the navigation property <b>to_CapacityShift</b> of a queried <b>WorkCenterCapacityInterval_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterCapacityShift_2</b> entities.
     */
    public void setCapacityShift( @Nonnull final List<WorkCenterCapacityShift_2> value )
    {
        if( toCapacityShift == null ) {
            toCapacityShift = Lists.newArrayList();
        }
        toCapacityShift.clear();
        toCapacityShift.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterCapacityShift_2</b> entities. This corresponds to the OData
     * navigation property <b>to_CapacityShift</b>.
     * <p>
     * If the navigation property <b>to_CapacityShift</b> of a queried <b>WorkCenterCapacityInterval_2</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterCapacityShift_2</b> entities.
     */
    public void addCapacityShift( WorkCenterCapacityShift_2... entity )
    {
        if( toCapacityShift == null ) {
            toCapacityShift = Lists.newArrayList();
        }
        toCapacityShift.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WorkCenterCapacityInterval_2 instances.
     *
     */
    public final static class WorkCenterCapacityInterval_2Builder
    {

        private List<WorkCenterCapacityShift_2> toCapacityShift = Lists.newArrayList();

        private WorkCenterCapacityInterval_2.WorkCenterCapacityInterval_2Builder toCapacityShift(
            final List<WorkCenterCapacityShift_2> value )
        {
            toCapacityShift.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CapacityShift</b> for <b>WorkCenterCapacityInterval_2</b> to multiple
         * <b>WorkCenterCapacityShift_2</b>.
         *
         * @param value
         *            The WorkCenterCapacityShift_2s to build this WorkCenterCapacityInterval_2 with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenterCapacityInterval_2.WorkCenterCapacityInterval_2Builder capacityShift(
            WorkCenterCapacityShift_2... value )
        {
            return toCapacityShift(Lists.newArrayList(value));
        }

    }

}
