/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapacityInterval_2Selectable;

/**
 * Fluent helper to fetch multiple
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
 * WorkCenterCapacityInterval_2} entities. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class WorkCenterCapacityInterval_2FluentHelper
    extends
    FluentHelperRead<WorkCenterCapacityInterval_2FluentHelper, WorkCenterCapacityInterval_2, WorkCenterCapacityInterval_2Selectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public WorkCenterCapacityInterval_2FluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<WorkCenterCapacityInterval_2> getEntityClass()
    {
        return WorkCenterCapacityInterval_2.class;
    }

}
