/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapacityShiftField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapacityShiftSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Capacity Shift
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCenterCapacityShiftType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenterCapacityShift extends VdmEntity<WorkCenterCapacityShift>
{

    /**
     * Selector for all available fields of WorkCenterCapacityShift.
     *
     */
    public final static WorkCenterCapacityShiftSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the resource
     */
    @Key
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<String> WORK_CENTER_INTERNAL_ID =
        new WorkCenterCapacityShiftField<String>("WorkCenterInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @Key
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<String> WORK_CENTER_TYPE_CODE =
        new WorkCenterCapacityShiftField<String>("WorkCenterTypeCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryAllocation</b>
     * </p>
     *
     * @return Capacity allocation number
     */
    @Key
    @SerializedName( "CapacityCategoryAllocation" )
    @JsonProperty( "CapacityCategoryAllocation" )
    @Nullable
    @ODataField( odataName = "CapacityCategoryAllocation" )
    private String capacityCategoryAllocation;
    /**
     * Use with available fluent helpers to apply the <b>CapacityCategoryAllocation</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<String> CAPACITY_CATEGORY_ALLOCATION =
        new WorkCenterCapacityShiftField<String>("CapacityCategoryAllocation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @return Capacity ID
     */
    @Key
    @SerializedName( "CapacityInternalID" )
    @JsonProperty( "CapacityInternalID" )
    @Nullable
    @ODataField( odataName = "CapacityInternalID" )
    private String capacityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CapacityInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<String> CAPACITY_INTERNAL_ID =
        new WorkCenterCapacityShiftField<String>("CapacityInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityActiveVersion</b>
     * </p>
     *
     * @return The capacityActiveVersion contained in this entity.
     */
    @Key
    @SerializedName( "CapacityActiveVersion" )
    @JsonProperty( "CapacityActiveVersion" )
    @Nullable
    @ODataField( odataName = "CapacityActiveVersion" )
    private String capacityActiveVersion;
    /**
     * Use with available fluent helpers to apply the <b>CapacityActiveVersion</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<String> CAPACITY_ACTIVE_VERSION =
        new WorkCenterCapacityShiftField<String>("CapacityActiveVersion");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalEndDate</b>
     * </p>
     *
     * @return The intervalEndDate contained in this entity.
     */
    @Key
    @SerializedName( "IntervalEndDate" )
    @JsonProperty( "IntervalEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "IntervalEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime intervalEndDate;
    /**
     * Use with available fluent helpers to apply the <b>IntervalEndDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<LocalDateTime> INTERVAL_END_DATE =
        new WorkCenterCapacityShiftField<LocalDateTime>("IntervalEndDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WeekDay</b>
     * </p>
     *
     * @return The weekDay contained in this entity.
     */
    @Key
    @SerializedName( "WeekDay" )
    @JsonProperty( "WeekDay" )
    @Nullable
    @ODataField( odataName = "WeekDay" )
    private String weekDay;
    /**
     * Use with available fluent helpers to apply the <b>WeekDay</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<String> WEEK_DAY =
        new WorkCenterCapacityShiftField<String>("WeekDay");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AvailableCapacityShift</b>
     * </p>
     *
     * @return The availableCapacityShift contained in this entity.
     */
    @Key
    @SerializedName( "AvailableCapacityShift" )
    @JsonProperty( "AvailableCapacityShift" )
    @Nullable
    @ODataField( odataName = "AvailableCapacityShift" )
    private String availableCapacityShift;
    /**
     * Use with available fluent helpers to apply the <b>AvailableCapacityShift</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<String> AVAILABLE_CAPACITY_SHIFT =
        new WorkCenterCapacityShiftField<String>("AvailableCapacityShift");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<String> WORK_CENTER =
        new WorkCenterCapacityShiftField<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<String> PLANT = new WorkCenterCapacityShiftField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalStartDate</b>
     * </p>
     *
     * @return The intervalStartDate contained in this entity.
     */
    @SerializedName( "IntervalStartDate" )
    @JsonProperty( "IntervalStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "IntervalStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime intervalStartDate;
    /**
     * Use with available fluent helpers to apply the <b>IntervalStartDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<LocalDateTime> INTERVAL_START_DATE =
        new WorkCenterCapacityShiftField<LocalDateTime>("IntervalStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftName</b>
     * </p>
     *
     * @return The shiftName contained in this entity.
     */
    @SerializedName( "ShiftName" )
    @JsonProperty( "ShiftName" )
    @Nullable
    @ODataField( odataName = "ShiftName" )
    private String shiftName;
    /**
     * Use with available fluent helpers to apply the <b>ShiftName</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<String> SHIFT_NAME =
        new WorkCenterCapacityShiftField<String>("ShiftName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftDefValidityStart</b>
     * </p>
     *
     * @return The shiftDefValidityStart contained in this entity.
     */
    @SerializedName( "ShiftDefValidityStart" )
    @JsonProperty( "ShiftDefValidityStart" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ShiftDefValidityStart",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime shiftDefValidityStart;
    /**
     * Use with available fluent helpers to apply the <b>ShiftDefValidityStart</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<LocalDateTime> SHIFT_DEF_VALIDITY_START =
        new WorkCenterCapacityShiftField<LocalDateTime>("ShiftDefValidityStart");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftDefValidityEnd</b>
     * </p>
     *
     * @return The shiftDefValidityEnd contained in this entity.
     */
    @SerializedName( "ShiftDefValidityEnd" )
    @JsonProperty( "ShiftDefValidityEnd" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ShiftDefValidityEnd",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime shiftDefValidityEnd;
    /**
     * Use with available fluent helpers to apply the <b>ShiftDefValidityEnd</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<LocalDateTime> SHIFT_DEF_VALIDITY_END =
        new WorkCenterCapacityShiftField<LocalDateTime>("ShiftDefValidityEnd");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftStartTime</b>
     * </p>
     *
     * @return The shiftStartTime contained in this entity.
     */
    @SerializedName( "ShiftStartTime" )
    @JsonProperty( "ShiftStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ShiftStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime shiftStartTime;
    /**
     * Use with available fluent helpers to apply the <b>ShiftStartTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<LocalTime> SHIFT_START_TIME =
        new WorkCenterCapacityShiftField<LocalTime>("ShiftStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftEndTime</b>
     * </p>
     *
     * @return The shiftEndTime contained in this entity.
     */
    @SerializedName( "ShiftEndTime" )
    @JsonProperty( "ShiftEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ShiftEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime shiftEndTime;
    /**
     * Use with available fluent helpers to apply the <b>ShiftEndTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<LocalTime> SHIFT_END_TIME =
        new WorkCenterCapacityShiftField<LocalTime>("ShiftEndTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityBreakDuration</b>
     * </p>
     *
     * @return The capacityBreakDuration contained in this entity.
     */
    @SerializedName( "CapacityBreakDuration" )
    @JsonProperty( "CapacityBreakDuration" )
    @Nullable
    @ODataField( odataName = "CapacityBreakDuration" )
    private Integer capacityBreakDuration;
    /**
     * Use with available fluent helpers to apply the <b>CapacityBreakDuration</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<Integer> CAPACITY_BREAK_DURATION =
        new WorkCenterCapacityShiftField<Integer>("CapacityBreakDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityPlanUtilizationPercent</b>
     * </p>
     *
     * @return The capacityPlanUtilizationPercent contained in this entity.
     */
    @SerializedName( "CapacityPlanUtilizationPercent" )
    @JsonProperty( "CapacityPlanUtilizationPercent" )
    @Nullable
    @ODataField( odataName = "CapacityPlanUtilizationPercent" )
    private String capacityPlanUtilizationPercent;
    /**
     * Use with available fluent helpers to apply the <b>CapacityPlanUtilizationPercent</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<String> CAPACITY_PLAN_UTILIZATION_PERCENT =
        new WorkCenterCapacityShiftField<String>("CapacityPlanUtilizationPercent");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityNumberOfCapacities</b>
     * </p>
     *
     * @return The capacityNumberOfCapacities contained in this entity.
     */
    @SerializedName( "CapacityNumberOfCapacities" )
    @JsonProperty( "CapacityNumberOfCapacities" )
    @Nullable
    @ODataField( odataName = "CapacityNumberOfCapacities" )
    private Short capacityNumberOfCapacities;
    /**
     * Use with available fluent helpers to apply the <b>CapacityNumberOfCapacities</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<Short> CAPACITY_NUMBER_OF_CAPACITIES =
        new WorkCenterCapacityShiftField<Short>("CapacityNumberOfCapacities");
    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotOperatingDurationInHours</b>
     * </p>
     *
     * @return Decimal 17_3
     */
    @SerializedName( "TotOperatingDurationInHours" )
    @JsonProperty( "TotOperatingDurationInHours" )
    @Nullable
    @ODataField( odataName = "TotOperatingDurationInHours" )
    private BigDecimal totOperatingDurationInHours;
    /**
     * Use with available fluent helpers to apply the <b>TotOperatingDurationInHours</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<BigDecimal> TOT_OPERATING_DURATION_IN_HOURS =
        new WorkCenterCapacityShiftField<BigDecimal>("TotOperatingDurationInHours");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotOperationDurationUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "TotOperationDurationUnit" )
    @JsonProperty( "TotOperationDurationUnit" )
    @Nullable
    @ODataField( odataName = "TotOperationDurationUnit" )
    private String totOperationDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>TotOperationDurationUnit</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShiftField<String> TOT_OPERATION_DURATION_UNIT =
        new WorkCenterCapacityShiftField<String>("TotOperationDurationUnit");

    @Nonnull
    @Override
    public Class<WorkCenterCapacityShift> getType()
    {
        return WorkCenterCapacityShift.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID of the resource
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CapacityCategoryAllocation</b>
     * </p>
     *
     * @param capacityCategoryAllocation
     *            Capacity allocation number
     */
    public void setCapacityCategoryAllocation( @Nullable final String capacityCategoryAllocation )
    {
        rememberChangedField("CapacityCategoryAllocation", this.capacityCategoryAllocation);
        this.capacityCategoryAllocation = capacityCategoryAllocation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @param capacityInternalID
     *            Capacity ID
     */
    public void setCapacityInternalID( @Nullable final String capacityInternalID )
    {
        rememberChangedField("CapacityInternalID", this.capacityInternalID);
        this.capacityInternalID = capacityInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityActiveVersion</b>
     * </p>
     *
     * @param capacityActiveVersion
     *            The capacityActiveVersion to set.
     */
    public void setCapacityActiveVersion( @Nullable final String capacityActiveVersion )
    {
        rememberChangedField("CapacityActiveVersion", this.capacityActiveVersion);
        this.capacityActiveVersion = capacityActiveVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalEndDate</b>
     * </p>
     *
     * @param intervalEndDate
     *            The intervalEndDate to set.
     */
    public void setIntervalEndDate( @Nullable final LocalDateTime intervalEndDate )
    {
        rememberChangedField("IntervalEndDate", this.intervalEndDate);
        this.intervalEndDate = intervalEndDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WeekDay</b>
     * </p>
     *
     * @param weekDay
     *            The weekDay to set.
     */
    public void setWeekDay( @Nullable final String weekDay )
    {
        rememberChangedField("WeekDay", this.weekDay);
        this.weekDay = weekDay;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AvailableCapacityShift</b>
     * </p>
     *
     * @param availableCapacityShift
     *            The availableCapacityShift to set.
     */
    public void setAvailableCapacityShift( @Nullable final String availableCapacityShift )
    {
        rememberChangedField("AvailableCapacityShift", this.availableCapacityShift);
        this.availableCapacityShift = availableCapacityShift;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalStartDate</b>
     * </p>
     *
     * @param intervalStartDate
     *            The intervalStartDate to set.
     */
    public void setIntervalStartDate( @Nullable final LocalDateTime intervalStartDate )
    {
        rememberChangedField("IntervalStartDate", this.intervalStartDate);
        this.intervalStartDate = intervalStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftName</b>
     * </p>
     *
     * @param shiftName
     *            The shiftName to set.
     */
    public void setShiftName( @Nullable final String shiftName )
    {
        rememberChangedField("ShiftName", this.shiftName);
        this.shiftName = shiftName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftDefValidityStart</b>
     * </p>
     *
     * @param shiftDefValidityStart
     *            The shiftDefValidityStart to set.
     */
    public void setShiftDefValidityStart( @Nullable final LocalDateTime shiftDefValidityStart )
    {
        rememberChangedField("ShiftDefValidityStart", this.shiftDefValidityStart);
        this.shiftDefValidityStart = shiftDefValidityStart;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftDefValidityEnd</b>
     * </p>
     *
     * @param shiftDefValidityEnd
     *            The shiftDefValidityEnd to set.
     */
    public void setShiftDefValidityEnd( @Nullable final LocalDateTime shiftDefValidityEnd )
    {
        rememberChangedField("ShiftDefValidityEnd", this.shiftDefValidityEnd);
        this.shiftDefValidityEnd = shiftDefValidityEnd;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftStartTime</b>
     * </p>
     *
     * @param shiftStartTime
     *            The shiftStartTime to set.
     */
    public void setShiftStartTime( @Nullable final LocalTime shiftStartTime )
    {
        rememberChangedField("ShiftStartTime", this.shiftStartTime);
        this.shiftStartTime = shiftStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftEndTime</b>
     * </p>
     *
     * @param shiftEndTime
     *            The shiftEndTime to set.
     */
    public void setShiftEndTime( @Nullable final LocalTime shiftEndTime )
    {
        rememberChangedField("ShiftEndTime", this.shiftEndTime);
        this.shiftEndTime = shiftEndTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityBreakDuration</b>
     * </p>
     *
     * @param capacityBreakDuration
     *            The capacityBreakDuration to set.
     */
    public void setCapacityBreakDuration( @Nullable final Integer capacityBreakDuration )
    {
        rememberChangedField("CapacityBreakDuration", this.capacityBreakDuration);
        this.capacityBreakDuration = capacityBreakDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityPlanUtilizationPercent</b>
     * </p>
     *
     * @param capacityPlanUtilizationPercent
     *            The capacityPlanUtilizationPercent to set.
     */
    public void setCapacityPlanUtilizationPercent( @Nullable final String capacityPlanUtilizationPercent )
    {
        rememberChangedField("CapacityPlanUtilizationPercent", this.capacityPlanUtilizationPercent);
        this.capacityPlanUtilizationPercent = capacityPlanUtilizationPercent;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityNumberOfCapacities</b>
     * </p>
     *
     * @param capacityNumberOfCapacities
     *            The capacityNumberOfCapacities to set.
     */
    public void setCapacityNumberOfCapacities( @Nullable final Short capacityNumberOfCapacities )
    {
        rememberChangedField("CapacityNumberOfCapacities", this.capacityNumberOfCapacities);
        this.capacityNumberOfCapacities = capacityNumberOfCapacities;
    }

    /**
     * Constraints: Not nullable, Precision: 17, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotOperatingDurationInHours</b>
     * </p>
     *
     * @param totOperatingDurationInHours
     *            Decimal 17_3
     */
    public void setTotOperatingDurationInHours( @Nullable final BigDecimal totOperatingDurationInHours )
    {
        rememberChangedField("TotOperatingDurationInHours", this.totOperatingDurationInHours);
        this.totOperatingDurationInHours = totOperatingDurationInHours;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotOperationDurationUnit</b>
     * </p>
     *
     * @param totOperationDurationUnit
     *            Base Unit of Measure
     */
    public void setTotOperationDurationUnit( @Nullable final String totOperationDurationUnit )
    {
        rememberChangedField("TotOperationDurationUnit", this.totOperationDurationUnit);
        this.totOperationDurationUnit = totOperationDurationUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenterCapacityShift";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WorkCenterInternalID", getWorkCenterInternalID());
        result.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        result.put("CapacityCategoryAllocation", getCapacityCategoryAllocation());
        result.put("CapacityInternalID", getCapacityInternalID());
        result.put("CapacityActiveVersion", getCapacityActiveVersion());
        result.put("IntervalEndDate", getIntervalEndDate());
        result.put("WeekDay", getWeekDay());
        result.put("AvailableCapacityShift", getAvailableCapacityShift());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("CapacityCategoryAllocation", getCapacityCategoryAllocation());
        values.put("CapacityInternalID", getCapacityInternalID());
        values.put("CapacityActiveVersion", getCapacityActiveVersion());
        values.put("IntervalEndDate", getIntervalEndDate());
        values.put("WeekDay", getWeekDay());
        values.put("AvailableCapacityShift", getAvailableCapacityShift());
        values.put("WorkCenter", getWorkCenter());
        values.put("Plant", getPlant());
        values.put("IntervalStartDate", getIntervalStartDate());
        values.put("ShiftName", getShiftName());
        values.put("ShiftDefValidityStart", getShiftDefValidityStart());
        values.put("ShiftDefValidityEnd", getShiftDefValidityEnd());
        values.put("ShiftStartTime", getShiftStartTime());
        values.put("ShiftEndTime", getShiftEndTime());
        values.put("CapacityBreakDuration", getCapacityBreakDuration());
        values.put("CapacityPlanUtilizationPercent", getCapacityPlanUtilizationPercent());
        values.put("CapacityNumberOfCapacities", getCapacityNumberOfCapacities());
        values.put("TotOperatingDurationInHours", getTotOperatingDurationInHours());
        values.put("TotOperationDurationUnit", getTotOperationDurationUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("CapacityCategoryAllocation") ) {
                final Object value = values.remove("CapacityCategoryAllocation");
                if( (value == null) || (!value.equals(getCapacityCategoryAllocation())) ) {
                    setCapacityCategoryAllocation(((String) value));
                }
            }
            if( values.containsKey("CapacityInternalID") ) {
                final Object value = values.remove("CapacityInternalID");
                if( (value == null) || (!value.equals(getCapacityInternalID())) ) {
                    setCapacityInternalID(((String) value));
                }
            }
            if( values.containsKey("CapacityActiveVersion") ) {
                final Object value = values.remove("CapacityActiveVersion");
                if( (value == null) || (!value.equals(getCapacityActiveVersion())) ) {
                    setCapacityActiveVersion(((String) value));
                }
            }
            if( values.containsKey("IntervalEndDate") ) {
                final Object value = values.remove("IntervalEndDate");
                if( (value == null) || (!value.equals(getIntervalEndDate())) ) {
                    setIntervalEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("WeekDay") ) {
                final Object value = values.remove("WeekDay");
                if( (value == null) || (!value.equals(getWeekDay())) ) {
                    setWeekDay(((String) value));
                }
            }
            if( values.containsKey("AvailableCapacityShift") ) {
                final Object value = values.remove("AvailableCapacityShift");
                if( (value == null) || (!value.equals(getAvailableCapacityShift())) ) {
                    setAvailableCapacityShift(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("IntervalStartDate") ) {
                final Object value = values.remove("IntervalStartDate");
                if( (value == null) || (!value.equals(getIntervalStartDate())) ) {
                    setIntervalStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ShiftName") ) {
                final Object value = values.remove("ShiftName");
                if( (value == null) || (!value.equals(getShiftName())) ) {
                    setShiftName(((String) value));
                }
            }
            if( values.containsKey("ShiftDefValidityStart") ) {
                final Object value = values.remove("ShiftDefValidityStart");
                if( (value == null) || (!value.equals(getShiftDefValidityStart())) ) {
                    setShiftDefValidityStart(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ShiftDefValidityEnd") ) {
                final Object value = values.remove("ShiftDefValidityEnd");
                if( (value == null) || (!value.equals(getShiftDefValidityEnd())) ) {
                    setShiftDefValidityEnd(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ShiftStartTime") ) {
                final Object value = values.remove("ShiftStartTime");
                if( (value == null) || (!value.equals(getShiftStartTime())) ) {
                    setShiftStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ShiftEndTime") ) {
                final Object value = values.remove("ShiftEndTime");
                if( (value == null) || (!value.equals(getShiftEndTime())) ) {
                    setShiftEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CapacityBreakDuration") ) {
                final Object value = values.remove("CapacityBreakDuration");
                if( (value == null) || (!value.equals(getCapacityBreakDuration())) ) {
                    setCapacityBreakDuration(((Integer) value));
                }
            }
            if( values.containsKey("CapacityPlanUtilizationPercent") ) {
                final Object value = values.remove("CapacityPlanUtilizationPercent");
                if( (value == null) || (!value.equals(getCapacityPlanUtilizationPercent())) ) {
                    setCapacityPlanUtilizationPercent(((String) value));
                }
            }
            if( values.containsKey("CapacityNumberOfCapacities") ) {
                final Object value = values.remove("CapacityNumberOfCapacities");
                if( (value == null) || (!value.equals(getCapacityNumberOfCapacities())) ) {
                    setCapacityNumberOfCapacities(((Short) value));
                }
            }
            if( values.containsKey("TotOperatingDurationInHours") ) {
                final Object value = values.remove("TotOperatingDurationInHours");
                if( (value == null) || (!value.equals(getTotOperatingDurationInHours())) ) {
                    setTotOperatingDurationInHours(((BigDecimal) value));
                }
            }
            if( values.containsKey("TotOperationDurationUnit") ) {
                final Object value = values.remove("TotOperationDurationUnit");
                if( (value == null) || (!value.equals(getTotOperationDurationUnit())) ) {
                    setTotOperationDurationUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WorkCenterCapacityShiftField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkCenterCapacityShiftField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCenterCapacityShiftField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCenterCapacityShiftField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

}
