/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapacityShift_2Field;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapacityShift_2Selectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Capacity Shift Version 2
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCenterCapacityShift_2Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenterCapacityShift_2 extends VdmEntity<WorkCenterCapacityShift_2>
{

    /**
     * Selector for all available fields of WorkCenterCapacityShift_2.
     *
     */
    public final static WorkCenterCapacityShift_2Selectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @return Capacity ID
     */
    @Key
    @SerializedName( "CapacityInternalID" )
    @JsonProperty( "CapacityInternalID" )
    @Nullable
    @ODataField( odataName = "CapacityInternalID" )
    private String capacityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CapacityInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<String> CAPACITY_INTERNAL_ID =
        new WorkCenterCapacityShift_2Field<String>("CapacityInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityActiveVersion</b>
     * </p>
     *
     * @return The capacityActiveVersion contained in this entity.
     */
    @Key
    @SerializedName( "CapacityActiveVersion" )
    @JsonProperty( "CapacityActiveVersion" )
    @Nullable
    @ODataField( odataName = "CapacityActiveVersion" )
    private String capacityActiveVersion;
    /**
     * Use with available fluent helpers to apply the <b>CapacityActiveVersion</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<String> CAPACITY_ACTIVE_VERSION =
        new WorkCenterCapacityShift_2Field<String>("CapacityActiveVersion");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @Key
    @SerializedName( "IntervalEndDate" )
    @JsonProperty( "IntervalEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "IntervalEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime intervalEndDate;
    /**
     * Use with available fluent helpers to apply the <b>IntervalEndDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<LocalDateTime> INTERVAL_END_DATE =
        new WorkCenterCapacityShift_2Field<LocalDateTime>("IntervalEndDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WeekDay</b>
     * </p>
     *
     * @return Week Day
     */
    @Key
    @SerializedName( "WeekDay" )
    @JsonProperty( "WeekDay" )
    @Nullable
    @ODataField( odataName = "WeekDay" )
    private String weekDay;
    /**
     * Use with available fluent helpers to apply the <b>WeekDay</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<String> WEEK_DAY =
        new WorkCenterCapacityShift_2Field<String>("WeekDay");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AvailableCapacityShift</b>
     * </p>
     *
     * @return Shift Number of an Available Capacity
     */
    @Key
    @SerializedName( "AvailableCapacityShift" )
    @JsonProperty( "AvailableCapacityShift" )
    @Nullable
    @ODataField( odataName = "AvailableCapacityShift" )
    private String availableCapacityShift;
    /**
     * Use with available fluent helpers to apply the <b>AvailableCapacityShift</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<String> AVAILABLE_CAPACITY_SHIFT =
        new WorkCenterCapacityShift_2Field<String>("AvailableCapacityShift");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "IntervalStartDate" )
    @JsonProperty( "IntervalStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "IntervalStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime intervalStartDate;
    /**
     * Use with available fluent helpers to apply the <b>IntervalStartDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<LocalDateTime> INTERVAL_START_DATE =
        new WorkCenterCapacityShift_2Field<LocalDateTime>("IntervalStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkDayRule</b>
     * </p>
     *
     * @return Workday Rule Code
     */
    @SerializedName( "WorkDayRule" )
    @JsonProperty( "WorkDayRule" )
    @Nullable
    @ODataField( odataName = "WorkDayRule" )
    private String workDayRule;
    /**
     * Use with available fluent helpers to apply the <b>WorkDayRule</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<String> WORK_DAY_RULE =
        new WorkCenterCapacityShift_2Field<String>("WorkDayRule");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftDefinition</b>
     * </p>
     *
     * @return Shift Definition
     */
    @SerializedName( "ShiftDefinition" )
    @JsonProperty( "ShiftDefinition" )
    @Nullable
    @ODataField( odataName = "ShiftDefinition" )
    private String shiftDefinition;
    /**
     * Use with available fluent helpers to apply the <b>ShiftDefinition</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<String> SHIFT_DEFINITION =
        new WorkCenterCapacityShift_2Field<String>("ShiftDefinition");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftStartTime</b>
     * </p>
     *
     * @return Start Time
     */
    @SerializedName( "ShiftStartTime" )
    @JsonProperty( "ShiftStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ShiftStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime shiftStartTime;
    /**
     * Use with available fluent helpers to apply the <b>ShiftStartTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<LocalTime> SHIFT_START_TIME =
        new WorkCenterCapacityShift_2Field<LocalTime>("ShiftStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftEndTime</b>
     * </p>
     *
     * @return End Time
     */
    @SerializedName( "ShiftEndTime" )
    @JsonProperty( "ShiftEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ShiftEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime shiftEndTime;
    /**
     * Use with available fluent helpers to apply the <b>ShiftEndTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<LocalTime> SHIFT_END_TIME =
        new WorkCenterCapacityShift_2Field<LocalTime>("ShiftEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftDefValidityStartDate</b>
     * </p>
     *
     * @return Start Date
     */
    @SerializedName( "ShiftDefValidityStartDate" )
    @JsonProperty( "ShiftDefValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ShiftDefValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime shiftDefValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ShiftDefValidityStartDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<LocalDateTime> SHIFT_DEF_VALIDITY_START_DATE =
        new WorkCenterCapacityShift_2Field<LocalDateTime>("ShiftDefValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftDefValidityEndDate</b>
     * </p>
     *
     * @return End Date
     */
    @SerializedName( "ShiftDefValidityEndDate" )
    @JsonProperty( "ShiftDefValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ShiftDefValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime shiftDefValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ShiftDefValidityEndDate</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<LocalDateTime> SHIFT_DEF_VALIDITY_END_DATE =
        new WorkCenterCapacityShift_2Field<LocalDateTime>("ShiftDefValidityEndDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityNumberOfCapacities</b>
     * </p>
     *
     * @return Number of Individual Capacities
     */
    @SerializedName( "CapacityNumberOfCapacities" )
    @JsonProperty( "CapacityNumberOfCapacities" )
    @Nullable
    @ODataField( odataName = "CapacityNumberOfCapacities" )
    private Short capacityNumberOfCapacities;
    /**
     * Use with available fluent helpers to apply the <b>CapacityNumberOfCapacities</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<Short> CAPACITY_NUMBER_OF_CAPACITIES =
        new WorkCenterCapacityShift_2Field<Short>("CapacityNumberOfCapacities");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityPlanUtilizationPercent</b>
     * </p>
     *
     * @return Capacity Utilization Ratio in Percent
     */
    @SerializedName( "CapacityPlanUtilizationPercent" )
    @JsonProperty( "CapacityPlanUtilizationPercent" )
    @Nullable
    @ODataField( odataName = "CapacityPlanUtilizationPercent" )
    private String capacityPlanUtilizationPercent;
    /**
     * Use with available fluent helpers to apply the <b>CapacityPlanUtilizationPercent</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<String> CAPACITY_PLAN_UTILIZATION_PERCENT =
        new WorkCenterCapacityShift_2Field<String>("CapacityPlanUtilizationPercent");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityBreakDuration</b>
     * </p>
     *
     * @return Cumulative Break Duration in Seconds (internal)
     */
    @SerializedName( "CapacityBreakDuration" )
    @JsonProperty( "CapacityBreakDuration" )
    @Nullable
    @ODataField( odataName = "CapacityBreakDuration" )
    private Integer capacityBreakDuration;
    /**
     * Use with available fluent helpers to apply the <b>CapacityBreakDuration</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<Integer> CAPACITY_BREAK_DURATION =
        new WorkCenterCapacityShift_2Field<Integer>("CapacityBreakDuration");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OperatingDurationInSeconds</b>
     * </p>
     *
     * @return Operating Duration in Seconds
     */
    @SerializedName( "OperatingDurationInSeconds" )
    @JsonProperty( "OperatingDurationInSeconds" )
    @Nullable
    @ODataField( odataName = "OperatingDurationInSeconds" )
    private Integer operatingDurationInSeconds;
    /**
     * Use with available fluent helpers to apply the <b>OperatingDurationInSeconds</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<Integer> OPERATING_DURATION_IN_SECONDS =
        new WorkCenterCapacityShift_2Field<Integer>("OperatingDurationInSeconds");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TotOperatingDurationInSeconds</b>
     * </p>
     *
     * @return Total Operating Duration In Seconds
     */
    @SerializedName( "TotOperatingDurationInSeconds" )
    @JsonProperty( "TotOperatingDurationInSeconds" )
    @Nullable
    @ODataField( odataName = "TotOperatingDurationInSeconds" )
    private Integer totOperatingDurationInSeconds;
    /**
     * Use with available fluent helpers to apply the <b>TotOperatingDurationInSeconds</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<Integer> TOT_OPERATING_DURATION_IN_SECONDS =
        new WorkCenterCapacityShift_2Field<Integer>("TotOperatingDurationInSeconds");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CapacityLastChangeDateTime</b>
     * </p>
     *
     * @return Capacity Last Change Date Time
     */
    @SerializedName( "CapacityLastChangeDateTime" )
    @JsonProperty( "CapacityLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CapacityLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime capacityLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CapacityLastChangeDateTime</b> field to query operations.
     *
     */
    public final static WorkCenterCapacityShift_2Field<ZonedDateTime> CAPACITY_LAST_CHANGE_DATE_TIME =
        new WorkCenterCapacityShift_2Field<ZonedDateTime>("CapacityLastChangeDateTime");

    @Nonnull
    @Override
    public Class<WorkCenterCapacityShift_2> getType()
    {
        return WorkCenterCapacityShift_2.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @param capacityInternalID
     *            Capacity ID
     */
    public void setCapacityInternalID( @Nullable final String capacityInternalID )
    {
        rememberChangedField("CapacityInternalID", this.capacityInternalID);
        this.capacityInternalID = capacityInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CapacityActiveVersion</b>
     * </p>
     *
     * @param capacityActiveVersion
     *            The capacityActiveVersion to set.
     */
    public void setCapacityActiveVersion( @Nullable final String capacityActiveVersion )
    {
        rememberChangedField("CapacityActiveVersion", this.capacityActiveVersion);
        this.capacityActiveVersion = capacityActiveVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalEndDate</b>
     * </p>
     *
     * @param intervalEndDate
     *            Valid-to date
     */
    public void setIntervalEndDate( @Nullable final LocalDateTime intervalEndDate )
    {
        rememberChangedField("IntervalEndDate", this.intervalEndDate);
        this.intervalEndDate = intervalEndDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WeekDay</b>
     * </p>
     *
     * @param weekDay
     *            Week Day
     */
    public void setWeekDay( @Nullable final String weekDay )
    {
        rememberChangedField("WeekDay", this.weekDay);
        this.weekDay = weekDay;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AvailableCapacityShift</b>
     * </p>
     *
     * @param availableCapacityShift
     *            Shift Number of an Available Capacity
     */
    public void setAvailableCapacityShift( @Nullable final String availableCapacityShift )
    {
        rememberChangedField("AvailableCapacityShift", this.availableCapacityShift);
        this.availableCapacityShift = availableCapacityShift;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IntervalStartDate</b>
     * </p>
     *
     * @param intervalStartDate
     *            Valid-From Date
     */
    public void setIntervalStartDate( @Nullable final LocalDateTime intervalStartDate )
    {
        rememberChangedField("IntervalStartDate", this.intervalStartDate);
        this.intervalStartDate = intervalStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkDayRule</b>
     * </p>
     *
     * @param workDayRule
     *            Workday Rule Code
     */
    public void setWorkDayRule( @Nullable final String workDayRule )
    {
        rememberChangedField("WorkDayRule", this.workDayRule);
        this.workDayRule = workDayRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShiftDefinition</b>
     * </p>
     *
     * @param shiftDefinition
     *            Shift Definition
     */
    public void setShiftDefinition( @Nullable final String shiftDefinition )
    {
        rememberChangedField("ShiftDefinition", this.shiftDefinition);
        this.shiftDefinition = shiftDefinition;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftStartTime</b>
     * </p>
     *
     * @param shiftStartTime
     *            Start Time
     */
    public void setShiftStartTime( @Nullable final LocalTime shiftStartTime )
    {
        rememberChangedField("ShiftStartTime", this.shiftStartTime);
        this.shiftStartTime = shiftStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftEndTime</b>
     * </p>
     *
     * @param shiftEndTime
     *            End Time
     */
    public void setShiftEndTime( @Nullable final LocalTime shiftEndTime )
    {
        rememberChangedField("ShiftEndTime", this.shiftEndTime);
        this.shiftEndTime = shiftEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftDefValidityStartDate</b>
     * </p>
     *
     * @param shiftDefValidityStartDate
     *            Start Date
     */
    public void setShiftDefValidityStartDate( @Nullable final LocalDateTime shiftDefValidityStartDate )
    {
        rememberChangedField("ShiftDefValidityStartDate", this.shiftDefValidityStartDate);
        this.shiftDefValidityStartDate = shiftDefValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ShiftDefValidityEndDate</b>
     * </p>
     *
     * @param shiftDefValidityEndDate
     *            End Date
     */
    public void setShiftDefValidityEndDate( @Nullable final LocalDateTime shiftDefValidityEndDate )
    {
        rememberChangedField("ShiftDefValidityEndDate", this.shiftDefValidityEndDate);
        this.shiftDefValidityEndDate = shiftDefValidityEndDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityNumberOfCapacities</b>
     * </p>
     *
     * @param capacityNumberOfCapacities
     *            Number of Individual Capacities
     */
    public void setCapacityNumberOfCapacities( @Nullable final Short capacityNumberOfCapacities )
    {
        rememberChangedField("CapacityNumberOfCapacities", this.capacityNumberOfCapacities);
        this.capacityNumberOfCapacities = capacityNumberOfCapacities;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CapacityPlanUtilizationPercent</b>
     * </p>
     *
     * @param capacityPlanUtilizationPercent
     *            Capacity Utilization Ratio in Percent
     */
    public void setCapacityPlanUtilizationPercent( @Nullable final String capacityPlanUtilizationPercent )
    {
        rememberChangedField("CapacityPlanUtilizationPercent", this.capacityPlanUtilizationPercent);
        this.capacityPlanUtilizationPercent = capacityPlanUtilizationPercent;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CapacityBreakDuration</b>
     * </p>
     *
     * @param capacityBreakDuration
     *            Cumulative Break Duration in Seconds (internal)
     */
    public void setCapacityBreakDuration( @Nullable final Integer capacityBreakDuration )
    {
        rememberChangedField("CapacityBreakDuration", this.capacityBreakDuration);
        this.capacityBreakDuration = capacityBreakDuration;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OperatingDurationInSeconds</b>
     * </p>
     *
     * @param operatingDurationInSeconds
     *            Operating Duration in Seconds
     */
    public void setOperatingDurationInSeconds( @Nullable final Integer operatingDurationInSeconds )
    {
        rememberChangedField("OperatingDurationInSeconds", this.operatingDurationInSeconds);
        this.operatingDurationInSeconds = operatingDurationInSeconds;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>TotOperatingDurationInSeconds</b>
     * </p>
     *
     * @param totOperatingDurationInSeconds
     *            Total Operating Duration In Seconds
     */
    public void setTotOperatingDurationInSeconds( @Nullable final Integer totOperatingDurationInSeconds )
    {
        rememberChangedField("TotOperatingDurationInSeconds", this.totOperatingDurationInSeconds);
        this.totOperatingDurationInSeconds = totOperatingDurationInSeconds;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>CapacityLastChangeDateTime</b>
     * </p>
     *
     * @param capacityLastChangeDateTime
     *            Capacity Last Change Date Time
     */
    public void setCapacityLastChangeDateTime( @Nullable final ZonedDateTime capacityLastChangeDateTime )
    {
        rememberChangedField("CapacityLastChangeDateTime", this.capacityLastChangeDateTime);
        this.capacityLastChangeDateTime = capacityLastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenterCapacityShift_2";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CapacityInternalID", getCapacityInternalID());
        result.put("CapacityActiveVersion", getCapacityActiveVersion());
        result.put("IntervalEndDate", getIntervalEndDate());
        result.put("WeekDay", getWeekDay());
        result.put("AvailableCapacityShift", getAvailableCapacityShift());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CapacityInternalID", getCapacityInternalID());
        values.put("CapacityActiveVersion", getCapacityActiveVersion());
        values.put("IntervalEndDate", getIntervalEndDate());
        values.put("WeekDay", getWeekDay());
        values.put("AvailableCapacityShift", getAvailableCapacityShift());
        values.put("IntervalStartDate", getIntervalStartDate());
        values.put("WorkDayRule", getWorkDayRule());
        values.put("ShiftDefinition", getShiftDefinition());
        values.put("ShiftStartTime", getShiftStartTime());
        values.put("ShiftEndTime", getShiftEndTime());
        values.put("ShiftDefValidityStartDate", getShiftDefValidityStartDate());
        values.put("ShiftDefValidityEndDate", getShiftDefValidityEndDate());
        values.put("CapacityNumberOfCapacities", getCapacityNumberOfCapacities());
        values.put("CapacityPlanUtilizationPercent", getCapacityPlanUtilizationPercent());
        values.put("CapacityBreakDuration", getCapacityBreakDuration());
        values.put("OperatingDurationInSeconds", getOperatingDurationInSeconds());
        values.put("TotOperatingDurationInSeconds", getTotOperatingDurationInSeconds());
        values.put("CapacityLastChangeDateTime", getCapacityLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CapacityInternalID") ) {
                final Object value = values.remove("CapacityInternalID");
                if( (value == null) || (!value.equals(getCapacityInternalID())) ) {
                    setCapacityInternalID(((String) value));
                }
            }
            if( values.containsKey("CapacityActiveVersion") ) {
                final Object value = values.remove("CapacityActiveVersion");
                if( (value == null) || (!value.equals(getCapacityActiveVersion())) ) {
                    setCapacityActiveVersion(((String) value));
                }
            }
            if( values.containsKey("IntervalEndDate") ) {
                final Object value = values.remove("IntervalEndDate");
                if( (value == null) || (!value.equals(getIntervalEndDate())) ) {
                    setIntervalEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("WeekDay") ) {
                final Object value = values.remove("WeekDay");
                if( (value == null) || (!value.equals(getWeekDay())) ) {
                    setWeekDay(((String) value));
                }
            }
            if( values.containsKey("AvailableCapacityShift") ) {
                final Object value = values.remove("AvailableCapacityShift");
                if( (value == null) || (!value.equals(getAvailableCapacityShift())) ) {
                    setAvailableCapacityShift(((String) value));
                }
            }
            if( values.containsKey("IntervalStartDate") ) {
                final Object value = values.remove("IntervalStartDate");
                if( (value == null) || (!value.equals(getIntervalStartDate())) ) {
                    setIntervalStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("WorkDayRule") ) {
                final Object value = values.remove("WorkDayRule");
                if( (value == null) || (!value.equals(getWorkDayRule())) ) {
                    setWorkDayRule(((String) value));
                }
            }
            if( values.containsKey("ShiftDefinition") ) {
                final Object value = values.remove("ShiftDefinition");
                if( (value == null) || (!value.equals(getShiftDefinition())) ) {
                    setShiftDefinition(((String) value));
                }
            }
            if( values.containsKey("ShiftStartTime") ) {
                final Object value = values.remove("ShiftStartTime");
                if( (value == null) || (!value.equals(getShiftStartTime())) ) {
                    setShiftStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ShiftEndTime") ) {
                final Object value = values.remove("ShiftEndTime");
                if( (value == null) || (!value.equals(getShiftEndTime())) ) {
                    setShiftEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ShiftDefValidityStartDate") ) {
                final Object value = values.remove("ShiftDefValidityStartDate");
                if( (value == null) || (!value.equals(getShiftDefValidityStartDate())) ) {
                    setShiftDefValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ShiftDefValidityEndDate") ) {
                final Object value = values.remove("ShiftDefValidityEndDate");
                if( (value == null) || (!value.equals(getShiftDefValidityEndDate())) ) {
                    setShiftDefValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CapacityNumberOfCapacities") ) {
                final Object value = values.remove("CapacityNumberOfCapacities");
                if( (value == null) || (!value.equals(getCapacityNumberOfCapacities())) ) {
                    setCapacityNumberOfCapacities(((Short) value));
                }
            }
            if( values.containsKey("CapacityPlanUtilizationPercent") ) {
                final Object value = values.remove("CapacityPlanUtilizationPercent");
                if( (value == null) || (!value.equals(getCapacityPlanUtilizationPercent())) ) {
                    setCapacityPlanUtilizationPercent(((String) value));
                }
            }
            if( values.containsKey("CapacityBreakDuration") ) {
                final Object value = values.remove("CapacityBreakDuration");
                if( (value == null) || (!value.equals(getCapacityBreakDuration())) ) {
                    setCapacityBreakDuration(((Integer) value));
                }
            }
            if( values.containsKey("OperatingDurationInSeconds") ) {
                final Object value = values.remove("OperatingDurationInSeconds");
                if( (value == null) || (!value.equals(getOperatingDurationInSeconds())) ) {
                    setOperatingDurationInSeconds(((Integer) value));
                }
            }
            if( values.containsKey("TotOperatingDurationInSeconds") ) {
                final Object value = values.remove("TotOperatingDurationInSeconds");
                if( (value == null) || (!value.equals(getTotOperatingDurationInSeconds())) ) {
                    setTotOperatingDurationInSeconds(((Integer) value));
                }
            }
            if( values.containsKey("CapacityLastChangeDateTime") ) {
                final Object value = values.remove("CapacityLastChangeDateTime");
                if( (value == null) || (!value.equals(getCapacityLastChangeDateTime())) ) {
                    setCapacityLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WorkCenterCapacityShift_2Field<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkCenterCapacityShift_2Field<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCenterCapacityShift_2Field<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCenterCapacityShift_2Field<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

}
