/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCapacityShift_2Selectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
 * WorkCenterCapacityShift_2} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class WorkCenterCapacityShift_2ByKeyFluentHelper
    extends
    FluentHelperByKey<WorkCenterCapacityShift_2ByKeyFluentHelper, WorkCenterCapacityShift_2, WorkCenterCapacityShift_2Selectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     * WorkCenterCapacityShift_2} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WorkCenterCapacityShift_2}
     * @param capacityInternalID
     *            Capacity ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code WorkCenterCapacityShift_2}
     * @param intervalEndDate
     *            Valid-to date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param weekDay
     *            Week Day
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param capacityActiveVersion
     *
     * @param availableCapacityShift
     *            Shift Number of an Available Capacity
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     */
    public WorkCenterCapacityShift_2ByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String capacityInternalID,
        final String capacityActiveVersion,
        final LocalDateTime intervalEndDate,
        final String weekDay,
        final String availableCapacityShift )
    {
        super(servicePath, entityCollection);
        this.key.put("CapacityInternalID", capacityInternalID);
        this.key.put("CapacityActiveVersion", capacityActiveVersion);
        this.key.put("IntervalEndDate", intervalEndDate);
        this.key.put("WeekDay", weekDay);
        this.key.put("AvailableCapacityShift", availableCapacityShift);
    }

    @Override
    @Nonnull
    protected Class<WorkCenterCapacityShift_2> getEntityClass()
    {
        return WorkCenterCapacityShift_2.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
