/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperCreate;

/**
 * Fluent helper to create a new
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
 * WorkCenterCapacityShift_2} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class WorkCenterCapacityShift_2CreateFluentHelper
    extends
    FluentHelperCreate<WorkCenterCapacityShift_2CreateFluentHelper, WorkCenterCapacityShift_2>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     * WorkCenterCapacityShift_2} entity object that will be created in the S/4HANA system.
     *
     */
    private final WorkCenterCapacityShift_2 entity;

    /**
     * Creates a fluent helper object that will create a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     * WorkCenterCapacityShift_2} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to direct the create requests to.
     * @param servicePath
     *            The service path to direct the create requests to.
     * @param entity
     *            The WorkCenterCapacityShift_2 to create.
     */
    public WorkCenterCapacityShift_2CreateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final WorkCenterCapacityShift_2 entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected WorkCenterCapacityShift_2 getEntity()
    {
        return entity;
    }

}
