/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCostCenterField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterCostCenterSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Cost Center Allocation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCenterCostCenterType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenterCostCenter extends VdmEntity<WorkCenterCostCenter>
{

    /**
     * Selector for all available fields of WorkCenterCostCenter.
     *
     */
    public final static WorkCenterCostCenterSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the resource
     */
    @Key
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> WORK_CENTER_INTERNAL_ID =
        new WorkCenterCostCenterField<String>("WorkCenterInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @Key
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> WORK_CENTER_TYPE_CODE =
        new WorkCenterCostCenterField<String>("WorkCenterTypeCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterAllocation</b>
     * </p>
     *
     * @return Cost Center Allocation
     */
    @Key
    @SerializedName( "CostCenterAllocation" )
    @JsonProperty( "CostCenterAllocation" )
    @Nullable
    @ODataField( odataName = "CostCenterAllocation" )
    private String costCenterAllocation;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterAllocation</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> COST_CENTER_ALLOCATION =
        new WorkCenterCostCenterField<String>("CostCenterAllocation");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<LocalDateTime> VALIDITY_END_DATE =
        new WorkCenterCostCenterField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<LocalDateTime> VALIDITY_START_DATE =
        new WorkCenterCostCenterField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> WORK_CENTER =
        new WorkCenterCostCenterField<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> PLANT = new WorkCenterCostCenterField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCategoryCode</b>
     * </p>
     *
     * @return Work Center Category
     */
    @SerializedName( "WorkCenterCategoryCode" )
    @JsonProperty( "WorkCenterCategoryCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterCategoryCode" )
    private String workCenterCategoryCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterCategoryCode</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> WORK_CENTER_CATEGORY_CODE =
        new WorkCenterCostCenterField<String>("WorkCenterCategoryCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> CONTROLLING_AREA =
        new WorkCenterCostCenterField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> COST_CENTER =
        new WorkCenterCostCenterField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @SerializedName( "CostCtrActivityType" )
    @JsonProperty( "CostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType" )
    private String costCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> COST_CTR_ACTIVITY_TYPE =
        new WorkCenterCostCenterField<String>("CostCtrActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeQtyUnit</b>
     * </p>
     *
     * @return Activity Unit
     */
    @SerializedName( "CostCtrActivityTypeQtyUnit" )
    @JsonProperty( "CostCtrActivityTypeQtyUnit" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityTypeQtyUnit" )
    private String costCtrActivityTypeQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityTypeQtyUnit</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> COST_CTR_ACTIVITY_TYPE_QTY_UNIT =
        new WorkCenterCostCenterField<String>("CostCtrActivityTypeQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @return Business Process
     */
    @SerializedName( "BusinessProcess" )
    @JsonProperty( "BusinessProcess" )
    @Nullable
    @ODataField( odataName = "BusinessProcess" )
    private String businessProcess;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcess</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> BUSINESS_PROCESS =
        new WorkCenterCostCenterField<String>("BusinessProcess");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ActivityDescOriginType</b>
     * </p>
     *
     * @return Activity Description Origin Type
     */
    @SerializedName( "ActivityDescOriginType" )
    @JsonProperty( "ActivityDescOriginType" )
    @Nullable
    @ODataField( odataName = "ActivityDescOriginType" )
    private String activityDescOriginType;
    /**
     * Use with available fluent helpers to apply the <b>ActivityDescOriginType</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> ACTIVITY_DESC_ORIGIN_TYPE =
        new WorkCenterCostCenterField<String>("ActivityDescOriginType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterActivityAltvDescID</b>
     * </p>
     *
     * @return ID for Alternative Activity Description
     */
    @SerializedName( "CostCenterActivityAltvDescID" )
    @JsonProperty( "CostCenterActivityAltvDescID" )
    @Nullable
    @ODataField( odataName = "CostCenterActivityAltvDescID" )
    private String costCenterActivityAltvDescID;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterActivityAltvDescID</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> COST_CENTER_ACTIVITY_ALTV_DESC_ID =
        new WorkCenterCostCenterField<String>("CostCenterActivityAltvDescID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterActivityTypeFormula</b>
     * </p>
     *
     * @return Formula key for costing
     */
    @SerializedName( "CostCenterActivityTypeFormula" )
    @JsonProperty( "CostCenterActivityTypeFormula" )
    @Nullable
    @ODataField( odataName = "CostCenterActivityTypeFormula" )
    private String costCenterActivityTypeFormula;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterActivityTypeFormula</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> COST_CENTER_ACTIVITY_TYPE_FORMULA =
        new WorkCenterCostCenterField<String>("CostCenterActivityTypeFormula");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActyTypeIsReferenced</b>
     * </p>
     *
     * @return Field is referenced
     */
    @SerializedName( "CostCtrActyTypeIsReferenced" )
    @JsonProperty( "CostCtrActyTypeIsReferenced" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CostCtrActyTypeIsReferenced" )
    private Boolean costCtrActyTypeIsReferenced;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActyTypeIsReferenced</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<Boolean> COST_CTR_ACTY_TYPE_IS_REFERENCED =
        new WorkCenterCostCenterField<Boolean>("CostCtrActyTypeIsReferenced");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActyTypeIncntvWageCode</b>
     * </p>
     *
     * @return Transfer activity types to incentive wages
     */
    @SerializedName( "CostCtrActyTypeIncntvWageCode" )
    @JsonProperty( "CostCtrActyTypeIncntvWageCode" )
    @Nullable
    @ODataField( odataName = "CostCtrActyTypeIncntvWageCode" )
    private String costCtrActyTypeIncntvWageCode;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActyTypeIncntvWageCode</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> COST_CTR_ACTY_TYPE_INCNTV_WAGE_CODE =
        new WorkCenterCostCenterField<String>("CostCtrActyTypeIncntvWageCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActyTypeRecdTypeGrpCode</b>
     * </p>
     *
     * @return Record type group
     */
    @SerializedName( "CostCtrActyTypeRecdTypeGrpCode" )
    @JsonProperty( "CostCtrActyTypeRecdTypeGrpCode" )
    @Nullable
    @ODataField( odataName = "CostCtrActyTypeRecdTypeGrpCode" )
    private String costCtrActyTypeRecdTypeGrpCode;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActyTypeRecdTypeGrpCode</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<String> COST_CTR_ACTY_TYPE_RECD_TYPE_GRP_CODE =
        new WorkCenterCostCenterField<String>("CostCtrActyTypeRecdTypeGrpCode");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterLastChangeDateTime</b>
     * </p>
     *
     * @return Date and Time of Last Change
     */
    @SerializedName( "WorkCenterLastChangeDateTime" )
    @JsonProperty( "WorkCenterLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "WorkCenterLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime workCenterLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterLastChangeDateTime</b> field to query operations.
     *
     */
    public final static WorkCenterCostCenterField<ZonedDateTime> WORK_CENTER_LAST_CHANGE_DATE_TIME =
        new WorkCenterCostCenterField<ZonedDateTime>("WorkCenterLastChangeDateTime");

    @Nonnull
    @Override
    public Class<WorkCenterCostCenter> getType()
    {
        return WorkCenterCostCenter.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID of the resource
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterAllocation</b>
     * </p>
     *
     * @param costCenterAllocation
     *            Cost Center Allocation
     */
    public void setCostCenterAllocation( @Nullable final String costCenterAllocation )
    {
        rememberChangedField("CostCenterAllocation", this.costCenterAllocation);
        this.costCenterAllocation = costCenterAllocation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCategoryCode</b>
     * </p>
     *
     * @param workCenterCategoryCode
     *            Work Center Category
     */
    public void setWorkCenterCategoryCode( @Nullable final String workCenterCategoryCode )
    {
        rememberChangedField("WorkCenterCategoryCode", this.workCenterCategoryCode);
        this.workCenterCategoryCode = workCenterCategoryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @param costCtrActivityType
     *            Activity Type
     */
    public void setCostCtrActivityType( @Nullable final String costCtrActivityType )
    {
        rememberChangedField("CostCtrActivityType", this.costCtrActivityType);
        this.costCtrActivityType = costCtrActivityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeQtyUnit</b>
     * </p>
     *
     * @param costCtrActivityTypeQtyUnit
     *            Activity Unit
     */
    public void setCostCtrActivityTypeQtyUnit( @Nullable final String costCtrActivityTypeQtyUnit )
    {
        rememberChangedField("CostCtrActivityTypeQtyUnit", this.costCtrActivityTypeQtyUnit);
        this.costCtrActivityTypeQtyUnit = costCtrActivityTypeQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcess</b>
     * </p>
     *
     * @param businessProcess
     *            Business Process
     */
    public void setBusinessProcess( @Nullable final String businessProcess )
    {
        rememberChangedField("BusinessProcess", this.businessProcess);
        this.businessProcess = businessProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ActivityDescOriginType</b>
     * </p>
     *
     * @param activityDescOriginType
     *            Activity Description Origin Type
     */
    public void setActivityDescOriginType( @Nullable final String activityDescOriginType )
    {
        rememberChangedField("ActivityDescOriginType", this.activityDescOriginType);
        this.activityDescOriginType = activityDescOriginType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterActivityAltvDescID</b>
     * </p>
     *
     * @param costCenterActivityAltvDescID
     *            ID for Alternative Activity Description
     */
    public void setCostCenterActivityAltvDescID( @Nullable final String costCenterActivityAltvDescID )
    {
        rememberChangedField("CostCenterActivityAltvDescID", this.costCenterActivityAltvDescID);
        this.costCenterActivityAltvDescID = costCenterActivityAltvDescID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterActivityTypeFormula</b>
     * </p>
     *
     * @param costCenterActivityTypeFormula
     *            Formula key for costing
     */
    public void setCostCenterActivityTypeFormula( @Nullable final String costCenterActivityTypeFormula )
    {
        rememberChangedField("CostCenterActivityTypeFormula", this.costCenterActivityTypeFormula);
        this.costCenterActivityTypeFormula = costCenterActivityTypeFormula;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActyTypeIsReferenced</b>
     * </p>
     *
     * @param costCtrActyTypeIsReferenced
     *            Field is referenced
     */
    public void setCostCtrActyTypeIsReferenced( @Nullable final Boolean costCtrActyTypeIsReferenced )
    {
        rememberChangedField("CostCtrActyTypeIsReferenced", this.costCtrActyTypeIsReferenced);
        this.costCtrActyTypeIsReferenced = costCtrActyTypeIsReferenced;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActyTypeIncntvWageCode</b>
     * </p>
     *
     * @param costCtrActyTypeIncntvWageCode
     *            Transfer activity types to incentive wages
     */
    public void setCostCtrActyTypeIncntvWageCode( @Nullable final String costCtrActyTypeIncntvWageCode )
    {
        rememberChangedField("CostCtrActyTypeIncntvWageCode", this.costCtrActyTypeIncntvWageCode);
        this.costCtrActyTypeIncntvWageCode = costCtrActyTypeIncntvWageCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActyTypeRecdTypeGrpCode</b>
     * </p>
     *
     * @param costCtrActyTypeRecdTypeGrpCode
     *            Record type group
     */
    public void setCostCtrActyTypeRecdTypeGrpCode( @Nullable final String costCtrActyTypeRecdTypeGrpCode )
    {
        rememberChangedField("CostCtrActyTypeRecdTypeGrpCode", this.costCtrActyTypeRecdTypeGrpCode);
        this.costCtrActyTypeRecdTypeGrpCode = costCtrActyTypeRecdTypeGrpCode;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterLastChangeDateTime</b>
     * </p>
     *
     * @param workCenterLastChangeDateTime
     *            Date and Time of Last Change
     */
    public void setWorkCenterLastChangeDateTime( @Nullable final ZonedDateTime workCenterLastChangeDateTime )
    {
        rememberChangedField("WorkCenterLastChangeDateTime", this.workCenterLastChangeDateTime);
        this.workCenterLastChangeDateTime = workCenterLastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenterCostCenter";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WorkCenterInternalID", getWorkCenterInternalID());
        result.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        result.put("CostCenterAllocation", getCostCenterAllocation());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("CostCenterAllocation", getCostCenterAllocation());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("WorkCenter", getWorkCenter());
        values.put("Plant", getPlant());
        values.put("WorkCenterCategoryCode", getWorkCenterCategoryCode());
        values.put("ControllingArea", getControllingArea());
        values.put("CostCenter", getCostCenter());
        values.put("CostCtrActivityType", getCostCtrActivityType());
        values.put("CostCtrActivityTypeQtyUnit", getCostCtrActivityTypeQtyUnit());
        values.put("BusinessProcess", getBusinessProcess());
        values.put("ActivityDescOriginType", getActivityDescOriginType());
        values.put("CostCenterActivityAltvDescID", getCostCenterActivityAltvDescID());
        values.put("CostCenterActivityTypeFormula", getCostCenterActivityTypeFormula());
        values.put("CostCtrActyTypeIsReferenced", getCostCtrActyTypeIsReferenced());
        values.put("CostCtrActyTypeIncntvWageCode", getCostCtrActyTypeIncntvWageCode());
        values.put("CostCtrActyTypeRecdTypeGrpCode", getCostCtrActyTypeRecdTypeGrpCode());
        values.put("WorkCenterLastChangeDateTime", getWorkCenterLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("CostCenterAllocation") ) {
                final Object value = values.remove("CostCenterAllocation");
                if( (value == null) || (!value.equals(getCostCenterAllocation())) ) {
                    setCostCenterAllocation(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("WorkCenterCategoryCode") ) {
                final Object value = values.remove("WorkCenterCategoryCode");
                if( (value == null) || (!value.equals(getWorkCenterCategoryCode())) ) {
                    setWorkCenterCategoryCode(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType") ) {
                final Object value = values.remove("CostCtrActivityType");
                if( (value == null) || (!value.equals(getCostCtrActivityType())) ) {
                    setCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityTypeQtyUnit") ) {
                final Object value = values.remove("CostCtrActivityTypeQtyUnit");
                if( (value == null) || (!value.equals(getCostCtrActivityTypeQtyUnit())) ) {
                    setCostCtrActivityTypeQtyUnit(((String) value));
                }
            }
            if( values.containsKey("BusinessProcess") ) {
                final Object value = values.remove("BusinessProcess");
                if( (value == null) || (!value.equals(getBusinessProcess())) ) {
                    setBusinessProcess(((String) value));
                }
            }
            if( values.containsKey("ActivityDescOriginType") ) {
                final Object value = values.remove("ActivityDescOriginType");
                if( (value == null) || (!value.equals(getActivityDescOriginType())) ) {
                    setActivityDescOriginType(((String) value));
                }
            }
            if( values.containsKey("CostCenterActivityAltvDescID") ) {
                final Object value = values.remove("CostCenterActivityAltvDescID");
                if( (value == null) || (!value.equals(getCostCenterActivityAltvDescID())) ) {
                    setCostCenterActivityAltvDescID(((String) value));
                }
            }
            if( values.containsKey("CostCenterActivityTypeFormula") ) {
                final Object value = values.remove("CostCenterActivityTypeFormula");
                if( (value == null) || (!value.equals(getCostCenterActivityTypeFormula())) ) {
                    setCostCenterActivityTypeFormula(((String) value));
                }
            }
            if( values.containsKey("CostCtrActyTypeIsReferenced") ) {
                final Object value = values.remove("CostCtrActyTypeIsReferenced");
                if( (value == null) || (!value.equals(getCostCtrActyTypeIsReferenced())) ) {
                    setCostCtrActyTypeIsReferenced(((Boolean) value));
                }
            }
            if( values.containsKey("CostCtrActyTypeIncntvWageCode") ) {
                final Object value = values.remove("CostCtrActyTypeIncntvWageCode");
                if( (value == null) || (!value.equals(getCostCtrActyTypeIncntvWageCode())) ) {
                    setCostCtrActyTypeIncntvWageCode(((String) value));
                }
            }
            if( values.containsKey("CostCtrActyTypeRecdTypeGrpCode") ) {
                final Object value = values.remove("CostCtrActyTypeRecdTypeGrpCode");
                if( (value == null) || (!value.equals(getCostCtrActyTypeRecdTypeGrpCode())) ) {
                    setCostCtrActyTypeRecdTypeGrpCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenterLastChangeDateTime") ) {
                final Object value = values.remove("WorkCenterLastChangeDateTime");
                if( (value == null) || (!value.equals(getWorkCenterLastChangeDateTime())) ) {
                    setWorkCenterLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WorkCenterCostCenterField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkCenterCostCenterField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCenterCostCenterField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCenterCostCenterField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

}
