/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterDayOperationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterDayOperationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Daily Operations
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCenterDayOperationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenterDayOperation extends VdmEntity<WorkCenterDayOperation>
{

    /**
     * Selector for all available fields of WorkCenterDayOperation.
     *
     */
    public final static WorkCenterDayOperationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Work Center Internal ID
     */
    @Key
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<String> WORK_CENTER_INTERNAL_ID =
        new WorkCenterDayOperationField<String>("WorkCenterInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Manufacturing Order ID
     */
    @Key
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<String> MANUFACTURING_ORDER =
        new WorkCenterDayOperationField<String>("ManufacturingOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @return Manufacturing Order Operation
     */
    @Key
    @SerializedName( "ManufacturingOrderOperation" )
    @JsonProperty( "ManufacturingOrderOperation" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderOperation" )
    private String manufacturingOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderOperation</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<String> MANUFACTURING_ORDER_OPERATION =
        new WorkCenterDayOperationField<String>("ManufacturingOrderOperation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @return Manufacturing Order Category
     */
    @Key
    @SerializedName( "ManufacturingOrderCategory" )
    @JsonProperty( "ManufacturingOrderCategory" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderCategory" )
    private String manufacturingOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderCategory</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<String> MANUFACTURING_ORDER_CATEGORY =
        new WorkCenterDayOperationField<String>("ManufacturingOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderOperationText</b>
     * </p>
     *
     * @return Manufacturing Order Operation Text
     */
    @SerializedName( "MfgOrderOperationText" )
    @JsonProperty( "MfgOrderOperationText" )
    @Nullable
    @ODataField( odataName = "MfgOrderOperationText" )
    private String mfgOrderOperationText;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderOperationText</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<String> MFG_ORDER_OPERATION_TEXT =
        new WorkCenterDayOperationField<String>("MfgOrderOperationText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number for Order
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<String> MATERIAL =
        new WorkCenterDayOperationField<String>("Material");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsReleased</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "OperationIsReleased" )
    @JsonProperty( "OperationIsReleased" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "OperationIsReleased" )
    private Boolean operationIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>OperationIsReleased</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<Boolean> OPERATION_IS_RELEASED =
        new WorkCenterDayOperationField<Boolean>("OperationIsReleased");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtDte</b>
     * </p>
     *
     * @return Earliest Scheduled Execution Start Date
     */
    @SerializedName( "OpErlstSchedldExecStrtDte" )
    @JsonProperty( "OpErlstSchedldExecStrtDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecStrtDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opErlstSchedldExecStrtDte;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecStrtDte</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<LocalDateTime> OP_ERLST_SCHEDLD_EXEC_STRT_DTE =
        new WorkCenterDayOperationField<LocalDateTime>("OpErlstSchedldExecStrtDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtTme</b>
     * </p>
     *
     * @return Earliest Scheduled Execution Start Time
     */
    @SerializedName( "OpErlstSchedldExecStrtTme" )
    @JsonProperty( "OpErlstSchedldExecStrtTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecStrtTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opErlstSchedldExecStrtTme;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecStrtTme</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<LocalTime> OP_ERLST_SCHEDLD_EXEC_STRT_TME =
        new WorkCenterDayOperationField<LocalTime>("OpErlstSchedldExecStrtTme");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndDte</b>
     * </p>
     *
     * @return Earliest Scheduled Execution End Date
     */
    @SerializedName( "OpErlstSchedldExecEndDte" )
    @JsonProperty( "OpErlstSchedldExecEndDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecEndDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opErlstSchedldExecEndDte;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecEndDte</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<LocalDateTime> OP_ERLST_SCHEDLD_EXEC_END_DTE =
        new WorkCenterDayOperationField<LocalDateTime>("OpErlstSchedldExecEndDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndTme</b>
     * </p>
     *
     * @return Earliest Scheduled Execution End Time
     */
    @SerializedName( "OpErlstSchedldExecEndTme" )
    @JsonProperty( "OpErlstSchedldExecEndTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecEndTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opErlstSchedldExecEndTme;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecEndTme</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<LocalTime> OP_ERLST_SCHEDLD_EXEC_END_TME =
        new WorkCenterDayOperationField<LocalTime>("OpErlstSchedldExecEndTme");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpPlannedTotalQuantity</b>
     * </p>
     *
     * @return Operation Total Quantity
     */
    @SerializedName( "OpPlannedTotalQuantity" )
    @JsonProperty( "OpPlannedTotalQuantity" )
    @Nullable
    @ODataField( odataName = "OpPlannedTotalQuantity" )
    private BigDecimal opPlannedTotalQuantity;
    /**
     * Use with available fluent helpers to apply the <b>OpPlannedTotalQuantity</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<BigDecimal> OP_PLANNED_TOTAL_QUANTITY =
        new WorkCenterDayOperationField<BigDecimal>("OpPlannedTotalQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @return Operation Unit of Measure
     */
    @SerializedName( "OperationUnit" )
    @JsonProperty( "OperationUnit" )
    @Nullable
    @ODataField( odataName = "OperationUnit" )
    private String operationUnit;
    /**
     * Use with available fluent helpers to apply the <b>OperationUnit</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<String> OPERATION_UNIT =
        new WorkCenterDayOperationField<String>("OperationUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedQuantity</b>
     * </p>
     *
     * @return The confirmedQuantity contained in this entity.
     */
    @SerializedName( "ConfirmedQuantity" )
    @JsonProperty( "ConfirmedQuantity" )
    @Nullable
    @ODataField( odataName = "ConfirmedQuantity" )
    private BigDecimal confirmedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedQuantity</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<BigDecimal> CONFIRMED_QUANTITY =
        new WorkCenterDayOperationField<BigDecimal>("ConfirmedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedQuantityInBaseUnit</b>
     * </p>
     *
     * @return Production Unit of Measure
     */
    @SerializedName( "ConfirmedQuantityInBaseUnit" )
    @JsonProperty( "ConfirmedQuantityInBaseUnit" )
    @Nullable
    @ODataField( odataName = "ConfirmedQuantityInBaseUnit" )
    private String confirmedQuantityInBaseUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedQuantityInBaseUnit</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<String> CONFIRMED_QUANTITY_IN_BASE_UNIT =
        new WorkCenterDayOperationField<String>("ConfirmedQuantityInBaseUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedQuantityUnit</b>
     * </p>
     *
     * @return Production Unit of Measure
     */
    @SerializedName( "ConfirmedQuantityUnit" )
    @JsonProperty( "ConfirmedQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConfirmedQuantityUnit" )
    private String confirmedQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedQuantityUnit</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<String> CONFIRMED_QUANTITY_UNIT =
        new WorkCenterDayOperationField<String>("ConfirmedQuantityUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ErlstSchedldExecDurnInWorkdays</b>
     * </p>
     *
     * @return Earliest Scheduled Execution Duration in Workdays
     */
    @SerializedName( "ErlstSchedldExecDurnInWorkdays" )
    @JsonProperty( "ErlstSchedldExecDurnInWorkdays" )
    @Nullable
    @ODataField( odataName = "ErlstSchedldExecDurnInWorkdays" )
    private Integer erlstSchedldExecDurnInWorkdays;
    /**
     * Use with available fluent helpers to apply the <b>ErlstSchedldExecDurnInWorkdays</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<Integer> ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS =
        new WorkCenterDayOperationField<Integer>("ErlstSchedldExecDurnInWorkdays");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionDays</b>
     * </p>
     *
     * @return Actual Execution Duration in Workdays
     */
    @SerializedName( "OpActualExecutionDays" )
    @JsonProperty( "OpActualExecutionDays" )
    @Nullable
    @ODataField( odataName = "OpActualExecutionDays" )
    private Integer opActualExecutionDays;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionDays</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<Integer> OP_ACTUAL_EXECUTION_DAYS =
        new WorkCenterDayOperationField<Integer>("OpActualExecutionDays");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @return Manufacturing Order Sequence
     */
    @SerializedName( "ManufacturingOrderSequence" )
    @JsonProperty( "ManufacturingOrderSequence" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderSequence" )
    private String manufacturingOrderSequence;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderSequence</b> field to query operations.
     *
     */
    public final static WorkCenterDayOperationField<String> MANUFACTURING_ORDER_SEQUENCE =
        new WorkCenterDayOperationField<String>("ManufacturingOrderSequence");

    @Nonnull
    @Override
    public Class<WorkCenterDayOperation> getType()
    {
        return WorkCenterDayOperation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Work Center Internal ID
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Manufacturing Order ID
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @param manufacturingOrderOperation
     *            Manufacturing Order Operation
     */
    public void setManufacturingOrderOperation( @Nullable final String manufacturingOrderOperation )
    {
        rememberChangedField("ManufacturingOrderOperation", this.manufacturingOrderOperation);
        this.manufacturingOrderOperation = manufacturingOrderOperation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @param manufacturingOrderCategory
     *            Manufacturing Order Category
     */
    public void setManufacturingOrderCategory( @Nullable final String manufacturingOrderCategory )
    {
        rememberChangedField("ManufacturingOrderCategory", this.manufacturingOrderCategory);
        this.manufacturingOrderCategory = manufacturingOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderOperationText</b>
     * </p>
     *
     * @param mfgOrderOperationText
     *            Manufacturing Order Operation Text
     */
    public void setMfgOrderOperationText( @Nullable final String mfgOrderOperationText )
    {
        rememberChangedField("MfgOrderOperationText", this.mfgOrderOperationText);
        this.mfgOrderOperationText = mfgOrderOperationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number for Order
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OperationIsReleased</b>
     * </p>
     *
     * @param operationIsReleased
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setOperationIsReleased( @Nullable final Boolean operationIsReleased )
    {
        rememberChangedField("OperationIsReleased", this.operationIsReleased);
        this.operationIsReleased = operationIsReleased;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtDte</b>
     * </p>
     *
     * @param opErlstSchedldExecStrtDte
     *            Earliest Scheduled Execution Start Date
     */
    public void setOpErlstSchedldExecStrtDte( @Nullable final LocalDateTime opErlstSchedldExecStrtDte )
    {
        rememberChangedField("OpErlstSchedldExecStrtDte", this.opErlstSchedldExecStrtDte);
        this.opErlstSchedldExecStrtDte = opErlstSchedldExecStrtDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtTme</b>
     * </p>
     *
     * @param opErlstSchedldExecStrtTme
     *            Earliest Scheduled Execution Start Time
     */
    public void setOpErlstSchedldExecStrtTme( @Nullable final LocalTime opErlstSchedldExecStrtTme )
    {
        rememberChangedField("OpErlstSchedldExecStrtTme", this.opErlstSchedldExecStrtTme);
        this.opErlstSchedldExecStrtTme = opErlstSchedldExecStrtTme;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndDte</b>
     * </p>
     *
     * @param opErlstSchedldExecEndDte
     *            Earliest Scheduled Execution End Date
     */
    public void setOpErlstSchedldExecEndDte( @Nullable final LocalDateTime opErlstSchedldExecEndDte )
    {
        rememberChangedField("OpErlstSchedldExecEndDte", this.opErlstSchedldExecEndDte);
        this.opErlstSchedldExecEndDte = opErlstSchedldExecEndDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndTme</b>
     * </p>
     *
     * @param opErlstSchedldExecEndTme
     *            Earliest Scheduled Execution End Time
     */
    public void setOpErlstSchedldExecEndTme( @Nullable final LocalTime opErlstSchedldExecEndTme )
    {
        rememberChangedField("OpErlstSchedldExecEndTme", this.opErlstSchedldExecEndTme);
        this.opErlstSchedldExecEndTme = opErlstSchedldExecEndTme;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpPlannedTotalQuantity</b>
     * </p>
     *
     * @param opPlannedTotalQuantity
     *            Operation Total Quantity
     */
    public void setOpPlannedTotalQuantity( @Nullable final BigDecimal opPlannedTotalQuantity )
    {
        rememberChangedField("OpPlannedTotalQuantity", this.opPlannedTotalQuantity);
        this.opPlannedTotalQuantity = opPlannedTotalQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @param operationUnit
     *            Operation Unit of Measure
     */
    public void setOperationUnit( @Nullable final String operationUnit )
    {
        rememberChangedField("OperationUnit", this.operationUnit);
        this.operationUnit = operationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedQuantity</b>
     * </p>
     *
     * @param confirmedQuantity
     *            The confirmedQuantity to set.
     */
    public void setConfirmedQuantity( @Nullable final BigDecimal confirmedQuantity )
    {
        rememberChangedField("ConfirmedQuantity", this.confirmedQuantity);
        this.confirmedQuantity = confirmedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedQuantityInBaseUnit</b>
     * </p>
     *
     * @param confirmedQuantityInBaseUnit
     *            Production Unit of Measure
     */
    public void setConfirmedQuantityInBaseUnit( @Nullable final String confirmedQuantityInBaseUnit )
    {
        rememberChangedField("ConfirmedQuantityInBaseUnit", this.confirmedQuantityInBaseUnit);
        this.confirmedQuantityInBaseUnit = confirmedQuantityInBaseUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedQuantityUnit</b>
     * </p>
     *
     * @param confirmedQuantityUnit
     *            Production Unit of Measure
     */
    public void setConfirmedQuantityUnit( @Nullable final String confirmedQuantityUnit )
    {
        rememberChangedField("ConfirmedQuantityUnit", this.confirmedQuantityUnit);
        this.confirmedQuantityUnit = confirmedQuantityUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ErlstSchedldExecDurnInWorkdays</b>
     * </p>
     *
     * @param erlstSchedldExecDurnInWorkdays
     *            Earliest Scheduled Execution Duration in Workdays
     */
    public void setErlstSchedldExecDurnInWorkdays( @Nullable final Integer erlstSchedldExecDurnInWorkdays )
    {
        rememberChangedField("ErlstSchedldExecDurnInWorkdays", this.erlstSchedldExecDurnInWorkdays);
        this.erlstSchedldExecDurnInWorkdays = erlstSchedldExecDurnInWorkdays;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionDays</b>
     * </p>
     *
     * @param opActualExecutionDays
     *            Actual Execution Duration in Workdays
     */
    public void setOpActualExecutionDays( @Nullable final Integer opActualExecutionDays )
    {
        rememberChangedField("OpActualExecutionDays", this.opActualExecutionDays);
        this.opActualExecutionDays = opActualExecutionDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @param manufacturingOrderSequence
     *            Manufacturing Order Sequence
     */
    public void setManufacturingOrderSequence( @Nullable final String manufacturingOrderSequence )
    {
        rememberChangedField("ManufacturingOrderSequence", this.manufacturingOrderSequence);
        this.manufacturingOrderSequence = manufacturingOrderSequence;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenterDayOperation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WorkCenterInternalID", getWorkCenterInternalID());
        result.put("ManufacturingOrder", getManufacturingOrder());
        result.put("ManufacturingOrderOperation", getManufacturingOrderOperation());
        result.put("ManufacturingOrderCategory", getManufacturingOrderCategory());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("ManufacturingOrderOperation", getManufacturingOrderOperation());
        values.put("ManufacturingOrderCategory", getManufacturingOrderCategory());
        values.put("MfgOrderOperationText", getMfgOrderOperationText());
        values.put("Material", getMaterial());
        values.put("OperationIsReleased", getOperationIsReleased());
        values.put("OpErlstSchedldExecStrtDte", getOpErlstSchedldExecStrtDte());
        values.put("OpErlstSchedldExecStrtTme", getOpErlstSchedldExecStrtTme());
        values.put("OpErlstSchedldExecEndDte", getOpErlstSchedldExecEndDte());
        values.put("OpErlstSchedldExecEndTme", getOpErlstSchedldExecEndTme());
        values.put("OpPlannedTotalQuantity", getOpPlannedTotalQuantity());
        values.put("OperationUnit", getOperationUnit());
        values.put("ConfirmedQuantity", getConfirmedQuantity());
        values.put("ConfirmedQuantityInBaseUnit", getConfirmedQuantityInBaseUnit());
        values.put("ConfirmedQuantityUnit", getConfirmedQuantityUnit());
        values.put("ErlstSchedldExecDurnInWorkdays", getErlstSchedldExecDurnInWorkdays());
        values.put("OpActualExecutionDays", getOpActualExecutionDays());
        values.put("ManufacturingOrderSequence", getManufacturingOrderSequence());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderOperation") ) {
                final Object value = values.remove("ManufacturingOrderOperation");
                if( (value == null) || (!value.equals(getManufacturingOrderOperation())) ) {
                    setManufacturingOrderOperation(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderCategory") ) {
                final Object value = values.remove("ManufacturingOrderCategory");
                if( (value == null) || (!value.equals(getManufacturingOrderCategory())) ) {
                    setManufacturingOrderCategory(((String) value));
                }
            }
            if( values.containsKey("MfgOrderOperationText") ) {
                final Object value = values.remove("MfgOrderOperationText");
                if( (value == null) || (!value.equals(getMfgOrderOperationText())) ) {
                    setMfgOrderOperationText(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("OperationIsReleased") ) {
                final Object value = values.remove("OperationIsReleased");
                if( (value == null) || (!value.equals(getOperationIsReleased())) ) {
                    setOperationIsReleased(((Boolean) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecStrtDte") ) {
                final Object value = values.remove("OpErlstSchedldExecStrtDte");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecStrtDte())) ) {
                    setOpErlstSchedldExecStrtDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecStrtTme") ) {
                final Object value = values.remove("OpErlstSchedldExecStrtTme");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecStrtTme())) ) {
                    setOpErlstSchedldExecStrtTme(((LocalTime) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecEndDte") ) {
                final Object value = values.remove("OpErlstSchedldExecEndDte");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecEndDte())) ) {
                    setOpErlstSchedldExecEndDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecEndTme") ) {
                final Object value = values.remove("OpErlstSchedldExecEndTme");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecEndTme())) ) {
                    setOpErlstSchedldExecEndTme(((LocalTime) value));
                }
            }
            if( values.containsKey("OpPlannedTotalQuantity") ) {
                final Object value = values.remove("OpPlannedTotalQuantity");
                if( (value == null) || (!value.equals(getOpPlannedTotalQuantity())) ) {
                    setOpPlannedTotalQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("OperationUnit") ) {
                final Object value = values.remove("OperationUnit");
                if( (value == null) || (!value.equals(getOperationUnit())) ) {
                    setOperationUnit(((String) value));
                }
            }
            if( values.containsKey("ConfirmedQuantity") ) {
                final Object value = values.remove("ConfirmedQuantity");
                if( (value == null) || (!value.equals(getConfirmedQuantity())) ) {
                    setConfirmedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConfirmedQuantityInBaseUnit") ) {
                final Object value = values.remove("ConfirmedQuantityInBaseUnit");
                if( (value == null) || (!value.equals(getConfirmedQuantityInBaseUnit())) ) {
                    setConfirmedQuantityInBaseUnit(((String) value));
                }
            }
            if( values.containsKey("ConfirmedQuantityUnit") ) {
                final Object value = values.remove("ConfirmedQuantityUnit");
                if( (value == null) || (!value.equals(getConfirmedQuantityUnit())) ) {
                    setConfirmedQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ErlstSchedldExecDurnInWorkdays") ) {
                final Object value = values.remove("ErlstSchedldExecDurnInWorkdays");
                if( (value == null) || (!value.equals(getErlstSchedldExecDurnInWorkdays())) ) {
                    setErlstSchedldExecDurnInWorkdays(((Integer) value));
                }
            }
            if( values.containsKey("OpActualExecutionDays") ) {
                final Object value = values.remove("OpActualExecutionDays");
                if( (value == null) || (!value.equals(getOpActualExecutionDays())) ) {
                    setOpActualExecutionDays(((Integer) value));
                }
            }
            if( values.containsKey("ManufacturingOrderSequence") ) {
                final Object value = values.remove("ManufacturingOrderSequence");
                if( (value == null) || (!value.equals(getManufacturingOrderSequence())) ) {
                    setManufacturingOrderSequence(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WorkCenterDayOperationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkCenterDayOperationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCenterDayOperationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCenterDayOperationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

}
