/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCenterPipeLineOperationSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterPipeLineOperation
 * WorkCenterPipeLineOperation} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class WorkCenterPipeLineOperationByKeyFluentHelper
    extends
    FluentHelperByKey<WorkCenterPipeLineOperationByKeyFluentHelper, WorkCenterPipeLineOperation, WorkCenterPipeLineOperationSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterPipeLineOperation
     * WorkCenterPipeLineOperation} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WorkCenterPipeLineOperation}
     * @param manufacturingOrderCategory
     *            Manufacturing Order Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code WorkCenterPipeLineOperation}
     * @param manufacturingOrderOperation
     *            Manufacturing Order Operation
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param manufacturingOrder
     *            Manufacturing Order ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param workCenterInternalID
     *            Work Center Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     */
    public WorkCenterPipeLineOperationByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String workCenterInternalID,
        final String manufacturingOrder,
        final String manufacturingOrderOperation,
        final String manufacturingOrderCategory )
    {
        super(servicePath, entityCollection);
        this.key.put("WorkCenterInternalID", workCenterInternalID);
        this.key.put("ManufacturingOrder", manufacturingOrder);
        this.key.put("ManufacturingOrderOperation", manufacturingOrderOperation);
        this.key.put("ManufacturingOrderCategory", manufacturingOrderCategory);
    }

    @Override
    @Nonnull
    protected Class<WorkCenterPipeLineOperation> getEntityClass()
    {
        return WorkCenterPipeLineOperation.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
