/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCentersField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCentersLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCentersOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable.WorkCentersSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_WorkCentersType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WorkCenters extends VdmEntity<WorkCenters>
{

    /**
     * Selector for all available fields of WorkCenters.
     *
     */
    public final static WorkCentersSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Object ID of the resource
     */
    @Key
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_INTERNAL_ID =
        new WorkCentersField<String>("WorkCenterInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Object types of the CIM resource
     */
    @Key
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_TYPE_CODE =
        new WorkCentersField<String>("WorkCenterTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER = new WorkCentersField<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterDesc</b>
     * </p>
     *
     * @return Work Center Text
     */
    @SerializedName( "WorkCenterDesc" )
    @JsonProperty( "WorkCenterDesc" )
    @Nullable
    @ODataField( odataName = "WorkCenterDesc" )
    private String workCenterDesc;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterDesc</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_DESC = new WorkCentersField<String>("WorkCenterDesc");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> PLANT = new WorkCentersField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCategoryCode</b>
     * </p>
     *
     * @return Work Center Category
     */
    @SerializedName( "WorkCenterCategoryCode" )
    @JsonProperty( "WorkCenterCategoryCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterCategoryCode" )
    private String workCenterCategoryCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterCategoryCode</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_CATEGORY_CODE =
        new WorkCentersField<String>("WorkCenterCategoryCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsible</b>
     * </p>
     *
     * @return Person Responsible for the Work Center
     */
    @SerializedName( "WorkCenterResponsible" )
    @JsonProperty( "WorkCenterResponsible" )
    @Nullable
    @ODataField( odataName = "WorkCenterResponsible" )
    private String workCenterResponsible;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterResponsible</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_RESPONSIBLE =
        new WorkCentersField<String>("WorkCenterResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsibleName</b>
     * </p>
     *
     * @return Work Center Responsible Name
     */
    @SerializedName( "WorkCenterResponsibleName" )
    @JsonProperty( "WorkCenterResponsibleName" )
    @Nullable
    @ODataField( odataName = "WorkCenterResponsibleName" )
    private String workCenterResponsibleName;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterResponsibleName</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_RESPONSIBLE_NAME =
        new WorkCentersField<String>("WorkCenterResponsibleName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyArea</b>
     * </p>
     *
     * @return Production Supply Area
     */
    @SerializedName( "SupplyArea" )
    @JsonProperty( "SupplyArea" )
    @Nullable
    @ODataField( odataName = "SupplyArea" )
    private String supplyArea;
    /**
     * Use with available fluent helpers to apply the <b>SupplyArea</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> SUPPLY_AREA = new WorkCentersField<String>("SupplyArea");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterUsage</b>
     * </p>
     *
     * @return Work Center Usage in Bill of Operations
     */
    @SerializedName( "WorkCenterUsage" )
    @JsonProperty( "WorkCenterUsage" )
    @Nullable
    @ODataField( odataName = "WorkCenterUsage" )
    private String workCenterUsage;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterUsage</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_USAGE = new WorkCentersField<String>("WorkCenterUsage");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @return Capacity ID
     */
    @SerializedName( "CapacityInternalID" )
    @JsonProperty( "CapacityInternalID" )
    @Nullable
    @ODataField( odataName = "CapacityInternalID" )
    private String capacityInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CapacityInternalID</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> CAPACITY_INTERNAL_ID =
        new WorkCentersField<String>("CapacityInternalID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterIsToBeDeleted</b>
     * </p>
     *
     * @return Deletion flag for work center
     */
    @SerializedName( "WorkCenterIsToBeDeleted" )
    @JsonProperty( "WorkCenterIsToBeDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WorkCenterIsToBeDeleted" )
    private Boolean workCenterIsToBeDeleted;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterIsToBeDeleted</b> field to query operations.
     *
     */
    public final static WorkCentersField<Boolean> WORK_CENTER_IS_TO_BE_DELETED =
        new WorkCentersField<Boolean>("WorkCenterIsToBeDeleted");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static WorkCentersField<LocalDateTime> VALIDITY_START_DATE =
        new WorkCentersField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid-To Date
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static WorkCentersField<LocalDateTime> VALIDITY_END_DATE =
        new WorkCentersField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFormulaParam1</b>
     * </p>
     *
     * @return Work Center Formula Parameter 1
     */
    @SerializedName( "WorkCenterFormulaParam1" )
    @JsonProperty( "WorkCenterFormulaParam1" )
    @Nullable
    @ODataField( odataName = "WorkCenterFormulaParam1" )
    private String workCenterFormulaParam1;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFormulaParam1</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_FORMULA_PARAM1 =
        new WorkCentersField<String>("WorkCenterFormulaParam1");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFormulaParam2</b>
     * </p>
     *
     * @return Work Center Formula Parameter 2
     */
    @SerializedName( "WorkCenterFormulaParam2" )
    @JsonProperty( "WorkCenterFormulaParam2" )
    @Nullable
    @ODataField( odataName = "WorkCenterFormulaParam2" )
    private String workCenterFormulaParam2;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFormulaParam2</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_FORMULA_PARAM2 =
        new WorkCentersField<String>("WorkCenterFormulaParam2");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFormulaParam3</b>
     * </p>
     *
     * @return Work Center Formula Parameter 3
     */
    @SerializedName( "WorkCenterFormulaParam3" )
    @JsonProperty( "WorkCenterFormulaParam3" )
    @Nullable
    @ODataField( odataName = "WorkCenterFormulaParam3" )
    private String workCenterFormulaParam3;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFormulaParam3</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_FORMULA_PARAM3 =
        new WorkCentersField<String>("WorkCenterFormulaParam3");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFormulaParam4</b>
     * </p>
     *
     * @return Work Center Formula Parameter 4
     */
    @SerializedName( "WorkCenterFormulaParam4" )
    @JsonProperty( "WorkCenterFormulaParam4" )
    @Nullable
    @ODataField( odataName = "WorkCenterFormulaParam4" )
    private String workCenterFormulaParam4;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFormulaParam4</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_FORMULA_PARAM4 =
        new WorkCentersField<String>("WorkCenterFormulaParam4");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFormulaParam5</b>
     * </p>
     *
     * @return Work Center Formula Parameter 5
     */
    @SerializedName( "WorkCenterFormulaParam5" )
    @JsonProperty( "WorkCenterFormulaParam5" )
    @Nullable
    @ODataField( odataName = "WorkCenterFormulaParam5" )
    private String workCenterFormulaParam5;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFormulaParam5</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_FORMULA_PARAM5 =
        new WorkCentersField<String>("WorkCenterFormulaParam5");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFormulaParam6</b>
     * </p>
     *
     * @return Work Center Formula Parameter 6
     */
    @SerializedName( "WorkCenterFormulaParam6" )
    @JsonProperty( "WorkCenterFormulaParam6" )
    @Nullable
    @ODataField( odataName = "WorkCenterFormulaParam6" )
    private String workCenterFormulaParam6;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFormulaParam6</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_FORMULA_PARAM6 =
        new WorkCentersField<String>("WorkCenterFormulaParam6");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamValue1</b>
     * </p>
     *
     * @return Work Center Formula Parameter Value 1
     */
    @SerializedName( "WorkCenterFmlaParamValue1" )
    @JsonProperty( "WorkCenterFmlaParamValue1" )
    @Nullable
    @ODataField( odataName = "WorkCenterFmlaParamValue1" )
    private BigDecimal workCenterFmlaParamValue1;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFmlaParamValue1</b> field to query operations.
     *
     */
    public final static WorkCentersField<BigDecimal> WORK_CENTER_FMLA_PARAM_VALUE1 =
        new WorkCentersField<BigDecimal>("WorkCenterFmlaParamValue1");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamValue2</b>
     * </p>
     *
     * @return Work Center Formula Parameter Value 2
     */
    @SerializedName( "WorkCenterFmlaParamValue2" )
    @JsonProperty( "WorkCenterFmlaParamValue2" )
    @Nullable
    @ODataField( odataName = "WorkCenterFmlaParamValue2" )
    private BigDecimal workCenterFmlaParamValue2;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFmlaParamValue2</b> field to query operations.
     *
     */
    public final static WorkCentersField<BigDecimal> WORK_CENTER_FMLA_PARAM_VALUE2 =
        new WorkCentersField<BigDecimal>("WorkCenterFmlaParamValue2");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamValue3</b>
     * </p>
     *
     * @return Work Center Formula Parameter Value 3
     */
    @SerializedName( "WorkCenterFmlaParamValue3" )
    @JsonProperty( "WorkCenterFmlaParamValue3" )
    @Nullable
    @ODataField( odataName = "WorkCenterFmlaParamValue3" )
    private BigDecimal workCenterFmlaParamValue3;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFmlaParamValue3</b> field to query operations.
     *
     */
    public final static WorkCentersField<BigDecimal> WORK_CENTER_FMLA_PARAM_VALUE3 =
        new WorkCentersField<BigDecimal>("WorkCenterFmlaParamValue3");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamValue4</b>
     * </p>
     *
     * @return Work Center Formula Parameter Value 4
     */
    @SerializedName( "WorkCenterFmlaParamValue4" )
    @JsonProperty( "WorkCenterFmlaParamValue4" )
    @Nullable
    @ODataField( odataName = "WorkCenterFmlaParamValue4" )
    private BigDecimal workCenterFmlaParamValue4;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFmlaParamValue4</b> field to query operations.
     *
     */
    public final static WorkCentersField<BigDecimal> WORK_CENTER_FMLA_PARAM_VALUE4 =
        new WorkCentersField<BigDecimal>("WorkCenterFmlaParamValue4");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamValue5</b>
     * </p>
     *
     * @return Work Center Formula Parameter Value 5
     */
    @SerializedName( "WorkCenterFmlaParamValue5" )
    @JsonProperty( "WorkCenterFmlaParamValue5" )
    @Nullable
    @ODataField( odataName = "WorkCenterFmlaParamValue5" )
    private BigDecimal workCenterFmlaParamValue5;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFmlaParamValue5</b> field to query operations.
     *
     */
    public final static WorkCentersField<BigDecimal> WORK_CENTER_FMLA_PARAM_VALUE5 =
        new WorkCentersField<BigDecimal>("WorkCenterFmlaParamValue5");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamValue6</b>
     * </p>
     *
     * @return Work Center Formula Parameter Value 6
     */
    @SerializedName( "WorkCenterFmlaParamValue6" )
    @JsonProperty( "WorkCenterFmlaParamValue6" )
    @Nullable
    @ODataField( odataName = "WorkCenterFmlaParamValue6" )
    private BigDecimal workCenterFmlaParamValue6;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFmlaParamValue6</b> field to query operations.
     *
     */
    public final static WorkCentersField<BigDecimal> WORK_CENTER_FMLA_PARAM_VALUE6 =
        new WorkCentersField<BigDecimal>("WorkCenterFmlaParamValue6");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamUnit1</b>
     * </p>
     *
     * @return Work Center Formula Parameter Unit 1
     */
    @SerializedName( "WorkCenterFmlaParamUnit1" )
    @JsonProperty( "WorkCenterFmlaParamUnit1" )
    @Nullable
    @ODataField( odataName = "WorkCenterFmlaParamUnit1" )
    private String workCenterFmlaParamUnit1;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFmlaParamUnit1</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_FMLA_PARAM_UNIT1 =
        new WorkCentersField<String>("WorkCenterFmlaParamUnit1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamUnit2</b>
     * </p>
     *
     * @return Work Center Formula Parameter Unit 2
     */
    @SerializedName( "WorkCenterFmlaParamUnit2" )
    @JsonProperty( "WorkCenterFmlaParamUnit2" )
    @Nullable
    @ODataField( odataName = "WorkCenterFmlaParamUnit2" )
    private String workCenterFmlaParamUnit2;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFmlaParamUnit2</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_FMLA_PARAM_UNIT2 =
        new WorkCentersField<String>("WorkCenterFmlaParamUnit2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamUnit3</b>
     * </p>
     *
     * @return Work Center Formula Parameter Unit 3
     */
    @SerializedName( "WorkCenterFmlaParamUnit3" )
    @JsonProperty( "WorkCenterFmlaParamUnit3" )
    @Nullable
    @ODataField( odataName = "WorkCenterFmlaParamUnit3" )
    private String workCenterFmlaParamUnit3;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFmlaParamUnit3</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_FMLA_PARAM_UNIT3 =
        new WorkCentersField<String>("WorkCenterFmlaParamUnit3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamUnit4</b>
     * </p>
     *
     * @return Work Center Formula Parameter Unit 4
     */
    @SerializedName( "WorkCenterFmlaParamUnit4" )
    @JsonProperty( "WorkCenterFmlaParamUnit4" )
    @Nullable
    @ODataField( odataName = "WorkCenterFmlaParamUnit4" )
    private String workCenterFmlaParamUnit4;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFmlaParamUnit4</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_FMLA_PARAM_UNIT4 =
        new WorkCentersField<String>("WorkCenterFmlaParamUnit4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamUnit5</b>
     * </p>
     *
     * @return Work Center Formula Parameter Unit 5
     */
    @SerializedName( "WorkCenterFmlaParamUnit5" )
    @JsonProperty( "WorkCenterFmlaParamUnit5" )
    @Nullable
    @ODataField( odataName = "WorkCenterFmlaParamUnit5" )
    private String workCenterFmlaParamUnit5;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFmlaParamUnit5</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_FMLA_PARAM_UNIT5 =
        new WorkCentersField<String>("WorkCenterFmlaParamUnit5");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamUnit6</b>
     * </p>
     *
     * @return Work Center Formula Parameter Unit 6
     */
    @SerializedName( "WorkCenterFmlaParamUnit6" )
    @JsonProperty( "WorkCenterFmlaParamUnit6" )
    @Nullable
    @ODataField( odataName = "WorkCenterFmlaParamUnit6" )
    private String workCenterFmlaParamUnit6;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterFmlaParamUnit6</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_FMLA_PARAM_UNIT6 =
        new WorkCentersField<String>("WorkCenterFmlaParamUnit6");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamGroup</b>
     * </p>
     *
     * @return Standard Value Key
     */
    @SerializedName( "StandardWorkFormulaParamGroup" )
    @JsonProperty( "StandardWorkFormulaParamGroup" )
    @Nullable
    @ODataField( odataName = "StandardWorkFormulaParamGroup" )
    private String standardWorkFormulaParamGroup;
    /**
     * Use with available fluent helpers to apply the <b>StandardWorkFormulaParamGroup</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> STANDARD_WORK_FORMULA_PARAM_GROUP =
        new WorkCentersField<String>("StandardWorkFormulaParamGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrStdValMaintRule1</b>
     * </p>
     *
     * @return Standard Value Maintenance Rule 1
     */
    @SerializedName( "WrkCtrStdValMaintRule1" )
    @JsonProperty( "WrkCtrStdValMaintRule1" )
    @Nullable
    @ODataField( odataName = "WrkCtrStdValMaintRule1" )
    private String wrkCtrStdValMaintRule1;
    /**
     * Use with available fluent helpers to apply the <b>WrkCtrStdValMaintRule1</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WRK_CTR_STD_VAL_MAINT_RULE1 =
        new WorkCentersField<String>("WrkCtrStdValMaintRule1");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrStdValMaintRule2</b>
     * </p>
     *
     * @return Standard Value Maintenance Rule 2
     */
    @SerializedName( "WrkCtrStdValMaintRule2" )
    @JsonProperty( "WrkCtrStdValMaintRule2" )
    @Nullable
    @ODataField( odataName = "WrkCtrStdValMaintRule2" )
    private String wrkCtrStdValMaintRule2;
    /**
     * Use with available fluent helpers to apply the <b>WrkCtrStdValMaintRule2</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WRK_CTR_STD_VAL_MAINT_RULE2 =
        new WorkCentersField<String>("WrkCtrStdValMaintRule2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrStdValMaintRule3</b>
     * </p>
     *
     * @return Standard Value Maintenance Rule 3
     */
    @SerializedName( "WrkCtrStdValMaintRule3" )
    @JsonProperty( "WrkCtrStdValMaintRule3" )
    @Nullable
    @ODataField( odataName = "WrkCtrStdValMaintRule3" )
    private String wrkCtrStdValMaintRule3;
    /**
     * Use with available fluent helpers to apply the <b>WrkCtrStdValMaintRule3</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WRK_CTR_STD_VAL_MAINT_RULE3 =
        new WorkCentersField<String>("WrkCtrStdValMaintRule3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrStdValMaintRule4</b>
     * </p>
     *
     * @return Standard Value Maintenance Rule 4
     */
    @SerializedName( "WrkCtrStdValMaintRule4" )
    @JsonProperty( "WrkCtrStdValMaintRule4" )
    @Nullable
    @ODataField( odataName = "WrkCtrStdValMaintRule4" )
    private String wrkCtrStdValMaintRule4;
    /**
     * Use with available fluent helpers to apply the <b>WrkCtrStdValMaintRule4</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WRK_CTR_STD_VAL_MAINT_RULE4 =
        new WorkCentersField<String>("WrkCtrStdValMaintRule4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrStdValMaintRule5</b>
     * </p>
     *
     * @return Standard Value Maintenance Rule 5
     */
    @SerializedName( "WrkCtrStdValMaintRule5" )
    @JsonProperty( "WrkCtrStdValMaintRule5" )
    @Nullable
    @ODataField( odataName = "WrkCtrStdValMaintRule5" )
    private String wrkCtrStdValMaintRule5;
    /**
     * Use with available fluent helpers to apply the <b>WrkCtrStdValMaintRule5</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WRK_CTR_STD_VAL_MAINT_RULE5 =
        new WorkCentersField<String>("WrkCtrStdValMaintRule5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrStdValMaintRule6</b>
     * </p>
     *
     * @return Standard Value Maintenance Rule 6
     */
    @SerializedName( "WrkCtrStdValMaintRule6" )
    @JsonProperty( "WrkCtrStdValMaintRule6" )
    @Nullable
    @ODataField( odataName = "WrkCtrStdValMaintRule6" )
    private String wrkCtrStdValMaintRule6;
    /**
     * Use with available fluent helpers to apply the <b>WrkCtrStdValMaintRule6</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WRK_CTR_STD_VAL_MAINT_RULE6 =
        new WorkCentersField<String>("WrkCtrStdValMaintRule6");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterStandardWorkQtyUnit1</b>
     * </p>
     *
     * @return Standard Work Quantity Unit 1
     */
    @SerializedName( "WorkCenterStandardWorkQtyUnit1" )
    @JsonProperty( "WorkCenterStandardWorkQtyUnit1" )
    @Nullable
    @ODataField( odataName = "WorkCenterStandardWorkQtyUnit1" )
    private String workCenterStandardWorkQtyUnit1;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterStandardWorkQtyUnit1</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_STANDARD_WORK_QTY_UNIT1 =
        new WorkCentersField<String>("WorkCenterStandardWorkQtyUnit1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterStandardWorkQtyUnit2</b>
     * </p>
     *
     * @return Standard Work Quantity Unit 2
     */
    @SerializedName( "WorkCenterStandardWorkQtyUnit2" )
    @JsonProperty( "WorkCenterStandardWorkQtyUnit2" )
    @Nullable
    @ODataField( odataName = "WorkCenterStandardWorkQtyUnit2" )
    private String workCenterStandardWorkQtyUnit2;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterStandardWorkQtyUnit2</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_STANDARD_WORK_QTY_UNIT2 =
        new WorkCentersField<String>("WorkCenterStandardWorkQtyUnit2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterStandardWorkQtyUnit3</b>
     * </p>
     *
     * @return Standard Work Quantity Unit 3
     */
    @SerializedName( "WorkCenterStandardWorkQtyUnit3" )
    @JsonProperty( "WorkCenterStandardWorkQtyUnit3" )
    @Nullable
    @ODataField( odataName = "WorkCenterStandardWorkQtyUnit3" )
    private String workCenterStandardWorkQtyUnit3;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterStandardWorkQtyUnit3</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_STANDARD_WORK_QTY_UNIT3 =
        new WorkCentersField<String>("WorkCenterStandardWorkQtyUnit3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterStandardWorkQtyUnit4</b>
     * </p>
     *
     * @return Standard Work Quantity Unit 4
     */
    @SerializedName( "WorkCenterStandardWorkQtyUnit4" )
    @JsonProperty( "WorkCenterStandardWorkQtyUnit4" )
    @Nullable
    @ODataField( odataName = "WorkCenterStandardWorkQtyUnit4" )
    private String workCenterStandardWorkQtyUnit4;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterStandardWorkQtyUnit4</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_STANDARD_WORK_QTY_UNIT4 =
        new WorkCentersField<String>("WorkCenterStandardWorkQtyUnit4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterStandardWorkQtyUnit5</b>
     * </p>
     *
     * @return Standard Work Quantity Unit 5
     */
    @SerializedName( "WorkCenterStandardWorkQtyUnit5" )
    @JsonProperty( "WorkCenterStandardWorkQtyUnit5" )
    @Nullable
    @ODataField( odataName = "WorkCenterStandardWorkQtyUnit5" )
    private String workCenterStandardWorkQtyUnit5;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterStandardWorkQtyUnit5</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_STANDARD_WORK_QTY_UNIT5 =
        new WorkCentersField<String>("WorkCenterStandardWorkQtyUnit5");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterStandardWorkQtyUnit6</b>
     * </p>
     *
     * @return Standard Work Quantity Unit 6
     */
    @SerializedName( "WorkCenterStandardWorkQtyUnit6" )
    @JsonProperty( "WorkCenterStandardWorkQtyUnit6" )
    @Nullable
    @ODataField( odataName = "WorkCenterStandardWorkQtyUnit6" )
    private String workCenterStandardWorkQtyUnit6;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterStandardWorkQtyUnit6</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_STANDARD_WORK_QTY_UNIT6 =
        new WorkCentersField<String>("WorkCenterStandardWorkQtyUnit6");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @return Operation Control Profile
     */
    @SerializedName( "OperationControlProfile" )
    @JsonProperty( "OperationControlProfile" )
    @Nullable
    @ODataField( odataName = "OperationControlProfile" )
    private String operationControlProfile;
    /**
     * Use with available fluent helpers to apply the <b>OperationControlProfile</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> OPERATION_CONTROL_PROFILE =
        new WorkCentersField<String>("OperationControlProfile");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @return Indicator: Backflushing
     */
    @SerializedName( "MatlCompIsMarkedForBackflush" )
    @JsonProperty( "MatlCompIsMarkedForBackflush" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MatlCompIsMarkedForBackflush" )
    private Boolean matlCompIsMarkedForBackflush;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompIsMarkedForBackflush</b> field to query operations.
     *
     */
    public final static WorkCentersField<Boolean> MATL_COMP_IS_MARKED_FOR_BACKFLUSH =
        new WorkCentersField<Boolean>("MatlCompIsMarkedForBackflush");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterLocation</b>
     * </p>
     *
     * @return Work center location
     */
    @SerializedName( "WorkCenterLocation" )
    @JsonProperty( "WorkCenterLocation" )
    @Nullable
    @ODataField( odataName = "WorkCenterLocation" )
    private String workCenterLocation;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterLocation</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_LOCATION =
        new WorkCentersField<String>("WorkCenterLocation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterLocationGroup</b>
     * </p>
     *
     * @return Location Group
     */
    @SerializedName( "WorkCenterLocationGroup" )
    @JsonProperty( "WorkCenterLocationGroup" )
    @Nullable
    @ODataField( odataName = "WorkCenterLocationGroup" )
    private String workCenterLocationGroup;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterLocationGroup</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WORK_CENTER_LOCATION_GROUP =
        new WorkCentersField<String>("WorkCenterLocationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrSetupSchedgFmla</b>
     * </p>
     *
     * @return Formula for setup time
     */
    @SerializedName( "WrkCtrSetupSchedgFmla" )
    @JsonProperty( "WrkCtrSetupSchedgFmla" )
    @Nullable
    @ODataField( odataName = "WrkCtrSetupSchedgFmla" )
    private String wrkCtrSetupSchedgFmla;
    /**
     * Use with available fluent helpers to apply the <b>WrkCtrSetupSchedgFmla</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WRK_CTR_SETUP_SCHEDG_FMLA =
        new WorkCentersField<String>("WrkCtrSetupSchedgFmla");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrProcgSchedgFmla</b>
     * </p>
     *
     * @return Formula for the duration of processing time
     */
    @SerializedName( "WrkCtrProcgSchedgFmla" )
    @JsonProperty( "WrkCtrProcgSchedgFmla" )
    @Nullable
    @ODataField( odataName = "WrkCtrProcgSchedgFmla" )
    private String wrkCtrProcgSchedgFmla;
    /**
     * Use with available fluent helpers to apply the <b>WrkCtrProcgSchedgFmla</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WRK_CTR_PROCG_SCHEDG_FMLA =
        new WorkCentersField<String>("WrkCtrProcgSchedgFmla");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrTeardownSchedgFmla</b>
     * </p>
     *
     * @return Formula for teardown time
     */
    @SerializedName( "WrkCtrTeardownSchedgFmla" )
    @JsonProperty( "WrkCtrTeardownSchedgFmla" )
    @Nullable
    @ODataField( odataName = "WrkCtrTeardownSchedgFmla" )
    private String wrkCtrTeardownSchedgFmla;
    /**
     * Use with available fluent helpers to apply the <b>WrkCtrTeardownSchedgFmla</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WRK_CTR_TEARDOWN_SCHEDG_FMLA =
        new WorkCentersField<String>("WrkCtrTeardownSchedgFmla");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrIntProcgSchedgFmla</b>
     * </p>
     *
     * @return Formula for the Internal Processing Duration
     */
    @SerializedName( "WrkCtrIntProcgSchedgFmla" )
    @JsonProperty( "WrkCtrIntProcgSchedgFmla" )
    @Nullable
    @ODataField( odataName = "WrkCtrIntProcgSchedgFmla" )
    private String wrkCtrIntProcgSchedgFmla;
    /**
     * Use with available fluent helpers to apply the <b>WrkCtrIntProcgSchedgFmla</b> field to query operations.
     *
     */
    public final static WorkCentersField<String> WRK_CTR_INT_PROCG_SCHEDG_FMLA =
        new WorkCentersField<String>("WrkCtrIntProcgSchedgFmla");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterLastChangeDateTime</b>
     * </p>
     *
     * @return Date and Time of Last Change
     */
    @SerializedName( "WorkCenterLastChangeDateTime" )
    @JsonProperty( "WorkCenterLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "WorkCenterLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime workCenterLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterLastChangeDateTime</b> field to query operations.
     *
     */
    public final static WorkCentersField<ZonedDateTime> WORK_CENTER_LAST_CHANGE_DATE_TIME =
        new WorkCentersField<ZonedDateTime>("WorkCenterLastChangeDateTime");
    /**
     * Navigation property <b>to_Capacity</b> for <b>WorkCenters</b> to single <b>WorkCenterCapacity</b>.
     *
     */
    @SerializedName( "to_Capacity" )
    @JsonProperty( "to_Capacity" )
    @ODataField( odataName = "to_Capacity" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private WorkCenterCapacity toCapacity;
    /**
     * Navigation property <b>to_WorkCenterAllCapacity</b> for <b>WorkCenters</b> to multiple
     * <b>WorkCenterAllCapacity_2</b>.
     *
     */
    @SerializedName( "to_WorkCenterAllCapacity" )
    @JsonProperty( "to_WorkCenterAllCapacity" )
    @ODataField( odataName = "to_WorkCenterAllCapacity" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterAllCapacity_2> toWorkCenterAllCapacity;
    /**
     * Navigation property <b>to_WorkCenterCapacity</b> for <b>WorkCenters</b> to multiple <b>WorkCenterAllCapacity</b>.
     *
     */
    @SerializedName( "to_WorkCenterCapacity" )
    @JsonProperty( "to_WorkCenterCapacity" )
    @ODataField( odataName = "to_WorkCenterCapacity" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterAllCapacity> toWorkCenterCapacity;
    /**
     * Navigation property <b>to_WorkCenterCostCenter</b> for <b>WorkCenters</b> to multiple
     * <b>WorkCenterCostCenter</b>.
     *
     */
    @SerializedName( "to_WorkCenterCostCenter" )
    @JsonProperty( "to_WorkCenterCostCenter" )
    @ODataField( odataName = "to_WorkCenterCostCenter" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterCostCenter> toWorkCenterCostCenter;
    /**
     * Navigation property <b>to_WorkCenterDescription</b> for <b>WorkCenters</b> to multiple
     * <b>WorkCenterDescription</b>.
     *
     */
    @SerializedName( "to_WorkCenterDescription" )
    @JsonProperty( "to_WorkCenterDescription" )
    @ODataField( odataName = "to_WorkCenterDescription" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterDescription> toWorkCenterDescription;
    /**
     * Navigation property <b>to_WorkCenterQueuingOp</b> for <b>WorkCenters</b> to multiple
     * <b>WorkCenterPipeLineOperation</b>.
     *
     */
    @SerializedName( "to_WorkCenterQueuingOp" )
    @JsonProperty( "to_WorkCenterQueuingOp" )
    @ODataField( odataName = "to_WorkCenterQueuingOp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterPipeLineOperation> toWorkCenterQueuingOp;
    /**
     * Navigation property <b>to_WorkCenterTodayOp</b> for <b>WorkCenters</b> to multiple <b>WorkCenterDayOperation</b>.
     *
     */
    @SerializedName( "to_WorkCenterTodayOp" )
    @JsonProperty( "to_WorkCenterTodayOp" )
    @ODataField( odataName = "to_WorkCenterTodayOp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WorkCenterDayOperation> toWorkCenterTodayOp;
    /**
     * Use with available fluent helpers to apply the <b>to_Capacity</b> navigation property to query operations.
     *
     */
    public final static WorkCentersOneToOneLink<WorkCenterCapacity> TO_CAPACITY =
        new WorkCentersOneToOneLink<WorkCenterCapacity>("to_Capacity");
    /**
     * Use with available fluent helpers to apply the <b>to_WorkCenterAllCapacity</b> navigation property to query
     * operations.
     *
     */
    public final static WorkCentersLink<WorkCenterAllCapacity_2> TO_WORK_CENTER_ALL_CAPACITY =
        new WorkCentersLink<WorkCenterAllCapacity_2>("to_WorkCenterAllCapacity");
    /**
     * Use with available fluent helpers to apply the <b>to_WorkCenterCapacity</b> navigation property to query
     * operations.
     *
     */
    public final static WorkCentersLink<WorkCenterAllCapacity> TO_WORK_CENTER_CAPACITY =
        new WorkCentersLink<WorkCenterAllCapacity>("to_WorkCenterCapacity");
    /**
     * Use with available fluent helpers to apply the <b>to_WorkCenterCostCenter</b> navigation property to query
     * operations.
     *
     */
    public final static WorkCentersLink<WorkCenterCostCenter> TO_WORK_CENTER_COST_CENTER =
        new WorkCentersLink<WorkCenterCostCenter>("to_WorkCenterCostCenter");
    /**
     * Use with available fluent helpers to apply the <b>to_WorkCenterDescription</b> navigation property to query
     * operations.
     *
     */
    public final static WorkCentersLink<WorkCenterDescription> TO_WORK_CENTER_DESCRIPTION =
        new WorkCentersLink<WorkCenterDescription>("to_WorkCenterDescription");
    /**
     * Use with available fluent helpers to apply the <b>to_WorkCenterQueuingOp</b> navigation property to query
     * operations.
     *
     */
    public final static WorkCentersLink<WorkCenterPipeLineOperation> TO_WORK_CENTER_QUEUING_OP =
        new WorkCentersLink<WorkCenterPipeLineOperation>("to_WorkCenterQueuingOp");
    /**
     * Use with available fluent helpers to apply the <b>to_WorkCenterTodayOp</b> navigation property to query
     * operations.
     *
     */
    public final static WorkCentersLink<WorkCenterDayOperation> TO_WORK_CENTER_TODAY_OP =
        new WorkCentersLink<WorkCenterDayOperation>("to_WorkCenterTodayOp");

    @Nonnull
    @Override
    public Class<WorkCenters> getType()
    {
        return WorkCenters.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Object ID of the resource
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Object types of the CIM resource
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterDesc</b>
     * </p>
     *
     * @param workCenterDesc
     *            Work Center Text
     */
    public void setWorkCenterDesc( @Nullable final String workCenterDesc )
    {
        rememberChangedField("WorkCenterDesc", this.workCenterDesc);
        this.workCenterDesc = workCenterDesc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterCategoryCode</b>
     * </p>
     *
     * @param workCenterCategoryCode
     *            Work Center Category
     */
    public void setWorkCenterCategoryCode( @Nullable final String workCenterCategoryCode )
    {
        rememberChangedField("WorkCenterCategoryCode", this.workCenterCategoryCode);
        this.workCenterCategoryCode = workCenterCategoryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsible</b>
     * </p>
     *
     * @param workCenterResponsible
     *            Person Responsible for the Work Center
     */
    public void setWorkCenterResponsible( @Nullable final String workCenterResponsible )
    {
        rememberChangedField("WorkCenterResponsible", this.workCenterResponsible);
        this.workCenterResponsible = workCenterResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterResponsibleName</b>
     * </p>
     *
     * @param workCenterResponsibleName
     *            Work Center Responsible Name
     */
    public void setWorkCenterResponsibleName( @Nullable final String workCenterResponsibleName )
    {
        rememberChangedField("WorkCenterResponsibleName", this.workCenterResponsibleName);
        this.workCenterResponsibleName = workCenterResponsibleName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyArea</b>
     * </p>
     *
     * @param supplyArea
     *            Production Supply Area
     */
    public void setSupplyArea( @Nullable final String supplyArea )
    {
        rememberChangedField("SupplyArea", this.supplyArea);
        this.supplyArea = supplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterUsage</b>
     * </p>
     *
     * @param workCenterUsage
     *            Work Center Usage in Bill of Operations
     */
    public void setWorkCenterUsage( @Nullable final String workCenterUsage )
    {
        rememberChangedField("WorkCenterUsage", this.workCenterUsage);
        this.workCenterUsage = workCenterUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CapacityInternalID</b>
     * </p>
     *
     * @param capacityInternalID
     *            Capacity ID
     */
    public void setCapacityInternalID( @Nullable final String capacityInternalID )
    {
        rememberChangedField("CapacityInternalID", this.capacityInternalID);
        this.capacityInternalID = capacityInternalID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterIsToBeDeleted</b>
     * </p>
     *
     * @param workCenterIsToBeDeleted
     *            Deletion flag for work center
     */
    public void setWorkCenterIsToBeDeleted( @Nullable final Boolean workCenterIsToBeDeleted )
    {
        rememberChangedField("WorkCenterIsToBeDeleted", this.workCenterIsToBeDeleted);
        this.workCenterIsToBeDeleted = workCenterIsToBeDeleted;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid-To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFormulaParam1</b>
     * </p>
     *
     * @param workCenterFormulaParam1
     *            Work Center Formula Parameter 1
     */
    public void setWorkCenterFormulaParam1( @Nullable final String workCenterFormulaParam1 )
    {
        rememberChangedField("WorkCenterFormulaParam1", this.workCenterFormulaParam1);
        this.workCenterFormulaParam1 = workCenterFormulaParam1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFormulaParam2</b>
     * </p>
     *
     * @param workCenterFormulaParam2
     *            Work Center Formula Parameter 2
     */
    public void setWorkCenterFormulaParam2( @Nullable final String workCenterFormulaParam2 )
    {
        rememberChangedField("WorkCenterFormulaParam2", this.workCenterFormulaParam2);
        this.workCenterFormulaParam2 = workCenterFormulaParam2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFormulaParam3</b>
     * </p>
     *
     * @param workCenterFormulaParam3
     *            Work Center Formula Parameter 3
     */
    public void setWorkCenterFormulaParam3( @Nullable final String workCenterFormulaParam3 )
    {
        rememberChangedField("WorkCenterFormulaParam3", this.workCenterFormulaParam3);
        this.workCenterFormulaParam3 = workCenterFormulaParam3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFormulaParam4</b>
     * </p>
     *
     * @param workCenterFormulaParam4
     *            Work Center Formula Parameter 4
     */
    public void setWorkCenterFormulaParam4( @Nullable final String workCenterFormulaParam4 )
    {
        rememberChangedField("WorkCenterFormulaParam4", this.workCenterFormulaParam4);
        this.workCenterFormulaParam4 = workCenterFormulaParam4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFormulaParam5</b>
     * </p>
     *
     * @param workCenterFormulaParam5
     *            Work Center Formula Parameter 5
     */
    public void setWorkCenterFormulaParam5( @Nullable final String workCenterFormulaParam5 )
    {
        rememberChangedField("WorkCenterFormulaParam5", this.workCenterFormulaParam5);
        this.workCenterFormulaParam5 = workCenterFormulaParam5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFormulaParam6</b>
     * </p>
     *
     * @param workCenterFormulaParam6
     *            Work Center Formula Parameter 6
     */
    public void setWorkCenterFormulaParam6( @Nullable final String workCenterFormulaParam6 )
    {
        rememberChangedField("WorkCenterFormulaParam6", this.workCenterFormulaParam6);
        this.workCenterFormulaParam6 = workCenterFormulaParam6;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamValue1</b>
     * </p>
     *
     * @param workCenterFmlaParamValue1
     *            Work Center Formula Parameter Value 1
     */
    public void setWorkCenterFmlaParamValue1( @Nullable final BigDecimal workCenterFmlaParamValue1 )
    {
        rememberChangedField("WorkCenterFmlaParamValue1", this.workCenterFmlaParamValue1);
        this.workCenterFmlaParamValue1 = workCenterFmlaParamValue1;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamValue2</b>
     * </p>
     *
     * @param workCenterFmlaParamValue2
     *            Work Center Formula Parameter Value 2
     */
    public void setWorkCenterFmlaParamValue2( @Nullable final BigDecimal workCenterFmlaParamValue2 )
    {
        rememberChangedField("WorkCenterFmlaParamValue2", this.workCenterFmlaParamValue2);
        this.workCenterFmlaParamValue2 = workCenterFmlaParamValue2;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamValue3</b>
     * </p>
     *
     * @param workCenterFmlaParamValue3
     *            Work Center Formula Parameter Value 3
     */
    public void setWorkCenterFmlaParamValue3( @Nullable final BigDecimal workCenterFmlaParamValue3 )
    {
        rememberChangedField("WorkCenterFmlaParamValue3", this.workCenterFmlaParamValue3);
        this.workCenterFmlaParamValue3 = workCenterFmlaParamValue3;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamValue4</b>
     * </p>
     *
     * @param workCenterFmlaParamValue4
     *            Work Center Formula Parameter Value 4
     */
    public void setWorkCenterFmlaParamValue4( @Nullable final BigDecimal workCenterFmlaParamValue4 )
    {
        rememberChangedField("WorkCenterFmlaParamValue4", this.workCenterFmlaParamValue4);
        this.workCenterFmlaParamValue4 = workCenterFmlaParamValue4;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamValue5</b>
     * </p>
     *
     * @param workCenterFmlaParamValue5
     *            Work Center Formula Parameter Value 5
     */
    public void setWorkCenterFmlaParamValue5( @Nullable final BigDecimal workCenterFmlaParamValue5 )
    {
        rememberChangedField("WorkCenterFmlaParamValue5", this.workCenterFmlaParamValue5);
        this.workCenterFmlaParamValue5 = workCenterFmlaParamValue5;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamValue6</b>
     * </p>
     *
     * @param workCenterFmlaParamValue6
     *            Work Center Formula Parameter Value 6
     */
    public void setWorkCenterFmlaParamValue6( @Nullable final BigDecimal workCenterFmlaParamValue6 )
    {
        rememberChangedField("WorkCenterFmlaParamValue6", this.workCenterFmlaParamValue6);
        this.workCenterFmlaParamValue6 = workCenterFmlaParamValue6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamUnit1</b>
     * </p>
     *
     * @param workCenterFmlaParamUnit1
     *            Work Center Formula Parameter Unit 1
     */
    public void setWorkCenterFmlaParamUnit1( @Nullable final String workCenterFmlaParamUnit1 )
    {
        rememberChangedField("WorkCenterFmlaParamUnit1", this.workCenterFmlaParamUnit1);
        this.workCenterFmlaParamUnit1 = workCenterFmlaParamUnit1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamUnit2</b>
     * </p>
     *
     * @param workCenterFmlaParamUnit2
     *            Work Center Formula Parameter Unit 2
     */
    public void setWorkCenterFmlaParamUnit2( @Nullable final String workCenterFmlaParamUnit2 )
    {
        rememberChangedField("WorkCenterFmlaParamUnit2", this.workCenterFmlaParamUnit2);
        this.workCenterFmlaParamUnit2 = workCenterFmlaParamUnit2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamUnit3</b>
     * </p>
     *
     * @param workCenterFmlaParamUnit3
     *            Work Center Formula Parameter Unit 3
     */
    public void setWorkCenterFmlaParamUnit3( @Nullable final String workCenterFmlaParamUnit3 )
    {
        rememberChangedField("WorkCenterFmlaParamUnit3", this.workCenterFmlaParamUnit3);
        this.workCenterFmlaParamUnit3 = workCenterFmlaParamUnit3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamUnit4</b>
     * </p>
     *
     * @param workCenterFmlaParamUnit4
     *            Work Center Formula Parameter Unit 4
     */
    public void setWorkCenterFmlaParamUnit4( @Nullable final String workCenterFmlaParamUnit4 )
    {
        rememberChangedField("WorkCenterFmlaParamUnit4", this.workCenterFmlaParamUnit4);
        this.workCenterFmlaParamUnit4 = workCenterFmlaParamUnit4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamUnit5</b>
     * </p>
     *
     * @param workCenterFmlaParamUnit5
     *            Work Center Formula Parameter Unit 5
     */
    public void setWorkCenterFmlaParamUnit5( @Nullable final String workCenterFmlaParamUnit5 )
    {
        rememberChangedField("WorkCenterFmlaParamUnit5", this.workCenterFmlaParamUnit5);
        this.workCenterFmlaParamUnit5 = workCenterFmlaParamUnit5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterFmlaParamUnit6</b>
     * </p>
     *
     * @param workCenterFmlaParamUnit6
     *            Work Center Formula Parameter Unit 6
     */
    public void setWorkCenterFmlaParamUnit6( @Nullable final String workCenterFmlaParamUnit6 )
    {
        rememberChangedField("WorkCenterFmlaParamUnit6", this.workCenterFmlaParamUnit6);
        this.workCenterFmlaParamUnit6 = workCenterFmlaParamUnit6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StandardWorkFormulaParamGroup</b>
     * </p>
     *
     * @param standardWorkFormulaParamGroup
     *            Standard Value Key
     */
    public void setStandardWorkFormulaParamGroup( @Nullable final String standardWorkFormulaParamGroup )
    {
        rememberChangedField("StandardWorkFormulaParamGroup", this.standardWorkFormulaParamGroup);
        this.standardWorkFormulaParamGroup = standardWorkFormulaParamGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrStdValMaintRule1</b>
     * </p>
     *
     * @param wrkCtrStdValMaintRule1
     *            Standard Value Maintenance Rule 1
     */
    public void setWrkCtrStdValMaintRule1( @Nullable final String wrkCtrStdValMaintRule1 )
    {
        rememberChangedField("WrkCtrStdValMaintRule1", this.wrkCtrStdValMaintRule1);
        this.wrkCtrStdValMaintRule1 = wrkCtrStdValMaintRule1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrStdValMaintRule2</b>
     * </p>
     *
     * @param wrkCtrStdValMaintRule2
     *            Standard Value Maintenance Rule 2
     */
    public void setWrkCtrStdValMaintRule2( @Nullable final String wrkCtrStdValMaintRule2 )
    {
        rememberChangedField("WrkCtrStdValMaintRule2", this.wrkCtrStdValMaintRule2);
        this.wrkCtrStdValMaintRule2 = wrkCtrStdValMaintRule2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrStdValMaintRule3</b>
     * </p>
     *
     * @param wrkCtrStdValMaintRule3
     *            Standard Value Maintenance Rule 3
     */
    public void setWrkCtrStdValMaintRule3( @Nullable final String wrkCtrStdValMaintRule3 )
    {
        rememberChangedField("WrkCtrStdValMaintRule3", this.wrkCtrStdValMaintRule3);
        this.wrkCtrStdValMaintRule3 = wrkCtrStdValMaintRule3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrStdValMaintRule4</b>
     * </p>
     *
     * @param wrkCtrStdValMaintRule4
     *            Standard Value Maintenance Rule 4
     */
    public void setWrkCtrStdValMaintRule4( @Nullable final String wrkCtrStdValMaintRule4 )
    {
        rememberChangedField("WrkCtrStdValMaintRule4", this.wrkCtrStdValMaintRule4);
        this.wrkCtrStdValMaintRule4 = wrkCtrStdValMaintRule4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrStdValMaintRule5</b>
     * </p>
     *
     * @param wrkCtrStdValMaintRule5
     *            Standard Value Maintenance Rule 5
     */
    public void setWrkCtrStdValMaintRule5( @Nullable final String wrkCtrStdValMaintRule5 )
    {
        rememberChangedField("WrkCtrStdValMaintRule5", this.wrkCtrStdValMaintRule5);
        this.wrkCtrStdValMaintRule5 = wrkCtrStdValMaintRule5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrStdValMaintRule6</b>
     * </p>
     *
     * @param wrkCtrStdValMaintRule6
     *            Standard Value Maintenance Rule 6
     */
    public void setWrkCtrStdValMaintRule6( @Nullable final String wrkCtrStdValMaintRule6 )
    {
        rememberChangedField("WrkCtrStdValMaintRule6", this.wrkCtrStdValMaintRule6);
        this.wrkCtrStdValMaintRule6 = wrkCtrStdValMaintRule6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterStandardWorkQtyUnit1</b>
     * </p>
     *
     * @param workCenterStandardWorkQtyUnit1
     *            Standard Work Quantity Unit 1
     */
    public void setWorkCenterStandardWorkQtyUnit1( @Nullable final String workCenterStandardWorkQtyUnit1 )
    {
        rememberChangedField("WorkCenterStandardWorkQtyUnit1", this.workCenterStandardWorkQtyUnit1);
        this.workCenterStandardWorkQtyUnit1 = workCenterStandardWorkQtyUnit1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterStandardWorkQtyUnit2</b>
     * </p>
     *
     * @param workCenterStandardWorkQtyUnit2
     *            Standard Work Quantity Unit 2
     */
    public void setWorkCenterStandardWorkQtyUnit2( @Nullable final String workCenterStandardWorkQtyUnit2 )
    {
        rememberChangedField("WorkCenterStandardWorkQtyUnit2", this.workCenterStandardWorkQtyUnit2);
        this.workCenterStandardWorkQtyUnit2 = workCenterStandardWorkQtyUnit2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterStandardWorkQtyUnit3</b>
     * </p>
     *
     * @param workCenterStandardWorkQtyUnit3
     *            Standard Work Quantity Unit 3
     */
    public void setWorkCenterStandardWorkQtyUnit3( @Nullable final String workCenterStandardWorkQtyUnit3 )
    {
        rememberChangedField("WorkCenterStandardWorkQtyUnit3", this.workCenterStandardWorkQtyUnit3);
        this.workCenterStandardWorkQtyUnit3 = workCenterStandardWorkQtyUnit3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterStandardWorkQtyUnit4</b>
     * </p>
     *
     * @param workCenterStandardWorkQtyUnit4
     *            Standard Work Quantity Unit 4
     */
    public void setWorkCenterStandardWorkQtyUnit4( @Nullable final String workCenterStandardWorkQtyUnit4 )
    {
        rememberChangedField("WorkCenterStandardWorkQtyUnit4", this.workCenterStandardWorkQtyUnit4);
        this.workCenterStandardWorkQtyUnit4 = workCenterStandardWorkQtyUnit4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterStandardWorkQtyUnit5</b>
     * </p>
     *
     * @param workCenterStandardWorkQtyUnit5
     *            Standard Work Quantity Unit 5
     */
    public void setWorkCenterStandardWorkQtyUnit5( @Nullable final String workCenterStandardWorkQtyUnit5 )
    {
        rememberChangedField("WorkCenterStandardWorkQtyUnit5", this.workCenterStandardWorkQtyUnit5);
        this.workCenterStandardWorkQtyUnit5 = workCenterStandardWorkQtyUnit5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterStandardWorkQtyUnit6</b>
     * </p>
     *
     * @param workCenterStandardWorkQtyUnit6
     *            Standard Work Quantity Unit 6
     */
    public void setWorkCenterStandardWorkQtyUnit6( @Nullable final String workCenterStandardWorkQtyUnit6 )
    {
        rememberChangedField("WorkCenterStandardWorkQtyUnit6", this.workCenterStandardWorkQtyUnit6);
        this.workCenterStandardWorkQtyUnit6 = workCenterStandardWorkQtyUnit6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @param operationControlProfile
     *            Operation Control Profile
     */
    public void setOperationControlProfile( @Nullable final String operationControlProfile )
    {
        rememberChangedField("OperationControlProfile", this.operationControlProfile);
        this.operationControlProfile = operationControlProfile;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @param matlCompIsMarkedForBackflush
     *            Indicator: Backflushing
     */
    public void setMatlCompIsMarkedForBackflush( @Nullable final Boolean matlCompIsMarkedForBackflush )
    {
        rememberChangedField("MatlCompIsMarkedForBackflush", this.matlCompIsMarkedForBackflush);
        this.matlCompIsMarkedForBackflush = matlCompIsMarkedForBackflush;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterLocation</b>
     * </p>
     *
     * @param workCenterLocation
     *            Work center location
     */
    public void setWorkCenterLocation( @Nullable final String workCenterLocation )
    {
        rememberChangedField("WorkCenterLocation", this.workCenterLocation);
        this.workCenterLocation = workCenterLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterLocationGroup</b>
     * </p>
     *
     * @param workCenterLocationGroup
     *            Location Group
     */
    public void setWorkCenterLocationGroup( @Nullable final String workCenterLocationGroup )
    {
        rememberChangedField("WorkCenterLocationGroup", this.workCenterLocationGroup);
        this.workCenterLocationGroup = workCenterLocationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrSetupSchedgFmla</b>
     * </p>
     *
     * @param wrkCtrSetupSchedgFmla
     *            Formula for setup time
     */
    public void setWrkCtrSetupSchedgFmla( @Nullable final String wrkCtrSetupSchedgFmla )
    {
        rememberChangedField("WrkCtrSetupSchedgFmla", this.wrkCtrSetupSchedgFmla);
        this.wrkCtrSetupSchedgFmla = wrkCtrSetupSchedgFmla;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrProcgSchedgFmla</b>
     * </p>
     *
     * @param wrkCtrProcgSchedgFmla
     *            Formula for the duration of processing time
     */
    public void setWrkCtrProcgSchedgFmla( @Nullable final String wrkCtrProcgSchedgFmla )
    {
        rememberChangedField("WrkCtrProcgSchedgFmla", this.wrkCtrProcgSchedgFmla);
        this.wrkCtrProcgSchedgFmla = wrkCtrProcgSchedgFmla;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrTeardownSchedgFmla</b>
     * </p>
     *
     * @param wrkCtrTeardownSchedgFmla
     *            Formula for teardown time
     */
    public void setWrkCtrTeardownSchedgFmla( @Nullable final String wrkCtrTeardownSchedgFmla )
    {
        rememberChangedField("WrkCtrTeardownSchedgFmla", this.wrkCtrTeardownSchedgFmla);
        this.wrkCtrTeardownSchedgFmla = wrkCtrTeardownSchedgFmla;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>WrkCtrIntProcgSchedgFmla</b>
     * </p>
     *
     * @param wrkCtrIntProcgSchedgFmla
     *            Formula for the Internal Processing Duration
     */
    public void setWrkCtrIntProcgSchedgFmla( @Nullable final String wrkCtrIntProcgSchedgFmla )
    {
        rememberChangedField("WrkCtrIntProcgSchedgFmla", this.wrkCtrIntProcgSchedgFmla);
        this.wrkCtrIntProcgSchedgFmla = wrkCtrIntProcgSchedgFmla;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterLastChangeDateTime</b>
     * </p>
     *
     * @param workCenterLastChangeDateTime
     *            Date and Time of Last Change
     */
    public void setWorkCenterLastChangeDateTime( @Nullable final ZonedDateTime workCenterLastChangeDateTime )
    {
        rememberChangedField("WorkCenterLastChangeDateTime", this.workCenterLastChangeDateTime);
        this.workCenterLastChangeDateTime = workCenterLastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_WorkCenters";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WorkCenterInternalID", getWorkCenterInternalID());
        result.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("WorkCenter", getWorkCenter());
        values.put("WorkCenterDesc", getWorkCenterDesc());
        values.put("Plant", getPlant());
        values.put("WorkCenterCategoryCode", getWorkCenterCategoryCode());
        values.put("WorkCenterResponsible", getWorkCenterResponsible());
        values.put("WorkCenterResponsibleName", getWorkCenterResponsibleName());
        values.put("SupplyArea", getSupplyArea());
        values.put("WorkCenterUsage", getWorkCenterUsage());
        values.put("CapacityInternalID", getCapacityInternalID());
        values.put("WorkCenterIsToBeDeleted", getWorkCenterIsToBeDeleted());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("WorkCenterFormulaParam1", getWorkCenterFormulaParam1());
        values.put("WorkCenterFormulaParam2", getWorkCenterFormulaParam2());
        values.put("WorkCenterFormulaParam3", getWorkCenterFormulaParam3());
        values.put("WorkCenterFormulaParam4", getWorkCenterFormulaParam4());
        values.put("WorkCenterFormulaParam5", getWorkCenterFormulaParam5());
        values.put("WorkCenterFormulaParam6", getWorkCenterFormulaParam6());
        values.put("WorkCenterFmlaParamValue1", getWorkCenterFmlaParamValue1());
        values.put("WorkCenterFmlaParamValue2", getWorkCenterFmlaParamValue2());
        values.put("WorkCenterFmlaParamValue3", getWorkCenterFmlaParamValue3());
        values.put("WorkCenterFmlaParamValue4", getWorkCenterFmlaParamValue4());
        values.put("WorkCenterFmlaParamValue5", getWorkCenterFmlaParamValue5());
        values.put("WorkCenterFmlaParamValue6", getWorkCenterFmlaParamValue6());
        values.put("WorkCenterFmlaParamUnit1", getWorkCenterFmlaParamUnit1());
        values.put("WorkCenterFmlaParamUnit2", getWorkCenterFmlaParamUnit2());
        values.put("WorkCenterFmlaParamUnit3", getWorkCenterFmlaParamUnit3());
        values.put("WorkCenterFmlaParamUnit4", getWorkCenterFmlaParamUnit4());
        values.put("WorkCenterFmlaParamUnit5", getWorkCenterFmlaParamUnit5());
        values.put("WorkCenterFmlaParamUnit6", getWorkCenterFmlaParamUnit6());
        values.put("StandardWorkFormulaParamGroup", getStandardWorkFormulaParamGroup());
        values.put("WrkCtrStdValMaintRule1", getWrkCtrStdValMaintRule1());
        values.put("WrkCtrStdValMaintRule2", getWrkCtrStdValMaintRule2());
        values.put("WrkCtrStdValMaintRule3", getWrkCtrStdValMaintRule3());
        values.put("WrkCtrStdValMaintRule4", getWrkCtrStdValMaintRule4());
        values.put("WrkCtrStdValMaintRule5", getWrkCtrStdValMaintRule5());
        values.put("WrkCtrStdValMaintRule6", getWrkCtrStdValMaintRule6());
        values.put("WorkCenterStandardWorkQtyUnit1", getWorkCenterStandardWorkQtyUnit1());
        values.put("WorkCenterStandardWorkQtyUnit2", getWorkCenterStandardWorkQtyUnit2());
        values.put("WorkCenterStandardWorkQtyUnit3", getWorkCenterStandardWorkQtyUnit3());
        values.put("WorkCenterStandardWorkQtyUnit4", getWorkCenterStandardWorkQtyUnit4());
        values.put("WorkCenterStandardWorkQtyUnit5", getWorkCenterStandardWorkQtyUnit5());
        values.put("WorkCenterStandardWorkQtyUnit6", getWorkCenterStandardWorkQtyUnit6());
        values.put("OperationControlProfile", getOperationControlProfile());
        values.put("MatlCompIsMarkedForBackflush", getMatlCompIsMarkedForBackflush());
        values.put("WorkCenterLocation", getWorkCenterLocation());
        values.put("WorkCenterLocationGroup", getWorkCenterLocationGroup());
        values.put("WrkCtrSetupSchedgFmla", getWrkCtrSetupSchedgFmla());
        values.put("WrkCtrProcgSchedgFmla", getWrkCtrProcgSchedgFmla());
        values.put("WrkCtrTeardownSchedgFmla", getWrkCtrTeardownSchedgFmla());
        values.put("WrkCtrIntProcgSchedgFmla", getWrkCtrIntProcgSchedgFmla());
        values.put("WorkCenterLastChangeDateTime", getWorkCenterLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("WorkCenterDesc") ) {
                final Object value = values.remove("WorkCenterDesc");
                if( (value == null) || (!value.equals(getWorkCenterDesc())) ) {
                    setWorkCenterDesc(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("WorkCenterCategoryCode") ) {
                final Object value = values.remove("WorkCenterCategoryCode");
                if( (value == null) || (!value.equals(getWorkCenterCategoryCode())) ) {
                    setWorkCenterCategoryCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenterResponsible") ) {
                final Object value = values.remove("WorkCenterResponsible");
                if( (value == null) || (!value.equals(getWorkCenterResponsible())) ) {
                    setWorkCenterResponsible(((String) value));
                }
            }
            if( values.containsKey("WorkCenterResponsibleName") ) {
                final Object value = values.remove("WorkCenterResponsibleName");
                if( (value == null) || (!value.equals(getWorkCenterResponsibleName())) ) {
                    setWorkCenterResponsibleName(((String) value));
                }
            }
            if( values.containsKey("SupplyArea") ) {
                final Object value = values.remove("SupplyArea");
                if( (value == null) || (!value.equals(getSupplyArea())) ) {
                    setSupplyArea(((String) value));
                }
            }
            if( values.containsKey("WorkCenterUsage") ) {
                final Object value = values.remove("WorkCenterUsage");
                if( (value == null) || (!value.equals(getWorkCenterUsage())) ) {
                    setWorkCenterUsage(((String) value));
                }
            }
            if( values.containsKey("CapacityInternalID") ) {
                final Object value = values.remove("CapacityInternalID");
                if( (value == null) || (!value.equals(getCapacityInternalID())) ) {
                    setCapacityInternalID(((String) value));
                }
            }
            if( values.containsKey("WorkCenterIsToBeDeleted") ) {
                final Object value = values.remove("WorkCenterIsToBeDeleted");
                if( (value == null) || (!value.equals(getWorkCenterIsToBeDeleted())) ) {
                    setWorkCenterIsToBeDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("WorkCenterFormulaParam1") ) {
                final Object value = values.remove("WorkCenterFormulaParam1");
                if( (value == null) || (!value.equals(getWorkCenterFormulaParam1())) ) {
                    setWorkCenterFormulaParam1(((String) value));
                }
            }
            if( values.containsKey("WorkCenterFormulaParam2") ) {
                final Object value = values.remove("WorkCenterFormulaParam2");
                if( (value == null) || (!value.equals(getWorkCenterFormulaParam2())) ) {
                    setWorkCenterFormulaParam2(((String) value));
                }
            }
            if( values.containsKey("WorkCenterFormulaParam3") ) {
                final Object value = values.remove("WorkCenterFormulaParam3");
                if( (value == null) || (!value.equals(getWorkCenterFormulaParam3())) ) {
                    setWorkCenterFormulaParam3(((String) value));
                }
            }
            if( values.containsKey("WorkCenterFormulaParam4") ) {
                final Object value = values.remove("WorkCenterFormulaParam4");
                if( (value == null) || (!value.equals(getWorkCenterFormulaParam4())) ) {
                    setWorkCenterFormulaParam4(((String) value));
                }
            }
            if( values.containsKey("WorkCenterFormulaParam5") ) {
                final Object value = values.remove("WorkCenterFormulaParam5");
                if( (value == null) || (!value.equals(getWorkCenterFormulaParam5())) ) {
                    setWorkCenterFormulaParam5(((String) value));
                }
            }
            if( values.containsKey("WorkCenterFormulaParam6") ) {
                final Object value = values.remove("WorkCenterFormulaParam6");
                if( (value == null) || (!value.equals(getWorkCenterFormulaParam6())) ) {
                    setWorkCenterFormulaParam6(((String) value));
                }
            }
            if( values.containsKey("WorkCenterFmlaParamValue1") ) {
                final Object value = values.remove("WorkCenterFmlaParamValue1");
                if( (value == null) || (!value.equals(getWorkCenterFmlaParamValue1())) ) {
                    setWorkCenterFmlaParamValue1(((BigDecimal) value));
                }
            }
            if( values.containsKey("WorkCenterFmlaParamValue2") ) {
                final Object value = values.remove("WorkCenterFmlaParamValue2");
                if( (value == null) || (!value.equals(getWorkCenterFmlaParamValue2())) ) {
                    setWorkCenterFmlaParamValue2(((BigDecimal) value));
                }
            }
            if( values.containsKey("WorkCenterFmlaParamValue3") ) {
                final Object value = values.remove("WorkCenterFmlaParamValue3");
                if( (value == null) || (!value.equals(getWorkCenterFmlaParamValue3())) ) {
                    setWorkCenterFmlaParamValue3(((BigDecimal) value));
                }
            }
            if( values.containsKey("WorkCenterFmlaParamValue4") ) {
                final Object value = values.remove("WorkCenterFmlaParamValue4");
                if( (value == null) || (!value.equals(getWorkCenterFmlaParamValue4())) ) {
                    setWorkCenterFmlaParamValue4(((BigDecimal) value));
                }
            }
            if( values.containsKey("WorkCenterFmlaParamValue5") ) {
                final Object value = values.remove("WorkCenterFmlaParamValue5");
                if( (value == null) || (!value.equals(getWorkCenterFmlaParamValue5())) ) {
                    setWorkCenterFmlaParamValue5(((BigDecimal) value));
                }
            }
            if( values.containsKey("WorkCenterFmlaParamValue6") ) {
                final Object value = values.remove("WorkCenterFmlaParamValue6");
                if( (value == null) || (!value.equals(getWorkCenterFmlaParamValue6())) ) {
                    setWorkCenterFmlaParamValue6(((BigDecimal) value));
                }
            }
            if( values.containsKey("WorkCenterFmlaParamUnit1") ) {
                final Object value = values.remove("WorkCenterFmlaParamUnit1");
                if( (value == null) || (!value.equals(getWorkCenterFmlaParamUnit1())) ) {
                    setWorkCenterFmlaParamUnit1(((String) value));
                }
            }
            if( values.containsKey("WorkCenterFmlaParamUnit2") ) {
                final Object value = values.remove("WorkCenterFmlaParamUnit2");
                if( (value == null) || (!value.equals(getWorkCenterFmlaParamUnit2())) ) {
                    setWorkCenterFmlaParamUnit2(((String) value));
                }
            }
            if( values.containsKey("WorkCenterFmlaParamUnit3") ) {
                final Object value = values.remove("WorkCenterFmlaParamUnit3");
                if( (value == null) || (!value.equals(getWorkCenterFmlaParamUnit3())) ) {
                    setWorkCenterFmlaParamUnit3(((String) value));
                }
            }
            if( values.containsKey("WorkCenterFmlaParamUnit4") ) {
                final Object value = values.remove("WorkCenterFmlaParamUnit4");
                if( (value == null) || (!value.equals(getWorkCenterFmlaParamUnit4())) ) {
                    setWorkCenterFmlaParamUnit4(((String) value));
                }
            }
            if( values.containsKey("WorkCenterFmlaParamUnit5") ) {
                final Object value = values.remove("WorkCenterFmlaParamUnit5");
                if( (value == null) || (!value.equals(getWorkCenterFmlaParamUnit5())) ) {
                    setWorkCenterFmlaParamUnit5(((String) value));
                }
            }
            if( values.containsKey("WorkCenterFmlaParamUnit6") ) {
                final Object value = values.remove("WorkCenterFmlaParamUnit6");
                if( (value == null) || (!value.equals(getWorkCenterFmlaParamUnit6())) ) {
                    setWorkCenterFmlaParamUnit6(((String) value));
                }
            }
            if( values.containsKey("StandardWorkFormulaParamGroup") ) {
                final Object value = values.remove("StandardWorkFormulaParamGroup");
                if( (value == null) || (!value.equals(getStandardWorkFormulaParamGroup())) ) {
                    setStandardWorkFormulaParamGroup(((String) value));
                }
            }
            if( values.containsKey("WrkCtrStdValMaintRule1") ) {
                final Object value = values.remove("WrkCtrStdValMaintRule1");
                if( (value == null) || (!value.equals(getWrkCtrStdValMaintRule1())) ) {
                    setWrkCtrStdValMaintRule1(((String) value));
                }
            }
            if( values.containsKey("WrkCtrStdValMaintRule2") ) {
                final Object value = values.remove("WrkCtrStdValMaintRule2");
                if( (value == null) || (!value.equals(getWrkCtrStdValMaintRule2())) ) {
                    setWrkCtrStdValMaintRule2(((String) value));
                }
            }
            if( values.containsKey("WrkCtrStdValMaintRule3") ) {
                final Object value = values.remove("WrkCtrStdValMaintRule3");
                if( (value == null) || (!value.equals(getWrkCtrStdValMaintRule3())) ) {
                    setWrkCtrStdValMaintRule3(((String) value));
                }
            }
            if( values.containsKey("WrkCtrStdValMaintRule4") ) {
                final Object value = values.remove("WrkCtrStdValMaintRule4");
                if( (value == null) || (!value.equals(getWrkCtrStdValMaintRule4())) ) {
                    setWrkCtrStdValMaintRule4(((String) value));
                }
            }
            if( values.containsKey("WrkCtrStdValMaintRule5") ) {
                final Object value = values.remove("WrkCtrStdValMaintRule5");
                if( (value == null) || (!value.equals(getWrkCtrStdValMaintRule5())) ) {
                    setWrkCtrStdValMaintRule5(((String) value));
                }
            }
            if( values.containsKey("WrkCtrStdValMaintRule6") ) {
                final Object value = values.remove("WrkCtrStdValMaintRule6");
                if( (value == null) || (!value.equals(getWrkCtrStdValMaintRule6())) ) {
                    setWrkCtrStdValMaintRule6(((String) value));
                }
            }
            if( values.containsKey("WorkCenterStandardWorkQtyUnit1") ) {
                final Object value = values.remove("WorkCenterStandardWorkQtyUnit1");
                if( (value == null) || (!value.equals(getWorkCenterStandardWorkQtyUnit1())) ) {
                    setWorkCenterStandardWorkQtyUnit1(((String) value));
                }
            }
            if( values.containsKey("WorkCenterStandardWorkQtyUnit2") ) {
                final Object value = values.remove("WorkCenterStandardWorkQtyUnit2");
                if( (value == null) || (!value.equals(getWorkCenterStandardWorkQtyUnit2())) ) {
                    setWorkCenterStandardWorkQtyUnit2(((String) value));
                }
            }
            if( values.containsKey("WorkCenterStandardWorkQtyUnit3") ) {
                final Object value = values.remove("WorkCenterStandardWorkQtyUnit3");
                if( (value == null) || (!value.equals(getWorkCenterStandardWorkQtyUnit3())) ) {
                    setWorkCenterStandardWorkQtyUnit3(((String) value));
                }
            }
            if( values.containsKey("WorkCenterStandardWorkQtyUnit4") ) {
                final Object value = values.remove("WorkCenterStandardWorkQtyUnit4");
                if( (value == null) || (!value.equals(getWorkCenterStandardWorkQtyUnit4())) ) {
                    setWorkCenterStandardWorkQtyUnit4(((String) value));
                }
            }
            if( values.containsKey("WorkCenterStandardWorkQtyUnit5") ) {
                final Object value = values.remove("WorkCenterStandardWorkQtyUnit5");
                if( (value == null) || (!value.equals(getWorkCenterStandardWorkQtyUnit5())) ) {
                    setWorkCenterStandardWorkQtyUnit5(((String) value));
                }
            }
            if( values.containsKey("WorkCenterStandardWorkQtyUnit6") ) {
                final Object value = values.remove("WorkCenterStandardWorkQtyUnit6");
                if( (value == null) || (!value.equals(getWorkCenterStandardWorkQtyUnit6())) ) {
                    setWorkCenterStandardWorkQtyUnit6(((String) value));
                }
            }
            if( values.containsKey("OperationControlProfile") ) {
                final Object value = values.remove("OperationControlProfile");
                if( (value == null) || (!value.equals(getOperationControlProfile())) ) {
                    setOperationControlProfile(((String) value));
                }
            }
            if( values.containsKey("MatlCompIsMarkedForBackflush") ) {
                final Object value = values.remove("MatlCompIsMarkedForBackflush");
                if( (value == null) || (!value.equals(getMatlCompIsMarkedForBackflush())) ) {
                    setMatlCompIsMarkedForBackflush(((Boolean) value));
                }
            }
            if( values.containsKey("WorkCenterLocation") ) {
                final Object value = values.remove("WorkCenterLocation");
                if( (value == null) || (!value.equals(getWorkCenterLocation())) ) {
                    setWorkCenterLocation(((String) value));
                }
            }
            if( values.containsKey("WorkCenterLocationGroup") ) {
                final Object value = values.remove("WorkCenterLocationGroup");
                if( (value == null) || (!value.equals(getWorkCenterLocationGroup())) ) {
                    setWorkCenterLocationGroup(((String) value));
                }
            }
            if( values.containsKey("WrkCtrSetupSchedgFmla") ) {
                final Object value = values.remove("WrkCtrSetupSchedgFmla");
                if( (value == null) || (!value.equals(getWrkCtrSetupSchedgFmla())) ) {
                    setWrkCtrSetupSchedgFmla(((String) value));
                }
            }
            if( values.containsKey("WrkCtrProcgSchedgFmla") ) {
                final Object value = values.remove("WrkCtrProcgSchedgFmla");
                if( (value == null) || (!value.equals(getWrkCtrProcgSchedgFmla())) ) {
                    setWrkCtrProcgSchedgFmla(((String) value));
                }
            }
            if( values.containsKey("WrkCtrTeardownSchedgFmla") ) {
                final Object value = values.remove("WrkCtrTeardownSchedgFmla");
                if( (value == null) || (!value.equals(getWrkCtrTeardownSchedgFmla())) ) {
                    setWrkCtrTeardownSchedgFmla(((String) value));
                }
            }
            if( values.containsKey("WrkCtrIntProcgSchedgFmla") ) {
                final Object value = values.remove("WrkCtrIntProcgSchedgFmla");
                if( (value == null) || (!value.equals(getWrkCtrIntProcgSchedgFmla())) ) {
                    setWrkCtrIntProcgSchedgFmla(((String) value));
                }
            }
            if( values.containsKey("WorkCenterLastChangeDateTime") ) {
                final Object value = values.remove("WorkCenterLastChangeDateTime");
                if( (value == null) || (!value.equals(getWorkCenterLastChangeDateTime())) ) {
                    setWorkCenterLastChangeDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Capacity") ) {
                final Object value = (values).remove("to_Capacity");
                if( value instanceof Map ) {
                    if( toCapacity == null ) {
                        toCapacity = new WorkCenterCapacity();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCapacity.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_WorkCenterAllCapacity") ) {
                final Object value = (values).remove("to_WorkCenterAllCapacity");
                if( value instanceof Iterable ) {
                    if( toWorkCenterAllCapacity == null ) {
                        toWorkCenterAllCapacity = Lists.newArrayList();
                    } else {
                        toWorkCenterAllCapacity = Lists.newArrayList(toWorkCenterAllCapacity);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterAllCapacity_2 entity;
                        if( toWorkCenterAllCapacity.size() > i ) {
                            entity = toWorkCenterAllCapacity.get(i);
                        } else {
                            entity = new WorkCenterAllCapacity_2();
                            toWorkCenterAllCapacity.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_WorkCenterCapacity") ) {
                final Object value = (values).remove("to_WorkCenterCapacity");
                if( value instanceof Iterable ) {
                    if( toWorkCenterCapacity == null ) {
                        toWorkCenterCapacity = Lists.newArrayList();
                    } else {
                        toWorkCenterCapacity = Lists.newArrayList(toWorkCenterCapacity);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterAllCapacity entity;
                        if( toWorkCenterCapacity.size() > i ) {
                            entity = toWorkCenterCapacity.get(i);
                        } else {
                            entity = new WorkCenterAllCapacity();
                            toWorkCenterCapacity.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_WorkCenterCostCenter") ) {
                final Object value = (values).remove("to_WorkCenterCostCenter");
                if( value instanceof Iterable ) {
                    if( toWorkCenterCostCenter == null ) {
                        toWorkCenterCostCenter = Lists.newArrayList();
                    } else {
                        toWorkCenterCostCenter = Lists.newArrayList(toWorkCenterCostCenter);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterCostCenter entity;
                        if( toWorkCenterCostCenter.size() > i ) {
                            entity = toWorkCenterCostCenter.get(i);
                        } else {
                            entity = new WorkCenterCostCenter();
                            toWorkCenterCostCenter.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_WorkCenterDescription") ) {
                final Object value = (values).remove("to_WorkCenterDescription");
                if( value instanceof Iterable ) {
                    if( toWorkCenterDescription == null ) {
                        toWorkCenterDescription = Lists.newArrayList();
                    } else {
                        toWorkCenterDescription = Lists.newArrayList(toWorkCenterDescription);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterDescription entity;
                        if( toWorkCenterDescription.size() > i ) {
                            entity = toWorkCenterDescription.get(i);
                        } else {
                            entity = new WorkCenterDescription();
                            toWorkCenterDescription.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_WorkCenterQueuingOp") ) {
                final Object value = (values).remove("to_WorkCenterQueuingOp");
                if( value instanceof Iterable ) {
                    if( toWorkCenterQueuingOp == null ) {
                        toWorkCenterQueuingOp = Lists.newArrayList();
                    } else {
                        toWorkCenterQueuingOp = Lists.newArrayList(toWorkCenterQueuingOp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterPipeLineOperation entity;
                        if( toWorkCenterQueuingOp.size() > i ) {
                            entity = toWorkCenterQueuingOp.get(i);
                        } else {
                            entity = new WorkCenterPipeLineOperation();
                            toWorkCenterQueuingOp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_WorkCenterTodayOp") ) {
                final Object value = (values).remove("to_WorkCenterTodayOp");
                if( value instanceof Iterable ) {
                    if( toWorkCenterTodayOp == null ) {
                        toWorkCenterTodayOp = Lists.newArrayList();
                    } else {
                        toWorkCenterTodayOp = Lists.newArrayList(toWorkCenterTodayOp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WorkCenterDayOperation entity;
                        if( toWorkCenterTodayOp.size() > i ) {
                            entity = toWorkCenterTodayOp.get(i);
                        } else {
                            entity = new WorkCenterDayOperation();
                            toWorkCenterTodayOp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WorkCentersField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WorkCentersField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WorkCentersField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WorkCentersField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCapacity != null ) {
            (values).put("to_Capacity", toCapacity);
        }
        if( toWorkCenterAllCapacity != null ) {
            (values).put("to_WorkCenterAllCapacity", toWorkCenterAllCapacity);
        }
        if( toWorkCenterCapacity != null ) {
            (values).put("to_WorkCenterCapacity", toWorkCenterCapacity);
        }
        if( toWorkCenterCostCenter != null ) {
            (values).put("to_WorkCenterCostCenter", toWorkCenterCostCenter);
        }
        if( toWorkCenterDescription != null ) {
            (values).put("to_WorkCenterDescription", toWorkCenterDescription);
        }
        if( toWorkCenterQueuingOp != null ) {
            (values).put("to_WorkCenterQueuingOp", toWorkCenterQueuingOp);
        }
        if( toWorkCenterTodayOp != null ) {
            (values).put("to_WorkCenterTodayOp", toWorkCenterTodayOp);
        }
        return values;
    }

    /**
     * Fetches the <b>WorkCenterCapacity</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Capacity</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>WorkCenterCapacity</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WorkCenterCapacity fetchCapacity()
    {
        return fetchFieldAsSingle("to_Capacity", WorkCenterCapacity.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacity</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Capacity</b>.
     * <p>
     * If the navigation property <b>to_Capacity</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCapacity</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public WorkCenterCapacity getCapacityOrFetch()
    {
        if( toCapacity == null ) {
            toCapacity = fetchCapacity();
        }
        return toCapacity;
    }

    /**
     * Retrieval of associated <b>WorkCenterCapacity</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_Capacity</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenters</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Capacity</b> is already loaded, the result will contain
     *         the <b>WorkCenterCapacity</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<WorkCenterCapacity> getCapacityIfPresent()
    {
        return Option.of(toCapacity);
    }

    /**
     * Overwrites the associated <b>WorkCenterCapacity</b> entity for the loaded navigation property <b>to_Capacity</b>.
     *
     * @param value
     *            New <b>WorkCenterCapacity</b> entity.
     */
    public void setCapacity( final WorkCenterCapacity value )
    {
        toCapacity = value;
    }

    /**
     * Fetches the <b>WorkCenterAllCapacity_2</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_WorkCenterAllCapacity</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterAllCapacity_2</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterAllCapacity_2> fetchWorkCenterAllCapacity()
    {
        return fetchFieldAsList("to_WorkCenterAllCapacity", WorkCenterAllCapacity_2.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterAllCapacity_2</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterAllCapacity</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterAllCapacity</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterAllCapacity_2</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterAllCapacity_2> getWorkCenterAllCapacityOrFetch()
    {
        if( toWorkCenterAllCapacity == null ) {
            toWorkCenterAllCapacity = fetchWorkCenterAllCapacity();
        }
        return toWorkCenterAllCapacity;
    }

    /**
     * Retrieval of associated <b>WorkCenterAllCapacity_2</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterAllCapacity</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenters</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WorkCenterAllCapacity</b> is already loaded, the result
     *         will contain the <b>WorkCenterAllCapacity_2</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterAllCapacity_2>> getWorkCenterAllCapacityIfPresent()
    {
        return Option.of(toWorkCenterAllCapacity);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterAllCapacity_2</b> entities for the loaded navigation property
     * <b>to_WorkCenterAllCapacity</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterAllCapacity</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterAllCapacity_2</b> entities.
     */
    public void setWorkCenterAllCapacity( @Nonnull final List<WorkCenterAllCapacity_2> value )
    {
        if( toWorkCenterAllCapacity == null ) {
            toWorkCenterAllCapacity = Lists.newArrayList();
        }
        toWorkCenterAllCapacity.clear();
        toWorkCenterAllCapacity.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterAllCapacity_2</b> entities. This corresponds to the OData
     * navigation property <b>to_WorkCenterAllCapacity</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterAllCapacity</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterAllCapacity_2</b> entities.
     */
    public void addWorkCenterAllCapacity( WorkCenterAllCapacity_2... entity )
    {
        if( toWorkCenterAllCapacity == null ) {
            toWorkCenterAllCapacity = Lists.newArrayList();
        }
        toWorkCenterAllCapacity.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WorkCenterAllCapacity</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_WorkCenterCapacity</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterAllCapacity</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterAllCapacity> fetchWorkCenterCapacity()
    {
        return fetchFieldAsList("to_WorkCenterCapacity", WorkCenterAllCapacity.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterAllCapacity</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterCapacity</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterCapacity</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterAllCapacity</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterAllCapacity> getWorkCenterCapacityOrFetch()
    {
        if( toWorkCenterCapacity == null ) {
            toWorkCenterCapacity = fetchWorkCenterCapacity();
        }
        return toWorkCenterCapacity;
    }

    /**
     * Retrieval of associated <b>WorkCenterAllCapacity</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterCapacity</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenters</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WorkCenterCapacity</b> is already loaded, the result
     *         will contain the <b>WorkCenterAllCapacity</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterAllCapacity>> getWorkCenterCapacityIfPresent()
    {
        return Option.of(toWorkCenterCapacity);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterAllCapacity</b> entities for the loaded navigation property
     * <b>to_WorkCenterCapacity</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterCapacity</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterAllCapacity</b> entities.
     */
    public void setWorkCenterCapacity( @Nonnull final List<WorkCenterAllCapacity> value )
    {
        if( toWorkCenterCapacity == null ) {
            toWorkCenterCapacity = Lists.newArrayList();
        }
        toWorkCenterCapacity.clear();
        toWorkCenterCapacity.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterAllCapacity</b> entities. This corresponds to the OData
     * navigation property <b>to_WorkCenterCapacity</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterCapacity</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterAllCapacity</b> entities.
     */
    public void addWorkCenterCapacity( WorkCenterAllCapacity... entity )
    {
        if( toWorkCenterCapacity == null ) {
            toWorkCenterCapacity = Lists.newArrayList();
        }
        toWorkCenterCapacity.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WorkCenterCostCenter</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_WorkCenterCostCenter</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterCostCenter</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCostCenter> fetchWorkCenterCostCenter()
    {
        return fetchFieldAsList("to_WorkCenterCostCenter", WorkCenterCostCenter.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterCostCenter</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterCostCenter</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterCostCenter</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterCostCenter</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterCostCenter> getWorkCenterCostCenterOrFetch()
    {
        if( toWorkCenterCostCenter == null ) {
            toWorkCenterCostCenter = fetchWorkCenterCostCenter();
        }
        return toWorkCenterCostCenter;
    }

    /**
     * Retrieval of associated <b>WorkCenterCostCenter</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterCostCenter</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenters</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WorkCenterCostCenter</b> is already loaded, the result
     *         will contain the <b>WorkCenterCostCenter</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterCostCenter>> getWorkCenterCostCenterIfPresent()
    {
        return Option.of(toWorkCenterCostCenter);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterCostCenter</b> entities for the loaded navigation property
     * <b>to_WorkCenterCostCenter</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterCostCenter</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterCostCenter</b> entities.
     */
    public void setWorkCenterCostCenter( @Nonnull final List<WorkCenterCostCenter> value )
    {
        if( toWorkCenterCostCenter == null ) {
            toWorkCenterCostCenter = Lists.newArrayList();
        }
        toWorkCenterCostCenter.clear();
        toWorkCenterCostCenter.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterCostCenter</b> entities. This corresponds to the OData
     * navigation property <b>to_WorkCenterCostCenter</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterCostCenter</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterCostCenter</b> entities.
     */
    public void addWorkCenterCostCenter( WorkCenterCostCenter... entity )
    {
        if( toWorkCenterCostCenter == null ) {
            toWorkCenterCostCenter = Lists.newArrayList();
        }
        toWorkCenterCostCenter.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WorkCenterDescription</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_WorkCenterDescription</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterDescription</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterDescription> fetchWorkCenterDescription()
    {
        return fetchFieldAsList("to_WorkCenterDescription", WorkCenterDescription.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterDescription</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterDescription</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterDescription</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterDescription</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterDescription> getWorkCenterDescriptionOrFetch()
    {
        if( toWorkCenterDescription == null ) {
            toWorkCenterDescription = fetchWorkCenterDescription();
        }
        return toWorkCenterDescription;
    }

    /**
     * Retrieval of associated <b>WorkCenterDescription</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterDescription</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenters</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WorkCenterDescription</b> is already loaded, the result
     *         will contain the <b>WorkCenterDescription</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterDescription>> getWorkCenterDescriptionIfPresent()
    {
        return Option.of(toWorkCenterDescription);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterDescription</b> entities for the loaded navigation property
     * <b>to_WorkCenterDescription</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterDescription</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterDescription</b> entities.
     */
    public void setWorkCenterDescription( @Nonnull final List<WorkCenterDescription> value )
    {
        if( toWorkCenterDescription == null ) {
            toWorkCenterDescription = Lists.newArrayList();
        }
        toWorkCenterDescription.clear();
        toWorkCenterDescription.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterDescription</b> entities. This corresponds to the OData
     * navigation property <b>to_WorkCenterDescription</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterDescription</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterDescription</b> entities.
     */
    public void addWorkCenterDescription( WorkCenterDescription... entity )
    {
        if( toWorkCenterDescription == null ) {
            toWorkCenterDescription = Lists.newArrayList();
        }
        toWorkCenterDescription.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WorkCenterPipeLineOperation</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterPipeLineOperation</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterPipeLineOperation> fetchWorkCenterQueuingOp()
    {
        return fetchFieldAsList("to_WorkCenterQueuingOp", WorkCenterPipeLineOperation.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterPipeLineOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterQueuingOp</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterPipeLineOperation</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterPipeLineOperation> getWorkCenterQueuingOpOrFetch()
    {
        if( toWorkCenterQueuingOp == null ) {
            toWorkCenterQueuingOp = fetchWorkCenterQueuingOp();
        }
        return toWorkCenterQueuingOp;
    }

    /**
     * Retrieval of associated <b>WorkCenterPipeLineOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenters</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WorkCenterQueuingOp</b> is already loaded, the result
     *         will contain the <b>WorkCenterPipeLineOperation</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterPipeLineOperation>> getWorkCenterQueuingOpIfPresent()
    {
        return Option.of(toWorkCenterQueuingOp);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterPipeLineOperation</b> entities for the loaded navigation property
     * <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterQueuingOp</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterPipeLineOperation</b> entities.
     */
    public void setWorkCenterQueuingOp( @Nonnull final List<WorkCenterPipeLineOperation> value )
    {
        if( toWorkCenterQueuingOp == null ) {
            toWorkCenterQueuingOp = Lists.newArrayList();
        }
        toWorkCenterQueuingOp.clear();
        toWorkCenterQueuingOp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterPipeLineOperation</b> entities. This corresponds to the
     * OData navigation property <b>to_WorkCenterQueuingOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterQueuingOp</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterPipeLineOperation</b> entities.
     */
    public void addWorkCenterQueuingOp( WorkCenterPipeLineOperation... entity )
    {
        if( toWorkCenterQueuingOp == null ) {
            toWorkCenterQueuingOp = Lists.newArrayList();
        }
        toWorkCenterQueuingOp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>WorkCenterDayOperation</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_WorkCenterTodayOp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WorkCenterDayOperation</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterDayOperation> fetchWorkCenterTodayOp()
    {
        return fetchFieldAsList("to_WorkCenterTodayOp", WorkCenterDayOperation.class);
    }

    /**
     * Retrieval of associated <b>WorkCenterDayOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterTodayOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterTodayOp</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WorkCenterDayOperation</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WorkCenterDayOperation> getWorkCenterTodayOpOrFetch()
    {
        if( toWorkCenterTodayOp == null ) {
            toWorkCenterTodayOp = fetchWorkCenterTodayOp();
        }
        return toWorkCenterTodayOp;
    }

    /**
     * Retrieval of associated <b>WorkCenterDayOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_WorkCenterTodayOp</b>.
     * <p>
     * If the navigation property for an entity <b>WorkCenters</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_WorkCenterTodayOp</b> is already loaded, the result will
     *         contain the <b>WorkCenterDayOperation</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WorkCenterDayOperation>> getWorkCenterTodayOpIfPresent()
    {
        return Option.of(toWorkCenterTodayOp);
    }

    /**
     * Overwrites the list of associated <b>WorkCenterDayOperation</b> entities for the loaded navigation property
     * <b>to_WorkCenterTodayOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterTodayOp</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WorkCenterDayOperation</b> entities.
     */
    public void setWorkCenterTodayOp( @Nonnull final List<WorkCenterDayOperation> value )
    {
        if( toWorkCenterTodayOp == null ) {
            toWorkCenterTodayOp = Lists.newArrayList();
        }
        toWorkCenterTodayOp.clear();
        toWorkCenterTodayOp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WorkCenterDayOperation</b> entities. This corresponds to the OData
     * navigation property <b>to_WorkCenterTodayOp</b>.
     * <p>
     * If the navigation property <b>to_WorkCenterTodayOp</b> of a queried <b>WorkCenters</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WorkCenterDayOperation</b> entities.
     */
    public void addWorkCenterTodayOp( WorkCenterDayOperation... entity )
    {
        if( toWorkCenterTodayOp == null ) {
            toWorkCenterTodayOp = Lists.newArrayList();
        }
        toWorkCenterTodayOp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WorkCenters instances.
     *
     */
    public final static class WorkCentersBuilder
    {

        private WorkCenterCapacity toCapacity;
        private List<WorkCenterAllCapacity_2> toWorkCenterAllCapacity = Lists.newArrayList();
        private List<WorkCenterAllCapacity> toWorkCenterCapacity = Lists.newArrayList();
        private List<WorkCenterCostCenter> toWorkCenterCostCenter = Lists.newArrayList();
        private List<WorkCenterDescription> toWorkCenterDescription = Lists.newArrayList();
        private List<WorkCenterPipeLineOperation> toWorkCenterQueuingOp = Lists.newArrayList();
        private List<WorkCenterDayOperation> toWorkCenterTodayOp = Lists.newArrayList();

        private WorkCenters.WorkCentersBuilder toCapacity( final WorkCenterCapacity value )
        {
            toCapacity = value;
            return this;
        }

        /**
         * Navigation property <b>to_Capacity</b> for <b>WorkCenters</b> to single <b>WorkCenterCapacity</b>.
         *
         * @param value
         *            The WorkCenterCapacity to build this WorkCenters with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenters.WorkCentersBuilder capacity( final WorkCenterCapacity value )
        {
            return toCapacity(value);
        }

        private WorkCenters.WorkCentersBuilder toWorkCenterAllCapacity( final List<WorkCenterAllCapacity_2> value )
        {
            toWorkCenterAllCapacity.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WorkCenterAllCapacity</b> for <b>WorkCenters</b> to multiple
         * <b>WorkCenterAllCapacity_2</b>.
         *
         * @param value
         *            The WorkCenterAllCapacity_2s to build this WorkCenters with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenters.WorkCentersBuilder workCenterAllCapacity( WorkCenterAllCapacity_2... value )
        {
            return toWorkCenterAllCapacity(Lists.newArrayList(value));
        }

        private WorkCenters.WorkCentersBuilder toWorkCenterCapacity( final List<WorkCenterAllCapacity> value )
        {
            toWorkCenterCapacity.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WorkCenterCapacity</b> for <b>WorkCenters</b> to multiple
         * <b>WorkCenterAllCapacity</b>.
         *
         * @param value
         *            The WorkCenterAllCapacitys to build this WorkCenters with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenters.WorkCentersBuilder workCenterCapacity( WorkCenterAllCapacity... value )
        {
            return toWorkCenterCapacity(Lists.newArrayList(value));
        }

        private WorkCenters.WorkCentersBuilder toWorkCenterCostCenter( final List<WorkCenterCostCenter> value )
        {
            toWorkCenterCostCenter.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WorkCenterCostCenter</b> for <b>WorkCenters</b> to multiple
         * <b>WorkCenterCostCenter</b>.
         *
         * @param value
         *            The WorkCenterCostCenters to build this WorkCenters with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenters.WorkCentersBuilder workCenterCostCenter( WorkCenterCostCenter... value )
        {
            return toWorkCenterCostCenter(Lists.newArrayList(value));
        }

        private WorkCenters.WorkCentersBuilder toWorkCenterDescription( final List<WorkCenterDescription> value )
        {
            toWorkCenterDescription.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WorkCenterDescription</b> for <b>WorkCenters</b> to multiple
         * <b>WorkCenterDescription</b>.
         *
         * @param value
         *            The WorkCenterDescriptions to build this WorkCenters with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenters.WorkCentersBuilder workCenterDescription( WorkCenterDescription... value )
        {
            return toWorkCenterDescription(Lists.newArrayList(value));
        }

        private WorkCenters.WorkCentersBuilder toWorkCenterQueuingOp( final List<WorkCenterPipeLineOperation> value )
        {
            toWorkCenterQueuingOp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WorkCenterQueuingOp</b> for <b>WorkCenters</b> to multiple
         * <b>WorkCenterPipeLineOperation</b>.
         *
         * @param value
         *            The WorkCenterPipeLineOperations to build this WorkCenters with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenters.WorkCentersBuilder workCenterQueuingOp( WorkCenterPipeLineOperation... value )
        {
            return toWorkCenterQueuingOp(Lists.newArrayList(value));
        }

        private WorkCenters.WorkCentersBuilder toWorkCenterTodayOp( final List<WorkCenterDayOperation> value )
        {
            toWorkCenterTodayOp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_WorkCenterTodayOp</b> for <b>WorkCenters</b> to multiple
         * <b>WorkCenterDayOperation</b>.
         *
         * @param value
         *            The WorkCenterDayOperations to build this WorkCenters with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WorkCenters.WorkCentersBuilder workCenterTodayOp( WorkCenterDayOperation... value )
        {
            return toWorkCenterTodayOp(Lists.newArrayList(value));
        }

    }

}
