/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters;

/**
 * Implementation of the {@link WorkCenterDataServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService WorkCenterDataService}.
 *
 */
public class DefaultWorkCenterDataServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<WorkCenterDataServiceBatch, WorkCenterDataServiceBatchChangeSet>
    implements
    WorkCenterDataServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService service;

    @SuppressWarnings( "deprecation" )
    DefaultWorkCenterDataServiceBatchChangeSet(
        @Nonnull final DefaultWorkCenterDataServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultWorkCenterDataServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet createWorkCenterAllCapacity(
        @Nonnull final WorkCenterAllCapacity workCenterAllCapacity )
    {
        return addRequestCreate(service::createWorkCenterAllCapacity, workCenterAllCapacity);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet createWorkCenterAllCapacity_2(
        @Nonnull final WorkCenterAllCapacity_2 workCenterAllCapacity_2 )
    {
        return addRequestCreate(service::createWorkCenterAllCapacity_2, workCenterAllCapacity_2);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet updateWorkCenterAllCapacity_2(
        @Nonnull final WorkCenterAllCapacity_2 workCenterAllCapacity_2 )
    {
        return addRequestUpdate(service::updateWorkCenterAllCapacity_2, workCenterAllCapacity_2);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet createWorkCenterCapacity(
        @Nonnull final WorkCenterCapacity workCenterCapacity )
    {
        return addRequestCreate(service::createWorkCenterCapacity, workCenterCapacity);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet updateWorkCenterCapacity(
        @Nonnull final WorkCenterCapacity workCenterCapacity )
    {
        return addRequestUpdate(service::updateWorkCenterCapacity, workCenterCapacity);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet createWorkCenterCapacityInterval(
        @Nonnull final WorkCenterCapacityInterval workCenterCapacityInterval )
    {
        return addRequestCreate(service::createWorkCenterCapacityInterval, workCenterCapacityInterval);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet updateWorkCenterCapacityInterval(
        @Nonnull final WorkCenterCapacityInterval workCenterCapacityInterval )
    {
        return addRequestUpdate(service::updateWorkCenterCapacityInterval, workCenterCapacityInterval);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet createWorkCenterCapacityInterval_2(
        @Nonnull final WorkCenterCapacityInterval_2 workCenterCapacityInterval_2 )
    {
        return addRequestCreate(service::createWorkCenterCapacityInterval_2, workCenterCapacityInterval_2);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet updateWorkCenterCapacityInterval_2(
        @Nonnull final WorkCenterCapacityInterval_2 workCenterCapacityInterval_2 )
    {
        return addRequestUpdate(service::updateWorkCenterCapacityInterval_2, workCenterCapacityInterval_2);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet createWorkCenterCapacityShift(
        @Nonnull final WorkCenterCapacityShift workCenterCapacityShift )
    {
        return addRequestCreate(service::createWorkCenterCapacityShift, workCenterCapacityShift);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet updateWorkCenterCapacityShift(
        @Nonnull final WorkCenterCapacityShift workCenterCapacityShift )
    {
        return addRequestUpdate(service::updateWorkCenterCapacityShift, workCenterCapacityShift);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet createWorkCenterCapacityShift_2(
        @Nonnull final WorkCenterCapacityShift_2 workCenterCapacityShift_2 )
    {
        return addRequestCreate(service::createWorkCenterCapacityShift_2, workCenterCapacityShift_2);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet updateWorkCenterCapacityShift_2(
        @Nonnull final WorkCenterCapacityShift_2 workCenterCapacityShift_2 )
    {
        return addRequestUpdate(service::updateWorkCenterCapacityShift_2, workCenterCapacityShift_2);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet updateWorkCenterCapacityText(
        @Nonnull final WorkCenterCapacityText workCenterCapacityText )
    {
        return addRequestUpdate(service::updateWorkCenterCapacityText, workCenterCapacityText);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet createWorkCenterCostCenter(
        @Nonnull final WorkCenterCostCenter workCenterCostCenter )
    {
        return addRequestCreate(service::createWorkCenterCostCenter, workCenterCostCenter);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet updateWorkCenterCostCenter(
        @Nonnull final WorkCenterCostCenter workCenterCostCenter )
    {
        return addRequestUpdate(service::updateWorkCenterCostCenter, workCenterCostCenter);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet updateWorkCenterDescription(
        @Nonnull final WorkCenterDescription workCenterDescription )
    {
        return addRequestUpdate(service::updateWorkCenterDescription, workCenterDescription);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet createWorkCenters( @Nonnull final WorkCenters workCenters )
    {
        return addRequestCreate(service::createWorkCenters, workCenters);
    }

    @Nonnull
    @Override
    public WorkCenterDataServiceBatchChangeSet updateWorkCenters( @Nonnull final WorkCenters workCenters )
    {
        return addRequestUpdate(service::updateWorkCenters, workCenters);
    }

}
