/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.WorkCenterDataService WorkCenterDataService}.
 *
 */
public interface WorkCenterDataServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<WorkCenterDataServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<WorkCenterDataServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity
     * WorkCenterAllCapacity} entity and save it to the S/4HANA system.
     *
     * @param workCenterAllCapacity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity
     *            WorkCenterAllCapacity} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        createWorkCenterAllCapacity( @Nonnull final WorkCenterAllCapacity workCenterAllCapacity );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     * WorkCenterAllCapacity_2} entity and save it to the S/4HANA system.
     *
     * @param workCenterAllCapacity_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     *            WorkCenterAllCapacity_2} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        createWorkCenterAllCapacity_2( @Nonnull final WorkCenterAllCapacity_2 workCenterAllCapacity_2 );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     * WorkCenterAllCapacity_2} entity and save it to the S/4HANA system.
     *
     * @param workCenterAllCapacity_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity_2
     *            WorkCenterAllCapacity_2} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        updateWorkCenterAllCapacity_2( @Nonnull final WorkCenterAllCapacity_2 workCenterAllCapacity_2 );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     * WorkCenterCapacity} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     *            WorkCenterCapacity} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        createWorkCenterCapacity( @Nonnull final WorkCenterCapacity workCenterCapacity );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     * WorkCenterCapacity} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacity
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacity
     *            WorkCenterCapacity} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        updateWorkCenterCapacity( @Nonnull final WorkCenterCapacity workCenterCapacity );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     * WorkCenterCapacityInterval} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityInterval
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     *            WorkCenterCapacityInterval} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        createWorkCenterCapacityInterval( @Nonnull final WorkCenterCapacityInterval workCenterCapacityInterval );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     * WorkCenterCapacityInterval} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityInterval
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval
     *            WorkCenterCapacityInterval} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        updateWorkCenterCapacityInterval( @Nonnull final WorkCenterCapacityInterval workCenterCapacityInterval );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     * WorkCenterCapacityInterval_2} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityInterval_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     *            WorkCenterCapacityInterval_2} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        createWorkCenterCapacityInterval_2( @Nonnull final WorkCenterCapacityInterval_2 workCenterCapacityInterval_2 );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     * WorkCenterCapacityInterval_2} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityInterval_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityInterval_2
     *            WorkCenterCapacityInterval_2} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        updateWorkCenterCapacityInterval_2( @Nonnull final WorkCenterCapacityInterval_2 workCenterCapacityInterval_2 );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     * WorkCenterCapacityShift} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityShift
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     *            WorkCenterCapacityShift} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        createWorkCenterCapacityShift( @Nonnull final WorkCenterCapacityShift workCenterCapacityShift );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     * WorkCenterCapacityShift} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityShift
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift
     *            WorkCenterCapacityShift} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        updateWorkCenterCapacityShift( @Nonnull final WorkCenterCapacityShift workCenterCapacityShift );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     * WorkCenterCapacityShift_2} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityShift_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     *            WorkCenterCapacityShift_2} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        createWorkCenterCapacityShift_2( @Nonnull final WorkCenterCapacityShift_2 workCenterCapacityShift_2 );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     * WorkCenterCapacityShift_2} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityShift_2
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityShift_2
     *            WorkCenterCapacityShift_2} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        updateWorkCenterCapacityShift_2( @Nonnull final WorkCenterCapacityShift_2 workCenterCapacityShift_2 );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityText
     * WorkCenterCapacityText} entity and save it to the S/4HANA system.
     *
     * @param workCenterCapacityText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapacityText
     *            WorkCenterCapacityText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        updateWorkCenterCapacityText( @Nonnull final WorkCenterCapacityText workCenterCapacityText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     * WorkCenterCostCenter} entity and save it to the S/4HANA system.
     *
     * @param workCenterCostCenter
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     *            WorkCenterCostCenter} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        createWorkCenterCostCenter( @Nonnull final WorkCenterCostCenter workCenterCostCenter );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     * WorkCenterCostCenter} entity and save it to the S/4HANA system.
     *
     * @param workCenterCostCenter
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCostCenter
     *            WorkCenterCostCenter} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        updateWorkCenterCostCenter( @Nonnull final WorkCenterCostCenter workCenterCostCenter );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescription
     * WorkCenterDescription} entity and save it to the S/4HANA system.
     *
     * @param workCenterDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterDescription
     *            WorkCenterDescription} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet
        updateWorkCenterDescription( @Nonnull final WorkCenterDescription workCenterDescription );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters WorkCenters}
     * entity and save it to the S/4HANA system.
     *
     * @param workCenters
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters WorkCenters}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet createWorkCenters( @Nonnull final WorkCenters workCenters );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters
     * WorkCenters} entity and save it to the S/4HANA system.
     *
     * @param workCenters
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenters WorkCenters}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    WorkCenterDataServiceBatchChangeSet updateWorkCenters( @Nonnull final WorkCenters workCenters );

}
