/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity
 * WorkCenterAllCapacity}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterAllCapacityField
 * WorkCenterAllCapacityField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterAllCapacityLink
 * WorkCenterAllCapacityLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#WORK_CENTER_TYPE_CODE
 * WORK_CENTER_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#CAPACITY_INTERNAL_ID
 * CAPACITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#CAPACITY_CATEGORY_ALLOCATION
 * CAPACITY_CATEGORY_ALLOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#WORK_CENTER_DESC
 * WORK_CENTER_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#WORK_CENTER_CATEGORY_CODE
 * WORK_CENTER_CATEGORY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#WORK_CENTER_RESPONSIBLE
 * WORK_CENTER_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#SUPPLY_AREA
 * SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#WORK_CENTER_USAGE
 * WORK_CENTER_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#WORK_CENTER_RESPONSIBLE_NAME
 * WORK_CENTER_RESPONSIBLE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#CAPACITY_CATEGORY_CODE
 * CAPACITY_CATEGORY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#TO_WORK_CENTER_INTERVAL
 * TO_WORK_CENTER_INTERVAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#TO_WORK_CENTER_QUEUING_OP
 * TO_WORK_CENTER_QUEUING_OP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterAllCapacity#TO_WORK_CENTER_TODAY_OP
 * TO_WORK_CENTER_TODAY_OP}</li>
 * </ul>
 *
 */
public interface WorkCenterAllCapacitySelectable extends EntitySelectable<WorkCenterAllCapacity>
{

}
