/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp WorkCenterCapDayOp}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapDayOpField
 * WorkCenterCapDayOpField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapDayOpLink
 * WorkCenterCapDayOpLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#MRP_CONTROLLER
 * MRP_CONTROLLER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#CAPACITY_INTERNAL_ID
 * CAPACITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#CAPACITY_REQUIREMENT
 * CAPACITY_REQUIREMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#OPERATION
 * OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#WORK_CENTER_DESC
 * WORK_CENTER_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#WORK_CENTER_RESPONSIBLE
 * WORK_CENTER_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#WORK_CENTER_CATEGORY_CODE
 * WORK_CENTER_CATEGORY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#CAPACITY_REQUIREMENT_ORIGIN
 * CAPACITY_REQUIREMENT_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#CAPACITY_REQUIREMENT_UNIT
 * CAPACITY_REQUIREMENT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#ORDER_TYPE
 * ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#ORDER_TYPE_NAME
 * ORDER_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#ORDER_PLANNED_TOTAL_QTY
 * ORDER_PLANNED_TOTAL_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#PRODUCTION_VERSION
 * PRODUCTION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#OPERATION_PLANNING_STATUS_TEXT
 * OPERATION_PLANNING_STATUS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#OPERATION_PLANNING_STATUS_CODE
 * OPERATION_PLANNING_STATUS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#OPERATION_LATEST_START_DATE
 * OPERATION_LATEST_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#OPERATION_LATEST_START_TIME
 * OPERATION_LATEST_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#OPERATION_LATEST_END_DATE
 * OPERATION_LATEST_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#OPERATION_LATEST_END_TIME
 * OPERATION_LATEST_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#ORDER_STATUS_TEXT
 * ORDER_STATUS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#ORDER_STATUS_CODE
 * ORDER_STATUS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#ORDER_FIRMING_STATUS_TEXT
 * ORDER_FIRMING_STATUS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#OP_LTST_SCHEDLD_PROCG_STRT_DTE
 * OP_LTST_SCHEDLD_PROCG_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#OP_LTST_SCHEDLD_PROCG_STRT_TME
 * OP_LTST_SCHEDLD_PROCG_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#OP_LTST_SCHEDLD_TRDWN_STRT_DTE
 * OP_LTST_SCHEDLD_TRDWN_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#OP_LTST_SCHEDLD_TRDWN_STRT_TME
 * OP_LTST_SCHEDLD_TRDWN_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#REMAINING_CAP_REQ_OP_SEG_SETUP_DURN
 * REMAINING_CAP_REQ_OP_SEG_SETUP_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#REMAINING_CAP_REQ_OP_SEG_PROCG_DURN
 * REMAINING_CAP_REQ_OP_SEG_PROCG_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#REMAINING_CAP_REQ_OP_SEG_TRDWN_DURN
 * REMAINING_CAP_REQ_OP_SEG_TRDWN_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#CAPACITY_REQUIREMENTS_ARE_DTMND
 * CAPACITY_REQUIREMENTS_ARE_DTMND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapDayOp#ORDER_INTERNAL_ID
 * ORDER_INTERNAL_ID}</li>
 * </ul>
 *
 */
public interface WorkCenterCapDayOpSelectable extends EntitySelectable<WorkCenterCapDayOp>
{

}
