/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucketParameters;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucketParameters
 * WorkCenterCapOrderPerBucketParameters}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapOrderPerBucketParametersField
 * WorkCenterCapOrderPerBucketParametersField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapOrderPerBucketParametersLink
 * WorkCenterCapOrderPerBucketParametersLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucketParameters#P_CAP_EVAL_START_DATE
 * P_CAP_EVAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucketParameters#P_CAP_EVAL_END_DATE
 * P_CAP_EVAL_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucketParameters#P_CAP_EVAL_BUCKET_TYPE
 * P_CAP_EVAL_BUCKET_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucketParameters#TO_SET
 * TO_SET}</li>
 * </ul>
 *
 */
public interface WorkCenterCapOrderPerBucketParametersSelectable
    extends
    EntitySelectable<WorkCenterCapOrderPerBucketParameters>
{

}
