/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket
 * WorkCenterCapOrderPerBucket}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapOrderPerBucketField
 * WorkCenterCapOrderPerBucketField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapOrderPerBucketLink
 * WorkCenterCapOrderPerBucketLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#P_CAP_EVAL_START_DATE
 * P_CAP_EVAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#P_CAP_EVAL_END_DATE
 * P_CAP_EVAL_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#P_CAP_EVAL_BUCKET_TYPE
 * P_CAP_EVAL_BUCKET_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#MRP_CONTROLLER
 * MRP_CONTROLLER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#WORK_CENTER_TYPE_CODE
 * WORK_CENTER_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#CAPACITY_CATEGORY_ALLOCATION
 * CAPACITY_CATEGORY_ALLOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#CAPACITY_INTERNAL_ID
 * CAPACITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#OPERATION
 * OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#CAPACITY_EVALUATION_TIME_PERIOD
 * CAPACITY_EVALUATION_TIME_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#SHIFT_NAME
 * SHIFT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#CAP_EVAL_BUCKET_TYPE
 * CAP_EVAL_BUCKET_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#CAPACITY_EVALUATION_TIME_PERD_TEXT
 * CAPACITY_EVALUATION_TIME_PERD_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#FACTORY_CALENDAR
 * FACTORY_CALENDAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#WORK_CENTER_DESC
 * WORK_CENTER_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#WORK_CENTER_RESPONSIBLE
 * WORK_CENTER_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#WORK_CENTER_CATEGORY_CODE
 * WORK_CENTER_CATEGORY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#CAPACITY_REQUIREMENT_ORIGIN
 * CAPACITY_REQUIREMENT_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#CAPACITY_REQUIREMENT_UNIT
 * CAPACITY_REQUIREMENT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#ORDER_TYPE
 * ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#ORDER_TYPE_NAME
 * ORDER_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#ORDER_PLANNED_TOTAL_QTY
 * ORDER_PLANNED_TOTAL_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#ORDER_CATEGORY
 * ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#ORDER_CATEGORY_NAME
 * ORDER_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#PRODUCTION_VERSION
 * PRODUCTION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#OPERATION_PLANNING_STATUS_TEXT
 * OPERATION_PLANNING_STATUS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#OPERATION_PLANNING_STATUS_CODE
 * OPERATION_PLANNING_STATUS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#OPERATION_LATEST_START_DATE
 * OPERATION_LATEST_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#OPERATION_LATEST_START_TIME
 * OPERATION_LATEST_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#OPERATION_LATEST_END_DATE
 * OPERATION_LATEST_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#OPERATION_LATEST_END_TIME
 * OPERATION_LATEST_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#ORDER_STATUS_TEXT
 * ORDER_STATUS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#ORDER_STATUS_CODE
 * ORDER_STATUS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#ORDER_FIRMING_STATUS_CODE
 * ORDER_FIRMING_STATUS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#ORDER_FIRMING_STATUS_TEXT
 * ORDER_FIRMING_STATUS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#OP_LTST_SCHEDLD_PROCG_STRT_DTE
 * OP_LTST_SCHEDLD_PROCG_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#OP_LTST_SCHEDLD_PROCG_STRT_TME
 * OP_LTST_SCHEDLD_PROCG_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#OP_LTST_SCHEDLD_TRDWN_STRT_DTE
 * OP_LTST_SCHEDLD_TRDWN_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#OP_LTST_SCHEDLD_TRDWN_STRT_TME
 * OP_LTST_SCHEDLD_TRDWN_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#REMAINING_CAP_REQ_OP_SEG_SETUP_DURN
 * REMAINING_CAP_REQ_OP_SEG_SETUP_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#REMAINING_CAP_REQ_OP_SEG_PROCG_DURN
 * REMAINING_CAP_REQ_OP_SEG_PROCG_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#REMAINING_CAP_REQ_OP_SEG_TRDWN_DURN
 * REMAINING_CAP_REQ_OP_SEG_TRDWN_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#ORDER_INTERNAL_ID
 * ORDER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#CAPACITY_START_TIME
 * CAPACITY_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#CAPACITY_END_TIME
 * CAPACITY_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#WORK_CENTER_AVAILABLE_CAPACITY
 * WORK_CENTER_AVAILABLE_CAPACITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#WORK_CENTER_CAP_RQMT_IN_CAP_UNIT
 * WORK_CENTER_CAP_RQMT_IN_CAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#WORK_CENTER_CAPACITY_UNIT
 * WORK_CENTER_CAPACITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#WORK_CENTER_CAP_UNIT_TEXT
 * WORK_CENTER_CAP_UNIT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapOrderPerBucket#TO_PARAMETERS
 * TO_PARAMETERS}</li>
 * </ul>
 *
 */
public interface WorkCenterCapOrderPerBucketSelectable extends EntitySelectable<WorkCenterCapOrderPerBucket>
{

}
