/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucketParameters;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucketParameters
 * WorkCenterCapPerBucketParameters}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapPerBucketParametersField
 * WorkCenterCapPerBucketParametersField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapPerBucketParametersLink
 * WorkCenterCapPerBucketParametersLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucketParameters#P_CAP_EVAL_START_DATE
 * P_CAP_EVAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucketParameters#P_CAP_EVAL_END_DATE
 * P_CAP_EVAL_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucketParameters#P_CAP_EVAL_BUCKET_TYPE
 * P_CAP_EVAL_BUCKET_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucketParameters#TO_SET
 * TO_SET}</li>
 * </ul>
 *
 */
public interface WorkCenterCapPerBucketParametersSelectable extends EntitySelectable<WorkCenterCapPerBucketParameters>
{

}
