/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket
 * WorkCenterCapPerBucket}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapPerBucketField
 * WorkCenterCapPerBucketField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapPerBucketLink
 * WorkCenterCapPerBucketLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#P_CAP_EVAL_START_DATE
 * P_CAP_EVAL_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#P_CAP_EVAL_END_DATE
 * P_CAP_EVAL_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#P_CAP_EVAL_BUCKET_TYPE
 * P_CAP_EVAL_BUCKET_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#CAPACITY_INTERNAL_ID
 * CAPACITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#SHIFT_NAME
 * SHIFT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#CAPACITY_EVALUATION_TIME_PERIOD
 * CAPACITY_EVALUATION_TIME_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#CAP_EVAL_BUCKET_TYPE
 * CAP_EVAL_BUCKET_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#CAPACITY_EVALUATION_TIME_PERD_TEXT
 * CAPACITY_EVALUATION_TIME_PERD_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#WORK_CENTER_RESPONSIBLE
 * WORK_CENTER_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#CAPACITY_START_TIME
 * CAPACITY_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#CAPACITY_END_TIME
 * CAPACITY_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#WORK_CENTER_AVAILABLE_CAPACITY
 * WORK_CENTER_AVAILABLE_CAPACITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#WORK_CENTER_CAP_RQMT_IN_CAP_UNIT
 * WORK_CENTER_CAP_RQMT_IN_CAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#WRK_CTR_RMNG_CAP_IN_CAP_UNIT
 * WRK_CTR_RMNG_CAP_IN_CAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#WORK_CENTER_TOT_UTILZN_IN_TME_PERD
 * WORK_CENTER_TOT_UTILZN_IN_TME_PERD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#WORK_CENTER_CAPACITY_UNIT
 * WORK_CENTER_CAPACITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#WORK_CENTER_CAP_UNIT_TEXT
 * WORK_CENTER_CAP_UNIT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#WORK_CENTER_TYPE_CODE
 * WORK_CENTER_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#CAPACITY_CATEGORY_ALLOCATION
 * CAPACITY_CATEGORY_ALLOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPerBucket#TO_PARAMETERS
 * TO_PARAMETERS}</li>
 * </ul>
 *
 */
public interface WorkCenterCapPerBucketSelectable extends EntitySelectable<WorkCenterCapPerBucket>
{

}
