/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp
 * WorkCenterCapPplineOp}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.field.WorkCenterCapPplineOpField
 * WorkCenterCapPplineOpField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.link.WorkCenterCapPplineOpLink
 * WorkCenterCapPplineOpLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#MRP_CONTROLLER
 * MRP_CONTROLLER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#CAPACITY_INTERNAL_ID
 * CAPACITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#CAPACITY_REQUIREMENT
 * CAPACITY_REQUIREMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#OPERATION
 * OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#WORK_CENTER_DESC
 * WORK_CENTER_DESC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#WORK_CENTER_RESPONSIBLE
 * WORK_CENTER_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#WORK_CENTER_CATEGORY_CODE
 * WORK_CENTER_CATEGORY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#CAPACITY_REQUIREMENT_ORIGIN
 * CAPACITY_REQUIREMENT_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#CAPACITY_REQUIREMENT_UNIT
 * CAPACITY_REQUIREMENT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#ORDER_TYPE
 * ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#ORDER_TYPE_NAME
 * ORDER_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#ORDER_CATEGORY
 * ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#ORDER_CATEGORY_NAME
 * ORDER_CATEGORY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#ORDER_PLANNED_TOTAL_QTY
 * ORDER_PLANNED_TOTAL_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#PRODUCTION_VERSION
 * PRODUCTION_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#OPERATION_PLANNING_STATUS_CODE
 * OPERATION_PLANNING_STATUS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#OPERATION_PLANNING_STATUS_TEXT
 * OPERATION_PLANNING_STATUS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#OPERATION_LATEST_START_DATE
 * OPERATION_LATEST_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#OPERATION_LATEST_START_TIME
 * OPERATION_LATEST_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#OPERATION_LATEST_END_DATE
 * OPERATION_LATEST_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#OPERATION_LATEST_END_TIME
 * OPERATION_LATEST_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#ORDER_STATUS_CODE
 * ORDER_STATUS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#ORDER_STATUS_TEXT
 * ORDER_STATUS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#ORDER_STATUS_SHORT_TEXT
 * ORDER_STATUS_SHORT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#ORDER_FIRMING_STATUS_CODE
 * ORDER_FIRMING_STATUS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#ORDER_FIRMING_STATUS_TEXT
 * ORDER_FIRMING_STATUS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#OP_LTST_SCHEDLD_PROCG_STRT_DTE
 * OP_LTST_SCHEDLD_PROCG_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#OP_LTST_SCHEDLD_PROCG_STRT_TME
 * OP_LTST_SCHEDLD_PROCG_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#OP_LTST_SCHEDLD_TRDWN_STRT_DTE
 * OP_LTST_SCHEDLD_TRDWN_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#OP_LTST_SCHEDLD_TRDWN_STRT_TME
 * OP_LTST_SCHEDLD_TRDWN_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#REMAINING_CAP_REQ_OP_SEG_SETUP_DURN
 * REMAINING_CAP_REQ_OP_SEG_SETUP_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#REMAINING_CAP_REQ_OP_SEG_PROCG_DURN
 * REMAINING_CAP_REQ_OP_SEG_PROCG_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#REMAINING_CAP_REQ_OP_SEG_TRDWN_DURN
 * REMAINING_CAP_REQ_OP_SEG_TRDWN_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#CAPACITY_REQUIREMENTS_ARE_DTMND
 * CAPACITY_REQUIREMENTS_ARE_DTMND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#REMAINING_CAP_REQ_EXECUTION_DURN
 * REMAINING_CAP_REQ_EXECUTION_DURN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.workcenterdata.WorkCenterCapPplineOp#ORDER_INTERNAL_ID
 * ORDER_INTERNAL_ID}</li>
 * </ul>
 *
 */
public interface WorkCenterCapPplineOpSelectable extends EntitySelectable<WorkCenterCapPplineOp>
{

}
